/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.GIVEntityResolver;
import com.informagen.giv.GIVXMLHandler;
import com.informagen.giv.MapView;
import com.informagen.giv.SAXErrorHandler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class GIVXMLParser {
    public static MapView parse(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        return GIVXMLParser.parse(fileReader);
    }

    public static MapView parse(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        return GIVXMLParser.parse(bufferedReader);
    }

    public static MapView parse(String string) throws IOException {
        return string != null ? GIVXMLParser.parse(new StringReader(string)) : null;
    }

    public static MapView parse(char[] cArray) throws IOException {
        return cArray != null ? GIVXMLParser.parse(new CharArrayReader(cArray)) : null;
    }

    public static MapView parse(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray));
        return GIVXMLParser.parse(inputStreamReader);
    }

    public static MapView parse(Reader reader) throws IOException {
        XMLReader xMLReader = null;
        try {
            xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setErrorHandler(new SAXErrorHandler(System.err));
            xMLReader.setEntityResolver(new GIVEntityResolver());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        MapView mapView = new MapView();
        try {
            GIVXMLHandler gIVXMLHandler = new GIVXMLHandler(mapView);
            xMLReader.setContentHandler(gIVXMLHandler);
            InputSource inputSource = new InputSource(reader);
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new IOException("Fatal SAX Error:  " + sAXException.getMessage());
        }
        return mapView;
    }
}

