/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.GlyphPanel;
import com.informagen.giv.MapGlyph;
import com.informagen.giv.MapTile;
import com.informagen.giv.MosaicLayout;
import com.informagen.giv.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import javax.swing.JCheckBox;

public class MapPanel
extends Container {
    Color color = Color.lightGray;
    private final JCheckBox panelTitleChbx = new JCheckBox();
    private final GlyphPanel glyphPanel = new GlyphPanel();
    private MouseAdapter mouseAdapter = null;
    private int hGap = 0;
    private int vGap = 0;

    public MapPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.glyphPanel, "Center");
        this.panelTitleChbx.setSelected(true);
        this.wireUI();
    }

    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    public void paint(Graphics graphics) {
        Util.paintWallpaper((Component)this, graphics, this.color);
        super.paint(graphics);
    }

    public void setTitle(String string) {
        if (string != null && string.length() > 0) {
            this.panelTitleChbx.setText(string);
            this.add((Component)this.panelTitleChbx, "North");
        }
    }

    public void setMouseAdapter(MouseAdapter mouseAdapter) {
        this.mouseAdapter = mouseAdapter;
    }

    public void setWallpaper(Color color) {
        this.color = color;
        this.panelTitleChbx.setBackground(color);
    }

    public void add(MapTile mapTile) {
        mapTile.addMouseListener(this.mouseAdapter);
        this.glyphPanel.add(mapTile);
    }

    public void add(MapGlyph mapGlyph) {
        mapGlyph.addMouseListener(this.mouseAdapter);
        this.glyphPanel.add(mapGlyph);
    }

    private void wireUI() {
        this.panelTitleChbx.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    MapPanel.this.glyphPanel.setVisible(true);
                } else {
                    MapPanel.this.glyphPanel.setVisible(false);
                }
                MapPanel.this.glyphPanel.invalidate();
                MapPanel.this.getParent().validate();
            }
        });
    }

    public void setBuoyancy(int n, int n2, int n3) {
        this.glyphPanel.setLayout(new MosaicLayout(n, n2, n3));
    }

    public void setBuoyancy(String string) {
        this.setBuoyancy(string, this.hGap, this.vGap);
    }

    public void setBuoyancy(String string, int n, int n2) {
        this.hGap = n;
        this.vGap = n2;
        int n3 = 0;
        if (string.equals("Floating")) {
            n3 = 0;
        } else if (string.equalsIgnoreCase("Sinking")) {
            n3 = 1;
        } else if (string.equalsIgnoreCase("TopDown")) {
            n3 = 2;
        } else if (string.equalsIgnoreCase("BottomUp")) {
            n3 = 3;
        } else if (string.equalsIgnoreCase("StackUp")) {
            n3 = 4;
        } else if (string.equalsIgnoreCase("StackDown")) {
            n3 = 5;
        } else if (string.equalsIgnoreCase("Collapsed")) {
            n3 = 6;
        }
        this.glyphPanel.setLayout(new MosaicLayout(n3, n, n2));
    }

    public void setExtent(double d, double d2) {
        this.glyphPanel.setExtent(d, d2);
    }

    void setPanelWidth(int n) {
        this.glyphPanel.setPanelWidth(n);
    }
}

