/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Vector;

public class MosaicLayout
implements LayoutManager {
    public static final int kFloating = 0;
    public static final int kSinking = 1;
    public static final int kTopDown = 2;
    public static final int kBottomUp = 3;
    public static final int kStackUp = 4;
    public static final int kStackDown = 5;
    public static final int kCollapsed = 6;
    private int mBuoyancy = 0;
    private Dimension mDimension = new Dimension(0, 0);
    private int mHgap = 0;
    private int mVgap = 1;

    public MosaicLayout() {
        this(0);
    }

    public MosaicLayout(int n) {
        this(n, 0);
    }

    public MosaicLayout(int n, int n2) {
        this(n, n2, n2);
    }

    public MosaicLayout(int n, int n2, int n3) {
        this.mBuoyancy = n;
        this.mHgap = n2;
        this.mVgap = n3;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        this.layoutContainer(container);
        return this.mDimension;
    }

    public void layoutContainer(Container container) {
        this.reTile(container, container.getSize().width);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            Dimension dimension = component.getPreferredSize();
            Point point = component.getLocation();
            component.setBounds(point.x, point.y, dimension.width, dimension.height);
        }
    }

    private void reTile(Container container, int n) {
        Component[] componentArray = container.getComponents();
        int n2 = 0;
        switch (this.mBuoyancy) {
            default: {
                n2 = this.packTiles(componentArray);
                break;
            }
            case 2: 
            case 3: {
                n2 = this.layerTiles(componentArray);
                break;
            }
            case 4: 
            case 5: {
                n2 = this.stackTiles(componentArray);
                break;
            }
            case 6: {
                n2 = this.collapseTiles(componentArray);
            }
        }
        switch (this.mBuoyancy) {
            case 1: 
            case 3: 
            case 4: {
                this.flipTiles(componentArray, n2);
            }
        }
        this.mDimension.width = n;
        this.mDimension.height = n2;
        container.setSize(this.mDimension);
    }

    private int packTiles(Component[] componentArray) {
        this.sortComponents(componentArray);
        Vector<Rectangle> vector = new Vector<Rectangle>();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            int n2;
            int n3;
            Component component = componentArray[i];
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            Point point = component.getLocation();
            Rectangle rectangle = new Rectangle(point.x, this.mVgap, dimension.width, dimension.height);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Rectangle rectangle2 = (Rectangle)iterator.next();
                n3 = rectangle2.y;
                n2 = rectangle2.y + rectangle2.height + this.mVgap;
                int n4 = rectangle2.x + rectangle2.width + this.mHgap;
                int n5 = rectangle.y + rectangle.height + this.mVgap;
                int n6 = rectangle.x - this.mHgap;
                if (n6 > n4) {
                    vector.setElementAt(null, vector.indexOf(rectangle2));
                    continue;
                }
                if (n5 <= n3) break;
                rectangle.y = n2;
            }
            for (n3 = vector.size() - 1; n3 >= 0; --n3) {
                if (vector.elementAt(n3) != null) continue;
                vector.removeElementAt(n3);
            }
            for (n3 = 0; n3 < vector.size() && ((Rectangle)vector.elementAt((int)n3)).y < rectangle.y; ++n3) {
            }
            vector.insertElementAt(rectangle, n3);
            component.setBounds(rectangle);
            n2 = rectangle.y + rectangle.height;
            n = n2 > n ? n2 : n;
        }
        if (n > 0) {
            n += this.mVgap;
        }
        return n;
    }

    private int layerTiles(Component[] componentArray) {
        this.sortComponents(componentArray);
        return this.stackTiles(componentArray);
    }

    private int stackTiles(Component[] componentArray) {
        int n = this.mVgap;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            Point point = component.getLocation();
            point.y = n;
            component.setLocation(point);
            n += dimension.height + this.mVgap;
        }
        if (n == this.mVgap) {
            n = 0;
        }
        return n;
    }

    private int collapseTiles(Component[] componentArray) {
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            Point point = component.getLocation();
            point.y = this.mVgap;
            component.setLocation(point);
            if (dimension.height <= n) continue;
            n = dimension.height;
        }
        if (n > 0) {
            n += this.mVgap * 2;
        }
        return n;
    }

    private void flipTiles(Component[] componentArray, int n) {
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            Rectangle rectangle = component.getBounds();
            rectangle.y = n - (rectangle.y + rectangle.height);
            component.setBounds(rectangle);
        }
    }

    private void sortComponents(Component[] componentArray) {
        int n = componentArray.length;
        for (int i = n / 2; i >= 1; i /= 2) {
            for (int j = i; j < n; ++j) {
                Component component = componentArray[j];
                Point point = component.getLocation();
                for (int k = j; k >= i; k -= i) {
                    Component component2 = componentArray[k - i];
                    Point point2 = componentArray[k - i].getLocation();
                    if (point.x >= point2.x) break;
                    componentArray[k] = component2;
                }
                componentArray[k] = component;
            }
        }
    }
}

