/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.primer3;

import com.informagen.C.IO;
import com.informagen.C.RefInt;
import com.informagen.F;
import com.informagen.primer3.BoulderIOReader;
import com.informagen.primer3.Boulder_input;
import com.informagen.primer3.Constants;
import com.informagen.primer3.Dpal;
import com.informagen.primer3.FileBoulderIOReader;
import com.informagen.primer3.Format_output;
import com.informagen.primer3.HashtableBoulderIOReader;
import com.informagen.primer3.Macros;
import com.informagen.primer3.OligoTm;
import com.informagen.primer3.dpal_args;
import com.informagen.primer3.dpal_results;
import com.informagen.primer3.oligo_stats;
import com.informagen.primer3.oligo_type;
import com.informagen.primer3.oligo_violation;
import com.informagen.primer3.pair_array_t;
import com.informagen.primer3.pr_append_str;
import com.informagen.primer3.primer_args;
import com.informagen.primer3.primer_pair;
import com.informagen.primer3.primer_rec;
import com.informagen.primer3.program_args;
import com.informagen.primer3.seq_args;
import com.informagen.primer3.seq_lib;
import com.informagen.primer3.task;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Vector;

public class Primer3
extends Observable {
    static String OOM_MESSAGE = ": out of memory\n";
    static int OOM_MESSAGE_LEN = 16;
    static int MAX_PRIMER_LENGTH = 36;
    static short ALIGN_SCORE_UNDEF = Short.MAX_VALUE;
    static int INITIAL_LIST_LEN = 2000;
    static boolean PAIR_OK = true;
    static boolean PAIR_FAILED = false;
    static final String[] copyright = new String[]{"", "In accordance with condition 2 of the Primer 3 copyright statement below", "we assert that;", "", "  \"This program is not identical to the original Primer 3 application", "   as developed at the Whitehead Institute.  In that, the original", "   \"C\" language source code was converted to the \"Java\" programming", "   language.\"", "", "                                  March 1999, Informagen, Inc.", "", "------------------------------------------------------------------------", "", "Copyright (c) 1996, 1997", "        Whitehead Institute for Biomedical Research. All rights reserved.", "", "Redistribution and use in source and binary forms, with or without", "modification, are permitted provided that the following conditions are met:", "", "1.      Redistributions must reproduce the above copyright notice, this", "list of conditions and the following disclaimer in the documentation", "and/or other materials provided with the distribution.  Redistributions of", "source code must also reproduce this information in the source code itself.", "", "2.      If the program is modified, redistributions must include a notice", "(in the same places as above) indicating that the redistributed program is", "not identical to the version distributed by Whitehead Institute.", "", "3.      All advertising materials mentioning features or use of this", "software  must display the following acknowledgment:", "", "        This product includes software developed by the", "          Whitehead Institute for Biomedical Research.", "", "4.      The name of the Whitehead Institute may not be used to endorse or", "promote products derived from this software without specific prior written", "permission.", "", "We also request that use of this software be cited in publications as ", "", "Steve Rozen, Helen J. Skaletsky (1996)", "   Primer3. Code available at", "   http://www-genome.wi.mit.edu/genome_software/other/primer3.html", "", "THIS SOFTWARE IS PROVIDED BY THE WHITEHEAD INSTITUTE ``AS IS'' AND  ANY", "EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  IMPLIED", "WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE  ARE", "DISCLAIMED. IN NO EVENT SHALL THE WHITEHEAD INSTITUTE BE LIABLE  FOR ANY", "DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL  DAMAGES", "(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS  OR", "SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)  HOWEVER", "CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT", "LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY", "OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF", "SUCH DAMAGE."};
    static Vector f = null;
    static Vector r = null;
    static Vector mid = null;
    static int f_len = 0;
    static int r_len = 0;
    static int mid_len = 0;
    static final String pr_program_name = "com.informagen.Primer3";
    static int pr_program_name_len;
    pair_array_t best_pairs;
    seq_args sa;
    primer_args pa;
    dpal_args local_args;
    dpal_args end_args;
    dpal_args local_end_args;
    static dpal_args lib_local_dpal_args;
    static dpal_args lib_local_end_dpal_args;
    program_args prog_args;
    BoulderIOReader aReader;
    static PrintWriter revPrintStream;
    static PrintWriter forPrintStream;
    static PrintWriter intPrintStream;
    String bestForward = "";
    String bestInternal = "";
    String bestReverse = "";
    int report = 25;
    static final int PR_UNDEFINED_INT_OPT = Integer.MIN_VALUE;
    static final double PR_UNDEFINED_DBL_OPT = Double.MIN_VALUE;
    static final int OPT_SIZE = 20;
    static final int MIN_SIZE = 18;
    static final int MAX_SIZE = 27;
    static final double OPT_TM = 60.0;
    static final double MIN_TM = 57.0;
    static final double MAX_TM = 63.0;
    static final double MAX_DIFF_TM = 100.0;
    static final int DEFAULT_OPT_GC_PERCENT = Integer.MIN_VALUE;
    static final double MIN_GC = 20.0;
    static final double MAX_GC = 80.0;
    static final double SALT_CONC = 50.0;
    static final double DNA_CONC = 50.0;
    static final int NUM_NS_ACCEPTED = 0;
    static final int MAX_POLY_X = 5;
    static final int SELF_ANY = 800;
    static final int SELF_END = 300;
    static final int PAIR_COMPL_ANY = 800;
    static final int PAIR_COMPL_END = 300;
    static final boolean FILE_FLAG = false;
    static final boolean ALIGNMENT_FLAG = true;
    static final int REPORT_COUNT = -1;
    static final int EXPLAIN_FLAG = 0;
    static final int GC_CLAMP = 0;
    static final int LIBERAL_BASE = 0;
    static final int PICK_INTERNAL_OLIGO = 0;
    static final int PRIMER_TASK = 0;
    static final int INTERNAL_OLIGO_OPT_SIZE = 20;
    static final int INTERNAL_OLIGO_MIN_SIZE = 18;
    static final int INTERNAL_OLIGO_MAX_SIZE = 27;
    static final double INTERNAL_OLIGO_OPT_TM = 60.0;
    static final double INTERNAL_OLIGO_MIN_TM = 57.0;
    static final double INTERNAL_OLIGO_MAX_TM = 63.0;
    static final double INTERNAL_OLIGO_MIN_GC = 20.0;
    static final double INTERNAL_OLIGO_MAX_GC = 80.0;
    static final double INTERNAL_OLIGO_SALT_CONC = 50.0;
    static final double INTERNAL_OLIGO_DNA_CONC = 50.0;
    static final int INTERNAL_OLIGO_NUM_NS = 0;
    static final int INTERNAL_OLIGO_MAX_POLY_X = 5;
    static final int INTERNAL_OLIGO_SELF_ANY = 1200;
    static final int INTERNAL_OLIGO_SELF_END = 1200;
    static final int INTERNAL_OLIGO_REPEAT_SIMILARITY = 1200;
    static final int REPEAT_SIMILARITY = 1200;
    static final int PAIR_REPEAT_SIMILARITY = 2400;
    static final int FIRST_BASE_INDEX = 0;
    static final int NUM_RETURN = 5;
    static final int MIN_QUALITY = 0;
    static final int QUALITY_RANGE_MIN = 0;
    static final int QUALITY_RANGE_MAX = 100;
    static final double DEFAULT_MAX_END_STABILITY = 100.0;
    static final int PRIMER_PRODUCT_OPT_SIZE = Integer.MIN_VALUE;
    static final double PRIMER_PRODUCT_OPT_TM = Double.MIN_VALUE;
    static final double PRIMER_WT_TM_GT = 1.0;
    static final double PRIMER_WT_TM_LT = 1.0;
    static final double PRIMER_WT_SIZE_LT = 1.0;
    static final double PRIMER_WT_SIZE_GT = 1.0;
    static final double PRIMER_WT_GC_PERCENT_LT = 0.0;
    static final double PRIMER_WT_GC_PERCENT_GT = 0.0;
    static final double PRIMER_WT_COMPL_ANY = 0.0;
    static final double PRIMER_WT_COMPL_END = 0.0;
    static final double PRIMER_WT_NUM_NS = 0.0;
    static final double PRIMER_WT_REP_SIM = 0.0;
    static final double PRIMER_WT_SEQ_QUAL = 0.0;
    static final double PRIMER_WT_END_QUAL = 0.0;
    static final double PRIMER_WT_POS_PENALTY = 1.0;
    static final double PRIMER_WT_END_STABILITY = 0.0;
    static final double IO_WT_TM_GT = 1.0;
    static final double IO_WT_TM_LT = 1.0;
    static final double IO_WT_SIZE_LT = 1.0;
    static final double IO_WT_SIZE_GT = 1.0;
    static final double IO_WT_GC_PERCENT_LT = 0.0;
    static final double IO_WT_GC_PERCENT_GT = 0.0;
    static final double IO_WT_COMPL_ANY = 0.0;
    static final double IO_WT_COMPL_END = 0.0;
    static final double IO_WT_NUM_NS = 0.0;
    static final double IO_WT_REP_SIM = 0.0;
    static final double IO_WT_SEQ_QUAL = 0.0;
    static final double IO_WT_END_QUAL = 0.0;
    static final double PAIR_WT_PRIMER_PENALTY = 1.0;
    static final double PAIR_WT_IO_PENALTY = 0.0;
    static final double PAIR_WT_DIFF_TM = 0.0;
    static final double PAIR_WT_COMPL_ANY = 0.0;
    static final double PAIR_WT_COMPL_END = 0.0;
    static final double PAIR_WT_REP_SIM = 0.0;
    static final double PAIR_WT_PRODUCT_TM_LT = 0.0;
    static final double PAIR_WT_PRODUCT_TM_GT = 0.0;
    static final double PAIR_WT_PRODUCT_SIZE_LT = 0.0;
    static final double PAIR_WT_PRODUCT_SIZE_GT = 0.0;

    static void OOM_ERROR() {
        System.err.println(pr_program_name);
    }

    static boolean DEFAULT_POSITION_PENALTIES(primer_args primer_args2) {
        return Constants.PR_DEFAULT_INSIDE_PENALTY == primer_args2.inside_penalty && Constants.PR_DEFAULT_OUTSIDE_PENALTY == primer_args2.outside_penalty;
    }

    static boolean OK_OR_MUST_USE(primer_rec primer_rec2) {
        return primer_rec2.ok == oligo_violation.OV_OK || primer_rec2.must_use;
    }

    static String MACRO_VALUE_AS_STRING(int n) {
        return Integer.toString(n);
    }

    public static void main(String[] stringArray) {
        Primer3 primer3 = new Primer3(stringArray);
        try {
            primer3.run();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static StringWriter runHashTable(Hashtable hashtable, String[] stringArray) {
        StringWriter stringWriter = new StringWriter();
        Primer3 primer3 = new Primer3(hashtable, stringArray, stringWriter);
        try {
            primer3.run();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return stringWriter;
    }

    public Primer3() {
        try {
            Class.forName("com.informagen.C.IO");
            Class.forName("com.informagen.primer3.OligoTm");
            Class.forName("com.informagen.primer3.Boulder_input");
            Class.forName("com.informagen.primer3.Dpal");
            Class.forName("com.informagen.primer3.Format_output");
        }
        catch (Exception exception) {
            System.err.println("Failed to load class." + exception.getMessage() + "\n\n");
        }
        this.best_pairs = new pair_array_t();
        this.pa = new primer_args();
        this.sa = new seq_args();
        this.local_args = new dpal_args();
        this.end_args = new dpal_args();
        this.local_end_args = new dpal_args();
        lib_local_end_dpal_args = new dpal_args();
        lib_local_dpal_args = new dpal_args();
        Primer3.set_default_global_primer_args(this.pa);
    }

    public Primer3(String[] stringArray) {
        this();
        int n = stringArray.length;
        String[] stringArray2 = stringArray;
        this.prog_args = new program_args();
        pr_program_name_len = pr_program_name.length();
        this.aReader = null;
        try {
            this.aReader = new FileBoulderIOReader(stringArray2[0]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            IO.stdout.print("File not found: " + stringArray2[0] + "\n");
        }
        while (--n > 0) {
            String string = stringArray2[n];
            if (string.equals("-format_output")) {
                this.prog_args.format_output = true;
                continue;
            }
            if (string.equals("-2x_compat")) {
                this.prog_args.twox_compat = true;
                continue;
            }
            if (string.equals("-strict_tags")) {
                this.prog_args.strict_tags = true;
                continue;
            }
            if (string.equals("-copyright")) {
                Primer3.print_usage();
                continue;
            }
            Primer3.print_usage();
            this.sa = null;
            this.local_args = null;
            this.end_args = null;
            this.local_end_args = null;
            lib_local_dpal_args = null;
            lib_local_end_dpal_args = null;
            if (this.best_pairs.storage_size() != 0) {
                this.best_pairs.reset();
            }
            this.pa = null;
        }
    }

    public Primer3(Hashtable hashtable, String[] stringArray, Writer writer) {
        this();
        this.setOutputStream(writer);
        this.setRevOutputStream(writer);
        this.setForOutputStream(writer);
        this.setIntOutputStream(writer);
        this.prog_args = new program_args();
        pr_program_name_len = pr_program_name.length();
        this.aReader = null;
        if (hashtable != null) {
            this.aReader = new HashtableBoulderIOReader(hashtable);
        }
        int n = stringArray.length;
        String[] stringArray2 = stringArray;
        while (n-- > 0) {
            String string = stringArray2[n];
            if (string.equals("-format_output")) {
                this.prog_args.format_output = true;
                continue;
            }
            if (string.equals("-2x_compat")) {
                this.prog_args.twox_compat = true;
                continue;
            }
            if (string.equals("-strict_tags")) {
                this.prog_args.strict_tags = true;
                continue;
            }
            if (string.equals("-copyright")) {
                Primer3.print_usage();
                continue;
            }
            Primer3.print_usage();
            this.sa = null;
            this.local_args = null;
            this.end_args = null;
            this.local_end_args = null;
            lib_local_dpal_args = null;
            lib_local_end_dpal_args = null;
            if (this.best_pairs.storage_size() != 0) {
                this.best_pairs.reset();
            }
            this.pa = null;
        }
    }

    public void setOutputStream(Writer writer) {
        PrintWriter printWriter = null;
        if (writer != null) {
            printWriter = new PrintWriter(writer);
        }
        IO.stderr = IO.stdout = printWriter;
    }

    public void setRevOutputStream(Writer writer) {
        PrintWriter printWriter = null;
        if (writer != null) {
            printWriter = new PrintWriter(writer);
        }
        revPrintStream = printWriter;
    }

    public void setForOutputStream(Writer writer) {
        PrintWriter printWriter = null;
        if (writer != null) {
            printWriter = new PrintWriter(writer);
        }
        forPrintStream = printWriter;
    }

    public void setIntOutputStream(Writer writer) {
        PrintWriter printWriter = null;
        if (writer != null) {
            printWriter = new PrintWriter(writer);
        }
        intPrintStream = printWriter;
    }

    public String getBestForward() {
        return this.bestForward;
    }

    public String getBestInternal() {
        return this.bestInternal;
    }

    public String getBestReverse() {
        return this.bestReverse;
    }

    private void saveBestPairs() {
        if (this.best_pairs.num_pairs() == 0) {
            this.bestForward = "";
            this.bestInternal = "";
            this.bestReverse = "";
            return;
        }
        primer_pair primer_pair2 = this.best_pairs.getPair(0);
        this.bestForward = Primer3.pr_oligo_sequence(this.sa, primer_pair2.left);
        this.bestInternal = Primer3.pr_oligo_sequence(this.sa, primer_pair2.intl);
        this.bestReverse = Primer3.pr_oligo_rev_c_sequence(this.sa, primer_pair2.right);
    }

    public void setReportFrequency(int n) {
        this.report = n;
    }

    private void progress() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.sa == null || this.pa == null) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Format_output.print_explain(printWriter, this.pa, this.sa, null != this.pa.repeat_lib.repeat_file);
        this.setChanged();
        this.notifyObservers(stringWriter.toString());
    }

    public void run() throws InterruptedException {
        boolean bl = false;
        Primer3.set_dpal_args(this.local_args);
        this.local_args.flag = 0;
        Primer3.set_dpal_args(lib_local_dpal_args);
        Primer3.lib_local_dpal_args.flag = 0;
        Macros.PR_ASSERT(Dpal.dpal_set_ambiguity_code_matrix(lib_local_dpal_args));
        Primer3.set_dpal_args(this.end_args);
        this.end_args.flag = 1;
        Primer3.set_dpal_args(this.local_end_args);
        this.local_end_args.flag = 3;
        Primer3.set_dpal_args(lib_local_end_dpal_args);
        Primer3.lib_local_end_dpal_args.flag = 3;
        Macros.PR_ASSERT(Dpal.dpal_set_ambiguity_code_matrix(lib_local_end_dpal_args));
        while (Boulder_input.read_record(this.aReader, this.prog_args, this.pa, this.sa) > 0) {
            this.progress();
            Thread.yield();
            bl = true;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            RefInt refInt = new RefInt(n3);
            RefInt refInt2 = new RefInt(n2);
            RefInt refInt3 = new RefInt(n);
            if (this.sa.error.noErrors() || this.pa.glob_err.noErrors()) {
                this.pr_choice(refInt, refInt3, refInt2);
            }
            n3 = refInt.getValue();
            n3 = refInt2.getValue();
            n3 = refInt3.getValue();
            if (this.pa.glob_err.hasError()) {
                Primer3.pr_append_new_chunk(this.sa.error, this.pa.glob_err.data.toString());
            }
            if (task.pick_pcr_primers == this.pa.primer_task || task.pick_pcr_primers_and_hyb_probe == this.pa.primer_task) {
                if (this.prog_args.format_output) {
                    Format_output.format_pairs(IO.stdout, this.pa, this.sa, this.best_pairs);
                } else {
                    Primer3.boulder_print_pairs(this.prog_args, this.pa, this.sa, this.best_pairs);
                }
            } else if (this.pa.primer_task == task.pick_left_only) {
                if (this.prog_args.format_output) {
                    Format_output.format_oligos(IO.stdout, this.pa, this.sa, f, n3, oligo_type.OT_LEFT);
                } else {
                    Primer3.boulder_print_oligos(this.pa, this.sa, n3, oligo_type.OT_LEFT);
                }
            } else if (this.pa.primer_task == task.pick_right_only) {
                if (this.prog_args.format_output) {
                    Format_output.format_oligos(IO.stdout, this.pa, this.sa, r, n, oligo_type.OT_RIGHT);
                } else {
                    Primer3.boulder_print_oligos(this.pa, this.sa, n, oligo_type.OT_RIGHT);
                }
            } else if (this.pa.primer_task == task.pick_hyb_probe_only) {
                if (this.prog_args.format_output) {
                    Format_output.format_oligos(IO.stdout, this.pa, this.sa, mid, n2, oligo_type.OT_INTL);
                } else {
                    Primer3.boulder_print_oligos(this.pa, this.sa, n2, oligo_type.OT_INTL);
                }
            }
            this.progress();
            Thread.yield();
            this.saveBestPairs();
            this.best_pairs.reset();
            if (this.pa.repeat_lib.seq_num > 0 || this.pa.io_mishyb_library.seq_num > 0) {
                Primer3.free_repeat_sim_score(n3, n, n2);
            }
            if (null != this.sa.internal_input) {
                this.sa.internal_input = null;
            }
            if (null != this.sa.left_input) {
                this.sa.left_input = null;
            }
            if (null != this.sa.right_input) {
                this.sa.right_input = null;
            }
            if (null != this.sa.sequence) {
                this.sa.sequence = null;
            }
            if (null != this.sa.quality) {
                this.sa.quality = null;
            }
            if (null != this.sa.trimmed_seq) {
                this.sa.trimmed_seq = null;
            }
            if (null != this.sa.sequence_name) {
                this.sa.sequence_name = null;
            }
            if (null != this.sa.error.data) {
                this.sa.error.data = null;
            }
            if (null != this.sa.warning.data) {
                this.sa.warning.data = null;
            }
            if (this.pa.glob_err == null || this.pa.glob_err.getSize() <= 0) continue;
            IO.stdout.print("com.informagen.Primer3: " + this.pa.glob_err.data + "\n");
            this.pa.glob_err.data = null;
            this.sa = null;
            this.local_args = null;
            this.end_args = null;
            this.local_end_args = null;
            lib_local_dpal_args = null;
            lib_local_end_dpal_args = null;
            if (this.best_pairs.storage_size() != 0) {
                this.best_pairs.reset();
            }
            this.pa = null;
        }
        this.sa = null;
        this.local_args = null;
        this.end_args = null;
        this.local_end_args = null;
        lib_local_dpal_args = null;
        lib_local_end_dpal_args = null;
        if (this.best_pairs.storage_size() != 0) {
            this.best_pairs.reset();
        }
        this.pa = null;
        if (!bl) {
            Primer3.print_usage();
        }
    }

    static void set_default_global_primer_args(primer_args primer_args2) {
        primer_args2.primer_opt_size = 20;
        primer_args2.primer_min_size = 18;
        primer_args2.primer_max_size = 27;
        primer_args2.opt_tm = 60.0;
        primer_args2.min_tm = 57.0;
        primer_args2.max_tm = 63.0;
        primer_args2.max_diff_tm = 100.0;
        primer_args2.min_gc = 20.0;
        primer_args2.opt_gc_content = -2.147483648E9;
        primer_args2.max_gc = 80.0;
        primer_args2.salt_conc = 50.0;
        primer_args2.dna_conc = 50.0;
        primer_args2.num_ns_accepted = 0;
        primer_args2.self_any = (short)800;
        primer_args2.self_end = (short)300;
        primer_args2.pair_compl_any = (short)800;
        primer_args2.pair_compl_end = (short)300;
        primer_args2.file_flag = false;
        primer_args2.alignment_flag = true;
        primer_args2.explain_flag = 0;
        primer_args2.forward_report_count = -1;
        primer_args2.io_report_count = -1;
        primer_args2.reverse_report_count = -1;
        primer_args2.gc_clamp = 0;
        primer_args2.max_poly_x = 5;
        primer_args2.liberal_base = 0;
        primer_args2.primer_task = 0;
        primer_args2.first_base_index = 0;
        primer_args2.num_return = 5;
        primer_args2.pr_min[0] = 100;
        primer_args2.pr_max[0] = 300;
        primer_args2.numIntervals = 1;
        primer_args2.repeat_compl = (short)1200;
        primer_args2.pair_repeat_compl = (short)2400;
        primer_args2.min_quality = 0;
        primer_args2.min_end_quality = 0;
        primer_args2.quality_range_min = 0;
        primer_args2.quality_range_max = 100;
        primer_args2.outside_penalty = Constants.PR_DEFAULT_OUTSIDE_PENALTY;
        primer_args2.inside_penalty = Constants.PR_DEFAULT_INSIDE_PENALTY;
        primer_args2.max_end_stability = 100.0;
        primer_args2.product_max_tm = Constants.PR_DEFAULT_PRODUCT_MAX_TM;
        primer_args2.product_min_tm = Constants.PR_DEFAULT_PRODUCT_MIN_TM;
        primer_args2.product_opt_tm = Double.MIN_VALUE;
        primer_args2.product_opt_size = Integer.MIN_VALUE;
        primer_args2.pick_anyway = false;
        primer_args2.io_primer_opt_size = 20;
        primer_args2.io_primer_min_size = 18;
        primer_args2.io_primer_max_size = 27;
        primer_args2.io_opt_tm = 60.0;
        primer_args2.io_min_tm = 57.0;
        primer_args2.io_max_tm = 63.0;
        primer_args2.io_min_gc = 20.0;
        primer_args2.io_opt_gc_content = -2.147483648E9;
        primer_args2.io_max_gc = 80.0;
        primer_args2.io_max_poly_x = 5;
        primer_args2.io_salt_conc = 50.0;
        primer_args2.io_dna_conc = 50.0;
        primer_args2.io_num_ns_accepted = 0;
        primer_args2.io_self_any = (short)1200;
        primer_args2.io_self_end = (short)1200;
        primer_args2.io_repeat_compl = (short)1200;
        primer_args2.io_min_quality = 0;
        primer_args2.io_min_end_quality = 0;
        primer_args2.primer_weights.temp_gt = 1.0;
        primer_args2.primer_weights.temp_lt = 1.0;
        primer_args2.primer_weights.length_gt = 1.0;
        primer_args2.primer_weights.length_lt = 1.0;
        primer_args2.primer_weights.gc_content_gt = 0.0;
        primer_args2.primer_weights.gc_content_lt = 0.0;
        primer_args2.primer_weights.compl_any = 0.0;
        primer_args2.primer_weights.compl_end = 0.0;
        primer_args2.primer_weights.num_ns = 0.0;
        primer_args2.primer_weights.repeat_sim = 0.0;
        primer_args2.primer_weights.seq_quality = 0.0;
        primer_args2.primer_weights.end_quality = 0.0;
        primer_args2.primer_weights.pos_penalty = 1.0;
        primer_args2.primer_weights.end_stability = 0.0;
        primer_args2.io_weights.temp_gt = 1.0;
        primer_args2.io_weights.temp_lt = 1.0;
        primer_args2.io_weights.length_gt = 1.0;
        primer_args2.io_weights.length_lt = 1.0;
        primer_args2.io_weights.gc_content_gt = 0.0;
        primer_args2.io_weights.gc_content_lt = 0.0;
        primer_args2.io_weights.compl_any = 0.0;
        primer_args2.io_weights.compl_end = 0.0;
        primer_args2.io_weights.num_ns = 0.0;
        primer_args2.io_weights.repeat_sim = 0.0;
        primer_args2.io_weights.seq_quality = 0.0;
        primer_args2.io_weights.end_quality = 0.0;
        primer_args2.pr_pair_weights.primer_quality = 1.0;
        primer_args2.pr_pair_weights.io_quality = 0.0;
        primer_args2.pr_pair_weights.diff_tm = 0.0;
        primer_args2.pr_pair_weights.compl_any = 0.0;
        primer_args2.pr_pair_weights.compl_end = 0.0;
        primer_args2.pr_pair_weights.repeat_sim = 0.0;
        primer_args2.pr_pair_weights.product_tm_lt = 0.0;
        primer_args2.pr_pair_weights.product_tm_gt = 0.0;
        primer_args2.pr_pair_weights.product_size_lt = 0.0;
        primer_args2.pr_pair_weights.product_size_gt = 0.0;
    }

    public void pr_choice(RefInt refInt, RefInt refInt2, RefInt refInt3) throws InterruptedException {
        pair_array_t pair_array_t2 = new pair_array_t();
        Macros.PR_ASSERT(null != this.pa);
        Macros.PR_ASSERT(null != this.sa);
        Macros.PR_ASSERT(null != this.local_args);
        Macros.PR_ASSERT(null != this.end_args);
        Macros.PR_ASSERT(null != this.local_end_args);
        Macros.PR_ASSERT(null != refInt);
        Macros.PR_ASSERT(null != refInt2);
        Macros.PR_ASSERT(null != refInt3);
        Macros.PR_ASSERT(0 == refInt.getValue());
        Macros.PR_ASSERT(0 == refInt2.getValue());
        Macros.PR_ASSERT(0 == refInt3.getValue());
        if (!this.data_control()) {
            return;
        }
        f = new Vector(INITIAL_LIST_LEN);
        r = new Vector(INITIAL_LIST_LEN);
        f_len = r_len = INITIAL_LIST_LEN;
        if (!this.make_lists(refInt, refInt2)) {
            return;
        }
        this.progress();
        Thread.yield();
        if ((this.pa.primer_task == task.pick_hyb_probe_only || this.pa.primer_task == task.pick_pcr_primers_and_hyb_probe) && this.make_internal_oligos_list(refInt3) != 0) {
            return;
        }
        this.progress();
        Thread.yield();
        if (this.pa.file_flag) {
            Primer3.print_list(this.sa, this.pa, refInt.getValue(), refInt2.getValue(), refInt3.getValue());
        }
        Thread.yield();
        if (this.pa.primer_task != task.pick_left_only && this.pa.primer_task != task.pick_hyb_probe_only) {
            Primer3.sort_primer_recs(r);
        }
        Thread.yield();
        if (this.pa.primer_task != task.pick_right_only && this.pa.primer_task != task.pick_hyb_probe_only) {
            Primer3.sort_primer_recs(f);
        }
        Thread.yield();
        if (this.pa.primer_task == task.pick_hyb_probe_only) {
            Primer3.sort_primer_recs(mid);
        }
        Thread.yield();
        pair_array_t2.reset();
        if (this.pa.primer_task == task.pick_pcr_primers || this.pa.primer_task == task.pick_pcr_primers_and_hyb_probe) {
            for (int i = 0; i < this.pa.numIntervals; ++i) {
                Thread.yield();
                if (this.choose_pair(refInt.getValue(), refInt2.getValue(), refInt3.getValue(), i, pair_array_t2) != 0) continue;
                for (int j = 0; j < pair_array_t2.num_pairs() && this.best_pairs.num_pairs() < this.pa.num_return; ++j) {
                    Thread.yield();
                    primer_pair primer_pair2 = pair_array_t2.getPair(j);
                    if (Primer3.oligo_pair_seen(primer_pair2, this.best_pairs) != 0) continue;
                    Primer3.add_pair(primer_pair2, this.best_pairs);
                }
                if (this.pa.num_return == this.best_pairs.num_pairs()) break;
                pair_array_t2.reset();
            }
        }
        if (this.pa.pick_anyway) {
            if (this.sa.left_input != null) {
                Primer3.add_must_use_warnings(this.sa, "Left primer", this.sa.left_expl);
            }
            if (this.sa.right_input != null) {
                Primer3.add_must_use_warnings(this.sa, "Right primer", this.sa.right_expl);
            }
            if (this.sa.internal_input != null) {
                Primer3.add_must_use_warnings(this.sa, "Hybridization probe", this.sa.intl_expl);
            }
        }
        if (0 != pair_array_t2.storage_size()) {
            pair_array_t2.reset();
        }
    }

    private static void add_must_use_warnings(seq_args seq_args2, String string, oligo_stats oligo_stats2) {
        String string2 = "/";
        pr_append_str pr_append_str2 = new pr_append_str();
        if (oligo_stats2.ns != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "Too many Ns");
        }
        if (oligo_stats2.target != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "Overlaps Target");
        }
        if (oligo_stats2.excluded != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "Overlaps Excluded Region");
        }
        if (oligo_stats2.gc != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "Unacceptable GC content");
        }
        if (oligo_stats2.gc_clamp != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "No GC clamp");
        }
        if (oligo_stats2.temp_min != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "Tm too low");
        }
        if (oligo_stats2.temp_max != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "Tm too high");
        }
        if (oligo_stats2.compl_any != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "High self complementarity");
        }
        if (oligo_stats2.compl_end != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "High end self complementarity");
        }
        if (oligo_stats2.repeat != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "High similarity to mispriming or mishyb library");
        }
        if (oligo_stats2.poly_x != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "Long poly-X");
        }
        if (oligo_stats2.seq_quality != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "Low sequence quality");
        }
        if (oligo_stats2.stability != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "High 3' stability");
        }
        if (oligo_stats2.no_orf != 0) {
            Primer3.pr_append_w_sep(pr_append_str2, string2, "Would not amplify any ORF");
        }
        if (pr_append_str2.data != null) {
            Primer3.pr_append_new_chunk(seq_args2.warning, string);
            Primer3.pr_append(seq_args2.warning, " is unacceptable: ");
            Primer3.pr_append(seq_args2.warning, pr_append_str2.data.toString());
            pr_append_str2.data = null;
        }
    }

    private static int oligo_pair_seen(primer_pair primer_pair2, pair_array_t pair_array_t2) {
        Vector vector = pair_array_t2.getVector();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            primer_pair primer_pair3 = (primer_pair)iterator.next();
            if (primer_pair3.left.start != primer_pair2.left.start || primer_pair3.left.length != primer_pair2.left.length || primer_pair3.right.start != primer_pair2.right.start || primer_pair3.right.length != primer_pair2.right.length) continue;
            return 1;
        }
        return 0;
    }

    private static void add_pair(primer_pair primer_pair2, pair_array_t pair_array_t2) {
        if (0 == pair_array_t2.storage_size()) {
            pair_array_t2.getVector().ensureCapacity(5);
        } else if (pair_array_t2.storage_size() == pair_array_t2.num_pairs()) {
            pair_array_t2.getVector().ensureCapacity(pair_array_t2.storage_size() * 2);
        }
        pair_array_t2.getVector().addElement(primer_pair2);
    }

    private boolean make_lists(RefInt refInt, RefInt refInt2) throws InterruptedException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = -1;
        char[] cArray = new char[MAX_PRIMER_LENGTH + 1];
        char[] cArray2 = null;
        primer_rec primer_rec2 = new primer_rec();
        int n5 = 0;
        int n6 = 0;
        if (!Macros.PR_START_CODON_POS_IS_NULL(this.sa)) {
            n4 = Primer3.find_stop_codon(this.sa.trimmed_seq, this.sa.start_codon_pos, -1);
            this.sa.stop_codon_pos = Primer3.find_stop_codon(this.sa.trimmed_seq, this.sa.start_codon_pos, 1);
            this.sa.stop_codon_pos += this.sa.incl_s;
        }
        n3 = Integer.MAX_VALUE;
        for (n2 = 0; n2 < this.pa.numIntervals; ++n2) {
            if (this.pa.pr_min[n2] >= n3) continue;
            n3 = this.pa.pr_min[n2];
        }
        int n7 = this.sa.trimmed_seq.length();
        Macros.PR_ASSERT(Integer.MAX_VALUE > n7);
        int n8 = 0;
        int n9 = n7;
        for (n2 = 0; n2 < this.sa.num_targets; ++n2) {
            if (this.sa.tar[n2][0] > n8) {
                n8 = this.sa.tar[n2][0];
            }
            if (this.sa.tar[n2][0] + this.sa.tar[n2][1] - 1 >= n9) continue;
            n9 = this.sa.tar[n2][0] + this.sa.tar[n2][1] - 1;
        }
        if (Primer3.DEFAULT_POSITION_PENALTIES(this.pa)) {
            if (0 == n8) {
                n8 = n7;
            }
            if (n9 == n7) {
                n9 = 0;
            }
        } else {
            n8 = n7;
            n9 = 0;
        }
        int n10 = this.pa.primer_task == task.pick_left_only ? n7 - 1 : (n8 - 1 < n7 - n3 + this.pa.primer_max_size - 1 && (!this.pa.pick_anyway || this.sa.left_input == null) ? n8 - 1 : n7 - n3 + this.pa.primer_max_size - 1);
        int n11 = 0;
        if (this.pa.primer_task != task.pick_right_only && this.pa.primer_task != task.pick_hyb_probe_only) {
            n6 = n7;
            n5 = 0;
            block2: for (n2 = n10; n2 >= this.pa.primer_min_size - 1; --n2) {
                Thread.yield();
                cArray[0] = '\u0000';
                for (n = this.pa.primer_min_size; n <= this.pa.primer_max_size; ++n) {
                    if (this.sa.left_expl.considered % this.report == 0) {
                        this.progress();
                    }
                    Thread.yield();
                    if (n2 - n > n7 - n3 - 1 && task.pick_left_only != this.pa.primer_task) continue;
                    if (n2 - n + 1 < 0) continue block2;
                    if (n11 >= f_len) {
                        f_len += f_len >> 1;
                        f.ensureCapacity(f_len);
                    }
                    primer_rec2.start = n2 - n + 1;
                    primer_rec2.length = n;
                    primer_rec2.repeat_sim.score = null;
                    cArray = Primer3.substr(this.sa.trimmed_seq, primer_rec2.start, primer_rec2.length);
                    if (this.sa.left_input != null && !this.sa.left_input.equalsIgnoreCase(new String(cArray))) continue;
                    boolean bl = primer_rec2.must_use = this.sa.left_input != null && this.pa.pick_anyway;
                    if (this.pa.explain_flag != 0) {
                        ++this.sa.left_expl.considered;
                    }
                    if (!Macros.PR_START_CODON_POS_IS_NULL(this.sa) && (0 != (primer_rec2.start - this.sa.start_codon_pos) % 3 || primer_rec2.start <= n4 || this.sa.stop_codon_pos != -1 && primer_rec2.start >= this.sa.stop_codon_pos)) {
                        if (this.pa.explain_flag != 0) {
                            ++this.sa.left_expl.no_orf;
                        }
                        if (!this.pa.pick_anyway) continue;
                    }
                    primer_rec2.repeat_sim.score = null;
                    Primer3.oligo_param(this.pa, primer_rec2, oligo_type.OT_LEFT, this.local_args, this.end_args, this.local_end_args, this.sa, this.sa.left_expl);
                    if (Primer3.OK_OR_MUST_USE(primer_rec2)) {
                        primer_rec2.quality = Primer3.p_obj_fn(this.pa, primer_rec2, 0);
                        f.addElement(primer_rec2);
                        primer_rec2 = new primer_rec();
                        if (((primer_rec)Primer3.f.elementAt((int)n11)).start < n6) {
                            n6 = ((primer_rec)Primer3.f.elementAt((int)n11)).start;
                        }
                        ++n11;
                        continue;
                    }
                    if (primer_rec2.ok == oligo_violation.OV_TOO_MANY_NS || primer_rec2.ok == oligo_violation.OV_INTERSECT_TARGET || primer_rec2.ok == oligo_violation.OV_SELF_ANY || primer_rec2.ok == oligo_violation.OV_END_STAB || primer_rec2.ok == oligo_violation.OV_POLY_X || primer_rec2.ok == oligo_violation.OV_EXCL_REGION || primer_rec2.ok == oligo_violation.OV_GC_CLAMP || primer_rec2.ok == oligo_violation.OV_SEQ_QUALITY || primer_rec2.ok == oligo_violation.OV_LIB_SIM) continue block2;
                }
            }
        }
        refInt.setValue(n11);
        int n12 = this.pa.primer_task == task.pick_right_only ? 0 : (n9 + 1 > n3 - this.pa.primer_max_size && (!this.pa.pick_anyway || this.sa.right_input == null) ? n9 + 1 : n3 - this.pa.primer_max_size);
        n11 = 0;
        if (this.pa.primer_task != task.pick_left_only && this.pa.primer_task != task.pick_hyb_probe_only) {
            block4: for (n2 = n12; n2 <= n7 - this.pa.primer_min_size; ++n2) {
                cArray[0] = '\u0000';
                for (n = this.pa.primer_min_size; n <= this.pa.primer_max_size; ++n) {
                    if (this.sa.right_expl.considered % this.report == 0) {
                        this.progress();
                    }
                    Thread.yield();
                    if (n2 + n < n3 && this.pa.primer_task != task.pick_right_only) continue;
                    if (n2 + n - 1 >= n7) continue block4;
                    if (n11 >= r_len) {
                        r_len += r_len >> 1;
                        r.ensureCapacity(r_len);
                    }
                    primer_rec2.start = n2 + n - 1;
                    primer_rec2.length = n;
                    primer_rec2.repeat_sim.score = null;
                    cArray = Primer3.substr(this.sa.trimmed_seq, n2, n);
                    cArray2 = Primer3.reverse_complement(new String(cArray));
                    if (this.sa.right_input != null && !this.sa.right_input.equalsIgnoreCase(new String(cArray2))) continue;
                    primer_rec2.must_use = this.sa.right_input != null && this.pa.pick_anyway;
                    primer_rec2.repeat_sim.score = null;
                    Primer3.oligo_param(this.pa, primer_rec2, oligo_type.OT_RIGHT, this.local_args, this.end_args, this.local_end_args, this.sa, this.sa.right_expl);
                    ++this.sa.right_expl.considered;
                    if (Primer3.OK_OR_MUST_USE(primer_rec2)) {
                        primer_rec2.quality = Primer3.p_obj_fn(this.pa, primer_rec2, 0);
                        r.addElement(primer_rec2);
                        primer_rec2 = new primer_rec();
                        if (((primer_rec)Primer3.r.elementAt((int)n11)).start > n5) {
                            n5 = ((primer_rec)Primer3.r.elementAt((int)n11)).start;
                        }
                        ++n11;
                        continue;
                    }
                    if (primer_rec2.ok == oligo_violation.OV_TOO_MANY_NS || primer_rec2.ok == oligo_violation.OV_INTERSECT_TARGET || primer_rec2.ok == oligo_violation.OV_SELF_ANY || primer_rec2.ok == oligo_violation.OV_END_STAB || primer_rec2.ok == oligo_violation.OV_POLY_X || primer_rec2.ok == oligo_violation.OV_EXCL_REGION || primer_rec2.ok == oligo_violation.OV_GC_CLAMP || primer_rec2.ok == oligo_violation.OV_SEQ_QUALITY || primer_rec2.ok == oligo_violation.OV_LIB_SIM) continue block4;
                }
            }
        }
        refInt2.setValue(n11);
        this.sa.left_expl.ok = refInt.getValue();
        this.sa.right_expl.ok = refInt2.getValue();
        if (this.pa.primer_task != task.pick_right_only && this.pa.primer_task != task.pick_hyb_probe_only && 0 == refInt.getValue() || this.pa.primer_task != task.pick_left_only && this.pa.primer_task != task.pick_hyb_probe_only && 0 == refInt2.getValue()) {
            return false;
        }
        if ((this.pa.primer_task == task.pick_pcr_primers || this.pa.primer_task == task.pick_pcr_primers_and_hyb_probe) && n5 - n6 < n3 - 1) {
            this.sa.pair_expl.product = 1;
            this.sa.pair_expl.considered = 1;
            return false;
        }
        return true;
    }

    private int make_internal_oligos_list(RefInt refInt) throws InterruptedException {
        char[] cArray = new char[MAX_PRIMER_LENGTH + 1];
        primer_rec primer_rec2 = new primer_rec();
        mid_len = INITIAL_LIST_LEN;
        mid = new Vector(mid_len);
        int n = this.sa.trimmed_seq.length();
        int n2 = 0;
        block0: for (int i = n - 1; i >= this.pa.io_primer_min_size - 1; --i) {
            Thread.yield();
            cArray[0] = '\u0000';
            for (int j = this.pa.io_primer_min_size; j <= this.pa.io_primer_max_size; ++j) {
                if (this.sa.intl_expl.considered % this.report == 0) {
                    this.progress();
                }
                Thread.yield();
                if (i - j < -1) continue block0;
                if (n2 >= mid_len) {
                    mid_len += mid_len >> 1;
                    mid.ensureCapacity(mid_len);
                }
                primer_rec2.start = i - j + 1;
                primer_rec2.length = j;
                primer_rec2.repeat_sim.score = null;
                cArray = Primer3.substr(this.sa.trimmed_seq, primer_rec2.start, primer_rec2.length);
                if (this.sa.internal_input != null && !this.sa.internal_input.equalsIgnoreCase(new String(cArray))) continue;
                primer_rec2.must_use = this.sa.internal_input != null && this.pa.pick_anyway;
                primer_rec2.repeat_sim.score = null;
                Primer3.oligo_param(this.pa, primer_rec2, oligo_type.OT_INTL, this.local_args, this.end_args, this.local_end_args, this.sa, this.sa.intl_expl);
                ++this.sa.intl_expl.considered;
                if (Primer3.OK_OR_MUST_USE(primer_rec2)) {
                    primer_rec2.quality = Primer3.p_obj_fn(this.pa, primer_rec2, 2);
                    mid.addElement(primer_rec2);
                    primer_rec2 = new primer_rec();
                    ++n2;
                    continue;
                }
                if (primer_rec2.ok == oligo_violation.OV_TOO_MANY_NS || primer_rec2.ok == oligo_violation.OV_INTERSECT_TARGET || primer_rec2.ok == oligo_violation.OV_SELF_ANY || primer_rec2.ok == oligo_violation.OV_POLY_X || primer_rec2.ok == oligo_violation.OV_EXCL_REGION || primer_rec2.ok == oligo_violation.OV_GC_CLAMP || primer_rec2.ok == oligo_violation.OV_SEQ_QUALITY || primer_rec2.ok == oligo_violation.OV_LIB_SIM) continue block0;
            }
        }
        refInt.setValue(n2);
        this.sa.intl_expl.ok = refInt.getValue();
        return refInt.getValue() == 0 ? 1 : 0;
    }

    private static char[] substr(String string, int n, int n2) {
        return string.substring(n, n + n2).toCharArray();
    }

    static char[] reverse_complement(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i <= (n - 1) / 2; ++i) {
            int n2 = n - i - 1;
            char c = Primer3.compBase(cArray[i]);
            cArray[i] = Primer3.compBase(cArray[n2]);
            cArray[n2] = c;
        }
        return cArray;
    }

    public static char compBase(char c) {
        char[] cArray = new char[]{'T', 'V', 'G', 'H', '-', '-', 'C', 'D', '-', '-', 'M', '-', 'K', 'N', '-', '-', '-', 'Y', 'S', 'A', 'A', 'B', 'W', 'X', 'R', '-'};
        char c2 = c;
        if (Character.isLetter(c)) {
            c2 = Character.isLowerCase(c) ? (char)(cArray[c - 97] + 32) : cArray[c - 65];
        }
        return c2;
    }

    static void oligo_param(primer_args primer_args2, primer_rec primer_rec2, int n, dpal_args dpal_args2, dpal_args dpal_args3, dpal_args dpal_args4, seq_args seq_args2, oligo_stats oligo_stats2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        boolean bl = primer_rec2.must_use;
        String string = seq_args2.trimmed_seq;
        char[] cArray = new char[MAX_PRIMER_LENGTH + 1];
        char[] cArray2 = null;
        primer_rec2.ok = oligo_violation.OV_UNINITIALIZED;
        primer_rec2.target = '\u0000';
        primer_rec2.gc_content = 0.0;
        primer_rec2.num_ns = 0;
        primer_rec2.excl = '\u0000';
        Macros.PR_ASSERT(oligo_type.OT_LEFT == n || oligo_type.OT_RIGHT == n || oligo_type.OT_INTL == n);
        if (oligo_type.OT_LEFT == n || oligo_type.OT_INTL == n) {
            n5 = primer_rec2.start;
            n4 = n5 + primer_rec2.length - 1;
        } else {
            n5 = primer_rec2.start - primer_rec2.length + 1;
            n4 = primer_rec2.start;
        }
        Macros.PR_ASSERT(n4 >= 0);
        Macros.PR_ASSERT(n4 < Macros.TRIMMED_SEQ_LEN(seq_args2));
        Primer3.gc_and_n_content(n5, n4 - n5 + 1, seq_args2.trimmed_seq, primer_rec2);
        if ((oligo_type.OT_LEFT == n || oligo_type.OT_RIGHT == n) && primer_rec2.num_ns > primer_args2.num_ns_accepted || oligo_type.OT_INTL == n && primer_rec2.num_ns > primer_args2.io_num_ns_accepted) {
            primer_rec2.ok = oligo_violation.OV_TOO_MANY_NS;
            ++oligo_stats2.ns;
            if (!bl) {
                return;
            }
        }
        Macros.PR_ASSERT(seq_args2.num_targets <= 1 || Primer3.DEFAULT_POSITION_PENALTIES(primer_args2));
        if (n < 2 && Primer3.DEFAULT_POSITION_PENALTIES(primer_args2) && Primer3.oligo_overlaps_interval(n5, n4 - n5 + 1, seq_args2.tar, seq_args2.num_targets)) {
            primer_rec2.position_penalty = 0.0;
            primer_rec2.position_penalty_infinite = '\u0001';
            primer_rec2.target = '\u0001';
        } else if (n < 2 && !Primer3.DEFAULT_POSITION_PENALTIES(primer_args2) && 1 == seq_args2.num_targets) {
            Primer3.compute_position_penalty(primer_args2, seq_args2, primer_rec2, n);
            if (primer_rec2.position_penalty_infinite != '\u0000') {
                primer_rec2.target = '\u0001';
            }
        } else {
            primer_rec2.position_penalty = 0.0;
            primer_rec2.position_penalty_infinite = '\u0000';
        }
        if (!Macros.PR_START_CODON_POS_IS_NULL(seq_args2)) {
            if (oligo_type.OT_LEFT == n) {
                primer_rec2.position_penalty = seq_args2.start_codon_pos > primer_rec2.start ? (double)(seq_args2.start_codon_pos - primer_rec2.start) * 30.0 : (double)(primer_rec2.start - seq_args2.start_codon_pos) * 20.0;
            } else if (oligo_type.OT_RIGHT == n) {
                primer_rec2.position_penalty = -1 == seq_args2.stop_codon_pos ? (double)(Macros.TRIMMED_SEQ_LEN(seq_args2) - primer_rec2.start - 1) * 100.0 : (seq_args2.stop_codon_pos < primer_rec2.start ? (double)(primer_rec2.start - seq_args2.stop_codon_pos) * 0.5 : (double)(seq_args2.stop_codon_pos - primer_rec2.start) * 100.0);
            }
        }
        if (n < 2 && Primer3.oligo_overlaps_interval(n5, n4 - n5 + 1, seq_args2.excl, seq_args2.num_excl)) {
            primer_rec2.excl = '\u0001';
        }
        if (n == 2 && Primer3.oligo_overlaps_interval(n5, n4 - n5 + 1, seq_args2.excl_internal, seq_args2.num_internal_excl)) {
            primer_rec2.excl = '\u0001';
        }
        if (n < 2 && primer_rec2.target == '\u0001') {
            primer_rec2.ok = oligo_violation.OV_INTERSECT_TARGET;
            ++oligo_stats2.target;
            if (!bl) {
                return;
            }
        }
        if (primer_rec2.excl == '\u0001') {
            primer_rec2.ok = oligo_violation.OV_EXCL_REGION;
            ++oligo_stats2.excluded;
            if (!bl) {
                return;
            }
        }
        if (n < 2 && (primer_rec2.gc_content < primer_args2.min_gc || primer_rec2.gc_content > primer_args2.max_gc) || n == 2 && (primer_rec2.gc_content < primer_args2.io_min_gc || primer_rec2.gc_content > primer_args2.io_max_gc)) {
            primer_rec2.ok = oligo_violation.OV_GC_CONTENT;
            ++oligo_stats2.gc;
            if (!bl) {
                return;
            }
        }
        if (primer_args2.gc_clamp != 0) {
            if (oligo_type.OT_LEFT == n) {
                for (n3 = n4 - primer_args2.gc_clamp + 1; n3 <= n4; ++n3) {
                    if (string.charAt(n3) == 'G' || string.charAt(n3) == 'C') continue;
                    primer_rec2.ok = oligo_violation.OV_GC_CLAMP;
                    ++oligo_stats2.gc_clamp;
                    if (bl) break;
                    return;
                }
            }
            if (oligo_type.OT_RIGHT == n) {
                for (n3 = n5; n3 < n5 + primer_args2.gc_clamp; ++n3) {
                    if (string.charAt(n3) == 'G' || string.charAt(n3) == 'C') continue;
                    primer_rec2.ok = oligo_violation.OV_GC_CLAMP;
                    ++oligo_stats2.gc_clamp;
                    if (bl) break;
                    return;
                }
            }
        }
        Primer3.check_sequence_quality(primer_args2, primer_rec2, n, seq_args2, n5, n4, new Integer(n6), new Integer(n7));
        if (oligo_type.OT_LEFT == n || oligo_type.OT_RIGHT == n) {
            if (n6 < primer_args2.min_quality) {
                primer_rec2.ok = oligo_violation.OV_SEQ_QUALITY;
                ++oligo_stats2.seq_quality;
                if (!bl) {
                    return;
                }
            } else if (n7 < primer_args2.min_end_quality) {
                primer_rec2.ok = oligo_violation.OV_SEQ_QUALITY;
                ++oligo_stats2.seq_quality;
                if (!bl) {
                    return;
                }
            }
        } else if (oligo_type.OT_INTL == n) {
            if (n6 < primer_args2.io_min_quality) {
                primer_rec2.ok = oligo_violation.OV_SEQ_QUALITY;
                ++oligo_stats2.seq_quality;
                if (!bl) {
                    return;
                }
            }
        } else {
            Macros.PR_ASSERT(false);
        }
        if ((n2 = oligo_type.OT_LEFT == n || oligo_type.OT_RIGHT == n ? primer_args2.max_poly_x : primer_args2.io_max_poly_x) > 0) {
            int n8 = 1;
            for (n3 = n5 + 1; n3 <= n4; ++n3) {
                if (string.charAt(n3) == string.charAt(n3 - 1) || string.charAt(n3) == 'N') {
                    if (++n8 <= n2) continue;
                    primer_rec2.ok = oligo_violation.OV_POLY_X;
                    ++oligo_stats2.poly_x;
                    if (bl) break;
                    return;
                }
                n8 = 1;
            }
        }
        cArray = Primer3.substr(string, n5, n4 - n5 + 1);
        primer_rec2.temp = oligo_type.OT_LEFT == n || oligo_type.OT_RIGHT == n ? OligoTm.seqtm(new String(cArray), primer_args2.dna_conc, primer_args2.salt_conc) : OligoTm.seqtm(new String(cArray), primer_args2.io_dna_conc, primer_args2.io_salt_conc);
        if ((n == oligo_type.OT_LEFT || n == oligo_type.OT_RIGHT) && primer_rec2.temp < primer_args2.min_tm || n == oligo_type.OT_INTL && primer_rec2.temp < primer_args2.io_min_tm) {
            primer_rec2.ok = oligo_violation.OV_TM_LOW;
            ++oligo_stats2.temp_min;
            if (!bl) {
                return;
            }
        }
        if ((oligo_type.OT_LEFT == n || oligo_type.OT_RIGHT == n) && primer_rec2.temp > primer_args2.max_tm || oligo_type.OT_INTL == n && primer_rec2.temp > primer_args2.io_max_tm) {
            primer_rec2.ok = oligo_violation.OV_TM_HIGH;
            ++oligo_stats2.temp_max;
            if (!bl) {
                return;
            }
        }
        if (oligo_type.OT_LEFT == n) {
            double d;
            primer_rec2.end_stability = OligoTm.end_oligodg(new String(cArray), 5);
            if (d > primer_args2.max_end_stability) {
                primer_rec2.ok = oligo_violation.OV_END_STAB;
                ++oligo_stats2.stability;
                if (!bl) {
                    return;
                }
            }
        } else if (oligo_type.OT_RIGHT == n) {
            double d;
            cArray2 = Primer3.reverse_complement(new String(cArray));
            primer_rec2.end_stability = OligoTm.end_oligodg(new String(cArray2), 5);
            if (d > primer_args2.max_end_stability) {
                primer_rec2.ok = oligo_violation.OV_END_STAB;
                ++oligo_stats2.stability;
                if (!bl) {
                    return;
                }
            }
        }
        if (bl || primer_args2.primer_task != task.pick_pcr_primers && primer_args2.primer_task != task.pick_pcr_primers_and_hyb_probe || (oligo_type.OT_RIGHT == n || oligo_type.OT_LEFT == n) && (primer_args2.primer_weights.compl_any != 0.0 || primer_args2.primer_weights.compl_end != 0.0) || oligo_type.OT_INTL == n && (primer_args2.io_weights.compl_any != 0.0 || primer_args2.io_weights.compl_end != 0.0)) {
            Primer3.oligo_compl(primer_rec2, primer_args2, seq_args2, n, dpal_args2, dpal_args3, dpal_args4);
            if (primer_rec2.ok != oligo_violation.OV_UNINITIALIZED && !bl) {
                return;
            }
        } else {
            primer_rec2.self_any = primer_rec2.self_end = ALIGN_SCORE_UNDEF;
        }
        if (bl || primer_args2.primer_task != task.pick_pcr_primers && primer_args2.primer_task != task.pick_pcr_primers_and_hyb_probe || (oligo_type.OT_RIGHT == n || oligo_type.OT_LEFT == n) && primer_args2.primer_weights.repeat_sim != 0.0 || oligo_type.OT_INTL == n && primer_args2.io_weights.repeat_sim != 0.0) {
            Primer3.oligo_mispriming(primer_rec2, primer_args2, seq_args2, n);
        }
        if (oligo_violation.OV_UNINITIALIZED == primer_rec2.ok) {
            primer_rec2.ok = oligo_violation.OV_OK;
        }
    }

    private static void check_sequence_quality(primer_args primer_args2, primer_rec primer_rec2, int n, seq_args seq_args2, int n2, int n3, Integer n4, Integer n5) {
        int n6;
        int n7 = n6 = primer_args2.quality_range_max;
        int n8 = n6;
        if (null != seq_args2.quality) {
            if (oligo_type.OT_LEFT == n || oligo_type.OT_RIGHT == n) {
                n7 = primer_args2.min_quality;
                n6 = primer_args2.min_end_quality;
            } else {
                n7 = n6 = primer_args2.io_min_quality;
            }
            if (oligo_type.OT_LEFT == n || oligo_type.OT_INTL == n) {
                int n9;
                int n10;
                for (n10 = n3 - 4; n10 <= n3; ++n10) {
                    if (n10 < n2 || (n9 = seq_args2.quality[n10 + seq_args2.incl_s]) >= n8) continue;
                    n8 = n9;
                }
                n6 = n8;
                for (n10 = n2; n10 <= n3 - 5; ++n10) {
                    n9 = seq_args2.quality[n10 + seq_args2.incl_s];
                    if (n9 >= n8) continue;
                    n8 = n9;
                }
                n7 = n8;
            } else if (oligo_type.OT_RIGHT == n) {
                int n11;
                int n12;
                for (n12 = n2; n12 < n2 + 5 && n12 <= n3; ++n12) {
                    n11 = seq_args2.quality[n12 + seq_args2.incl_s];
                    if (n11 >= n8) continue;
                    n8 = n11;
                }
                n6 = n8;
                for (n12 = n2 + 5; n12 <= n3; ++n12) {
                    n11 = seq_args2.quality[n12 + seq_args2.incl_s];
                    if (n11 >= n8) continue;
                    n8 = n11;
                }
                n7 = n8;
            } else {
                Macros.PR_ASSERT(false);
            }
        }
        primer_rec2.seq_quality = n7;
        n4 = new Integer(n7);
        n5 = new Integer(n6);
    }

    private static void gc_and_n_content(int n, int n2, String string, primer_rec primer_rec2) {
        char[] cArray = string.substring(n, n + n2).toCharArray();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if ('N' == c) {
                ++n5;
            } else {
                ++n4;
                if ('C' == c || 'G' == c) {
                    ++n3;
                }
            }
            c = (char)(c + '\u0001');
        }
        primer_rec2.num_ns = n5;
        primer_rec2.gc_content = 0 == n4 ? 0.0 : 100.0 * (double)n3 / (double)n4;
    }

    private static boolean oligo_overlaps_interval(int n, int n2, int[][] nArray, int n3) {
        int n4 = n + n2 - 1;
        for (int i = 0; i < n3; ++i) {
            if (n4 < nArray[i][0] || n > nArray[i][0] + nArray[i][1] - 1) continue;
            return true;
        }
        return false;
    }

    private static double p_obj_fn(primer_args primer_args2, primer_rec primer_rec2, int n) {
        double d = 0.0;
        if (n == oligo_type.OT_LEFT || n == oligo_type.OT_RIGHT) {
            if (primer_args2.primer_weights.temp_gt != 0.0 && primer_rec2.temp > primer_args2.opt_tm) {
                d += primer_args2.primer_weights.temp_gt * (primer_rec2.temp - primer_args2.opt_tm);
            }
            if (primer_args2.primer_weights.temp_lt != 0.0 && primer_rec2.temp < primer_args2.opt_tm) {
                d += primer_args2.primer_weights.temp_lt * (primer_args2.opt_tm - primer_rec2.temp);
            }
            if (primer_args2.primer_weights.gc_content_gt != 0.0 && primer_rec2.gc_content > primer_args2.opt_gc_content) {
                d += primer_args2.primer_weights.gc_content_gt * (primer_rec2.gc_content - primer_args2.opt_gc_content);
            }
            if (primer_args2.primer_weights.gc_content_lt != 0.0 && primer_rec2.gc_content < primer_args2.opt_gc_content) {
                d += primer_args2.primer_weights.gc_content_lt * (primer_args2.opt_gc_content - primer_rec2.gc_content);
            }
            if (primer_args2.primer_weights.length_lt != 0.0 && primer_rec2.length < primer_args2.primer_opt_size) {
                d += primer_args2.primer_weights.length_lt * (double)(primer_args2.primer_opt_size - primer_rec2.length);
            }
            if (primer_args2.primer_weights.length_gt != 0.0 && primer_rec2.length > primer_args2.primer_opt_size) {
                d += primer_args2.primer_weights.length_gt * (double)(primer_rec2.length - primer_args2.primer_opt_size);
            }
            if (primer_args2.primer_weights.compl_any != 0.0) {
                d += primer_args2.primer_weights.compl_any * (double)primer_rec2.self_any / Constants.PR_ALIGN_SCORE_PRECISION;
            }
            if (primer_args2.primer_weights.compl_end != 0.0) {
                d += primer_args2.primer_weights.compl_end * (double)primer_rec2.self_end / Constants.PR_ALIGN_SCORE_PRECISION;
            }
            if (primer_args2.primer_weights.num_ns != 0.0) {
                d += primer_args2.primer_weights.num_ns * (double)primer_rec2.num_ns;
            }
            if (primer_args2.primer_weights.repeat_sim != 0.0) {
                d += primer_args2.primer_weights.repeat_sim * (double)primer_rec2.repeat_sim.score[primer_rec2.repeat_sim.max] / Constants.PR_ALIGN_SCORE_PRECISION;
            }
            if (primer_rec2.target == '\u0000') {
                Macros.PR_ASSERT(primer_rec2.position_penalty_infinite == '\u0000');
                if (primer_args2.primer_weights.pos_penalty != 0.0) {
                    d += primer_args2.primer_weights.pos_penalty * primer_rec2.position_penalty;
                }
            }
            if (primer_args2.primer_weights.end_stability != 0.0) {
                d += primer_args2.primer_weights.end_stability * primer_rec2.end_stability;
            }
            if (primer_args2.primer_weights.seq_quality != 0.0) {
                d += primer_args2.primer_weights.seq_quality * (double)(primer_args2.quality_range_max - primer_rec2.seq_quality);
            }
            return d;
        }
        if (n == oligo_type.OT_INTL) {
            if (primer_args2.io_weights.temp_gt != 0.0 && primer_rec2.temp > primer_args2.io_opt_tm) {
                d += primer_args2.io_weights.temp_gt * (primer_rec2.temp - primer_args2.io_opt_tm);
            }
            if (primer_args2.io_weights.temp_lt != 0.0 && primer_rec2.temp < primer_args2.io_opt_tm) {
                d += primer_args2.io_weights.temp_lt * (primer_args2.io_opt_tm - primer_rec2.temp);
            }
            if (primer_args2.io_weights.gc_content_gt != 0.0 && primer_rec2.gc_content > primer_args2.io_opt_gc_content) {
                d += primer_args2.io_weights.gc_content_gt * (primer_rec2.gc_content - primer_args2.io_opt_gc_content);
            }
            if (primer_args2.io_weights.gc_content_lt != 0.0 && primer_rec2.gc_content < primer_args2.io_opt_gc_content) {
                d += primer_args2.io_weights.gc_content_lt * (primer_args2.io_opt_gc_content - primer_rec2.gc_content);
            }
            if (primer_args2.io_weights.length_lt != 0.0 && primer_rec2.length < primer_args2.io_primer_opt_size) {
                d += primer_args2.io_weights.length_lt * (double)(primer_args2.io_primer_opt_size - primer_rec2.length);
            }
            if (primer_args2.io_weights.length_gt != 0.0 && primer_rec2.length > primer_args2.io_primer_opt_size) {
                d += primer_args2.io_weights.length_gt * (double)(primer_rec2.length - primer_args2.io_primer_opt_size);
            }
            if (primer_args2.io_weights.compl_any != 0.0) {
                d += primer_args2.io_weights.compl_any * (double)primer_rec2.self_any / Constants.PR_ALIGN_SCORE_PRECISION;
            }
            if (primer_args2.io_weights.compl_end != 0.0) {
                d += primer_args2.io_weights.compl_end * (double)primer_rec2.self_end / Constants.PR_ALIGN_SCORE_PRECISION;
            }
            if (primer_args2.io_weights.num_ns != 0.0) {
                d += primer_args2.io_weights.num_ns * (double)primer_rec2.num_ns;
            }
            if (primer_args2.io_weights.repeat_sim != 0.0) {
                d += primer_args2.io_weights.repeat_sim * (double)primer_rec2.repeat_sim.score[primer_rec2.repeat_sim.max] / Constants.PR_ALIGN_SCORE_PRECISION;
            }
            if (primer_args2.io_weights.seq_quality != 0.0) {
                d += primer_args2.io_weights.seq_quality * (double)(primer_args2.quality_range_max - primer_rec2.seq_quality);
            }
            return d;
        }
        Macros.PR_ASSERT(false);
        return 0.0;
    }

    private static void print_list(seq_args seq_args2, primer_args primer_args2, int n, int n2, int n3) {
        int n4 = primer_args2.first_base_index;
        if (primer_args2.primer_task != task.pick_right_only && primer_args2.primer_task != task.pick_hyb_probe_only) {
            Primer3.create_and_print_file(seq_args2, primer_args2, n, f, oligo_type.OT_LEFT, n4, null != primer_args2.repeat_lib.repeat_file, ".for");
        }
        if (primer_args2.primer_task != task.pick_left_only && primer_args2.primer_task != task.pick_hyb_probe_only) {
            Primer3.create_and_print_file(seq_args2, primer_args2, n2, r, oligo_type.OT_RIGHT, n4, null != primer_args2.repeat_lib.repeat_file, ".rev");
        }
        if (primer_args2.primer_task == task.pick_pcr_primers_and_hyb_probe || primer_args2.primer_task == task.pick_hyb_probe_only) {
            Primer3.create_and_print_file(seq_args2, primer_args2, n3, mid, oligo_type.OT_INTL, n4, null != primer_args2.io_mishyb_library.repeat_file, ".int");
        }
    }

    private static void create_and_print_file(seq_args seq_args2, primer_args primer_args2, int n, Vector vector, int n2, int n3, boolean bl, String string) {
        PrintWriter printWriter = null;
        if (string.equals(".rev")) {
            printWriter = revPrintStream;
            int n4 = n = primer_args2.reverse_report_count >= 0 ? primer_args2.reverse_report_count : n;
        }
        if (string.equals(".for")) {
            printWriter = forPrintStream;
            int n5 = n = primer_args2.forward_report_count >= 0 ? primer_args2.forward_report_count : n;
        }
        if (string.equals(".int")) {
            printWriter = intPrintStream;
            int n6 = n = primer_args2.io_report_count >= 0 ? primer_args2.io_report_count : n;
        }
        if (printWriter == null) {
            return;
        }
        Vector vector2 = (Vector)vector.clone();
        Primer3.sort_primer_recs(vector2);
        Primer3.print_list_header(printWriter, n2, n3, bl);
        n = vector2.size() < n ? vector2.size() : n;
        for (int i = 0; i < n; ++i) {
            Primer3.print_oligo(printWriter, seq_args2, i + 1, (primer_rec)vector2.elementAt(i), n2, n3, bl);
        }
        if (vector2.size() > n) {
            printWriter.print("\n\n Only the top " + n + " of " + vector2.size() + " are shown.\n");
        }
    }

    private static void print_list_header(PrintWriter printWriter, int n, int n2, boolean bl) {
        printWriter.print("\n\nACCEPTABLE " + (oligo_type.OT_LEFT == n ? "LEFT PRIMERS" : (oligo_type.OT_RIGHT == n ? "RIGHT PRIMERS" : "INTERNAL OLIGOS")) + "\n");
        printWriter.print(F.f(" ", 36, (short)16) + F.f(n2, 4) + "-based     ");
        printWriter.print("#               self  self  qual-\n");
        printWriter.print("   # sequence                            start ln  ");
        printWriter.print("N   GC%     Tm   any   end   lity\n");
    }

    private static void print_oligo(PrintWriter printWriter, seq_args seq_args2, int n, primer_rec primer_rec2, int n2, int n3, boolean bl) {
        String string = oligo_type.OT_RIGHT != n2 ? Primer3.pr_oligo_sequence(seq_args2, primer_rec2) : Primer3.pr_oligo_rev_c_sequence(seq_args2, primer_rec2);
        printWriter.print(F.f(n, 5, (short)2));
        printWriter.print(F.f(string, 35, (short)2));
        printWriter.print(F.f(primer_rec2.start + seq_args2.incl_s + n3, 6));
        printWriter.print(F.f(primer_rec2.length, 3));
        printWriter.print(F.f(primer_rec2.num_ns, 3));
        printWriter.print(F.f(primer_rec2.gc_content, 6, 1));
        printWriter.print(F.f(primer_rec2.temp, 7, 1));
        printWriter.print(F.f((int)((double)primer_rec2.self_any / Constants.PR_ALIGN_SCORE_PRECISION), 6));
        printWriter.print(F.f((int)((double)primer_rec2.self_end / Constants.PR_ALIGN_SCORE_PRECISION), 6));
        printWriter.print(F.f(primer_rec2.quality, 7, 3));
        printWriter.print("\n");
    }

    private int choose_pair(int n, int n2, int n3, int n4, pair_array_t pair_array_t2) throws InterruptedException {
        int n5 = 0;
        primer_pair primer_pair2 = new primer_pair();
        primer_pair primer_pair3 = new primer_pair();
        int n6 = 0;
        int n7 = 0;
        int n8 = n;
        block0: for (int i = 0; i < n2; ++i) {
            if (!Primer3.OK_OR_MUST_USE((primer_rec)r.elementAt(i))) continue;
            if (n6 >= this.pa.num_return && (((primer_rec)Primer3.r.elementAt((int)i)).quality + ((primer_rec)Primer3.f.elementAt((int)0)).quality > primer_pair3.pair_quality || primer_pair3.pair_quality == 0.0)) break;
            for (int j = 0; j < n8; ++j) {
                if (this.sa.pair_expl.considered % this.report == 0) {
                    this.progress();
                }
                Thread.yield();
                if (!Primer3.OK_OR_MUST_USE((primer_rec)r.elementAt(i))) continue block0;
                if (!Primer3.OK_OR_MUST_USE((primer_rec)f.elementAt(j))) continue;
                if (n6 >= this.pa.num_return && (((primer_rec)Primer3.f.elementAt((int)j)).quality + ((primer_rec)Primer3.r.elementAt((int)i)).quality > primer_pair3.pair_quality || primer_pair3.pair_quality == 0.0)) {
                    n8 = j;
                    continue block0;
                }
                if (PAIR_OK != Primer3.pair_param(this.pa, this.sa, j, i, n4, primer_pair2, this.local_args, this.end_args, this.local_end_args)) continue;
                if (this.pa.pr_pair_weights.io_quality == 0.0) {
                    primer_pair2.pair_quality = this.obj_fn(primer_pair2);
                }
                RefInt refInt = new RefInt(n5);
                if (this.pa.primer_task == task.pick_pcr_primers_and_hyb_probe && Primer3.choose_internal_oligo(primer_pair2.left, primer_pair2.right, n3, refInt, this.sa, this.pa, this.local_args, this.end_args, this.local_end_args) != 0) {
                    n5 = refInt.getValue();
                    ++this.sa.pair_expl.internal;
                    continue;
                }
                n5 = refInt.getValue();
                ++this.sa.pair_expl.ok;
                if (n6 < this.pa.num_return) {
                    if (this.pa.primer_task == task.pick_pcr_primers_and_hyb_probe) {
                        primer_pair2.intl = (primer_rec)mid.elementAt(n5);
                    }
                    if (this.pa.pr_pair_weights.io_quality != 0.0) {
                        primer_pair2.pair_quality = this.obj_fn(primer_pair2);
                    }
                    Primer3.add_pair((primer_pair)primer_pair2.clone(), pair_array_t2);
                    if (n6 == 0 || Primer3.primer_pair_comp(primer_pair2, primer_pair3) > 0) {
                        primer_pair3 = (primer_pair)primer_pair2.clone();
                        n7 = n6;
                    }
                    ++n6;
                    continue;
                }
                if (this.pa.primer_task == task.pick_pcr_primers_and_hyb_probe) {
                    primer_pair2.intl = (primer_rec)mid.elementAt(n5);
                }
                if (this.pa.pr_pair_weights.io_quality != 0.0) {
                    primer_pair2.pair_quality = this.obj_fn(primer_pair2);
                }
                if (Primer3.primer_pair_comp(primer_pair2, primer_pair3) >= 0) continue;
                pair_array_t2.getVector().setElementAt((primer_pair)primer_pair2.clone(), n7);
                primer_pair3 = (primer_pair)primer_pair2.clone();
                for (int k = 0; k < this.pa.num_return; ++k) {
                    Thread.yield();
                    if (Primer3.primer_pair_comp(pair_array_t2.getPair(k), primer_pair3) <= 0) continue;
                    n7 = k;
                    primer_pair3 = (primer_pair)pair_array_t2.getPair(k).clone();
                }
            }
        }
        if (n6 != 0) {
            Primer3.sort_primer_pairs(pair_array_t2.getVector());
        }
        if (n6 == 0) {
            return 1;
        }
        return 0;
    }

    private static int choose_internal_oligo(primer_rec primer_rec2, primer_rec primer_rec3, int n, RefInt refInt, seq_args seq_args2, primer_args primer_args2, dpal_args dpal_args2, dpal_args dpal_args3, dpal_args dpal_args4) {
        double d = 1000000.0;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            Thread.yield();
            primer_rec primer_rec4 = (primer_rec)mid.elementAt(i);
            if (primer_rec4.start <= primer_rec2.start + (primer_rec2.length - 1) || primer_rec4.start + (primer_rec4.length - 1) >= primer_rec3.start - primer_rec3.length + 1 || !(primer_rec4.quality < d) || !Primer3.OK_OR_MUST_USE(primer_rec4)) continue;
            if (primer_rec4.self_any == ALIGN_SCORE_UNDEF) {
                Primer3.oligo_compl(primer_rec4, primer_args2, seq_args2, oligo_type.OT_INTL, dpal_args2, dpal_args3, dpal_args4);
                if (!Primer3.OK_OR_MUST_USE(primer_rec4)) continue;
            }
            if (primer_rec4.repeat_sim.score == null) {
                Primer3.oligo_mispriming(primer_rec4, primer_args2, seq_args2, oligo_type.OT_INTL);
                if (!Primer3.OK_OR_MUST_USE(primer_rec4)) continue;
            }
            d = primer_rec4.quality;
            n2 = i;
        }
        refInt.setValue(n2);
        if (refInt.getValue() < 0) {
            return 1;
        }
        return 0;
    }

    static int primer_rec_comp(Object object, Object object2) {
        Macros.PR_ASSERT(object instanceof primer_rec);
        Macros.PR_ASSERT(object2 instanceof primer_rec);
        primer_rec primer_rec2 = (primer_rec)object;
        primer_rec primer_rec3 = (primer_rec)object2;
        if (primer_rec2.quality < primer_rec3.quality) {
            return -1;
        }
        if (primer_rec2.quality > primer_rec3.quality) {
            return 1;
        }
        if (primer_rec2.start > primer_rec3.start) {
            return -1;
        }
        if (primer_rec2.start < primer_rec3.start) {
            return 1;
        }
        if (primer_rec2.length < primer_rec3.length) {
            return -1;
        }
        if (primer_rec2.length > primer_rec3.length) {
            return 1;
        }
        return 0;
    }

    private static int primer_pair_comp(Object object, Object object2) {
        Macros.PR_ASSERT(object instanceof primer_pair);
        Macros.PR_ASSERT(object2 instanceof primer_pair);
        primer_pair primer_pair2 = (primer_pair)object;
        primer_pair primer_pair3 = (primer_pair)object2;
        if (primer_pair2.pair_quality < primer_pair3.pair_quality) {
            return -1;
        }
        if (primer_pair2.pair_quality > primer_pair3.pair_quality) {
            return 1;
        }
        if (primer_pair2.compl_measure < primer_pair3.compl_measure) {
            return -1;
        }
        if (primer_pair2.compl_measure > primer_pair3.compl_measure) {
            return 1;
        }
        int n = primer_pair2.left.start;
        int n2 = primer_pair3.left.start;
        if (n > n2) {
            return -1;
        }
        if (n < n2) {
            return 1;
        }
        n = primer_pair2.right.start;
        n2 = primer_pair3.right.start;
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        n = primer_pair2.left.length;
        n2 = primer_pair3.left.length;
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        n = primer_pair2.right.length;
        n2 = primer_pair3.right.length;
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    private static boolean pair_param(primer_args primer_args2, seq_args seq_args2, int n, int n2, int n3, primer_pair primer_pair2, dpal_args dpal_args2, dpal_args dpal_args3, dpal_args dpal_args4) {
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        primer_pair2.left = (primer_rec)f.elementAt(n);
        primer_pair2.right = (primer_rec)r.elementAt(n2);
        primer_pair2.product_size = primer_pair2.right.start - primer_pair2.left.start + 1;
        primer_pair2.target = 0;
        primer_pair2.compl_end = 0;
        primer_pair2.compl_any = 0;
        ++seq_args2.pair_expl.considered;
        if (primer_pair2.product_size < primer_args2.pr_min[n3] || primer_pair2.product_size > primer_args2.pr_max[n3]) {
            ++seq_args2.pair_expl.product;
            primer_pair2.product_size = -1;
            return PAIR_FAILED;
        }
        if (seq_args2.num_targets > 0) {
            if (Primer3.pair_spans_target(primer_pair2, seq_args2)) {
                primer_pair2.target = 1;
            } else {
                primer_pair2.target = -1;
                ++seq_args2.pair_expl.target;
                return PAIR_FAILED;
            }
        }
        primer_pair2.product_tm = OligoTm.long_seq_tm(seq_args2.trimmed_seq, primer_pair2.left.start, primer_pair2.right.start - primer_pair2.left.start + 1, primer_args2.salt_conc);
        Macros.PR_ASSERT(primer_pair2.product_tm != OligoTm.OLIGOTM_ERROR);
        double d = primer_pair2.left.temp > primer_pair2.right.temp ? primer_pair2.right.temp : primer_pair2.left.temp;
        primer_pair2.product_tm_oligo_tm_diff = primer_pair2.product_tm - d;
        primer_pair2.t_opt_a = 0.3 * d + 0.7 * primer_pair2.product_tm - 14.9;
        if (primer_args2.product_min_tm != Constants.PR_DEFAULT_PRODUCT_MIN_TM && primer_pair2.product_tm < primer_args2.product_min_tm) {
            ++seq_args2.pair_expl.low_tm;
            return PAIR_FAILED;
        }
        if (primer_args2.product_max_tm != Constants.PR_DEFAULT_PRODUCT_MAX_TM && primer_pair2.product_tm > primer_args2.product_max_tm) {
            ++seq_args2.pair_expl.high_tm;
            return PAIR_FAILED;
        }
        primer_pair2.diff_tm = Math.abs(((primer_rec)Primer3.f.elementAt((int)n)).temp - ((primer_rec)Primer3.r.elementAt((int)n2)).temp);
        if (primer_pair2.diff_tm > primer_args2.max_diff_tm) {
            ++seq_args2.pair_expl.temp_diff;
            return PAIR_FAILED;
        }
        if (((primer_rec)Primer3.f.elementAt((int)n)).self_any == ALIGN_SCORE_UNDEF) {
            Primer3.oligo_compl((primer_rec)f.elementAt(n), primer_args2, seq_args2, oligo_type.OT_LEFT, dpal_args2, dpal_args3, dpal_args4);
            if (!Primer3.OK_OR_MUST_USE((primer_rec)f.elementAt(n))) {
                --seq_args2.pair_expl.considered;
                return PAIR_FAILED;
            }
        }
        if (((primer_rec)Primer3.f.elementAt((int)n)).repeat_sim.score == null) {
            Primer3.oligo_mispriming((primer_rec)f.elementAt(n), primer_args2, seq_args2, oligo_type.OT_LEFT);
            if (!Primer3.OK_OR_MUST_USE((primer_rec)f.elementAt(n))) {
                --seq_args2.pair_expl.considered;
                return PAIR_FAILED;
            }
        }
        if (((primer_rec)Primer3.r.elementAt((int)n2)).self_any == ALIGN_SCORE_UNDEF) {
            Primer3.oligo_compl((primer_rec)r.elementAt(n2), primer_args2, seq_args2, oligo_type.OT_RIGHT, dpal_args2, dpal_args3, dpal_args4);
            if (!Primer3.OK_OR_MUST_USE((primer_rec)r.elementAt(n2))) {
                --seq_args2.pair_expl.considered;
                return PAIR_FAILED;
            }
        }
        if (((primer_rec)Primer3.r.elementAt((int)n2)).repeat_sim.score == null) {
            Primer3.oligo_mispriming((primer_rec)r.elementAt(n2), primer_args2, seq_args2, oligo_type.OT_RIGHT);
            if (!Primer3.OK_OR_MUST_USE((primer_rec)r.elementAt(n2))) {
                --seq_args2.pair_expl.considered;
                return PAIR_FAILED;
            }
        }
        cArray = Primer3.substr(seq_args2.trimmed_seq, ((primer_rec)Primer3.f.elementAt((int)n)).start, ((primer_rec)Primer3.f.elementAt((int)n)).length);
        cArray2 = Primer3.substr(seq_args2.trimmed_seq, ((primer_rec)Primer3.r.elementAt((int)n2)).start - ((primer_rec)Primer3.r.elementAt((int)n2)).length + 1, ((primer_rec)Primer3.r.elementAt((int)n2)).length);
        primer_pair2.compl_any = Primer3.align(cArray, cArray2, dpal_args2);
        if (primer_pair2.compl_any > primer_args2.self_any) {
            ++seq_args2.pair_expl.compl_any;
            return PAIR_FAILED;
        }
        short s = Primer3.align(cArray, cArray2, dpal_args3);
        primer_pair2.compl_end = s;
        if (s > primer_args2.self_end) {
            ++seq_args2.pair_expl.compl_end;
            return PAIR_FAILED;
        }
        cArray3 = Primer3.reverse_complement(new String(cArray));
        cArray4 = Primer3.reverse_complement(new String(cArray2));
        short s2 = Primer3.align(cArray4, cArray3, dpal_args3);
        if (s2 > primer_pair2.compl_end) {
            if (s2 > primer_args2.self_end) {
                ++seq_args2.pair_expl.compl_end;
                return PAIR_FAILED;
            }
            primer_pair2.compl_end = s2;
        }
        primer_pair2.compl_measure = (double)(primer_pair2.right.self_end + primer_pair2.left.self_end + primer_pair2.compl_end) * 1.1 + (double)primer_pair2.right.self_any + (double)primer_pair2.left.self_any + (double)primer_pair2.compl_any;
        primer_pair2.repeat_sim = (short)Primer3.pair_repeat_sim(primer_pair2, primer_args2);
        if (primer_pair2.repeat_sim > primer_args2.pair_repeat_compl) {
            ++seq_args2.pair_expl.repeat_sim;
            return PAIR_FAILED;
        }
        return PAIR_OK;
    }

    private static void compute_position_penalty(primer_args primer_args2, seq_args seq_args2, primer_rec primer_rec2, int n) {
        boolean bl = false;
        Macros.PR_ASSERT(oligo_type.OT_LEFT == n || oligo_type.OT_RIGHT == n);
        Macros.PR_ASSERT(1 == seq_args2.num_targets);
        int n2 = seq_args2.tar[0][0];
        int n3 = n2 + seq_args2.tar[0][1] - 1;
        int n4 = oligo_type.OT_LEFT == n ? primer_rec2.start + primer_rec2.length - 1 : primer_rec2.start - primer_rec2.length + 1;
        primer_rec2.position_penalty_infinite = '\u0001';
        primer_rec2.position_penalty = 0.0;
        if (oligo_type.OT_LEFT == n) {
            if (n4 <= n3) {
                primer_rec2.position_penalty_infinite = '\u0000';
                if (n4 < n2) {
                    primer_rec2.position_penalty = n2 - n4 - 1;
                } else {
                    primer_rec2.position_penalty = n4 - n2 + 1;
                    bl = true;
                }
            }
        } else if (n4 >= n2) {
            primer_rec2.position_penalty_infinite = '\u0000';
            if (n4 > n3) {
                primer_rec2.position_penalty = n4 - n3 - 1;
            } else {
                primer_rec2.position_penalty = n3 - n4 + 1;
                bl = true;
            }
        }
        primer_rec2.position_penalty = !bl ? (primer_rec2.position_penalty *= primer_args2.outside_penalty) : (primer_rec2.position_penalty *= primer_args2.inside_penalty);
    }

    private static boolean pair_spans_target(primer_pair primer_pair2, seq_args seq_args2) {
        int n = primer_pair2.left.start + primer_pair2.left.length - 1;
        int n2 = primer_pair2.right.start - primer_pair2.right.length + 1;
        for (int i = 0; i < seq_args2.num_targets; ++i) {
            int n3 = seq_args2.tar[i][0];
            int n4 = n3 + seq_args2.tar[i][1] - 1;
            if (n > n4 || n2 < n3 || n >= n2) continue;
            return true;
        }
        return false;
    }

    private double obj_fn(primer_pair primer_pair2) {
        double d = 0.0;
        if (this.pa.pr_pair_weights.primer_quality != 0.0) {
            d += this.pa.pr_pair_weights.primer_quality * (primer_pair2.left.quality + primer_pair2.right.quality);
        }
        if (this.pa.pr_pair_weights.io_quality != 0.0 && this.pa.primer_task == task.pick_pcr_primers_and_hyb_probe) {
            d += this.pa.pr_pair_weights.io_quality * primer_pair2.intl.quality;
        }
        if (this.pa.pr_pair_weights.diff_tm != 0.0) {
            d += this.pa.pr_pair_weights.diff_tm * primer_pair2.diff_tm;
        }
        if (this.pa.pr_pair_weights.compl_any != 0.0) {
            d += this.pa.pr_pair_weights.compl_any * (double)primer_pair2.compl_any / Constants.PR_ALIGN_SCORE_PRECISION;
        }
        if (this.pa.pr_pair_weights.compl_end != 0.0) {
            d += this.pa.pr_pair_weights.compl_end * (double)primer_pair2.compl_end / Constants.PR_ALIGN_SCORE_PRECISION;
        }
        if (this.pa.pr_pair_weights.product_tm_lt != 0.0 && primer_pair2.product_tm < this.pa.product_opt_tm) {
            d += this.pa.pr_pair_weights.product_tm_lt * (this.pa.product_opt_tm - primer_pair2.product_tm);
        }
        if (this.pa.pr_pair_weights.product_tm_gt != 0.0 && primer_pair2.product_tm > this.pa.product_opt_tm) {
            d += this.pa.pr_pair_weights.product_tm_gt * (primer_pair2.product_tm - this.pa.product_opt_tm);
        }
        if (this.pa.pr_pair_weights.product_size_lt != 0.0 && primer_pair2.product_size < this.pa.product_opt_size) {
            d += this.pa.pr_pair_weights.product_size_lt * (double)(this.pa.product_opt_size - primer_pair2.product_size);
        }
        if (this.pa.pr_pair_weights.product_size_gt != 0.0 && primer_pair2.product_size > this.pa.product_opt_size) {
            d += this.pa.pr_pair_weights.product_size_gt * (double)(primer_pair2.product_size - this.pa.product_opt_size);
        }
        if (this.pa.pr_pair_weights.repeat_sim != 0.0) {
            d += this.pa.pr_pair_weights.repeat_sim * (double)primer_pair2.repeat_sim;
        }
        return d;
    }

    static String pr_gather_warnings(seq_args seq_args2, primer_args primer_args2) {
        pr_append_str pr_append_str2 = new pr_append_str();
        Macros.PR_ASSERT(null != seq_args2);
        Macros.PR_ASSERT(null != primer_args2);
        if (primer_args2.repeat_lib.warning.data != null) {
            Primer3.pr_append_new_chunk(pr_append_str2, primer_args2.repeat_lib.warning.data.toString());
        }
        if (primer_args2.io_mishyb_library.warning.data != null) {
            Primer3.pr_append_new_chunk(pr_append_str2, primer_args2.io_mishyb_library.warning.data.toString());
            Primer3.pr_append(pr_append_str2, " (for internal oligo)");
        }
        if (seq_args2.warning.data != null) {
            Primer3.pr_append_new_chunk(pr_append_str2, seq_args2.warning.data.toString());
        }
        return Primer3.pr_is_empty(pr_append_str2) ? null : pr_append_str2.data.toString();
    }

    private static void boulder_print_pairs(program_args program_args2, primer_args primer_args2, seq_args seq_args2, pair_array_t pair_array_t2) {
    }

    private static void boulder_print_oligos(primer_args primer_args2, seq_args seq_args2, int n, int n2) {
    }

    static void pr_print_pair_explain(PrintWriter printWriter, seq_args seq_args2) {
        printWriter.print("considered " + seq_args2.pair_expl.considered);
        if (seq_args2.pair_expl.target != 0) {
            printWriter.print(", no target " + seq_args2.pair_expl.target);
        }
        if (seq_args2.pair_expl.product != 0) {
            printWriter.print(", unacceptable product size " + seq_args2.pair_expl.product);
        }
        if (seq_args2.pair_expl.low_tm != 0) {
            printWriter.print(", low product Tm " + seq_args2.pair_expl.low_tm);
        }
        if (seq_args2.pair_expl.high_tm != 0) {
            printWriter.print(", high product Tm " + seq_args2.pair_expl.high_tm);
        }
        if (seq_args2.pair_expl.temp_diff != 0) {
            printWriter.print(", tm diff too large " + seq_args2.pair_expl.temp_diff);
        }
        if (seq_args2.pair_expl.compl_any != 0) {
            printWriter.print(", high any compl " + seq_args2.pair_expl.compl_any);
        }
        if (seq_args2.pair_expl.compl_end != 0) {
            printWriter.print(", high end compl " + seq_args2.pair_expl.compl_end);
        }
        if (seq_args2.pair_expl.internal != 0) {
            printWriter.print(", no internal oligo " + seq_args2.pair_expl.internal);
        }
        if (seq_args2.pair_expl.repeat_sim != 0) {
            printWriter.print(", high mispriming library similarity " + seq_args2.pair_expl.repeat_sim);
        }
        printWriter.print(", ok " + seq_args2.pair_expl.ok);
    }

    private boolean data_control() {
        int n;
        char[] cArray = new char[MAX_PRIMER_LENGTH + 1];
        int n2 = this.sa.sequence.length();
        boolean bl = false;
        if (this.pa.primer_min_size < 1) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_MIN_SIZE must be >= 1");
        }
        if (this.pa.primer_max_size > MAX_PRIMER_LENGTH) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_MAX_SIZE exceeds built-in maximum of ");
            Primer3.pr_append(this.pa.glob_err, Primer3.MACRO_VALUE_AS_STRING(MAX_PRIMER_LENGTH));
            return false;
        }
        if (this.pa.primer_opt_size > this.pa.primer_max_size) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_{OPT,DEFAULT}_SIZE > PRIMER_MAX_SIZE");
            return false;
        }
        if (this.pa.primer_opt_size < this.pa.primer_min_size) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_{OPT,DEFAULT}_SIZE < PRIMER_MIN_SIZE");
            return false;
        }
        if (this.pa.io_primer_max_size > MAX_PRIMER_LENGTH) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_INTERNAL_OLIGO_MAX_SIZE exceeds built-in maximum");
            return false;
        }
        if (this.pa.io_primer_opt_size > this.pa.io_primer_max_size) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_INTERNAL_OLIGO_{OPT,DEFAULT}_SIZE > MAX_SIZE");
            return false;
        }
        if (this.pa.io_primer_opt_size < this.pa.io_primer_min_size) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_INTERNAL_OLIGO_{OPT,DEFAULT}_SIZE < MIN_SIZE");
            return false;
        }
        if (this.pa.gc_clamp > this.pa.primer_min_size) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_GC_CLAMP > PRIMER_MIN_SIZE");
            return false;
        }
        if (0 == this.pa.numIntervals) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Empty value for PRIMER_PRODUCT_SIZE_RANGE");
            return false;
        }
        for (n = 0; n < this.pa.numIntervals; ++n) {
            if (this.pa.pr_min[n] <= this.pa.pr_max[n] && this.pa.pr_min[n] >= 0) continue;
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Illegal element in PRIMER_PRODUCT_SIZE_RANGE");
            return false;
        }
        int n3 = Integer.MAX_VALUE;
        for (n = 0; n < this.pa.numIntervals; ++n) {
            if (this.pa.pr_min[n] >= n3) continue;
            n3 = this.pa.pr_min[n];
        }
        if (this.pa.primer_max_size > n3) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_MAX_SIZE > min PRIMER_PRODUCT_SIZE_RANGE");
            return false;
        }
        if (this.pa.io_primer_max_size > n3) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_INTERNAL_OLIGO_MAX_SIZE > min PRIMER_PRODUCT_SIZE_RANGE");
            return false;
        }
        if (this.pa.num_return < 1) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_NUM_RETURN < 1");
            return false;
        }
        if (this.sa.incl_l >= Integer.MAX_VALUE) {
            Primer3.pr_append_new_chunk(this.sa.error, "Value for INCLUDED_REGION too large");
            return false;
        }
        if (this.sa.incl_s < 0 || this.sa.incl_l < 0 || this.sa.incl_s + this.sa.incl_l > n2) {
            Primer3.pr_append_new_chunk(this.sa.error, "Illegal value for INCLUDED_REGION");
            return false;
        }
        if (this.sa.incl_l < n3 && this.pa.primer_task != task.pick_hyb_probe_only && this.pa.primer_task != task.pick_left_only && this.pa.primer_task != task.pick_right_only) {
            Primer3.pr_append_new_chunk(this.sa.error, "INCLUDED_REGION length < min PRIMER_PRODUCT_SIZE_RANGE");
            return false;
        }
        if (this.pa.max_end_stability < 0.0) {
            Primer3.pr_append_new_chunk(this.sa.error, "PRIMER_MAX_END_STABILITY must be non-negative");
            return false;
        }
        if (!Macros.PR_START_CODON_POS_IS_NULL(this.sa)) {
            if (!Macros.PR_POSITION_PENALTY_IS_NULL(this.pa)) {
                Primer3.pr_append_new_chunk(this.sa.error, "Cannot accept both PRIMER_START_CODON_POSITION and non-default ");
                Primer3.pr_append(this.sa.error, "arguments for PRIMER_INSIDE_PENALTY or PRIMER_OUTSIDE_PENALTY");
            }
            if (this.sa.start_codon_pos > this.sa.incl_s + this.sa.incl_l - 3) {
                Primer3.pr_append_new_chunk(this.sa.error, "Start codon position not contained in INCLUDED_REGION");
            } else if (this.sa.start_codon_pos >= 0 && (this.sa.sequence.charAt(this.sa.start_codon_pos) != 'A' && this.sa.sequence.charAt(this.sa.start_codon_pos) != 'a' || this.sa.sequence.charAt(this.sa.start_codon_pos + 1) != 'T' && this.sa.sequence.charAt(this.sa.start_codon_pos + 1) != 't' || this.sa.sequence.charAt(this.sa.start_codon_pos + 2) != 'G' && this.sa.sequence.charAt(this.sa.start_codon_pos + 2) != 'g')) {
                Primer3.pr_append_new_chunk(this.sa.error, "No start codon at PRIMER_START_CODON_POSITION");
            }
        }
        this.sa.trimmed_seq = new String();
        this.sa.trimmed_seq = new String(Primer3.substr(this.sa.sequence, this.sa.incl_s, this.sa.incl_l));
        if (Primer3.check_intervals("TARGET", this.sa.num_targets, this.sa.tar, n2, this.sa) == 1) {
            return false;
        }
        this.sa.start_codon_pos -= this.sa.incl_s;
        if (Primer3.check_intervals("EXCLUDED_REGION", this.sa.num_excl, this.sa.excl, n2, this.sa) == 1) {
            return false;
        }
        if (Primer3.check_intervals("PRIMER_INTERNAL_OLIGO_EXCLUDED_REGION", this.sa.num_internal_excl, this.sa.excl_internal, n2, this.sa) == 1) {
            return false;
        }
        if (null != this.sa.quality) {
            if (this.pa.min_quality != 0 && this.pa.min_quality < this.pa.quality_range_min) {
                Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_MIN_QUALITY < PRIMER_QUALITY_RANGE_MIN");
                return false;
            }
            if (this.pa.min_quality != 0 && this.pa.min_quality > this.pa.quality_range_max) {
                Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_MIN_QUALITY > PRIMER_QUALITY_RANGE_MAX");
                return false;
            }
            if (this.pa.io_min_quality != 0 && this.pa.io_min_quality < this.pa.quality_range_min) {
                Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_INTERNAL_OLIGO_MIN_QUALITY < PRIMER_QUALITY_RANGE_MIN");
                return false;
            }
            if (this.pa.io_min_quality != 0 && this.pa.io_min_quality > this.pa.quality_range_max) {
                Primer3.pr_append_new_chunk(this.pa.glob_err, "PRIMER_INTERNAL_OLIGO_MIN_QUALITY > PRIMER_QUALITY_RANGE_MAX");
                return false;
            }
            for (n = 0; n < n2; ++n) {
                if (this.sa.quality[n] >= this.pa.quality_range_min && this.sa.quality[n] <= this.pa.quality_range_max) continue;
                Primer3.pr_append_new_chunk(this.sa.error, "Sequence quality score out of range");
                return false;
            }
        } else if (this.pa.primer_weights.seq_quality != 0.0 || this.pa.io_weights.seq_quality != 0.0) {
            Primer3.pr_append_new_chunk(this.sa.error, "Sequence quality is part of objective function but sequence quality is not defined");
            return false;
        }
        char[] cArray2 = this.sa.trimmed_seq.toCharArray();
        block15: for (n = 0; n < cArray2.length; ++n) {
            switch (cArray2[n]) {
                case 'a': {
                    cArray2[n] = 65;
                    continue block15;
                }
                case 'c': {
                    cArray2[n] = 67;
                    continue block15;
                }
                case 'g': {
                    cArray2[n] = 71;
                    continue block15;
                }
                case 't': {
                    cArray2[n] = 84;
                    continue block15;
                }
                case 'n': {
                    cArray2[n] = 78;
                    continue block15;
                }
                case 'A': {
                    continue block15;
                }
                case 'C': {
                    continue block15;
                }
                case 'G': {
                    continue block15;
                }
                case 'T': {
                    continue block15;
                }
                case 'N': {
                    continue block15;
                }
                default: {
                    if (this.pa.liberal_base != 0) {
                        cArray2[n] = 78;
                        bl = true;
                        continue block15;
                    }
                    Primer3.pr_append_new_chunk(this.sa.error, "Unrecognized base in input sequence");
                    return false;
                }
            }
        }
        this.sa.trimmed_seq = new String(cArray2);
        if (bl) {
            Primer3.pr_append_new_chunk(this.sa.warning, "Unrecognized base in input sequence");
        }
        if (this.pa.opt_tm < this.pa.min_tm || this.pa.opt_tm > this.pa.max_tm) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Optimum primer Tm lower than minimum or higher than maximum");
            return false;
        }
        if (this.pa.io_opt_tm < this.pa.io_min_tm || this.pa.io_opt_tm > this.pa.io_max_tm) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Illegal values for PRIMER_INTERNAL_OLIGO_TM");
            return false;
        }
        if (this.pa.min_gc > this.pa.max_gc || this.pa.min_gc > 100.0 || this.pa.max_gc < 0.0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Illegal value for PRIMER_MAX_GC and PRIMER_MIN_GC");
            return false;
        }
        if (this.pa.io_min_gc > this.pa.io_max_gc || this.pa.io_min_gc > 100.0 || this.pa.io_max_gc < 0.0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Illegal value for PRIMER_INTERNAL_OLIGO_GC");
            return false;
        }
        if (this.pa.num_ns_accepted < 0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Illegal value for PRIMER_NUM_NS_ACCEPTED");
            return false;
        }
        if (this.pa.io_num_ns_accepted < 0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Illegal value for PRIMER_INTERNAL_OLIGO_NUM_NS");
            return false;
        }
        if (this.pa.self_any < 0 || this.pa.self_end < 0 || this.pa.pair_compl_any < 0 || this.pa.pair_compl_end < 0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Illegal value for primer complementarity restrictions");
            return false;
        }
        if (this.pa.io_self_any < 0 || this.pa.io_self_end < 0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Illegal value for internal oligo complementarity restrictions");
            return false;
        }
        if (this.pa.salt_conc <= 0.0 || this.pa.dna_conc <= 0.0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Illegal value for primer salt or dna concentration");
            return false;
        }
        if (this.pa.io_salt_conc <= 0.0 || this.pa.io_dna_conc <= 0.0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Illegal value for internal oligo salt or dna concentration");
            return false;
        }
        if (!Primer3.DEFAULT_POSITION_PENALTIES(this.pa) && this.sa.num_targets > 1) {
            Primer3.pr_append_new_chunk(this.sa.error, "Non-default inside penalty or outside penalty ");
            Primer3.pr_append(this.sa.error, "is valid only when number of targets <= 1");
        }
        if (!Primer3.DEFAULT_POSITION_PENALTIES(this.pa) && 0 == this.sa.num_targets) {
            Primer3.pr_append_new_chunk(this.sa.warning, "Non-default inside penalty or outside penalty ");
            Primer3.pr_append(this.sa.warning, "has no effect when number of targets is 0");
        }
        if (this.pa.primer_task != task.pick_pcr_primers_and_hyb_probe && this.pa.primer_task != task.pick_hyb_probe_only && this.sa.internal_input != null) {
            Primer3.pr_append_new_chunk(this.sa.error, "Not specified to pick internal oligos");
            Primer3.pr_append(this.sa.error, " but a specific internal oligo is provided");
        }
        if (this.sa.internal_input != null) {
            if (this.sa.internal_input.length() > this.pa.io_primer_max_size) {
                Primer3.pr_append_new_chunk(this.sa.error, "Specified internal oligo too long");
            }
            if (this.sa.internal_input.length() < this.pa.io_primer_min_size) {
                Primer3.pr_append_new_chunk(this.sa.error, "Specified internal oligo too short");
            }
            if (Primer3.strNotFound(this.sa.sequence, this.sa.internal_input)) {
                Primer3.pr_append_new_chunk(this.sa.error, "Specified internal oligo not in sequence");
            } else if (Primer3.strNotFound(this.sa.trimmed_seq, this.sa.internal_input)) {
                Primer3.pr_append_new_chunk(this.sa.error, "Specified internal oligo not in Included Region");
            }
        }
        if (this.sa.left_input != null) {
            if (this.sa.left_input.length() > this.pa.primer_max_size) {
                Primer3.pr_append_new_chunk(this.sa.error, "Specified left primer too long");
            }
            if (this.sa.left_input.length() < this.pa.primer_min_size) {
                Primer3.pr_append_new_chunk(this.sa.error, "Specified left primer too short");
            }
            if (Primer3.strNotFound(this.sa.sequence, this.sa.left_input)) {
                Primer3.pr_append_new_chunk(this.sa.error, "Specified left primer not in sequence");
            } else if (Primer3.strNotFound(this.sa.trimmed_seq, this.sa.left_input)) {
                Primer3.pr_append_new_chunk(this.sa.error, "Specified left primer not in Included Region");
            }
        }
        if (this.sa.right_input != null) {
            if (this.sa.right_input.length() < this.pa.primer_min_size) {
                Primer3.pr_append_new_chunk(this.sa.error, "Specified right primer too short");
            }
            if (this.sa.right_input.length() > this.pa.primer_max_size) {
                Primer3.pr_append_new_chunk(this.sa.error, "Specified right primer too long");
            } else {
                cArray = Primer3.reverse_complement(this.sa.right_input);
                if (Primer3.strNotFound(this.sa.sequence, new String(cArray))) {
                    Primer3.pr_append_new_chunk(this.sa.error, "Specified right primer not in sequence");
                } else if (Primer3.strNotFound(this.sa.trimmed_seq, new String(cArray))) {
                    Primer3.pr_append_new_chunk(this.sa.error, "Specified right primer not in Included Region");
                }
            }
        }
        if ((this.pa.pr_pair_weights.product_tm_lt != 0.0 || this.pa.pr_pair_weights.product_tm_gt != 0.0) && this.pa.product_opt_tm == Double.MIN_VALUE) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Product temperature is part of objective function while optimum temperature is not defined");
            return false;
        }
        if ((this.pa.pr_pair_weights.product_size_lt != 0.0 || this.pa.pr_pair_weights.product_size_gt != 0.0) && this.pa.product_opt_size == Integer.MIN_VALUE) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Product size is part of objective function while optimum size is not defined");
            return false;
        }
        if ((this.pa.primer_weights.gc_content_lt != 0.0 || this.pa.primer_weights.gc_content_gt != 0.0) && this.pa.opt_gc_content == -2.147483648E9) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Primer GC content is part of objective function while optimum gc_content is not defined");
            return false;
        }
        if ((this.pa.io_weights.gc_content_lt != 0.0 || this.pa.io_weights.gc_content_gt != 0.0) && this.pa.io_opt_gc_content == -2.147483648E9) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Hyb probe GC content is part of objective function while optimum gc_content is not defined");
            return false;
        }
        if (this.pa.primer_task != task.pick_pcr_primers_and_hyb_probe && this.pa.primer_task != task.pick_hyb_probe_only && this.pa.pr_pair_weights.io_quality != 0.0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Internal oligo quality is part of objective function while internal oligo choice is not required");
            return false;
        }
        if (this.pa.primer_weights.repeat_sim != 0.0 && this.pa.repeat_lib.seq_num == 0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Mispriming score is part of objective function, but mispriming library is not defined");
            return false;
        }
        if (this.pa.io_weights.repeat_sim != 0.0 && this.pa.io_mishyb_library.seq_num == 0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Internal oligo mispriming score is part of objective function while mishyb library is not defined");
            return false;
        }
        if (this.pa.pr_pair_weights.repeat_sim != 0.0 && this.pa.repeat_lib.seq_num == 0) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Mispriming score is part of objective function, but mispriming library is not defined");
            return false;
        }
        if (this.pa.pr_pair_weights.io_quality != 0.0 && this.pa.primer_task != task.pick_pcr_primers_and_hyb_probe) {
            Primer3.pr_append_new_chunk(this.pa.glob_err, "Internal oligo quality is part of objective function while internal oligo choice is not required");
            return false;
        }
        return !this.sa.error.hasError() && !this.pa.glob_err.hasError();
    }

    private static int check_intervals(String string, int n, int[][] nArray, int n2, seq_args seq_args2) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (nArray[i][0] + nArray[i][1] > n2) {
                Primer3.pr_append_new_chunk(seq_args2.error, string);
                Primer3.pr_append(seq_args2.error, " beyond end of sequence");
                return 1;
            }
            int[] nArray2 = nArray[i];
            nArray2[0] = nArray2[0] - seq_args2.incl_s;
            if (!(nArray[i][0] >= 0 && nArray[i][0] + nArray[i][1] <= seq_args2.incl_l || bl)) {
                Primer3.pr_append_new_chunk(seq_args2.warning, string);
                Primer3.pr_append(seq_args2.warning, " outside of INCLUDED_REGION");
                bl = true;
            }
            if (nArray[i][1] >= 0) continue;
            Primer3.pr_append_new_chunk(seq_args2.error, "Negative ");
            Primer3.pr_append(seq_args2.error, string);
            Primer3.pr_append(seq_args2.error, " length");
            return 1;
        }
        return 0;
    }

    public static void pr_append(pr_append_str pr_append_str2, String string) {
        int n;
        int n2;
        if (null == pr_append_str2.data) {
            pr_append_str2.data = new StringBuffer();
        }
        if ((n2 = pr_append_str2.data.length()) + (n = string.length()) + 1 > pr_append_str2.getSize()) {
            pr_append_str2.data.ensureCapacity(pr_append_str2.getSize() + 2 * (n + 1));
        }
        pr_append_str2.data.append(string);
    }

    public static void pr_append_new_chunk(pr_append_str pr_append_str2, String string) {
        Primer3.pr_append_w_sep(pr_append_str2, "; ", string);
    }

    public static void pr_append_w_sep(pr_append_str pr_append_str2, String string, String string2) {
        if (Primer3.pr_is_empty(pr_append_str2)) {
            Primer3.pr_append(pr_append_str2, string2);
        } else {
            Primer3.pr_append(pr_append_str2, "\n");
            Primer3.pr_append(pr_append_str2, string);
            Primer3.pr_append(pr_append_str2, string2);
        }
    }

    public static boolean pr_is_empty(pr_append_str pr_append_str2) {
        Macros.PR_ASSERT(null != pr_append_str2);
        Macros.PR_ASSERT(null != pr_append_str2.data);
        return pr_append_str2.data.length() == 0;
    }

    private static short align(char[] cArray, char[] cArray2, dpal_args dpal_args2) {
        dpal_results dpal_results2 = new dpal_results();
        Dpal.dpal(cArray, cArray2, dpal_args2, dpal_results2);
        Macros.PR_ASSERT(dpal_results2.score <= Short.MAX_VALUE);
        return dpal_results2.score < 0 ? (short)0 : (short)dpal_results2.score;
    }

    private static void set_dpal_args(dpal_args dpal_args2) {
        for (int i = 0; i <= 127; ++i) {
            for (int j = 0; j <= 127; ++j) {
                if (!(65 != i && 67 != i && 71 != i && 84 != i && 78 != i || 65 != j && 67 != j && 71 != j && 84 != j && 78 != j)) {
                    if (i == 78 || j == 78) {
                        dpal_args2.ssm[i][j] = -25;
                        continue;
                    }
                    if (i == j) {
                        dpal_args2.ssm[i][j] = 100;
                        continue;
                    }
                    dpal_args2.ssm[i][j] = -100;
                    continue;
                }
                dpal_args2.ssm[i][j] = Integer.MIN_VALUE;
            }
        }
        dpal_args2.gap = -200;
        dpal_args2.gapl = -200;
        dpal_args2.flag = 0;
        dpal_args2.max_gap = 1;
        dpal_args2.fail_stop = 1;
        dpal_args2.check_chars = 0;
        dpal_args2.debug = 0;
        dpal_args2.score_only = 1;
        dpal_args2.force_generic = 0;
        dpal_args2.force_long_generic = 0;
        dpal_args2.force_long_maxgap1 = 0;
    }

    static String pr_oligo_sequence(seq_args seq_args2, primer_rec primer_rec2) {
        Macros.PR_ASSERT(null != seq_args2);
        Macros.PR_ASSERT(null != primer_rec2);
        int n = seq_args2.sequence.length();
        Macros.PR_ASSERT(primer_rec2.start + seq_args2.incl_s >= 0);
        Macros.PR_ASSERT(primer_rec2.start + seq_args2.incl_s + primer_rec2.length <= n);
        char[] cArray = Primer3.substr(seq_args2.sequence, seq_args2.incl_s + primer_rec2.start, primer_rec2.length);
        return new String(cArray);
    }

    static String pr_oligo_rev_c_sequence(seq_args seq_args2, primer_rec primer_rec2) {
        char[] cArray = new char[MAX_PRIMER_LENGTH + 1];
        char[] cArray2 = new char[MAX_PRIMER_LENGTH + 1];
        Macros.PR_ASSERT(null != seq_args2);
        Macros.PR_ASSERT(null != primer_rec2);
        int n = seq_args2.sequence.length();
        int n2 = seq_args2.incl_s + primer_rec2.start - primer_rec2.length + 1;
        Macros.PR_ASSERT(n2 >= 0);
        Macros.PR_ASSERT(n2 + primer_rec2.length <= n);
        cArray = Primer3.substr(seq_args2.sequence, n2, primer_rec2.length);
        cArray2 = Primer3.reverse_complement(new String(cArray));
        return new String(cArray2);
    }

    private static void print_usage() {
        String[] stringArray = copyright;
        for (int i = 0; i < stringArray.length; ++i) {
            IO.stdout.print(stringArray[i] + "\n");
        }
        IO.stderr.print("\n\nThis is " + Constants.pr_release + "\n");
    }

    private static void sig_handler(int n) {
        Primer3.print_usage();
        System.err.println("com.informagen.Primer3received signal " + n);
    }

    private static void oligo_compl(primer_rec primer_rec2, primer_args primer_args2, seq_args seq_args2, int n, dpal_args dpal_args2, dpal_args dpal_args3, dpal_args dpal_args4) {
        short s = 0;
        short s2 = 0;
        if (oligo_type.OT_INTL == n) {
            s = primer_args2.io_self_any;
            s2 = primer_args2.io_self_end;
        } else {
            s = primer_args2.self_any;
            s2 = primer_args2.self_end;
        }
        int n2 = oligo_type.OT_LEFT == n || oligo_type.OT_INTL == n ? primer_rec2.start : primer_rec2.start - primer_rec2.length + 1;
        char[] cArray = Primer3.substr(seq_args2.trimmed_seq, n2, primer_rec2.length);
        char[] cArray2 = Primer3.reverse_complement(new String(cArray));
        primer_rec2.self_any = Primer3.align(cArray, cArray2, dpal_args2);
        if (primer_rec2.self_any > s) {
            primer_rec2.ok = oligo_violation.OV_SELF_ANY;
            if (oligo_type.OT_LEFT == n) {
                ++seq_args2.left_expl.compl_any;
                --seq_args2.left_expl.ok;
            } else if (oligo_type.OT_RIGHT == n) {
                ++seq_args2.right_expl.compl_any;
                --seq_args2.right_expl.ok;
            } else {
                ++seq_args2.intl_expl.compl_any;
                --seq_args2.intl_expl.ok;
            }
            if (!primer_rec2.must_use) {
                return;
            }
        }
        short s3 = primer_rec2.self_end = n != oligo_type.OT_RIGHT ? Primer3.align(cArray, cArray2, dpal_args3) : Primer3.align(cArray2, cArray, dpal_args3);
        if (primer_rec2.self_end > s2) {
            primer_rec2.ok = oligo_violation.OV_SELF_END;
            if (oligo_type.OT_LEFT == n) {
                ++seq_args2.left_expl.compl_end;
                --seq_args2.left_expl.ok;
            } else if (oligo_type.OT_RIGHT == n) {
                ++seq_args2.right_expl.compl_end;
                --seq_args2.right_expl.ok;
            } else {
                ++seq_args2.intl_expl.compl_end;
                --seq_args2.intl_expl.ok;
            }
            return;
        }
    }

    private static void oligo_mispriming(primer_rec primer_rec2, primer_args primer_args2, seq_args seq_args2, int n) {
        short s;
        seq_lib seq_lib2;
        double d = 0.0;
        if (oligo_type.OT_INTL == n) {
            seq_lib2 = primer_args2.io_mishyb_library;
            s = primer_args2.io_repeat_compl;
        } else {
            seq_lib2 = primer_args2.repeat_lib;
            s = primer_args2.repeat_compl;
        }
        int n2 = oligo_type.OT_LEFT == n || oligo_type.OT_INTL == n ? primer_rec2.start : primer_rec2.start - primer_rec2.length + 1;
        char[] cArray = Primer3.substr(seq_args2.trimmed_seq, n2, primer_rec2.length);
        char[] cArray2 = Primer3.reverse_complement(new String(cArray));
        if (seq_lib2.seq_num > 0) {
            primer_rec2.repeat_sim.score = new short[seq_lib2.seq_num];
            primer_rec2.repeat_sim.min = 0;
            primer_rec2.repeat_sim.max = 0;
            int n3 = 0;
            int n4 = 0;
            primer_rec2.repeat_sim.name = seq_lib2.names(0);
            for (int i = 0; i < seq_lib2.seq_num; ++i) {
                d = oligo_type.OT_LEFT == n ? seq_lib2.weight(i) * (double)Primer3.align(cArray, seq_lib2.seqs(i).toCharArray(), lib_local_end_dpal_args) : (oligo_type.OT_INTL == n ? seq_lib2.weight(i) * (double)Primer3.align(cArray, seq_lib2.seqs(i).toCharArray(), lib_local_dpal_args) : seq_lib2.weight(i) * (double)Primer3.align(cArray2, seq_lib2.rev_compl_seqs(i).toCharArray(), lib_local_end_dpal_args));
                primer_rec2.repeat_sim.score[i] = (short)d;
                if (d > (double)n4) {
                    n4 = (int)d;
                    primer_rec2.repeat_sim.max = (short)i;
                    primer_rec2.repeat_sim.name = seq_lib2.names(i);
                }
                if (d < (double)n3) {
                    n3 = (int)d;
                    primer_rec2.repeat_sim.min = (short)i;
                }
                if (!(d > (double)s)) continue;
                primer_rec2.ok = oligo_violation.OV_LIB_SIM;
                if (oligo_type.OT_LEFT == n) {
                    ++seq_args2.left_expl.repeat;
                    --seq_args2.left_expl.ok;
                } else if (oligo_type.OT_RIGHT == n) {
                    ++seq_args2.right_expl.repeat;
                    --seq_args2.right_expl.ok;
                } else {
                    ++seq_args2.intl_expl.repeat;
                    --seq_args2.intl_expl.ok;
                }
                if (primer_rec2.must_use) continue;
                return;
            }
        }
    }

    private static int pair_repeat_sim(primer_pair primer_pair2, primer_args primer_args2) {
        int n = 0;
        primer_rec primer_rec2 = primer_pair2.left;
        primer_rec primer_rec3 = primer_pair2.right;
        int n2 = 0;
        int n3 = primer_args2.repeat_lib.seq_num;
        if (n3 == 0) {
            return 0;
        }
        primer_pair2.rep_name = primer_args2.repeat_lib.names(0);
        for (int i = 0; i < n3; ++i) {
            n = primer_rec2.repeat_sim.score[i] + primer_rec3.repeat_sim.score[i];
            if (n <= n2) continue;
            n2 = n;
            primer_pair2.rep_name = primer_args2.repeat_lib.names(i);
        }
        return n2;
    }

    private static int find_stop_codon(String string, int n, int n2) {
        int n3 = 3 * n2;
        int n4 = string.length();
        Macros.PR_ASSERT(string != null);
        Macros.PR_ASSERT(n2 == 1 || n2 == -1);
        Macros.PR_ASSERT(n4 >= 3);
        Macros.PR_ASSERT(n <= n4 - 3);
        if (n < 0) {
            if (n2 == 1) {
                while (n < 0) {
                    n += n3;
                }
            } else {
                return -1;
            }
        }
        return -1;
    }

    static String[] pr_realloc_array(String[] stringArray, int n) {
        if (stringArray == null) {
            return new String[n];
        }
        Macros.PR_ASSERT(n >= stringArray.length);
        String[] stringArray2 = new String[n];
        for (int i = stringArray.length; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    static double[] pr_realloc_array(double[] dArray, int n) {
        if (dArray == null) {
            return new double[n];
        }
        Macros.PR_ASSERT(n >= dArray.length);
        double[] dArray2 = new double[n];
        for (int i = dArray.length; i < n; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    private static boolean strNotFound(String string, String string2) {
        String string3;
        String string4 = string.toUpperCase();
        return string4.indexOf(string3 = string.toUpperCase()) == -1;
    }

    private static void free_repeat_sim_score(int n, int n2, int n3) {
        if (f != null) {
            f.removeAllElements();
        }
        if (r != null) {
            r.removeAllElements();
        }
        if (mid != null) {
            mid.removeAllElements();
        }
    }

    private static void sort_primer_pairs(Vector vector) {
        int n = vector.size();
        for (int i = n / 2; i > 0; --i) {
            Primer3.downheap_primer_pairs(vector, i, n);
        }
        Object e = null;
        do {
            e = vector.elementAt(0);
            vector.setElementAt(vector.elementAt(n - 1), 0);
            vector.setElementAt(e, n - 1);
            Primer3.downheap_primer_pairs(vector, 1, --n);
        } while (n > 1);
    }

    private static void downheap_primer_pairs(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n - 1);
        while (n <= n2 / 2) {
            int n3 = n + n;
            if (n3 < n2 && Primer3.primer_pair_comp(vector.elementAt(n3 - 1), vector.elementAt(n3)) == -1) {
                ++n3;
            }
            if (Primer3.primer_pair_comp(e, vector.elementAt(n3 - 1)) != -1) break;
            vector.setElementAt(vector.elementAt(n3 - 1), n - 1);
            n = n3;
        }
        vector.setElementAt(e, n - 1);
    }

    private static void sort_primer_recs(Vector vector) {
        int n = vector.size();
        for (int i = n / 2; i > 0; --i) {
            Primer3.downheap_primer_recs(vector, i, n);
        }
        Object e = null;
        do {
            e = vector.elementAt(0);
            vector.setElementAt(vector.elementAt(n - 1), 0);
            vector.setElementAt(e, n - 1);
            Primer3.downheap_primer_recs(vector, 1, --n);
        } while (n > 1);
    }

    private static void downheap_primer_recs(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n - 1);
        while (n <= n2 / 2) {
            int n3 = n + n;
            if (n3 < n2 && Primer3.primer_rec_comp(vector.elementAt(n3 - 1), vector.elementAt(n3)) == -1) {
                ++n3;
            }
            if (Primer3.primer_rec_comp(e, vector.elementAt(n3 - 1)) != -1) break;
            vector.setElementAt(vector.elementAt(n3 - 1), n - 1);
            n = n3;
        }
        vector.setElementAt(e, n - 1);
    }

    static {
        revPrintStream = new PrintWriter(IO.stdout);
        forPrintStream = new PrintWriter(IO.stdout);
        intPrintStream = new PrintWriter(IO.stdout);
    }
}

