/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.Sequence;
import com.informagen.sa.digest.Enzyme;
import com.informagen.sa.digest.EnzymeCuts;
import java.util.Iterator;
import java.util.Vector;

public class Digest {
    private static final int[] revcomp = new int[]{0, 8, 4, 12, 2, 10, 6, 14, 1, 9, 5, 13, 3, 11, 7, 15};
    private Vector inUseEnzymes = null;
    private Sequence sequence = null;
    private int[] binarySequence = null;
    private Vector cutters;
    private Vector uniqueCutters;
    private Vector allCutters;
    private Vector nonCutters;
    private int maxCuts = 0;

    public Digest() {
    }

    public Digest(Sequence sequence, Vector vector) {
        this.setSequence(sequence);
        this.setEnzymes(vector);
    }

    public int getSeqLength() {
        return this.binarySequence != null ? this.binarySequence.length : 0;
    }

    public int getMaxCuts() {
        return this.maxCuts;
    }

    public void setEnzymes(Vector vector) {
        this.inUseEnzymes = vector;
    }

    public Vector getEnzymes() {
        return this.inUseEnzymes;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
        this.binarySequence = Sequence.toBinary(sequence.getSequence());
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    private boolean digest() {
        this.maxCuts = 0;
        int n = 0;
        this.cutters = new Vector();
        this.uniqueCutters = new Vector();
        this.allCutters = new Vector();
        this.nonCutters = new Vector();
        Vector vector = this.getEnzymes();
        if (vector == null) {
            return false;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Enzyme enzyme = (Enzyme)iterator.next();
            EnzymeCuts enzymeCuts = this.findCuts(enzyme);
            int n2 = enzymeCuts.getCutCount();
            this.maxCuts = n2 > this.maxCuts ? n2 : this.maxCuts;
            switch (n2) {
                case 0: {
                    this.nonCutters.addElement(enzymeCuts);
                    break;
                }
                case 1: {
                    this.uniqueCutters.addElement(enzymeCuts);
                    this.cutters.addElement(enzymeCuts);
                    break;
                }
                default: {
                    this.cutters.addElement(enzymeCuts);
                }
            }
            this.allCutters.addElement(enzymeCuts);
            n += n2;
        }
        return true;
    }

    public Vector getCutters() {
        return this.cutters;
    }

    public Vector getAllCutters() {
        return this.allCutters;
    }

    public Vector getUniqueCutters() {
        return this.uniqueCutters;
    }

    public Vector getNonCutters() {
        return this.nonCutters;
    }

    private EnzymeCuts findCuts(Enzyme enzyme) {
        EnzymeCuts enzymeCuts = new EnzymeCuts(enzyme);
        int[] nArray = enzyme.getPattern();
        int n = enzyme.getForwardOffset();
        this.findPatternForward(nArray, n, enzymeCuts);
        this.findPatternReverse(nArray, n, enzymeCuts);
        return enzymeCuts;
    }

    private void findPatternForward(int[] nArray, int n, EnzymeCuts enzymeCuts) {
        int n2 = 0;
        int n3 = this.binarySequence.length - nArray.length;
        for (int i = 0; i < n3; ++i) {
            if ((this.binarySequence[i] & nArray[n2]) != 0) {
                if (++n2 != nArray.length) continue;
                int n4 = i - nArray.length + 1;
                int n5 = n4 + n;
                if (n5 > 0 && n5 < this.binarySequence.length) {
                    enzymeCuts.addCutSite(n4, n5);
                }
                n2 = 0;
                i = i - nArray.length + 1;
                continue;
            }
            i -= n2;
            n2 = 0;
        }
    }

    private void findPatternReverse(int[] nArray, int n, EnzymeCuts enzymeCuts) {
        int n2 = 0;
        int n3 = nArray.length;
        for (int i = this.binarySequence.length - 1; i > n3; --i) {
            if ((revcomp[this.binarySequence[i]] & nArray[n2]) != 0) {
                if (++n2 != nArray.length) continue;
                int n4 = i;
                int n5 = n4 + n;
                if (n5 > 0 && n5 < this.binarySequence.length) {
                    enzymeCuts.addCutSite(n4, n5);
                }
                n2 = 0;
                i = i + nArray.length - 1;
                continue;
            }
            i += n2;
            n2 = 0;
        }
    }

    public void doDigest() {
        if (this.inUseEnzymes == null || this.binarySequence == null) {
            return;
        }
        this.digest();
    }
}

