/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.structure;

import com.informagen.sa.structure.SequenceAnalyzer;

public final class ALOM
implements SequenceAnalyzer {
    private static final String mName = "Transmembrane Prediction (Klein, Kanehisa & DeLisi)";
    private static final String Symbols = "ARNDBCQEZGHILKMFPSTWYVX*";
    private static final double[] Values = new double[]{1.8, -4.5, -3.5, -3.5, -3.5, 2.5, -3.5, -3.5, -3.5, -0.4, -3.2, 4.5, 3.8, -3.9, 1.9, 2.8, -1.6, -0.8, -0.7, -0.9, -1.3, 4.2, -0.5, -0.5};
    private static final double a0 = 1.582;
    private static final double a1 = -1.0;
    private double MaxH;
    private int Index;
    private int Left;
    private int Right;
    private StringBuffer Seq;
    private int Len;
    private int Window;

    public String getName() {
        return mName;
    }

    public double getGraphMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getGraphMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double getGraphCutoff() {
        return 0.0;
    }

    public double[] analyze(String string) {
        string = string.toUpperCase();
        double d = 80.0;
        boolean bl = false;
        this.Window = 17;
        this.Seq = new StringBuffer(string);
        this.Len = this.Seq.length();
        if (this.Len <= this.Window * 2) {
            return null;
        }
        double[] dArray = new double[this.Len];
        block0: while (true) {
            int n;
            this.Ymax();
            double d2 = -1.0 * this.MaxH + 1.582;
            double d3 = -9.02 * this.MaxH + 14.27;
            double d4 = Math.exp(d3);
            if (d2 < 0.0) {
                bl = true;
                this.Extend();
                for (n = this.Left; n <= this.Right; ++n) {
                    dArray[n] = -d3;
                }
            } else {
                if (!bl || d4 > d) {
                    return dArray;
                }
                for (n = this.Index; n <= this.Index + this.Window; ++n) {
                    dArray[n] = -d3;
                }
            }
            n = this.Index;
            while (true) {
                if (n >= this.Index + this.Window) continue block0;
                this.Seq.setCharAt(n, 'R');
                ++n;
            }
            break;
        }
    }

    private void Ymax() {
        double d;
        int n;
        double[] dArray = new double[this.Len];
        for (n = 0; n < this.Len; ++n) {
            int n2 = Symbols.indexOf(this.Seq.charAt(n));
            dArray[n] = n2 > -1 ? Values[n2] : -0.5;
        }
        int n3 = 0;
        this.Index = 0;
        double d2 = 0.0;
        for (n = 0; n < this.Window; ++n) {
            d2 += dArray[n];
        }
        this.MaxH = d = d2 / (double)this.Window;
        while (n3 + this.Window < this.Len) {
            d2 -= dArray[n3];
            d = (d2 += dArray[n3 + this.Window]) / (double)this.Window;
            ++n3;
            if (!(d > this.MaxH)) continue;
            this.MaxH = d;
            this.Index = n3;
        }
        dArray = null;
    }

    private void Extend() {
        double d;
        double d2;
        this.Left = this.Index - 1;
        while (this.Left >= 0 && !((d2 = -1.0 * (d = this.Limit(17, this.Left)) + 1.582) >= 0.0)) {
            --this.Left;
        }
        ++this.Left;
        this.Right = this.Index + this.Window;
        while (this.Right < this.Len && !((d2 = -1.0 * (d = this.Limit(this.Window, this.Right - this.Window)) + 1.582) >= 0.0)) {
            ++this.Right;
        }
        this.Right = this.Right < this.Len ? this.Right : this.Len - 1;
    }

    private double Limit(int n, int n2) {
        int n3;
        double d = 0.0;
        double[] dArray = new double[n];
        for (n3 = 0; n3 < n; ++n3) {
            int n4;
            for (n4 = 0; n4 < 23 && this.Seq.charAt(n2 + n3) != Symbols.charAt(n4); ++n4) {
            }
            dArray[n3] = Values[n4];
        }
        d = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            d += dArray[n3];
        }
        dArray = null;
        return d /= (double)n;
    }
}

