/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import neobio.alignment.IncompatibleScoringSchemeException;
import neobio.alignment.InvalidScoringMatrixException;
import neobio.alignment.ScoringScheme;

public class ScoringMatrix
extends ScoringScheme {
    protected static final char INDEL_CHAR = '*';
    protected static final char COMMENT_CHAR = '#';
    protected String col_codes;
    protected String row_codes;
    protected int[][] matrix;
    protected int dimension;
    protected int max_absolute_score;

    public ScoringMatrix(Reader reader) throws IOException, InvalidScoringMatrixException {
        this(reader, true);
    }

    public ScoringMatrix(Reader reader, boolean bl) throws IOException, InvalidScoringMatrixException {
        super(bl);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.commentChar(35);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.nextToken();
        while (streamTokenizer.ttype == 10) {
            streamTokenizer.nextToken();
        }
        while (streamTokenizer.ttype != -1 && streamTokenizer.ttype != 10) {
            if (streamTokenizer.ttype == -3) {
                if (streamTokenizer.sval.length() > 1) {
                    throw new InvalidScoringMatrixException("Column headers must have one-character only.");
                }
                stringBuffer.append(streamTokenizer.sval.charAt(0));
            } else if (streamTokenizer.ttype == 42) {
                stringBuffer.append('*');
            } else {
                throw new InvalidScoringMatrixException("Column headers must be one-character codes or the special character '*'.");
            }
            streamTokenizer.nextToken();
        }
        this.col_codes = bl ? stringBuffer.toString() : stringBuffer.toString().toUpperCase();
        this.dimension = this.col_codes.length();
        if (this.col_codes.indexOf(42) == -1) {
            throw new InvalidScoringMatrixException("Matrix have no column for deletion penalties.");
        }
        if (this.dimension < 2) {
            throw new InvalidScoringMatrixException("Matrix must have at least one column with a character code.");
        }
        int n2 = 0;
        while (n2 < this.dimension) {
            if (this.col_codes.indexOf(this.col_codes.charAt(n2), n2 + 1) > n2) {
                throw new InvalidScoringMatrixException("Columns must have distinct one-character codes.");
            }
            ++n2;
        }
        this.matrix = new int[this.dimension][this.dimension];
        stringBuffer.delete(0, this.dimension);
        streamTokenizer.eolIsSignificant(false);
        if (streamTokenizer.ttype == 10) {
            streamTokenizer.nextToken();
        }
        int n3 = 0;
        while (n3 < this.dimension && streamTokenizer.ttype != -1) {
            if (streamTokenizer.ttype == -3) {
                if (streamTokenizer.sval.length() > 1) {
                    throw new InvalidScoringMatrixException("Codes must have one character only.");
                }
                stringBuffer.append(streamTokenizer.sval.charAt(0));
            } else if (streamTokenizer.ttype == 42) {
                stringBuffer.append('*');
            } else {
                throw new InvalidScoringMatrixException("Rows must start with an one-character code or the special character '*'.");
            }
            int n4 = 0;
            while (n4 < this.dimension) {
                if (streamTokenizer.nextToken() != -2) {
                    throw new InvalidScoringMatrixException("Invalid value at row " + (n3 + 1) + ", column " + (n4 + 1) + ".");
                }
                this.matrix[n3][n4] = (int)streamTokenizer.nval;
                if (Math.abs(this.matrix[n3][n4]) > n) {
                    n = Math.abs(this.matrix[n3][n4]);
                }
                ++n4;
            }
            streamTokenizer.nextToken();
            ++n3;
        }
        this.row_codes = bl ? stringBuffer.toString() : stringBuffer.toString().toUpperCase();
        if (this.row_codes.length() != this.dimension) {
            throw new InvalidScoringMatrixException("Matrix must have as many rows as columns.");
        }
        if (this.row_codes.indexOf(42) == -1) {
            throw new InvalidScoringMatrixException("Matrix have no row for insertion penalties.");
        }
        int n5 = 0;
        while (n5 < this.dimension) {
            if (this.row_codes.indexOf(this.row_codes.charAt(n5), n5 + 1) > n5) {
                throw new InvalidScoringMatrixException("Rows must have distinct one-character codes.");
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.dimension) {
            char c = this.row_codes.charAt(n6);
            if (this.col_codes.indexOf(c) == -1) {
                throw new InvalidScoringMatrixException("There is no corresponding column for row character '" + c + "'.");
            }
            ++n6;
        }
        this.max_absolute_score = n;
    }

    public int scoreSubstitution(char c, char c2) throws IncompatibleScoringSchemeException {
        int n;
        int n2;
        if (this.case_sensitive) {
            n2 = this.row_codes.indexOf(c);
            n = this.col_codes.indexOf(c2);
        } else {
            n2 = this.row_codes.indexOf(Character.toUpperCase(c));
            n = this.col_codes.indexOf(Character.toUpperCase(c2));
        }
        if (n2 < 0 || n < 0) {
            throw new IncompatibleScoringSchemeException("Substitution of character " + c + " for " + c2 + " is not defined.");
        }
        return this.matrix[n2][n];
    }

    public int scoreInsertion(char c) throws IncompatibleScoringSchemeException {
        return this.scoreSubstitution('*', c);
    }

    public int scoreDeletion(char c) throws IncompatibleScoringSchemeException {
        return this.scoreSubstitution(c, '*');
    }

    public boolean isPartialMatchSupported() {
        return true;
    }

    public int maxAbsoluteScore() {
        return this.max_absolute_score;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Scoring matrix:\n\t");
        int n = 0;
        while (n < this.dimension) {
            stringBuffer.append("\t" + n);
            ++n;
        }
        stringBuffer.append("\n\t");
        n = 0;
        while (n < this.dimension) {
            stringBuffer.append('\t');
            stringBuffer.append(this.col_codes.charAt(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.dimension) {
            stringBuffer.append("\n" + n2 + "\t" + this.row_codes.charAt(n2));
            n = 0;
            while (n < this.dimension) {
                stringBuffer.append('\t');
                stringBuffer.append(this.matrix[n2][n]);
                ++n;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

