/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

import neobio.alignment.Matrix;

public class Smawk {
    protected Matrix matrix;
    protected int numrows;
    protected int[] row;
    protected int[] row_position;
    protected int numcols;
    protected int[] col;

    public synchronized void computeColumnMaxima(Matrix matrix, int[] nArray) {
        this.matrix = matrix;
        this.numcols = matrix.numColumns();
        this.col = new int[this.numcols];
        int n = 0;
        while (n < this.numcols) {
            this.col[n] = n;
            ++n;
        }
        this.numrows = matrix.numRows();
        this.row = new int[this.numrows];
        n = 0;
        while (n < this.numrows) {
            this.row[n] = n;
            ++n;
        }
        this.row_position = new int[this.numrows];
        this.computeColumnMaxima(nArray);
    }

    protected void computeColumnMaxima(int[] nArray) {
        int n = this.numrows;
        if (this.numrows > this.numcols) {
            this.reduce();
        }
        if (this.numrows == 1) {
            nArray[this.col[0]] = this.row[0];
            if (n > this.numrows) {
                this.restoreRows(n);
            }
            return;
        }
        int n2 = this.numcols;
        this.deleteOddColumns();
        this.computeColumnMaxima(nArray);
        this.restoreOddColumns(n2);
        int n3 = 0;
        while (n3 < this.numrows) {
            this.row_position[this.row[n3]] = n3;
            ++n3;
        }
        int n4 = 1;
        while (n4 < this.numcols) {
            int n5 = n4 < this.numcols - 1 ? this.row_position[nArray[this.col[n4 + 1]]] : this.numrows - 1;
            int n6 = this.row_position[nArray[this.col[n4 - 1]]];
            n3 = n6 + 1;
            while (n3 <= n5) {
                if (this.valueAt(n3, n4) > this.valueAt(n6, n4)) {
                    n6 = n3;
                }
                ++n3;
            }
            nArray[this.col[n4]] = this.row[n6];
            n4 += 2;
        }
        if (n > this.numrows) {
            this.restoreRows(n);
        }
    }

    protected final int valueAt(int n, int n2) {
        return this.matrix.valueAt(this.row[n], this.col[n2]);
    }

    protected void deleteOddColumns() {
        int n = 2;
        while (n < this.numcols) {
            int n2 = this.col[n / 2];
            this.col[n / 2] = this.col[n];
            this.col[n] = n2;
            n += 2;
        }
        this.numcols = (this.numcols - 1) / 2 + 1;
    }

    protected void restoreOddColumns(int n) {
        int n2 = 2 * ((n - 1) / 2);
        while (n2 > 0) {
            int n3 = this.col[n2 / 2];
            this.col[n2 / 2] = this.col[n2];
            this.col[n2] = n3;
            n2 -= 2;
        }
        this.numcols = n;
    }

    protected void reduce() {
        int n = 0;
        int n2 = this.numrows;
        while (n2 > this.numcols) {
            if (this.valueAt(n, n) < this.valueAt(n + 1, n)) {
                this.deleteRow(n2, n);
                --n2;
                --n;
                continue;
            }
            if (n < this.numcols - 1) {
                ++n;
                continue;
            }
            this.deleteRow(n2, n + 1);
            --n2;
        }
        this.numrows = n2;
    }

    protected void deleteRow(int n, int n2) {
        int n3 = this.row[n2];
        int n4 = n2 + 1;
        while (n4 < n) {
            this.row[n4 - 1] = this.row[n4];
            ++n4;
        }
        n4 = n - 1;
        while (n4 < this.numrows - 1 && this.row[n4 + 1] < n3) {
            this.row[n4] = this.row[n4 + 1];
            ++n4;
        }
        this.row[n4] = n3;
    }

    protected void restoreRows(int n) {
        int n2 = this.numrows;
        int n3 = 0;
        while (n3 < n2) {
            if (this.row[n3] > this.row[n2]) {
                int n4 = this.row[n2];
                int n5 = n2;
                while (n5 > n3) {
                    this.row[n5] = this.row[n5 - 1];
                    --n5;
                }
                this.row[n3] = n4;
                if (++n2 > n - 1) break;
            }
            ++n3;
        }
        this.numrows = n;
    }

    public static void naiveComputeColumnMaxima(Matrix matrix, int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < matrix.numColumns()) {
            int n3 = n;
            while (n3 < matrix.numRows()) {
                if (matrix.valueAt(n3, n2) > matrix.valueAt(n, n2)) {
                    n = n3;
                }
                ++n3;
            }
            nArray[n2] = n;
            ++n2;
        }
    }

    public static void naiveComputeRowMaxima(Matrix matrix, int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < matrix.numRows()) {
            int n3 = n;
            while (n3 < matrix.numColumns()) {
                if (matrix.valueAt(n2, n3) > matrix.valueAt(n2, n)) {
                    n = n3;
                }
                ++n3;
            }
            nArray[n2] = n;
            ++n2;
        }
    }

    protected void printMatrix() {
        System.out.print("row\\col\t| ");
        int n = 0;
        while (n < this.numcols) {
            System.out.print(this.col[n] + "\t");
            ++n;
        }
        int n2 = 0;
        while (n2 < this.numrows) {
            System.out.print(this.row[n2] + "\n\t| ");
            n = 0;
            while (n < this.numcols) {
                System.out.print(this.matrix.valueAt(n2, n) + "\t");
                ++n;
            }
            ++n2;
        }
    }

    public static void printMatrix(Matrix matrix) {
        int n = 0;
        while (n < matrix.numRows()) {
            int n2 = 0;
            while (n2 < matrix.numColumns()) {
                System.out.print(matrix.valueAt(n, n2) + "\t");
                ++n2;
            }
            System.out.print("\n");
            ++n;
        }
    }
}

