/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.misc;
import DistLib.uniform;

public class hypergeometric {
    private static double[] al = new double[]{0.0, 0.0, 0.0, 0.6931471805599453, 1.791759469228055, 3.1780538303479458, 4.787491742782046, 6.579251212010101, 8.525161361065415};
    private static int ks = -1;
    private static int n1s = -1;
    private static int n2s = -1;
    private static double con = 57.56462733;
    private static double deltal = 0.0078;
    private static double deltau = 0.0034;
    private static double scale = 1.0E25;
    private static double a;
    private static double d;
    private static double e;
    private static double f;
    private static double g;
    private static int i;
    private static int k;
    private static int m;
    private static double p;
    private static double r;
    private static double s;
    private static double t;
    private static double u;
    private static double v;
    private static double w;
    private static double lamdl;
    private static double y;
    private static double lamdr;
    private static int minjx;
    private static int maxjx;
    private static int n1;
    private static int n2;
    private static double p1;
    private static double p2;
    private static double p3;
    private static double y1;
    private static double de;
    private static double dg;
    private static boolean setup1;
    private static boolean setup2;
    private static double gl;
    private static double kl;
    private static double ub;
    private static double nk;
    private static double dr;
    private static double nm;
    private static double gu;
    private static double kr;
    private static double ds;
    private static double dt;
    private static int ix;
    private static double tn;
    private static double xl;
    private static double ym;
    private static double yn;
    private static double yk;
    private static double xm;
    private static double xr;
    private static double xn;
    private static boolean reject;
    private static double xk;
    private static double alv;

    public static double density(double x2, double NR, double NB, double n) {
        if (Double.isNaN(x2) || Double.isNaN(NR) || Double.isNaN(NB) || Double.isNaN(n)) {
            return x2 + NR + NB + n;
        }
        x2 = Math.floor(x2 + 0.5);
        NR = Math.floor(NR + 0.5);
        NB = Math.floor(NB + 0.5);
        double N = NR + NB;
        n = Math.floor(n + 0.5);
        if (NR < 0.0 || NB < 0.0 || n < 0.0 || n > N) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < Math.max(0.0, n - NB) || x2 > Math.min(n, NR)) {
            return 0.0;
        }
        return Math.exp(misc.lfastchoose(NR, x2) + misc.lfastchoose(NB, n - x2) - misc.lfastchoose(N, n));
    }

    public static double cumulative(double x2, double NR, double NB, double n) {
        if (Double.isNaN(x2) || Double.isNaN(NR) || Double.isNaN(NB) || Double.isNaN(n)) {
            return x2 + NR + NB + n;
        }
        if (Double.isInfinite(x2) || Double.isInfinite(NR) || Double.isInfinite(NB) || Double.isInfinite(n)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        x2 = Math.floor(x2);
        NR = Math.floor(NR + 0.5);
        NB = Math.floor(NB + 0.5);
        double N = NR + NB;
        n = Math.floor(n + 0.5);
        if (NR < 0.0 || NB < 0.0 || n < 0.0 || n > N) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        double xstart = Math.max(0.0, n - NB);
        double xend = Math.min(n, NR);
        if (x2 < xstart) {
            return 0.0;
        }
        if (x2 >= xend) {
            return 1.0;
        }
        double xr = xstart;
        double xb = n - xr;
        double term = Math.exp(misc.lfastchoose(NR, xr) + misc.lfastchoose(NB, xb) - misc.lfastchoose(N, n));
        NR -= xr;
        NB -= xb;
        double sum2 = 0.0;
        while (xr <= x2) {
            sum2 += term;
            term *= NR / (xr += 1.0) * (xb / (NB += 1.0));
            xb -= 1.0;
            NR -= 1.0;
        }
        return sum2;
    }

    public static double quantile(double x2, double NR, double NB, double n) {
        if (Double.isNaN(x2) || Double.isNaN(NR) || Double.isNaN(NB) || Double.isNaN(n)) {
            return x2 + NR + NB + n;
        }
        if (Double.isInfinite(x2) || Double.isInfinite(NR) || Double.isInfinite(NB) || Double.isInfinite(n)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        NR = Math.floor(NR + 0.5);
        NB = Math.floor(NB + 0.5);
        double N = NR + NB;
        n = Math.floor(n + 0.5);
        if (x2 < 0.0 || x2 > 1.0 || NR < 0.0 || NR < 0.0 || n < 0.0 || n > N) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        double xstart = Math.max(0.0, n - NB);
        double xend = Math.min(n, NR);
        if (x2 <= 0.0) {
            return xstart;
        }
        if (x2 >= 1.0) {
            return xend;
        }
        double xr = xstart;
        double xb = n - xr;
        double term = Math.exp(misc.lfastchoose(NR, xr) + misc.lfastchoose(NB, xb) - misc.lfastchoose(N, n));
        NR -= xr;
        NB -= xb;
        double sum2 = term;
        while (sum2 < x2 && xr < xend) {
            sum2 += (term *= NR / (xr += 1.0) * (xb / (NB += 1.0)));
            xb -= 1.0;
            NR -= 1.0;
        }
        return xr;
    }

    private static double afc(int i) {
        double value2;
        if (i < 0) {
            System.out.println("rhyper.c: afc(i)+ i=%d < 0 -- SHOULD NOT HAPPEN!\n" + i);
            return -1.0;
        }
        if (i <= 7) {
            value2 = al[i + 1];
        } else {
            double di = i;
            value2 = (di + 0.5) * Math.log(di) - di + 0.08333333333333 / di - 0.00277777777777 / di / di / di + 0.9189385332;
        }
        return value2;
    }

    public static double random(double nn1in, double nn2in, double kkin, uniform PRNG) {
        int kk;
        int nn2;
        int nn1;
        block42: {
            if (Double.isInfinite(nn1in) || Double.isInfinite(nn2in) || Double.isInfinite(kkin)) {
                throw new ArithmeticException("Math Error: DOMAIN");
            }
            nn1 = (int)Math.floor(nn1in + 0.5);
            nn2 = (int)Math.floor(nn2in + 0.5);
            kk = (int)Math.floor(kkin + 0.5);
            if (nn1 < 0 || nn2 < 0 || kk < 0 || kk > nn1 + nn2) {
                throw new ArithmeticException("Math Error: DOMAIN");
            }
            reject = true;
            setup1 = false;
            setup2 = false;
            if (nn1 != n1s || nn2 != n2s) {
                setup1 = true;
                setup2 = true;
            } else if (kk != ks) {
                setup2 = true;
            }
            if (setup1) {
                n1s = nn1;
                n2s = nn2;
                tn = nn1 + nn2;
                if (nn1 <= nn2) {
                    n1 = nn1;
                    n2 = nn2;
                } else {
                    n1 = nn2;
                    n2 = nn1;
                }
            }
            if (setup2) {
                ks = kk;
                k = (double)(kk + kk) >= tn ? (int)tn - kk : kk;
            }
            if (setup1 || setup2) {
                m = (int)(((double)k + 1.0) * ((double)n1 + 1.0) / (tn + 2.0));
                minjx = Math.max(0, k - n2);
                maxjx = Math.min(n1, k);
            }
            if (minjx == maxjx) {
                ix = maxjx;
                if ((double)(kk + kk) >= tn) {
                    ix = nn1 > nn2 ? kk - nn2 + ix : nn1 - ix;
                } else if (nn1 > nn2) {
                    ix = kk - ix;
                }
                return ix;
            }
            if (m - minjx < 10) {
                if (setup1 || setup2) {
                    w = k < n2 ? Math.exp(con + hypergeometric.afc(n2) + hypergeometric.afc(n1 + n2 - k) - hypergeometric.afc(n2 - k) - hypergeometric.afc(n1 + n2)) : Math.exp(con + hypergeometric.afc(n1) + hypergeometric.afc(k) - hypergeometric.afc(k - n2) - hypergeometric.afc(n1 + n2));
                }
                block0: while (true) {
                    p = w;
                    ix = minjx;
                    for (u = uniform.random() * scale; u > p; u -= p) {
                        p = p * (double)(n1 - ix) * (double)(k - ix);
                        p = p / (double)(++ix) / (double)(n2 - k + ix);
                        if (ix <= maxjx) continue;
                        continue block0;
                    }
                    break block42;
                    break;
                }
            }
            if (setup1 || setup2) {
                s = Math.sqrt((tn - (double)k) * (double)k * (double)n1 * (double)n2 / (tn - 1.0) / tn / tn);
                d = (double)((int)(1.5 * s)) + 0.5;
                xl = (double)m - d + 0.5;
                xr = (double)m + d + 0.5;
                a = hypergeometric.afc(m) + hypergeometric.afc(n1 - m) + hypergeometric.afc(k - m) + hypergeometric.afc(n2 - k + m);
                kl = Math.exp(a - hypergeometric.afc((int)xl) - hypergeometric.afc((int)((double)n1 - xl)) - hypergeometric.afc((int)((double)k - xl)) - hypergeometric.afc((int)((double)(n2 - k) + xl)));
                kr = Math.exp(a - hypergeometric.afc((int)(xr - 1.0)) - hypergeometric.afc((int)((double)n1 - xr + 1.0)) - hypergeometric.afc((int)((double)k - xr + 1.0)) - hypergeometric.afc((int)((double)(n2 - k) + xr - 1.0)));
                lamdl = -Math.log(xl * ((double)(n2 - k) + xl) / ((double)n1 - xl + 1.0) / ((double)k - xl + 1.0));
                lamdr = -Math.log(((double)n1 - xr + 1.0) * ((double)k - xr + 1.0) / xr / ((double)(n2 - k) + xr));
                p1 = d + d;
                p2 = p1 + kl / lamdl;
                p3 = p2 + kr / lamdr;
            }
            while (true) {
                u = uniform.random() * p3;
                v = uniform.random();
                if (u < p1) {
                    ix = (int)(xl + u);
                } else if (u <= p2) {
                    ix = (int)(xl + Math.log(v) / lamdl);
                    if (ix < minjx) continue;
                    v = v * (u - p1) * lamdl;
                } else {
                    ix = (int)(xr - Math.log(v) / lamdr);
                    if (ix > maxjx) continue;
                    v = v * (u - p2) * lamdr;
                }
                if (m < 100 || ix <= 50) {
                    f = 1.0;
                    if (m < ix) {
                        i = m + 1;
                        while (i <= ix) {
                            f = f * (double)(n1 - i + 1) * (double)(k - i + 1) / (double)(n2 - k + i) / (double)i;
                            ++i;
                        }
                    } else if (m > ix) {
                        i = ix + 1;
                        while (i <= m) {
                            f = f * (double)i * (double)(n2 - k + i) / (double)(n1 - i) / (double)(k - i);
                            ++i;
                        }
                    }
                    if (v <= f) {
                        reject = false;
                    }
                } else {
                    y = ix;
                    y1 = y + 1.0;
                    ym = y - (double)m;
                    yn = (double)n1 - y + 1.0;
                    yk = (double)k - y + 1.0;
                    nk = (double)(n2 - k) + y1;
                    r = -ym / y1;
                    s = ym / yn;
                    t = ym / yk;
                    e = -ym / nk;
                    g = yn * yk / (y1 * nk) - 1.0;
                    dg = 1.0;
                    if (g < 0.0) {
                        dg = 1.0 + g;
                    }
                    gu = g * (1.0 + g * (-0.5 + g / 3.0));
                    gl = gu - 0.25 * (g * g * g * g) / dg;
                    xm = (double)m + 0.5;
                    xn = (double)(n1 - m) + 0.5;
                    xk = (double)(k - m) + 0.5;
                    nm = (double)(n2 - k) + xm;
                    ub = y * gu - (double)m * gl + deltau + xm * r * (1.0 + r * (-0.5 + r / 3.0)) + xn * s * (1.0 + s * (-0.5 + s / 3.0)) + xk * t * (1.0 + t * (-0.5 + t / 3.0)) + nm * e * (1.0 + e * (-0.5 + e / 3.0));
                    alv = Math.log(v);
                    if (alv > ub) {
                        reject = true;
                    } else {
                        dr = xm * (r * r * r * r);
                        if (r < 0.0) {
                            dr /= 1.0 + r;
                        }
                        ds = xn * (s * s * s * s);
                        if (s < 0.0) {
                            ds /= 1.0 + s;
                        }
                        dt = xk * (t * t * t * t);
                        if (t < 0.0) {
                            dt /= 1.0 + t;
                        }
                        de = nm * (e * e * e * e);
                        if (e < 0.0) {
                            de /= 1.0 + e;
                        }
                        reject = alv < ub - 0.25 * (dr + ds + dt + de) + (y + (double)m) * (gl - gu) - deltal ? false : !(alv <= a - hypergeometric.afc(ix) - hypergeometric.afc(n1 - ix) - hypergeometric.afc(k - ix) - hypergeometric.afc(n2 - k + ix));
                    }
                }
                if (!reject) break;
            }
        }
        if ((double)(kk + kk) >= tn) {
            ix = nn1 > nn2 ? kk - nn2 + ix : nn1 - ix;
        } else if (nn1 > nn2) {
            ix = kk - ix;
        }
        return ix;
    }
}

