/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.gamma;
import DistLib.misc;
import DistLib.normal;
import DistLib.uniform;

public class poisson {
    static double[] fact = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0};
    private static double a0 = -0.5;
    private static double a1 = 0.3333333;
    private static double a2 = -0.2500068;
    private static double a3 = 0.2000118;
    private static double a4 = -0.1661269;
    private static double a5 = 0.1421878;
    private static double a6 = -0.1384794;
    private static double a7 = 0.125006;
    private static double b1;
    private static double b2;
    private static double c;
    private static double c0;
    private static double c1;
    private static double c2;
    private static double c3;
    private static double d;
    private static double del;
    private static double difmuk;
    private static double e;
    private static double fk;
    private static double fx;
    private static double fy;
    private static double g;
    private static double omega;
    private static double p;
    private static double p0;
    private static double px;
    private static double py;
    private static double q;
    private static double s;
    private static double t;
    private static double u;
    private static double v;
    private static double x;
    private static double xx;
    private static double[] pp;
    private static int j;
    private static int k;
    private static int kflag;
    private static int l;
    private static int m;
    private static int ipois;
    private static double muprev;
    private static double muold;

    static {
        pp = new double[36];
        muprev = 0.0;
        muold = 0.0;
    }

    public static double density(double x2, double lambda) {
        if (Double.isNaN(x2) || Double.isNaN(lambda)) {
            return x2 + lambda;
        }
        x2 = Math.floor(x2 + 0.5);
        if (lambda <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(x2)) {
            return 0.0;
        }
        return Math.exp(x2 * Math.log(lambda) - lambda - misc.lgammafn(x2 + 1.0));
    }

    public static double cumulative(double x2, double lambda) {
        if (Double.isNaN(x2) || Double.isNaN(lambda)) {
            return x2 + lambda;
        }
        x2 = Math.floor(x2 + 0.5);
        if (lambda <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(x2)) {
            return 1.0;
        }
        return 1.0 - gamma.cumulative(lambda, x2 + 1.0, 1.0);
    }

    public static double quantile(double x2, double lambda) {
        double sigma;
        if (Double.isNaN(x2) || Double.isNaN(lambda)) {
            return x2 + lambda;
        }
        if (Double.isInfinite(lambda)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < 0.0 || x2 > 1.0 || lambda <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 == 0.0) {
            return 0.0;
        }
        if (x2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double mu = lambda;
        double gamma2 = sigma = Math.sqrt(lambda);
        double z = normal.quantile(x2, 0.0, 1.0);
        double y = Math.floor(mu + sigma * (z + gamma2 * (z * z - 1.0) / 6.0) + 0.5);
        if ((z = poisson.cumulative(y, lambda)) >= x2) {
            while (true) {
                double d;
                z = poisson.cumulative(y - 1.0, lambda);
                if (d < x2) {
                    return y;
                }
                y -= 1.0;
            }
        }
        while (true) {
            double d;
            z = poisson.cumulative(y + 1.0, lambda);
            if (d >= x2) {
                return y + 1.0;
            }
            y += 1.0;
        }
    }

    public static double random(double mu, uniform PRNG) {
        throw new ArithmeticException("FUNCTION NOT IMPLEMENTED");
    }
}

