/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.Serializer;
import akka.util.NonFatal$;
import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.util.concurrent.ConcurrentHashMap;
import scala.Either;
import scala.Function1;
import scala.Left;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Right;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.DynamicVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t=r!B\u0001\u0003\u0011\u000b9\u0011!D*fe&\fG.\u001b>bi&|gN\u0003\u0002\u0004\t\u0005i1/\u001a:jC2L'0\u0019;j_:T\u0011!B\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001RA\u0006\u0003\u001bM+'/[1mSj\fG/[8o'\rIA\u0002\u0006\t\u0003\u001bIi\u0011A\u0004\u0006\u0003\u001fA\tA\u0001\\1oO*\t\u0011#\u0001\u0003kCZ\f\u0017BA\n\u000f\u0005\u0019y%M[3diB\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\tY1kY1mC>\u0013'.Z2u\u0011\u0015Y\u0012\u0002\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tq!\u0002\u0003\u001f\u0013\u0001y\"aD\"mCN\u001c8+\u001a:jC2L'0\u001a:\u0011\tU\u0001#%N\u0005\u0003CY\u0011a\u0001V;qY\u0016\u0014\u0004GA\u0012-!\r!sE\u000b\b\u0003+\u0015J!A\n\f\u0002\rA\u0013X\rZ3g\u0013\tA\u0013FA\u0003DY\u0006\u001c8O\u0003\u0002'-A\u00111\u0006\f\u0007\u0001\t\u0015iSD!\u0001/\u0005\ryF%M\t\u0003_I\u0002\"!\u0006\u0019\n\u0005E2\"a\u0002(pi\"Lgn\u001a\t\u0003+MJ!\u0001\u000e\f\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\tm%\u0011qG\u0001\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bbB\u001d\n\u0005\u0004%\tAO\u0001\u0018GV\u0014(/\u001a8u)J\fgn\u001d9peR\fE\r\u001a:fgN,\u0012a\u000f\t\u0004y}\nU\"A\u001f\u000b\u0005y2\u0012\u0001B;uS2L!\u0001Q\u001f\u0003\u001f\u0011Kh.Y7jGZ\u000b'/[1cY\u0016\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u0003\u0002\u000b\u0005\u001cGo\u001c:\n\u0005\u0019\u001b%aB!eIJ,7o\u001d\u0005\u0007\u0011&\u0001\u000b\u0011B\u001e\u00021\r,(O]3oiR\u0013\u0018M\\:q_J$\u0018\t\u001a3sKN\u001c\bE\u0002\u0003K\u0013\u0001Y%\u0001C*fiRLgnZ:\u0014\u0007%cA\u0003\u0003\u0005N\u0013\n\u0015\r\u0011\"\u0001O\u0003\u0019\u0019wN\u001c4jOV\tq\n\u0005\u0002Q-6\t\u0011K\u0003\u0002N%*\u00111\u000bV\u0001\tif\u0004Xm]1gK*\tQ+A\u0002d_6L!aV)\u0003\r\r{gNZ5h\u0011!I\u0016J!A!\u0002\u0013y\u0015aB2p]\u001aLw\r\t\u0005\u00067%#\ta\u0017\u000b\u00039z\u0003\"!X%\u000e\u0003%AQ!\u0014.A\u0002=Cq\u0001Y%C\u0002\u0013\u0005\u0011-A\u0006TKJL\u0017\r\\5{KJ\u001cX#\u00012\u0011\t\u0011\u001aW-Z\u0005\u0003I&\u00121!T1q!\t!c-\u0003\u0002hS\t11\u000b\u001e:j]\u001eDa![%!\u0002\u0013\u0011\u0017\u0001D*fe&\fG.\u001b>feN\u0004\u0003bB6J\u0005\u0004%\t!Y\u0001\u0016'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8CS:$\u0017N\\4t\u0011\u0019i\u0017\n)A\u0005E\u000612+\u001a:jC2L'0\u0019;j_:\u0014\u0015N\u001c3j]\u001e\u001c\b\u0005C\u0003p\u0013\u0012%\u0001/A\u0006d_:4\u0017n\u001a+p\u001b\u0006\u0004HC\u00012r\u0011\u0015\u0011h\u000e1\u0001P\u0003\r\u0019gm\u001a\u0004\u0005\u0015\t\u0001Ao\u0005\u0003t\u0019U$\u0002C\u0001\"w\u0013\t98IA\u0005FqR,gn]5p]\"A\u0011p\u001dBC\u0002\u0013\u0005!0\u0001\u0004tsN$X-\\\u000b\u0002wB\u0011!\t`\u0005\u0003{\u000e\u00131#\u0012=uK:$W\rZ!di>\u00148+_:uK6D\u0001b`:\u0003\u0002\u0003\u0006Ia_\u0001\bgf\u001cH/Z7!\u0011\u0019Y2\u000f\"\u0001\u0002\u0004Q!\u0011QAA\u0004!\tA1\u000f\u0003\u0004z\u0003\u0003\u0001\ra\u001f\u0005\n\u0003\u0017\u0019(\u0019!C\u0001\u0003\u001b\t\u0001b]3ui&twm]\u000b\u0003\u0003\u001f\u00012!!\u0005J\u001d\tA\u0001\u0001\u0003\u0005\u0002\u0016M\u0004\u000b\u0011BA\b\u0003%\u0019X\r\u001e;j]\u001e\u001c\b\u0005C\u0005\u0002\u001aM\u0014\r\u0011\"\u0001\u0002\u001c\u0005\u0019An\\4\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rB!A\u0003fm\u0016tG/\u0003\u0003\u0002(\u0005\u0005\"A\u0004'pO\u001eLgnZ!eCB$XM\u001d\u0005\t\u0003W\u0019\b\u0015!\u0003\u0002\u001e\u0005!An\\4!\u0011\u001d\tyc\u001dC\u0001\u0003c\t\u0011b]3sS\u0006d\u0017N_3\u0015\t\u0005M\u0012Q\f\t\b+\u0005U\u0012\u0011HA)\u0013\r\t9D\u0006\u0002\u0007\u000b&$\b.\u001a:\u0011\t\u0005m\u00121\n\b\u0005\u0003{\t9E\u0004\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019EB\u0001\u0007yI|w\u000e\u001e \n\u0003]I1!!\u0013\u0017\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0014\u0002P\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u00132\u0002#B\u000b\u0002T\u0005]\u0013bAA+-\t)\u0011I\u001d:bsB\u0019Q#!\u0017\n\u0007\u0005mcC\u0001\u0003CsR,\u0007\u0002CA0\u0003[\u0001\r!!\u0019\u0002\u0003=\u00042!FA2\u0013\r\t)G\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0005%4\u000f\"\u0001\u0002l\u0005YA-Z:fe&\fG.\u001b>f)!\ti'a\u001c\u0002t\u0005u\u0004cB\u000b\u00026\u0005e\u0012\u0011\r\u0005\t\u0003c\n9\u00071\u0001\u0002R\u0005)!-\u001f;fg\"A\u0011QOA4\u0001\u0004\t9(\u0001\u0007tKJL\u0017\r\\5{KJLE\rE\u0002\u0016\u0003sJ1!a\u001f\u0017\u0005\rIe\u000e\u001e\u0005\t\u0003\u007f\n9\u00071\u0001\u0002\u0002\u0006)1\r\\1{uB)Q#a!\u0002\b&\u0019\u0011Q\u0011\f\u0003\r=\u0003H/[8oa\u0011\tI)!$\u0011\t\u0011:\u00131\u0012\t\u0004W\u00055EaBAH\u0003O\u0012\tA\f\u0002\u0004?\u0012\u0012\u0004bBA5g\u0012\u0005\u00111\u0013\u000b\u0007\u0003[\n)*a&\t\u0011\u0005E\u0014\u0011\u0013a\u0001\u0003#B\u0001\"a \u0002\u0012\u0002\u0007\u0011\u0011\u0014\u0019\u0005\u00037\u000by\n\u0005\u0003%O\u0005u\u0005cA\u0016\u0002 \u00129\u0011\u0011UAI\u0005\u0003q#aA0%g!9\u0011QU:\u0005\u0002\u0005\u001d\u0016!\u00054j]\u0012\u001cVM]5bY&TXM\u001d$peR\u0019Q'!+\t\u0011\u0005}\u00131\u0015a\u0001\u0003CBq!!,t\t\u0003\ty+A\u0007tKJL\u0017\r\\5{KJ4uN\u001d\u000b\u0004k\u0005E\u0006\u0002CA@\u0003W\u0003\r!a-1\t\u0005U\u0016\u0011\u0018\t\u0005I\u001d\n9\fE\u0002,\u0003s#q!a/\u0002,\n\u0005aFA\u0002`IQBq!a0t\t\u0003\t\t-\u0001\u0007tKJL\u0017\r\\5{KJ|e\r\u0006\u0003\u0002D\u0006\u0015\u0007CB\u000b\u00026\u0005eR\u0007C\u0004\u0002H\u0006u\u0006\u0019A3\u0002\u001bM,'/[1mSj,'OR)O\u0011%\tYm\u001db\u0001\n\u0013\ti-A\u0006tKJL\u0017\r\\5{KJ\u001cXCAAh!\u0011!3-Z\u001b\t\u0011\u0005M7\u000f)A\u0005\u0003\u001f\fAb]3sS\u0006d\u0017N_3sg\u0002B!\"a6t\u0005\u0004%\t\u0001BAm\u0003!\u0011\u0017N\u001c3j]\u001e\u001cXCAAn!\u0019\tY$!8\u0002b&!\u0011q\\A(\u0005\r\u0019V-\u001d\t\u0004\u0003#i\u0002\u0002CAsg\u0002\u0006I!a7\u0002\u0013\tLg\u000eZ5oON\u0004\u0003bBAug\u0012%\u00111^\u0001\u0005g>\u0014H\u000f\u0006\u0003\u0002\\\u00065\b\u0002CAx\u0003O\u0004\r!!=\u0002\u0005%t\u0007CBA\u001e\u0003g\f\t/\u0003\u0003\u0002v\u0006=#\u0001C%uKJ\f'\r\\3\t\u0013\u0005e8O1A\u0005\n\u0005m\u0018!D:fe&\fG.\u001b>fe6\u000b\u0007/\u0006\u0002\u0002~B9\u0011q B\u0004\u0005\u0017)TB\u0001B\u0001\u0015\u0011\u0011\u0019A!\u0002\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002?!%!!\u0011\u0002B\u0001\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\u0019\u0005\u0005\u001b\u0011\t\u0002\u0005\u0003%O\t=\u0001cA\u0016\u0003\u0012\u00111!1C:\u0003\u00029\u00121a\u0018\u00138\u0011!\u00119b\u001dQ\u0001\n\te\u0011AD:fe&\fG.\u001b>fe6\u000b\u0007\u000f\t\t\b\u0003\u007f\u00149Aa\u00076a\u0011\u0011iB!\t\u0011\t\u0011:#q\u0004\t\u0004W\t\u0005BA\u0002B\ng\n\u0005a\u0006C\u0005\u0003&M\u0014\r\u0011\"\u0001\u0003(\u0005!2/\u001a:jC2L'0\u001a:Cs&#WM\u001c;jif,\"A!\u000b\u0011\u000b\u0011\u001a\u0017qO\u001b\t\u0011\t52\u000f)A\u0005\u0005S\tQc]3sS\u0006d\u0017N_3s\u0005fLE-\u001a8uSRL\b\u0005")
public class Serialization
implements Extension,
ScalaObject {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final LoggingAdapter log;
    private final Map<String, Serializer> akka$serialization$Serialization$$serializers;
    private final Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;

    public static final DynamicVariable<Address> currentTransportAddress() {
        return Serialization$.MODULE$.currentTransportAddress();
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    /*
     * WARNING - void declaration
     */
    public Either<Throwable, byte[]> serialize(Object o) {
        void var2_2;
        Either exceptionResult1 = null;
        try {
            exceptionResult1 = new Right(this.findSerializerFor(o).toBinary(o));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            exceptionResult1 = new Left(option.get());
        }
        return var2_2;
    }

    public Either<Throwable, Object> deserialize(byte[] bytes, int serializerId, Option<Class<?>> clazz) {
        Either exceptionResult2 = null;
        try {
            exceptionResult2 = new Right<Throwable, Object>(((Serializer)this.serializerByIdentity().apply(BoxesRunTime.boxToInteger(serializerId))).fromBinary(bytes, clazz));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            exceptionResult2 = new Left(option.get());
        }
        return exceptionResult2;
    }

    /*
     * WARNING - void declaration
     */
    public Either<Throwable, Object> deserialize(byte[] bytes, Class<?> clazz) {
        void var3_3;
        Either exceptionResult3 = null;
        try {
            exceptionResult3 = new Right(this.serializerFor(clazz).fromBinary(bytes, new Some(clazz)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            exceptionResult3 = new Left(option.get());
        }
        return var3_3;
    }

    public Serializer findSerializerFor(Object o) {
        Object object = o;
        return object == null ? NullSerializer$.MODULE$ : this.serializerFor(object.getClass());
    }

    public Serializer serializerFor(Class<?> clazz$1) {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap().get(clazz$1);
        if (serializer2 == null) {
            Seq possibilities;
            Seq seq2 = (Seq)this.bindings().filter((Function1<Tuple2<Class<?>, Serializer>, Object>)((Object)new Serializable(this, clazz$1){
                public static final long serialVersionUID;
                private final Class clazz$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<Class<?>, Serializer> tuple2) {
                    return tuple2._1().isAssignableFrom(this.clazz$1);
                }
                {
                    this.clazz$1 = clazz;
                }
            }));
            Some<Seq> some = Seq$.MODULE$.unapplySeq(seq2);
            if (true) {
                Seq seq3 = some.get();
                if (seq3 == null ? false : seq3.lengthCompare(0) == 0) {
                    throw new NotSerializableException(Predef$.MODULE$.augmentString("No configured serialization-bindings for class [%s]").format(Predef$.MODULE$.genericWrapArray(new Object[]{clazz$1.getName()})));
                }
                possibilities = seq2;
            } else {
                possibilities = seq2;
            }
            if (!this.unique$1(possibilities)) {
                this.log().warning(new StringBuilder().append((Object)"Multiple serializers found for ").append(clazz$1).append((Object)", choosing first: ").append(possibilities).toString());
            }
            Serializer ser = (Serializer)((Tuple2)possibilities.apply(0))._2();
            Serializer serializer3 = this.serializerMap().putIfAbsent(clazz$1, ser);
            if (serializer3 == null) {
                this.log().debug("Using serializer[{}] for message [{}]", ser.getClass().getName(), clazz$1.getName());
                serializer = ser;
            } else {
                serializer = serializer3;
            }
        } else {
            serializer = serializer2;
        }
        return serializer;
    }

    public Either<Throwable, Serializer> serializerOf(String serializerFQN$1) {
        return (Either)this.system().dynamicAccess().createInstanceFor(serializerFQN$1, (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(ExtendedActorSystem.class).$minus$greater(this.system())})), ClassManifest$.MODULE$.classType(Serializer.class)).fold(new Serializable(this, serializerFQN$1){
            public static final long serialVersionUID;
            private final Serialization $outer;
            private final String serializerFQN$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Either<Throwable, Serializer> apply(Throwable x$6) {
                return this.$outer.system().dynamicAccess().createInstanceFor(this.serializerFQN$1, (Seq)Seq$.MODULE$.apply(Nil$.MODULE$), ClassManifest$.MODULE$.classType(Serializer.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.serializerFQN$1 = string2;
            }
        }, new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Right<Nothing$, Serializer> apply(Serializer serializer) {
                return new Right<Nothing$, Serializer>(serializer);
            }
        });
    }

    public final Map<String, Serializer> akka$serialization$Serialization$$serializers() {
        return this.akka$serialization$Serialization$$serializers;
    }

    public Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        ArrayBuffer arrayBuffer = new ArrayBuffer(in.size());
        return in.$div$colon(arrayBuffer, new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ArrayBuffer<Tuple2<Class<?>, Serializer>> apply(ArrayBuffer<Tuple2<Class<?>, Serializer>> buf, Tuple2<Class<?>, Serializer> ca$1) {
                int n = buf.indexWhere((Function1<Tuple2<Class<?>, Serializer>, Object>)((Object)new Serializable(this, ca$1){
                    public static final long serialVersionUID;
                    private final Tuple2 ca$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<Class<?>, Serializer> tuple2) {
                        return tuple2._1().isAssignableFrom((Class)this.ca$1._1());
                    }
                    {
                        this.ca$1 = tuple2;
                    }
                }));
                if (n == -1) {
                    buf.append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca$1}));
                } else {
                    buf.insert(n, Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca$1}));
                }
                return buf;
            }
        });
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private final boolean unique$1(Seq possibilities$1) {
        return possibilities$1.size() == 1 || ((IterableLike)possibilities$1.map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Class<?> apply(Tuple2<Class<?>, Serializer> tuple2) {
                return tuple2._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).forall(new Serializable(this, possibilities$1){
            public static final long serialVersionUID;
            private final Seq possibilities$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Class<?> clazz) {
                return clazz.isAssignableFrom((Class)((Tuple2)this.possibilities$1.apply(0))._1());
            }
            {
                this.possibilities$1 = seq2;
            }
        }) || ((IterableLike)possibilities$1.map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Serializer apply(Tuple2<Class<?>, Serializer> tuple2) {
                return tuple2._2();
            }
        }, Seq$.MODULE$.canBuildFrom())).forall(new Serializable(this, possibilities$1){
            public static final long serialVersionUID;
            private final Seq possibilities$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Serializer serializer) {
                Serializer serializer2 = serializer;
                T2 T2 = ((Tuple2)this.possibilities$1.apply(0))._2();
                return !(serializer2 != null ? !serializer2.equals(T2) : T2 != null);
            }
            {
                this.possibilities$1 = seq2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Serialization(ExtendedActorSystem system) {
        void var3_3;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.log = Logging$.MODULE$.apply(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.akka$serialization$Serialization$$serializers = this.settings().Serializers().map(new $anonfun$2(this), Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable<Tuple2<Class<?>, Serializer>> configuredBindings = this.settings().SerializationBindings().withFilter(new $anonfun$3(this)).map(new $anonfun$4(this), Iterable$.MODULE$.canBuildFrom());
        this.bindings = this.sort(configuredBindings);
        ConcurrentHashMap serializerMap$1 = new ConcurrentHashMap();
        ((IterableLike)this.bindings().filter(new $anonfun$7(this))).foreach(new $anonfun$8(this, serializerMap$1));
        this.serializerMap = var3_3;
        this.serializerByIdentity = ((TraversableLike)((TraversableLike)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(BoxesRunTime.boxToInteger(NullSerializer$.MODULE$.identifier())).$minus$greater(NullSerializer$.MODULE$)}))).$plus$plus(this.akka$serialization$Serialization$$serializers(), Map$.MODULE$.canBuildFrom())).map(new $anonfun$9(this), Map$.MODULE$.canBuildFrom());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Settings
    implements ScalaObject {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private Map<String, String> configToMap(Config cfg) {
            return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(cfg.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.conforms()).map(new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Tuple2<String, String> apply(Tuple2<String, Object> tuple2) {
                    Tuple2<String, Object> tuple22 = tuple2;
                    if (tuple22 != null) {
                        return new Tuple2<String, String>(tuple22._1(), tuple22._2().toString());
                    }
                    throw new MatchError(tuple22);
                }
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("akka.actor.serializers"));
            this.SerializationBindings = this.configToMap(config.getConfig("akka.actor.serialization-bindings"));
        }
    }
}

