/*
 * Decompiled with CFR 0.152.
 */
package com.clineff.license;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class License {
    public static final String INSTANCE_NAME = "RSA";
    public static final int DEFAULT_KEY_LEN = 8192;
    public static final String PRIVATE_KEY_BASE64 = "";
    public static final String PUBLIC_KEY_BASE64 = "MIIEIjANBgkqhkiG9w0BAQEFAAOCBA8AMIIECgKCBAEAjI7X81ovape18DAXzQaO9A3hmGj5rI/D7T88HIWbR8vItKKCGWianOAR+pTdJhUzu1/6zpDCFdaD+lQtNoqUtZH8eoFOfduvEztDB+RKKYzrn2GX2UxOz1WmnHQGEN+ZNyFfNyTZ7SiwSD/4iw3xSGMTaocmq/7f20xs8RWScspxjjmmaLDvIOFkkMyyUhMIJA7yAOkx+xGBtX3CP4zlBu3PH3GxwptyXXQ4ryPh31r6Cy7gT7BzPCgyHr3EFyRjDcFdjowzlbq5S00g7k8/FGssKDAteILn40KMjit9wyCqId1kqiPL+/u3tfXdmpAn7prdIyOZble033NYlyW574zx6snWjSPgCqYJ2u1TBLr5GCOS5/IRr+4tnTDzcm1iYwn6I2ar32KcM9f8DSbyTG6gIeQmx4j2TRaV6o/rXWUQb3VLG0e6k6ml4BUJ+32qzxlD0obNunD6B+nmlVDW6hdxRkWzYXsSzQicdeUBJFfRx5rTPjy5Ul5Vi19g2TwMGbHcjsqgO/wkXmcYpZ3V4e8hz9zI/ovHDhIhNsGQiKqk+HWuTVDbyGTk66iEjVD2BBoDjLALVhaHoA3AwkWAQ+p0B8nwauJXSSEOUVEGW5TqfV1De396dLqDbNCK86FRiqz5QB7u1+Kzk+sMm+41a5Uw7J0bhpsRq1NSAJbz37swVsoGL6oyhy5m0jMGUAnoltbEBU8iHF/kkL+p5J7gvqZ/gKdNnEOiKzZhKnrMsDskyge39+qBlTU1m0NjRYfoqzFwKUPHkw7bNia2DdV8mdiRUan8qQKTC4AABzTu7dr4DMupVMor7bMkB3vGITT1V+7pQ7+jIH5cKT5ts4mnZkFnfMHYJZkETHUYw/hgLXNMxQ50Mba9aGyoczxEU30/gPQGfoB2qAiCTQh+U7aqrZNrDLxInFpm5YmeE8Mk2B6OH0gKndE+Q1KPhBKzeQUi5g/nJp8MoLEpKBsmBjeX6e/KL0Z51+ySZoqJ+tewkxpDKcnYBKQ8goN0q80xbc+ij8FoUn8RyxiRiuh7tkf8d+r0uccNI+Mmoh8aVdcNYDOZ+9ZSeGs+hY9SVDK42/4yjYp0xCYPHLiMXK4tp/bXJnotsmZuNZqEm6ei/u3JIZFJNBNn1HyiI1jqa1O+YiD8ALqsVd0JZ+9VCKufbDIOCNwfjZG7DvQyCkI563k9e51Yy4NXQcFGSlj4Wv6/FV/zVY0vF6IjEwtpEitz1vf9sfElH2kmEbBe9wosHtVDI3zZ+AEL5V2pWM1WFEQ+yXsdWUTEtW1JOnhd2rU7QSUJSbRTDSbJoR3FdQOLG8I/xjbEkUWt99KG5uvbI5xN86XJqxOHRCW1jQ9cnT+NEO7gxQIDAQAB";
    public static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    public static final String LICENSE_VERSION = "20161210";
    int keyLength = 8192;
    String privateKeyPath;
    String publicKeyPath;
    String transformation = "RSA/ECB/PKCS1Padding";
    String encoding = "UTF-8";
    private PrivateKey privateKey;
    private PublicKey publicKey;
    boolean verbose;
    Properties properties;

    static String addMonths(int months) {
        Calendar gc = Calendar.getInstance();
        gc.add(2, months);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(gc.getTime());
    }

    static String licenseExpires(LicenseType licenseType) {
        switch (licenseType) {
            case Test: {
                return License.addMonths(3);
            }
            case Academic: 
            case Non_Profit: 
            case Professional: {
                return License.addMonths(12);
            }
        }
        throw new RuntimeException("Unknown license type " + (Object)((Object)licenseType));
    }

    public static void main(String[] args) {
        String todo = "createLicense";
        String licensedTo = "Matthias Winkler";
        LicenseType licenseType = LicenseType.Non_Profit;
        String licenseExpires = License.licenseExpires(licenseType);
        String pubKeyFile = "keys/key_public.key";
        String privKeyFile = "keys/key_private.key";
        String licenseFile = "licenses/clinEff." + licensedTo.replaceAll("\\s", "_") + ".license";
        String licenseFileHome = String.valueOf(Gpr.HOME) + "/clinEff.license";
        License license = null;
        switch (todo) {
            case "createKey": {
                license = new License(8192);
                license.createKeys();
                license.saveKeys(privKeyFile, pubKeyFile);
                break;
            }
            case "loadKey": {
                license = new License(privKeyFile, pubKeyFile);
                break;
            }
            case "loadKeyBase64": {
                license = new License();
                license.createPrivateKey(PRIVATE_KEY_BASE64);
                license.createPublicKey(PUBLIC_KEY_BASE64);
                break;
            }
            case "createLicense": {
                String licenseNumber = PRIVATE_KEY_BASE64;
                Random rand = new Random();
                int i = 0;
                while (i < 2) {
                    licenseNumber = String.valueOf(licenseNumber) + Integer.toHexString(rand.nextInt());
                    ++i;
                }
                String txt = "license_to      : " + licensedTo + "\n" + "license_expires : " + licenseExpires + "\n" + "license_type    : " + (Object)((Object)licenseType) + "\n" + "license_version : " + LICENSE_VERSION + "\n" + "license_number  : " + licenseNumber + "\n";
                System.out.println("Creating file: " + licenseFile);
                Gpr.toFile(licenseFile, txt);
                System.out.println("Creating file: " + licenseFileHome);
                Gpr.toFile(licenseFileHome, txt);
            }
            case "signLicense": {
                System.out.println("Reading file: " + licenseFile);
                String originalTxt = Gpr.readFile(licenseFile);
                System.out.println("Original text:\n" + originalTxt + "\n");
                license = new License(privKeyFile, pubKeyFile);
                String signature = license.sign(originalTxt);
                System.out.println("Signature:\n----------\n" + signature + "\n----------\n");
                String signFile = String.valueOf(licenseFile) + ".sign";
                String signFileHome = String.valueOf(licenseFileHome) + ".sign";
                Gpr.toFile(signFile, signature);
                Gpr.toFile(signFileHome, signature);
                System.out.println("Signature saved to file '" + signFile + "'");
                System.out.println("Signature saved to file '" + signFileHome + "'");
                license = new License();
                boolean ok = license.checkLicense(licenseFile);
                if (!ok) {
                    throw new RuntimeException("Signature does not match!");
                }
                System.out.println("Checking signature: " + ok);
                String emailFileName = "email_template." + (Object)((Object)licenseType) + ".txt";
                String emailTxt = Gpr.readFile(emailFileName);
                System.out.println("\n\n\nEmail template:\n----------------------------------------\n" + emailTxt + "\n\n----------------------------------------");
                return;
            }
            default: {
                throw new RuntimeException("Unknown option " + todo);
            }
        }
        Gpr.debug(license);
        license.testCrypt();
        license.testSign();
    }

    public License() {
    }

    public License(int keyLength) {
        this.keyLength = keyLength;
    }

    public License(String publicKeyPath) {
        this.privateKeyPath = null;
        this.publicKeyPath = publicKeyPath;
    }

    public License(String privateKeyPath, String publicKeyPath) {
        this.privateKeyPath = privateKeyPath;
        this.publicKeyPath = publicKeyPath;
        this.loadKeys();
    }

    public boolean checkLicense(String licenseFileName) {
        String signature;
        String originalTxt;
        block14: {
            block13: {
                if (this.publicKey == null) {
                    this.createPublicKey(PUBLIC_KEY_BASE64);
                }
                try {
                    if (this.verbose) {
                        Timer.showStdErr("License: Checking license file '" + licenseFileName + "'");
                    }
                    if (!(originalTxt = Gpr.readFile(licenseFileName)).isEmpty()) break block13;
                    if (this.verbose) {
                        Timer.showStdErr("License: Cannot read license file '" + licenseFileName + "'");
                    }
                    return false;
                }
                catch (Throwable t2) {
                    if (this.verbose) {
                        Timer.showStdErr("Error checking license file '" + licenseFileName + "'");
                    }
                    return false;
                }
            }
            String signFile = String.valueOf(licenseFileName) + ".sign";
            signature = Gpr.readFile(signFile);
            if (!signature.isEmpty()) break block14;
            if (this.verbose) {
                Timer.showStdErr("License: Cannot read license signature file '" + licenseFileName + "'");
            }
            return false;
        }
        boolean ok = this.signCheck(originalTxt, signature);
        if (ok) {
            if (this.verbose) {
                Timer.showStdErr("License: OK");
            }
            this.properties = this.parseConfig(originalTxt);
        } else if (this.verbose) {
            Timer.showStdErr("License: Check failed");
        }
        return ok;
    }

    public void createKeys() {
        KeyPairGenerator keyPairGenerator;
        System.out.println("Creating Public/Private key pairs, length: " + this.keyLength);
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(INSTANCE_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        keyPairGenerator.initialize(this.keyLength);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
    }

    void createPrivateKey(String base64) {
        try {
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64(base64.getBytes()));
            this.privateKey = KeyFactory.getInstance(INSTANCE_NAME).generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException("Error reading private key from Base64 string '" + base64 + "'", e);
        }
    }

    void createPublicKey(String base64) {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.decodeBase64(base64.getBytes()));
            this.publicKey = KeyFactory.getInstance(INSTANCE_NAME).generatePublic(x509EncodedKeySpec);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading public key from Base64 string '" + base64 + "'", e);
        }
    }

    public String decrypt(String cipherText) {
        try {
            PrivateKey privateKey = this.getPrivateKey();
            Cipher cipher = Cipher.getInstance(this.transformation);
            cipher.init(2, privateKey);
            return new String(cipher.doFinal(Base64.decodeBase64(cipherText)), this.encoding);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException("Error when decrypting text with public key '" + this.privateKeyPath + "'", e);
        }
    }

    public String encrypt(String rawText) {
        try {
            PublicKey publicKey = this.getPublicKey();
            Cipher cipher = Cipher.getInstance(this.transformation);
            cipher.init(1, publicKey);
            return Base64.encodeBase64String(cipher.doFinal(rawText.getBytes(this.encoding)));
        }
        catch (Exception e) {
            throw new RuntimeException("Error when decrypting text with public key '" + this.publicKeyPath + "'", e);
        }
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void loadKeys() {
        if (this.privateKeyPath != null) {
            this.privateKey = this.loadPrivateKey(this.privateKeyPath);
        }
        if (this.publicKeyPath != null) {
            this.publicKey = this.loadPublicKey(this.publicKeyPath);
        }
    }

    PrivateKey loadPrivateKey(String fileName) {
        try {
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(IOUtils.toByteArray(new FileInputStream(this.privateKeyPath)));
            return KeyFactory.getInstance(INSTANCE_NAME).generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException("Error reading private key from file '" + fileName + "'", e);
        }
    }

    PublicKey loadPublicKey(String fileName) {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(IOUtils.toByteArray(new FileInputStream(fileName)));
            return KeyFactory.getInstance(INSTANCE_NAME).generatePublic(x509EncodedKeySpec);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading public key from file '" + fileName + "'", e);
        }
    }

    protected Properties parseConfig(String originalTxt) {
        try {
            Properties properties = new Properties();
            ByteArrayInputStream stream = new ByteArrayInputStream(originalTxt.getBytes(StandardCharsets.UTF_8));
            properties.load(stream);
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveKeys(String privateKeyPath, String publicKeyPath) {
        this.privateKeyPath = privateKeyPath;
        this.publicKeyPath = publicKeyPath;
        FileOutputStream privateKeyOutputStream = null;
        FileOutputStream publicKeyOutputStream = null;
        try {
            try {
                File privateKeyFile = new File(privateKeyPath);
                File publicKeyFile = new File(publicKeyPath);
                privateKeyOutputStream = new FileOutputStream(privateKeyFile);
                privateKeyOutputStream.write(this.privateKey.getEncoded());
                publicKeyOutputStream = new FileOutputStream(publicKeyFile);
                publicKeyOutputStream.write(this.publicKey.getEncoded());
            }
            catch (IOException ioException) {
                throw new RuntimeException("Error saving keys to files:\n\t'" + privateKeyPath + "'\n\t'" + publicKeyPath + "'", ioException);
            }
        }
        finally {
            try {
                if (privateKeyOutputStream != null) {
                    privateKeyOutputStream.close();
                }
                if (publicKeyOutputStream != null) {
                    publicKeyOutputStream.close();
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException("Error closing files", ioException);
            }
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String sign(String text2) {
        try {
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(this.getPrivateKey(), new SecureRandom());
            byte[] message = text2.getBytes();
            signature.update(message);
            byte[] sigBytes = signature.sign();
            String signatureTxt = Base64.encodeBase64String(sigBytes);
            return signatureTxt;
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing text ", e);
        }
    }

    public boolean signCheck(String text2, String base64Signature) {
        try {
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            byte[] message = text2.getBytes();
            byte[] sigBytes = Base64.decodeBase64(base64Signature);
            signature.initVerify(this.getPublicKey());
            signature.update(message);
            return signature.verify(sigBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing text ", e);
        }
    }

    void testCrypt() {
        String originalTxt = "John has a long mustache";
        System.out.println("In        : " + originalTxt);
        String encrypted = this.encrypt(originalTxt);
        System.out.println("Encrypted : " + encrypted);
        String decrypted = this.decrypt(encrypted);
        System.out.println("Out       : " + decrypted);
        if (!decrypted.equals(originalTxt)) {
            throw new RuntimeException("Error: Encryption / decryption does not produce the original text!");
        }
    }

    void testSign() {
        String originalTxt = "John has a long mustache";
        System.out.println("In           : " + originalTxt);
        String signature = this.sign(originalTxt);
        System.out.println("Signature    : " + signature);
        boolean ok = this.signCheck(originalTxt, signature);
        if (!ok) {
            throw new RuntimeException("Signature does not match!");
        }
        System.out.println("Signature OK : " + ok);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\tProperties:\n");
        for (Map.Entry<Object, Object> e : this.properties.entrySet()) {
            sb.append("\t\t" + e.getKey() + " : '" + e.getValue() + "'\n");
        }
        return "\tPrivate key  : " + this.privateKey + "\n\tPublic key : " + this.publicKey + (this.privateKey == null ? PRIVATE_KEY_BASE64 : "\n\tPRIVATE_KEY_BASE64 = \"" + new String(Base64.encodeBase64(this.privateKey.getEncoded())) + "\";") + (this.publicKey == null ? PRIVATE_KEY_BASE64 : "\n\tPUBLIC_KEY_BASE64 = \"" + new String(Base64.encodeBase64(this.publicKey.getEncoded())) + "\";") + sb;
    }

    public static enum LicenseType {
        Academic,
        Non_Profit,
        Test,
        Professional,
        OEM;

    }
}

