/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.Argument;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.search.AddressTerm;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.DateTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.FromTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.MessageIDTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.RecipientTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SizeTerm;
import javax.mail.search.StringTerm;
import javax.mail.search.SubjectTerm;

class SearchSequence {
    private static String[] monthTable = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static Calendar cal = new GregorianCalendar();

    SearchSequence() {
    }

    static Argument generateSequence(SearchTerm term, String charset) throws SearchException, IOException {
        if (term instanceof AndTerm) {
            return SearchSequence.and((AndTerm)term, charset);
        }
        if (term instanceof OrTerm) {
            return SearchSequence.or((OrTerm)term, charset);
        }
        if (term instanceof NotTerm) {
            return SearchSequence.not((NotTerm)term, charset);
        }
        if (term instanceof HeaderTerm) {
            return SearchSequence.header((HeaderTerm)term, charset);
        }
        if (term instanceof FlagTerm) {
            return SearchSequence.flag((FlagTerm)term);
        }
        if (term instanceof FromTerm) {
            FromTerm fterm = (FromTerm)term;
            return SearchSequence.from(fterm.getAddress().toString(), charset);
        }
        if (term instanceof FromStringTerm) {
            FromStringTerm fterm = (FromStringTerm)term;
            return SearchSequence.from(fterm.getPattern(), charset);
        }
        if (term instanceof RecipientTerm) {
            RecipientTerm rterm = (RecipientTerm)term;
            return SearchSequence.recipient(rterm.getRecipientType(), rterm.getAddress().toString(), charset);
        }
        if (term instanceof RecipientStringTerm) {
            RecipientStringTerm rterm = (RecipientStringTerm)term;
            return SearchSequence.recipient(rterm.getRecipientType(), rterm.getPattern(), charset);
        }
        if (term instanceof SubjectTerm) {
            return SearchSequence.subject((SubjectTerm)term, charset);
        }
        if (term instanceof BodyTerm) {
            return SearchSequence.body((BodyTerm)term, charset);
        }
        if (term instanceof SizeTerm) {
            return SearchSequence.size((SizeTerm)term);
        }
        if (term instanceof SentDateTerm) {
            return SearchSequence.sentdate((SentDateTerm)term);
        }
        if (term instanceof ReceivedDateTerm) {
            return SearchSequence.receiveddate((ReceivedDateTerm)term);
        }
        if (term instanceof MessageIDTerm) {
            return SearchSequence.messageid((MessageIDTerm)term, charset);
        }
        throw new SearchException("Search too complex");
    }

    static boolean isAscii(SearchTerm term) {
        if (term instanceof AndTerm || term instanceof OrTerm) {
            SearchTerm[] terms = term instanceof AndTerm ? ((AndTerm)term).getTerms() : ((OrTerm)term).getTerms();
            for (int i = 0; i < terms.length; ++i) {
                if (SearchSequence.isAscii(terms[i])) continue;
                return false;
            }
        } else {
            if (term instanceof NotTerm) {
                return SearchSequence.isAscii(((NotTerm)term).getTerm());
            }
            if (term instanceof StringTerm) {
                return SearchSequence.isAscii(((StringTerm)term).getPattern());
            }
            if (term instanceof AddressTerm) {
                return SearchSequence.isAscii(((AddressTerm)term).getAddress().toString());
            }
        }
        return true;
    }

    private static boolean isAscii(String s) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            if (s.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private static Argument and(AndTerm term, String charset) throws SearchException, IOException {
        SearchTerm[] terms = term.getTerms();
        Argument result2 = SearchSequence.generateSequence(terms[0], charset);
        for (int i = 1; i < terms.length; ++i) {
            result2.append(SearchSequence.generateSequence(terms[i], charset));
        }
        return result2;
    }

    private static Argument or(OrTerm term, String charset) throws SearchException, IOException {
        SearchTerm[] terms = term.getTerms();
        if (terms.length > 2) {
            SearchTerm t2 = terms[0];
            for (int i = 1; i < terms.length; ++i) {
                t2 = new OrTerm(t2, terms[i]);
            }
            term = (OrTerm)t2;
            terms = term.getTerms();
        }
        Argument result2 = new Argument();
        result2.writeAtom("OR");
        if (terms[0] instanceof AndTerm || terms[0] instanceof FlagTerm) {
            result2.writeArgument(SearchSequence.generateSequence(terms[0], charset));
        } else {
            result2.append(SearchSequence.generateSequence(terms[0], charset));
        }
        if (terms[1] instanceof AndTerm || terms[1] instanceof FlagTerm) {
            result2.writeArgument(SearchSequence.generateSequence(terms[1], charset));
        } else {
            result2.append(SearchSequence.generateSequence(terms[1], charset));
        }
        return result2;
    }

    private static Argument not(NotTerm term, String charset) throws SearchException, IOException {
        Argument result2 = new Argument();
        result2.writeAtom("NOT");
        SearchTerm nterm = term.getTerm();
        if (nterm instanceof AndTerm || nterm instanceof FlagTerm) {
            result2.writeArgument(SearchSequence.generateSequence(nterm, charset));
        } else {
            result2.append(SearchSequence.generateSequence(nterm, charset));
        }
        return result2;
    }

    private static Argument header(HeaderTerm term, String charset) throws SearchException, IOException {
        Argument result2 = new Argument();
        result2.writeAtom("HEADER");
        result2.writeString(term.getHeaderName());
        result2.writeString(term.getPattern(), charset);
        return result2;
    }

    private static Argument messageid(MessageIDTerm term, String charset) throws SearchException, IOException {
        Argument result2 = new Argument();
        result2.writeAtom("HEADER");
        result2.writeString("Message-ID");
        result2.writeString(term.getPattern(), charset);
        return result2;
    }

    private static Argument flag(FlagTerm term) throws SearchException {
        int i;
        boolean set = term.getTestSet();
        Argument result2 = new Argument();
        Flags flags = term.getFlags();
        Flags.Flag[] sf = flags.getSystemFlags();
        String[] uf = flags.getUserFlags();
        if (sf.length == 0 && uf.length == 0) {
            throw new SearchException("Invalid FlagTerm");
        }
        for (i = 0; i < sf.length; ++i) {
            if (sf[i] == Flags.Flag.DELETED) {
                result2.writeAtom(set ? "DELETED" : "UNDELETED");
                continue;
            }
            if (sf[i] == Flags.Flag.ANSWERED) {
                result2.writeAtom(set ? "ANSWERED" : "UNANSWERED");
                continue;
            }
            if (sf[i] == Flags.Flag.DRAFT) {
                result2.writeAtom(set ? "DRAFT" : "UNDRAFT");
                continue;
            }
            if (sf[i] == Flags.Flag.FLAGGED) {
                result2.writeAtom(set ? "FLAGGED" : "UNFLAGGED");
                continue;
            }
            if (sf[i] == Flags.Flag.RECENT) {
                result2.writeAtom(set ? "RECENT" : "OLD");
                continue;
            }
            if (sf[i] != Flags.Flag.SEEN) continue;
            result2.writeAtom(set ? "SEEN" : "UNSEEN");
        }
        for (i = 0; i < uf.length; ++i) {
            result2.writeAtom(set ? "KEYWORD" : "UNKEYWORD");
            result2.writeAtom(uf[i]);
        }
        return result2;
    }

    private static Argument from(String address, String charset) throws SearchException, IOException {
        Argument result2 = new Argument();
        result2.writeAtom("FROM");
        result2.writeString(address, charset);
        return result2;
    }

    private static Argument recipient(Message.RecipientType type, String address, String charset) throws SearchException, IOException {
        Argument result2 = new Argument();
        if (type == Message.RecipientType.TO) {
            result2.writeAtom("TO");
        } else if (type == Message.RecipientType.CC) {
            result2.writeAtom("CC");
        } else if (type == Message.RecipientType.BCC) {
            result2.writeAtom("BCC");
        } else {
            throw new SearchException("Illegal Recipient type");
        }
        result2.writeString(address, charset);
        return result2;
    }

    private static Argument subject(SubjectTerm term, String charset) throws SearchException, IOException {
        Argument result2 = new Argument();
        result2.writeAtom("SUBJECT");
        result2.writeString(term.getPattern(), charset);
        return result2;
    }

    private static Argument body(BodyTerm term, String charset) throws SearchException, IOException {
        Argument result2 = new Argument();
        result2.writeAtom("BODY");
        result2.writeString(term.getPattern(), charset);
        return result2;
    }

    private static Argument size(SizeTerm term) throws SearchException {
        Argument result2 = new Argument();
        switch (term.getComparison()) {
            case 5: {
                result2.writeAtom("LARGER");
                break;
            }
            case 2: {
                result2.writeAtom("SMALLER");
                break;
            }
            default: {
                throw new SearchException("Cannot handle Comparison");
            }
        }
        result2.writeNumber(term.getNumber());
        return result2;
    }

    private static String toIMAPDate(Date date) {
        StringBuffer s = new StringBuffer();
        cal.setTime(date);
        s.append(cal.get(5)).append("-");
        s.append(monthTable[cal.get(2)]).append('-');
        s.append(cal.get(1));
        return s.toString();
    }

    private static Argument sentdate(DateTerm term) throws SearchException {
        Argument result2 = new Argument();
        String date = SearchSequence.toIMAPDate(term.getDate());
        switch (term.getComparison()) {
            case 5: {
                result2.writeAtom("SENTSINCE " + date);
                break;
            }
            case 3: {
                result2.writeAtom("SENTON " + date);
                break;
            }
            case 2: {
                result2.writeAtom("SENTBEFORE " + date);
                break;
            }
            case 6: {
                result2.writeAtom("OR SENTSINCE " + date + " SENTON " + date);
                break;
            }
            case 1: {
                result2.writeAtom("OR SENTBEFORE " + date + " SENTON " + date);
                break;
            }
            case 4: {
                result2.writeAtom("NOT SENTON " + date);
                break;
            }
            default: {
                throw new SearchException("Cannot handle Date Comparison");
            }
        }
        return result2;
    }

    private static Argument receiveddate(DateTerm term) throws SearchException {
        Argument result2 = new Argument();
        String date = SearchSequence.toIMAPDate(term.getDate());
        switch (term.getComparison()) {
            case 5: {
                result2.writeAtom("SINCE " + date);
                break;
            }
            case 3: {
                result2.writeAtom("ON " + date);
                break;
            }
            case 2: {
                result2.writeAtom("BEFORE " + date);
                break;
            }
            case 6: {
                result2.writeAtom("OR SINCE " + date + " ON " + date);
                break;
            }
            case 1: {
                result2.writeAtom("OR BEFORE " + date + " ON " + date);
                break;
            }
            case 4: {
                result2.writeAtom("NOT ON " + date);
                break;
            }
            default: {
                throw new SearchException("Cannot handle Date Comparison");
            }
        }
        return result2;
    }
}

