/*
 * Decompiled with CFR 0.152.
 */
package demo;

import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.StructureAlignment;
import org.biojava.bio.structure.align.StructureAlignmentFactory;
import org.biojava.bio.structure.align.fatcat.FatCatRigid;
import org.biojava.bio.structure.align.fatcat.calc.FatCatParameters;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.align.util.AtomCache;

public class DemoFATCAT {
    public static void main(String[] args) {
        String name1 = "1cdg.A";
        String name2 = "1tim.B";
        AtomCache cache = new AtomCache();
        Structure structure1 = null;
        Structure structure2 = null;
        try {
            StructureAlignment algorithm = StructureAlignmentFactory.getAlgorithm(FatCatRigid.algorithmName);
            structure1 = cache.getStructure(name1);
            structure2 = cache.getStructure(name2);
            Atom[] ca1 = StructureTools.getAtomCAArray(structure1);
            Atom[] ca2 = StructureTools.getAtomCAArray(structure2);
            FatCatParameters params = new FatCatParameters();
            AFPChain afpChain = algorithm.align(ca1, ca2, params);
            afpChain.setName1(name1);
            afpChain.setName2(name2);
            System.out.println(afpChain.toFatcat(ca1, ca2));
            System.out.println(afpChain.toRotMat());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

