/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.util.List;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.StructureAlignment;
import org.biojava.bio.structure.align.StructureAlignmentFactory;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.align.model.AfpChainWriter;
import org.biojava.bio.structure.align.util.AFPChainScorer;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.scop.ScopCategory;
import org.biojava.bio.structure.scop.ScopDatabase;
import org.biojava.bio.structure.scop.ScopDescription;
import org.biojava.bio.structure.scop.ScopDomain;
import org.biojava.bio.structure.scop.ScopFactory;
import org.biojava.bio.structure.scop.ScopInstallation;
import org.biojava.bio.structure.scop.ScopNode;

public class DemoSCOP {
    public static void main(String[] args) {
        DemoSCOP demo = new DemoSCOP();
        ScopInstallation scop = new ScopInstallation();
        ScopFactory.setScopDatabase(scop);
        demo.getCategories();
        demo.printDomainsForPDB();
        demo.traverseHierarchy();
        demo.alignSuperfamily();
    }

    public void traverseHierarchy() {
        String pdbId = "4HHB";
        ScopDatabase scop = ScopFactory.getSCOP();
        List<ScopDomain> domains = scop.getDomainsForPDB(pdbId);
        ScopNode node = scop.getScopNode(domains.get(0).getSunid());
        while (node != null) {
            System.out.println("This node: sunid:" + node.getSunid());
            System.out.println(scop.getScopDescriptionBySunid(node.getSunid()));
            node = scop.getScopNode(node.getParentSunid());
        }
    }

    public void getCategories() {
        ScopDatabase scop = ScopFactory.getSCOP();
        List<ScopDescription> superfams = scop.getByCategory(ScopCategory.Superfamily);
        System.out.println("Total nr. of superfamilies:" + superfams.size());
        List<ScopDescription> folds = scop.getByCategory(ScopCategory.Fold);
        System.out.println("Total nr. of folds:" + folds.size());
    }

    public void alignSuperfamily() {
        ScopDatabase scop = ScopFactory.getSCOP();
        List<ScopDescription> superfams = scop.getByCategory(ScopCategory.Superfamily);
        System.out.println("Total nr. of superfamilies:" + superfams.size());
        AtomCache cache = new AtomCache();
        FileParsingParameters fileparams = new FileParsingParameters();
        fileparams.setAlignSeqRes(false);
        fileparams.setLoadChemCompInfo(true);
        fileparams.setParseSecStruc(false);
        cache.setFileParsingParams(fileparams);
        ScopDescription superfam1 = superfams.get(0);
        System.out.println("First superfamily: " + superfam1);
        ScopNode node = scop.getScopNode(superfam1.getSunID());
        System.out.println("scopNode for first superfamily:" + node);
        List<ScopDomain> doms4superfam1 = scop.getScopDomainsBySunid(superfam1.getSunID());
        ScopDomain dom1 = doms4superfam1.get(0);
        for (int i = 1; i < doms4superfam1.size(); ++i) {
            ScopDomain dom2 = doms4superfam1.get(i);
            try {
                Structure s1 = cache.getStructureForDomain(dom1);
                Structure s2 = cache.getStructureForDomain(dom2);
                Atom[] ca1 = StructureTools.getAtomCAArray(s1);
                Atom[] ca2 = StructureTools.getAtomCAArray(s2);
                StructureAlignment ce = StructureAlignmentFactory.getAlgorithm("jCE");
                AFPChain afpChain = ce.align(ca1, ca2);
                System.out.println(dom1.getScopId() + " vs. " + dom2.getScopId() + " :" + afpChain.getProbability());
                double tmScore = AFPChainScorer.getTMScore(afpChain, ca1, ca2);
                afpChain.setTMScore(tmScore);
                System.out.println(AfpChainWriter.toScoresList(afpChain));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void printDomainsForPDB() {
        String pdbId = "4HHB";
        ScopDatabase scop = ScopFactory.getSCOP();
        List<ScopDomain> domains = scop.getDomainsForPDB(pdbId);
        System.out.println(domains);
    }
}

