/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.CollectionAndSequence;
import freemarker.core.DateBuiltins;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.Interpret;
import freemarker.core.InvalidReferenceException;
import freemarker.core.Macro;
import freemarker.core.NewBI;
import freemarker.core.NodeBuiltins;
import freemarker.core.NumericalBuiltins;
import freemarker.core.ParentheticalExpression;
import freemarker.core.ParseException;
import freemarker.core.SequenceBuiltins;
import freemarker.core.StringArraySequence;
import freemarker.core.StringBuiltins;
import freemarker.core.Token;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.TemplateTransformModel;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.StringUtil;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

abstract class BuiltIn
extends Expression
implements Cloneable {
    Expression target;
    String key;
    static final HashMap builtins = new HashMap();

    BuiltIn() {
    }

    private static Object instantiate(String className) throws Exception {
        return ClassUtil.forName(className).newInstance();
    }

    static BuiltIn newBuiltIn(Expression target, String key, Token tok, String templateName) throws ParseException {
        BuiltIn bi = (BuiltIn)builtins.get(key);
        if (bi == null) {
            String locationInfo = "Error on line " + tok.beginLine + ", column " + tok.beginColumn + ", in template " + templateName + "\n";
            StringBuffer buf = new StringBuffer("Found " + key + ", expecting one of: ");
            Iterator it = builtins.keySet().iterator();
            while (it.hasNext()) {
                if (it.hasNext()) {
                    buf.append(" ");
                } else {
                    buf.append(" or ");
                }
                buf.append(it.next());
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            throw new ParseException(locationInfo + buf, target);
        }
        try {
            bi = (BuiltIn)bi.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        bi.target = target;
        bi.key = key;
        return bi;
    }

    public String getCanonicalForm() {
        return this.target.getCanonicalForm() + "?" + this.key;
    }

    boolean isLiteral() {
        return false;
    }

    Expression _deepClone(String name, Expression subst) {
        try {
            BuiltIn clone2 = (BuiltIn)this.clone();
            clone2.target = this.target.deepClone(name, subst);
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    static {
        builtins.put("ancestors", new NodeBuiltins.ancestorsBI());
        builtins.put("byte", new NumericalBuiltins.byteBI());
        builtins.put("c", new NumericalBuiltins.cBI());
        builtins.put("cap_first", new StringBuiltins.cap_firstBI());
        builtins.put("capitalize", new StringBuiltins.capitalizeBI());
        builtins.put("ceiling", new NumericalBuiltins.ceilingBI());
        builtins.put("children", new NodeBuiltins.childrenBI());
        builtins.put("chop_linebreak", new StringBuiltins.chop_linebreakBI());
        builtins.put("contains", new containsBI());
        builtins.put("date", new dateBI(2));
        builtins.put("datetime", new dateBI(3));
        builtins.put("default", new defaultBI());
        builtins.put("double", new NumericalBuiltins.doubleBI());
        builtins.put("ends_with", new ends_withBI());
        builtins.put("eval", new StringBuiltins.evalBI());
        builtins.put("exists", new existsBI());
        builtins.put("first", new SequenceBuiltins.firstBI());
        builtins.put("float", new NumericalBuiltins.floatBI());
        builtins.put("floor", new NumericalBuiltins.floorBI());
        builtins.put("chunk", new SequenceBuiltins.chunkBI());
        builtins.put("has_content", new has_contentBI());
        builtins.put("html", new htmlBI());
        builtins.put("if_exists", new if_existsBI());
        builtins.put("index_of", new index_ofBI());
        builtins.put("int", new NumericalBuiltins.intBI());
        builtins.put("interpret", new Interpret());
        builtins.put("is_boolean", new is_booleanBI());
        builtins.put("is_collection", new is_collectionBI());
        builtins.put("is_date", new is_dateBI());
        builtins.put("is_directive", new is_directiveBI());
        builtins.put("is_enumerable", new is_enumerableBI());
        builtins.put("is_hash_ex", new is_hash_exBI());
        builtins.put("is_hash", new is_hashBI());
        builtins.put("is_indexable", new is_indexableBI());
        builtins.put("is_macro", new is_macroBI());
        builtins.put("is_method", new is_methodBI());
        builtins.put("is_node", new is_nodeBI());
        builtins.put("is_number", new is_numberBI());
        builtins.put("is_sequence", new is_sequenceBI());
        builtins.put("is_string", new is_stringBI());
        builtins.put("is_transform", new is_transformBI());
        builtins.put("iso_utc", new DateBuiltins.iso_tz_BI("iso_utc", true, 6, true));
        builtins.put("iso_utc_nz", new DateBuiltins.iso_tz_BI("iso_utc_nz", false, 6, true));
        builtins.put("iso_utc_ms", new DateBuiltins.iso_tz_BI("iso_utc_ms", true, 7, true));
        builtins.put("iso_utc_ms_nz", new DateBuiltins.iso_tz_BI("iso_utc_ms_nz", false, 7, true));
        builtins.put("iso_utc_m", new DateBuiltins.iso_tz_BI("iso_utc_m", true, 5, true));
        builtins.put("iso_utc_m_nz", new DateBuiltins.iso_tz_BI("iso_utc_m_nz", false, 5, true));
        builtins.put("iso_utc_h", new DateBuiltins.iso_tz_BI("iso_utc_h", true, 4, true));
        builtins.put("iso_utc_h_nz", new DateBuiltins.iso_tz_BI("iso_utc_h_nz", false, 4, true));
        builtins.put("iso_local", new DateBuiltins.iso_tz_BI("iso_local", true, 6, false));
        builtins.put("iso_local_nz", new DateBuiltins.iso_tz_BI("iso_local_nz", false, 6, false));
        builtins.put("iso_local_ms", new DateBuiltins.iso_tz_BI("iso_local_ms", true, 7, false));
        builtins.put("iso_local_ms_nz", new DateBuiltins.iso_tz_BI("iso_local_ms_nz", false, 7, false));
        builtins.put("iso_local_m", new DateBuiltins.iso_tz_BI("iso_local_m", true, 5, false));
        builtins.put("iso_local_m_nz", new DateBuiltins.iso_tz_BI("iso_local_m_nz", false, 5, false));
        builtins.put("iso_local_h", new DateBuiltins.iso_tz_BI("iso_local_h", true, 4, false));
        builtins.put("iso_local_h_nz", new DateBuiltins.iso_tz_BI("iso_local_h_nz", false, 4, false));
        builtins.put("iso", new DateBuiltins.iso_BI("iso", true, 6));
        builtins.put("iso_nz", new DateBuiltins.iso_BI("iso_nz", false, 6));
        builtins.put("iso_ms", new DateBuiltins.iso_BI("iso_ms", true, 7));
        builtins.put("iso_ms_nz", new DateBuiltins.iso_BI("iso_ms_nz", false, 7));
        builtins.put("iso_m", new DateBuiltins.iso_BI("iso_m", true, 5));
        builtins.put("iso_m_nz", new DateBuiltins.iso_BI("iso_m_nz", false, 5));
        builtins.put("iso_h", new DateBuiltins.iso_BI("iso_h", true, 4));
        builtins.put("iso_h_nz", new DateBuiltins.iso_BI("iso_h_nz", false, 4));
        builtins.put("j_string", new StringBuiltins.j_stringBI());
        builtins.put("js_string", new StringBuiltins.js_stringBI());
        builtins.put("json_string", new StringBuiltins.json_stringBI());
        builtins.put("keys", new keysBI());
        builtins.put("last_index_of", new last_index_ofBI());
        builtins.put("last", new SequenceBuiltins.lastBI());
        builtins.put("left_pad", new left_padBI());
        builtins.put("length", new lengthBI());
        builtins.put("long", new NumericalBuiltins.longBI());
        builtins.put("lower_case", new StringBuiltins.lower_caseBI());
        builtins.put("namespace", new namespaceBI());
        builtins.put("new", new NewBI());
        builtins.put("node_name", new NodeBuiltins.node_nameBI());
        builtins.put("node_namespace", new NodeBuiltins.node_namespaceBI());
        builtins.put("node_type", new NodeBuiltins.node_typeBI());
        builtins.put("number", new StringBuiltins.numberBI());
        builtins.put("number_to_date", new NumericalBuiltins.number_to_dateBI(2));
        builtins.put("number_to_time", new NumericalBuiltins.number_to_dateBI(1));
        builtins.put("number_to_datetime", new NumericalBuiltins.number_to_dateBI(3));
        builtins.put("parent", new NodeBuiltins.parentBI());
        builtins.put("replace", new replaceBI());
        builtins.put("reverse", new SequenceBuiltins.reverseBI());
        builtins.put("right_pad", new right_padBI());
        builtins.put("root", new NodeBuiltins.rootBI());
        builtins.put("round", new NumericalBuiltins.roundBI());
        builtins.put("rtf", new rtfBI());
        builtins.put("seq_contains", new SequenceBuiltins.seq_containsBI());
        builtins.put("seq_index_of", new SequenceBuiltins.seq_index_ofBI(1));
        builtins.put("seq_last_index_of", new SequenceBuiltins.seq_index_ofBI(-1));
        builtins.put("short", new NumericalBuiltins.shortBI());
        builtins.put("size", new sizeBI());
        builtins.put("sort_by", new SequenceBuiltins.sort_byBI());
        builtins.put("sort", new SequenceBuiltins.sortBI());
        builtins.put("split", new splitBI());
        builtins.put("starts_with", new starts_withBI());
        builtins.put("string", new stringBI());
        builtins.put("substring", new StringBuiltins.substringBI());
        builtins.put("time", new dateBI(1));
        builtins.put("trim", new trimBI());
        builtins.put("uncap_first", new StringBuiltins.uncap_firstBI());
        builtins.put("upper_case", new StringBuiltins.upper_caseBI());
        builtins.put("url", new urlBI());
        builtins.put("values", new valuesBI());
        builtins.put("web_safe", builtins.get("html"));
        builtins.put("word_list", new StringBuiltins.word_listBI());
        builtins.put("xhtml", new xhtmlBI());
        builtins.put("xml", new xmlBI());
        try {
            Class.forName("java.util.regex.Pattern");
            builtins.put("matches", BuiltIn.instantiate("freemarker.core.RegexBuiltins$matchesBI"));
            builtins.put("groups", BuiltIn.instantiate("freemarker.core.RegexBuiltins$groupsBI"));
            builtins.put("replace", BuiltIn.instantiate("freemarker.core.RegexBuiltins$replace_reBI"));
            builtins.put("split", BuiltIn.instantiate("freemarker.core.RegexBuiltins$split_reBI"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class right_padBI
    extends BuiltIn {
        right_padBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw right_padBI.invalidTypeException(model, this.target, env, "string");
        }

        private static class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                int ln = args.size();
                if (ln == 0) {
                    throw new TemplateModelException("?right_pad(...) expects at least 1 argument.");
                }
                if (ln > 2) {
                    throw new TemplateModelException("?right_pad(...) expects at most 2 arguments.");
                }
                Object obj = args.get(0);
                if (!(obj instanceof TemplateNumberModel)) {
                    throw new TemplateModelException("?right_pad(...) expects a number as its 1st argument.");
                }
                int width = ((TemplateNumberModel)obj).getAsNumber().intValue();
                if (ln > 1) {
                    obj = args.get(1);
                    if (!(obj instanceof TemplateScalarModel)) {
                        throw new TemplateModelException("?right_pad(...) expects a string as its 2nd argument.");
                    }
                    String filling = ((TemplateScalarModel)obj).getAsString();
                    try {
                        return new SimpleScalar(StringUtil.rightPad(this.s, width, filling));
                    }
                    catch (IllegalArgumentException e) {
                        if (filling.length() == 0) {
                            throw new TemplateModelException("The 2nd argument of ?right_pad(...) can't be a 0 length string.");
                        }
                        throw new TemplateModelException("Error while executing the ?right_pad(...) built-in.", e);
                    }
                }
                return new SimpleScalar(StringUtil.rightPad(this.s, width));
            }
        }
    }

    static class left_padBI
    extends BuiltIn {
        left_padBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw left_padBI.invalidTypeException(model, this.target, env, "string");
        }

        private static class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                int ln = args.size();
                if (ln == 0) {
                    throw new TemplateModelException("?left_pad(...) expects at least 1 argument.");
                }
                if (ln > 2) {
                    throw new TemplateModelException("?left_pad(...) expects at most 2 arguments.");
                }
                Object obj = args.get(0);
                if (!(obj instanceof TemplateNumberModel)) {
                    throw new TemplateModelException("?left_pad(...) expects a number as its 1st argument.");
                }
                int width = ((TemplateNumberModel)obj).getAsNumber().intValue();
                if (ln > 1) {
                    obj = args.get(1);
                    if (!(obj instanceof TemplateScalarModel)) {
                        throw new TemplateModelException("?left_pad(...) expects a string as its 2nd argument.");
                    }
                    String filling = ((TemplateScalarModel)obj).getAsString();
                    try {
                        return new SimpleScalar(StringUtil.leftPad(this.s, width, filling));
                    }
                    catch (IllegalArgumentException e) {
                        if (filling.length() == 0) {
                            throw new TemplateModelException("The 2nd argument of ?left_pad(...) can't be a 0 length string.");
                        }
                        throw new TemplateModelException("Error while executing the ?left_pad(...) built-in.", e);
                    }
                }
                return new SimpleScalar(StringUtil.leftPad(this.s, width));
            }
        }
    }

    static class splitBI
    extends BuiltIn {
        splitBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw splitBI.invalidTypeException(model, this.target, env, "string");
        }

        private static class BIMethod
        implements TemplateMethodModel {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                boolean caseInsensitive;
                int numArgs = args.size();
                if (numArgs != 1 && numArgs != 2) {
                    throw new TemplateModelException("?split(...) expects 1 or 2 arguments.");
                }
                String splitString = (String)args.get(0);
                String flags = numArgs == 2 ? (String)args.get(1) : "";
                boolean bl = caseInsensitive = flags.indexOf(105) >= 0;
                if (flags.indexOf(114) >= 0) {
                    throw new TemplateModelException("regular expression classes not available");
                }
                return new StringArraySequence(StringUtil.split(this.s, splitString, caseInsensitive));
            }
        }
    }

    static class replaceBI
    extends BuiltIn {
        replaceBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw replaceBI.invalidTypeException(model, this.target, env, "string");
        }

        private static class BIMethod
        implements TemplateMethodModel {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                boolean firstOnly;
                int numArgs = args.size();
                if (numArgs < 2 || numArgs > 3) {
                    throw new TemplateModelException("?replace(...) needs 2 or 3 arguments.");
                }
                String first = (String)args.get(0);
                String second = (String)args.get(1);
                String flags = numArgs > 2 ? (String)args.get(2) : "";
                boolean caseInsensitive = flags.indexOf(105) >= 0;
                boolean bl = firstOnly = flags.indexOf(102) >= 0;
                if (flags.indexOf(114) >= 0) {
                    throw new TemplateModelException("The regular expression classes are not available.");
                }
                return new SimpleScalar(StringUtil.replace(this.s, first, second, caseInsensitive, firstOnly));
            }
        }
    }

    static class ends_withBI
    extends BuiltIn {
        ends_withBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw ends_withBI.invalidTypeException(model, this.target, env, "string");
        }

        private static class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                if (args.size() != 1) {
                    throw new TemplateModelException("?ends_with(...) expects exactly 1 argument.");
                }
                Object obj = args.get(0);
                if (!(obj instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?ends_with(...) expects a string argument");
                }
                String sub = ((TemplateScalarModel)obj).getAsString();
                return this.s.endsWith(sub) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
    }

    static class starts_withBI
    extends BuiltIn {
        starts_withBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw starts_withBI.invalidTypeException(model, this.target, env, "string");
        }

        private static class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                if (args.size() != 1) {
                    throw new TemplateModelException("?starts_with(...) expects exactly 1 argument.");
                }
                Object obj = args.get(0);
                if (!(obj instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?starts_with(...) expects a string argument");
                }
                String sub = ((TemplateScalarModel)obj).getAsString();
                return this.s.startsWith(sub) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
    }

    static class last_index_ofBI
    extends BuiltIn {
        last_index_ofBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw last_index_ofBI.invalidTypeException(model, this.target, env, "string");
        }

        private static class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                int ln = args.size();
                if (ln == 0) {
                    throw new TemplateModelException("?last_index_of(...) expects at least one argument.");
                }
                if (ln > 2) {
                    throw new TemplateModelException("?last_index_of(...) expects at most two arguments.");
                }
                Object obj = args.get(0);
                if (!(obj instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?last_index_of(...) expects a string as its first argument.");
                }
                String sub = ((TemplateScalarModel)obj).getAsString();
                if (ln > 1) {
                    obj = args.get(1);
                    if (!(obj instanceof TemplateNumberModel)) {
                        throw new TemplateModelException("?last_index_of(...) expects a number as its second argument.");
                    }
                    int fidx = ((TemplateNumberModel)obj).getAsNumber().intValue();
                    return new SimpleNumber(this.s.lastIndexOf(sub, fidx));
                }
                return new SimpleNumber(this.s.lastIndexOf(sub));
            }
        }
    }

    static class index_ofBI
    extends BuiltIn {
        index_ofBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw index_ofBI.invalidTypeException(model, this.target, env, "string");
        }

        private static class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                int fidx;
                int ln = args.size();
                if (ln == 0) {
                    throw new TemplateModelException("?index_of(...) expects at least one argument.");
                }
                if (ln > 2) {
                    throw new TemplateModelException("?index_of(...) expects at most two arguments.");
                }
                Object obj = args.get(0);
                if (!(obj instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?index_of(...) expects a string as its first argument.");
                }
                String sub = ((TemplateScalarModel)obj).getAsString();
                if (ln > 1) {
                    obj = args.get(1);
                    if (!(obj instanceof TemplateNumberModel)) {
                        throw new TemplateModelException("?index_of(...) expects a number as its second argument.");
                    }
                    fidx = ((TemplateNumberModel)obj).getAsNumber().intValue();
                } else {
                    fidx = 0;
                }
                return new SimpleNumber(this.s.indexOf(sub, fidx));
            }
        }
    }

    static class containsBI
    extends BuiltIn {
        containsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw containsBI.invalidTypeException(model, this.target, env, "string");
        }

        private static class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                int ln = args.size();
                if (ln != 1) {
                    throw new TemplateModelException("?contains(...) expects one argument.");
                }
                Object obj = args.get(0);
                if (!(obj instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?contains(...) expects a string as its first argument.");
                }
                String sub = ((TemplateScalarModel)obj).getAsString();
                return this.s.indexOf(sub) != -1 ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
    }

    static class defaultBI
    extends BuiltIn {
        private static final TemplateMethodModelEx FIRST_NON_NULL_METHOD = new TemplateMethodModelEx(){

            public Object exec(List args) throws TemplateModelException {
                if (args.isEmpty()) {
                    throw new TemplateModelException("?default(arg) expects at least one argument.");
                }
                TemplateModel result2 = null;
                for (int i = 0; i < args.size() && (result2 = (TemplateModel)args.get(i)) == null; ++i) {
                }
                return result2;
            }
        };

        defaultBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            try {
                TemplateModel model = this.target.getAsTemplateModel(env);
                return model == null ? FIRST_NON_NULL_METHOD : new ConstantMethod(model);
            }
            catch (InvalidReferenceException ire) {
                if (this.target instanceof ParentheticalExpression) {
                    return FIRST_NON_NULL_METHOD;
                }
                throw ire;
            }
        }

        private static class ConstantMethod
        implements TemplateMethodModelEx {
            private final TemplateModel constant;

            ConstantMethod(TemplateModel constant) {
                this.constant = constant;
            }

            public Object exec(List args) {
                return this.constant;
            }
        }
    }

    static class namespaceBI
    extends BuiltIn {
        namespaceBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            if (!(tm instanceof Macro)) {
                namespaceBI.invalidTypeException(tm, this.target, env, "macro");
            }
            return env.getMacroNamespace((Macro)tm);
        }
    }

    static class is_directiveBI
    extends BuiltIn {
        is_directiveBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_directiveBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateTransformModel || tm instanceof Macro || tm instanceof TemplateDirectiveModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_enumerableBI
    extends BuiltIn {
        is_enumerableBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_enumerableBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateSequenceModel || tm instanceof TemplateCollectionModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_indexableBI
    extends BuiltIn {
        is_indexableBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_indexableBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateSequenceModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_collectionBI
    extends BuiltIn {
        is_collectionBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_collectionBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateCollectionModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_sequenceBI
    extends BuiltIn {
        is_sequenceBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_sequenceBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateSequenceModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_hash_exBI
    extends BuiltIn {
        is_hash_exBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_hash_exBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateHashModelEx ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_hashBI
    extends BuiltIn {
        is_hashBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_hashBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateHashModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_transformBI
    extends BuiltIn {
        is_transformBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_transformBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateTransformModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_macroBI
    extends BuiltIn {
        is_macroBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_macroBI.assertNonNull(tm, this.target, env);
            return tm instanceof Macro ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_methodBI
    extends BuiltIn {
        is_methodBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_methodBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateMethodModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_dateBI
    extends BuiltIn {
        is_dateBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_dateBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateDateModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_booleanBI
    extends BuiltIn {
        is_booleanBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_booleanBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateBooleanModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_nodeBI
    extends BuiltIn {
        is_nodeBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_nodeBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateNodeModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_numberBI
    extends BuiltIn {
        is_numberBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_numberBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateNumberModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_stringBI
    extends BuiltIn {
        is_stringBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_stringBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateScalarModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class if_existsBI
    extends BuiltIn {
        if_existsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            try {
                TemplateModel model = this.target.getAsTemplateModel(env);
                return model == null ? TemplateModel.NOTHING : model;
            }
            catch (InvalidReferenceException ire) {
                if (this.target instanceof ParentheticalExpression) {
                    return TemplateModel.NOTHING;
                }
                throw ire;
            }
        }
    }

    static class has_contentBI
    extends BuiltIn {
        has_contentBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            try {
                TemplateModel model = this.target.getAsTemplateModel(env);
                return Expression.isEmpty(model) ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
            }
            catch (InvalidReferenceException ire) {
                if (this.target instanceof ParentheticalExpression) {
                    return TemplateBooleanModel.FALSE;
                }
                throw ire;
            }
        }

        boolean isTrue(Environment env) throws TemplateException {
            return this._getAsTemplateModel(env) == TemplateBooleanModel.TRUE;
        }
    }

    static class existsBI
    extends BuiltIn {
        existsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            try {
                TemplateModel model = this.target.getAsTemplateModel(env);
                return model == null ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
            }
            catch (InvalidReferenceException ire) {
                if (this.target instanceof ParentheticalExpression) {
                    return TemplateBooleanModel.FALSE;
                }
                throw ire;
            }
        }

        boolean isTrue(Environment env) throws TemplateException {
            return this._getAsTemplateModel(env) == TemplateBooleanModel.TRUE;
        }
    }

    static class sizeBI
    extends BuiltIn {
        sizeBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateSequenceModel) {
                int size2 = ((TemplateSequenceModel)model).size();
                return new SimpleNumber(size2);
            }
            if (model instanceof TemplateHashModelEx) {
                int size3 = ((TemplateHashModelEx)model).size();
                return new SimpleNumber(size3);
            }
            throw sizeBI.invalidTypeException(model, this.target, env, "extended-hash or sequence");
        }
    }

    static class valuesBI
    extends BuiltIn {
        valuesBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateHashModelEx) {
                TemplateCollectionModel values2 = ((TemplateHashModelEx)model).values();
                valuesBI.assertNonNull(values2, this, env);
                if (!(values2 instanceof TemplateSequenceModel)) {
                    values2 = new CollectionAndSequence(values2);
                }
                return values2;
            }
            throw valuesBI.invalidTypeException(model, this.target, env, "extended hash");
        }
    }

    static class keysBI
    extends BuiltIn {
        keysBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateHashModelEx) {
                TemplateCollectionModel keys = ((TemplateHashModelEx)model).keys();
                keysBI.assertNonNull(keys, this, env);
                if (!(keys instanceof TemplateSequenceModel)) {
                    keys = new CollectionAndSequence(keys);
                }
                return keys;
            }
            throw keysBI.invalidTypeException(model, this.target, env, "extended hash");
        }
    }

    static class urlBI
    extends StringBuiltins.StringBuiltIn {
        urlBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new urlBIResult(s, env);
        }

        static class urlBIResult
        implements TemplateScalarModel,
        TemplateMethodModel {
            private final String target;
            private final Environment env;
            private String cachedResult;

            private urlBIResult(String target, Environment env) {
                this.target = target;
                this.env = env;
            }

            public String getAsString() throws TemplateModelException {
                if (this.cachedResult == null) {
                    String cs = this.env.getEffectiveURLEscapingCharset();
                    if (cs == null) {
                        throw new TemplateModelException("To do URL encoding, the framework that encloses FreeMarker must specify the output encoding or the URL encoding charset, so ask the programmers to fix it. Or, as a last chance, you can set the url_encoding_charset setting in the template, e.g. <#setting url_escaping_charset='ISO-8859-1'>, or give the charset explicitly to the buit-in, e.g. foo?url('ISO-8859-1').");
                    }
                    try {
                        this.cachedResult = StringUtil.URLEnc(this.target, cs);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new TemplateModelException("Failed to execute URL encoding.", e);
                    }
                }
                return this.cachedResult;
            }

            public Object exec(List args) throws TemplateModelException {
                if (args.size() != 1) {
                    throw new TemplateModelException("The \"url\" built-in needs exactly 1 parameter, the charset.");
                }
                try {
                    return new SimpleScalar(StringUtil.URLEnc(this.target, (String)args.get(0)));
                }
                catch (UnsupportedEncodingException e) {
                    throw new TemplateModelException("Failed to execute URL encoding.", e);
                }
            }
        }
    }

    static class rtfBI
    extends StringBuiltins.StringBuiltIn {
        rtfBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.RTFEnc(s));
        }
    }

    static class xhtmlBI
    extends StringBuiltins.StringBuiltIn {
        xhtmlBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.XHTMLEnc(s));
        }
    }

    static class xmlBI
    extends StringBuiltins.StringBuiltIn {
        xmlBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.XMLEnc(s));
        }
    }

    static class htmlBI
    extends StringBuiltins.StringBuiltIn {
        htmlBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.HTMLEnc(s));
        }
    }

    static class trimBI
    extends StringBuiltins.StringBuiltIn {
        trimBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(s.trim());
        }
    }

    static class stringBI
    extends BuiltIn {
        stringBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateNumberModel) {
                return new NumberFormatter(EvaluationUtil.getNumber((TemplateNumberModel)model, this.target, env), env);
            }
            if (model instanceof TemplateDateModel) {
                TemplateDateModel dm = (TemplateDateModel)model;
                int dateType = dm.getDateType();
                return new DateFormatter(EvaluationUtil.getDate(dm, this.target, env), dateType, env);
            }
            if (model instanceof SimpleScalar) {
                return model;
            }
            if (model instanceof TemplateBooleanModel) {
                return new BooleanFormatter((TemplateBooleanModel)model, env);
            }
            if (model instanceof TemplateScalarModel) {
                return new SimpleScalar(((TemplateScalarModel)model).getAsString());
            }
            throw stringBI.invalidTypeException(model, this.target, env, "number, date, or string");
        }

        private static class BooleanFormatter
        implements TemplateScalarModel,
        TemplateMethodModel {
            private final TemplateBooleanModel bool;
            private final Environment env;

            BooleanFormatter(TemplateBooleanModel bool2, Environment env) {
                this.bool = bool2;
                this.env = env;
            }

            public String getAsString() throws TemplateModelException {
                if (this.bool instanceof TemplateScalarModel) {
                    return ((TemplateScalarModel)((Object)this.bool)).getAsString();
                }
                return this.env.getBooleanFormat(this.bool.getAsBoolean());
            }

            public Object exec(List arguments) throws TemplateModelException {
                if (arguments.size() != 2) {
                    throw new TemplateModelException("boolean?string(...) requires exactly 2 arguments.");
                }
                return new SimpleScalar((String)arguments.get(this.bool.getAsBoolean() ? 0 : 1));
            }
        }

        private static class DateFormatter
        implements TemplateScalarModel,
        TemplateHashModel,
        TemplateMethodModel {
            private final Date date;
            private final int dateType;
            private final Environment env;
            private final DateFormat defaultFormat;
            private String cachedValue;

            DateFormatter(Date date, int dateType, Environment env) throws TemplateModelException {
                this.date = date;
                this.dateType = dateType;
                this.env = env;
                this.defaultFormat = env.getDateFormatObject(dateType);
            }

            public String getAsString() throws TemplateModelException {
                if (this.dateType == 0) {
                    throw new TemplateModelException("Can't convert the date to string, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(format) built-in with this date.");
                }
                if (this.cachedValue == null) {
                    this.cachedValue = this.defaultFormat.format(this.date);
                }
                return this.cachedValue;
            }

            public TemplateModel get(String key) throws TemplateModelException {
                return new SimpleScalar(this.env.getDateFormatObject(this.dateType, key).format(this.date));
            }

            public Object exec(List arguments) throws TemplateModelException {
                if (arguments.size() != 1) {
                    throw new TemplateModelException("date?string(...) requires exactly 1 argument.");
                }
                return this.get((String)arguments.get(0));
            }

            public boolean isEmpty() {
                return false;
            }
        }

        private static class NumberFormatter
        implements TemplateScalarModel,
        TemplateHashModel,
        TemplateMethodModel {
            private final Number number;
            private final Environment env;
            private final NumberFormat defaultFormat;
            private String cachedValue;

            NumberFormatter(Number number2, Environment env) {
                this.number = number2;
                this.env = env;
                this.defaultFormat = env.getNumberFormatObject(env.getNumberFormat());
            }

            public String getAsString() {
                if (this.cachedValue == null) {
                    this.cachedValue = this.defaultFormat.format(this.number);
                }
                return this.cachedValue;
            }

            public TemplateModel get(String key) {
                return new SimpleScalar(this.env.getNumberFormatObject(key).format(this.number));
            }

            public Object exec(List arguments) throws TemplateModelException {
                if (arguments.size() != 1) {
                    throw new TemplateModelException("number?string(...) requires exactly 1 argument.");
                }
                return this.get((String)arguments.get(0));
            }

            public boolean isEmpty() {
                return false;
            }
        }
    }

    static class dateBI
    extends BuiltIn {
        private final int dateType;

        dateBI(int dateType) {
            this.dateType = dateType;
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateDateModel) {
                TemplateDateModel dmodel = (TemplateDateModel)model;
                int dtype = dmodel.getDateType();
                if (this.dateType == dtype) {
                    return model;
                }
                if (dtype == 0 || dtype == 3) {
                    return new SimpleDate(dmodel.getAsDate(), this.dateType);
                }
                throw new TemplateException("Cannot convert " + TemplateDateModel.TYPE_NAMES.get(dtype) + " into " + TemplateDateModel.TYPE_NAMES.get(this.dateType), env);
            }
            String s = this.target.getStringValue(env);
            return new DateParser(s, env);
        }

        private class DateParser
        implements TemplateDateModel,
        TemplateMethodModel,
        TemplateHashModel {
            private final String text;
            private final Environment env;
            private final DateFormat defaultFormat;
            private Date cachedValue;

            DateParser(String text2, Environment env) throws TemplateModelException {
                this.text = text2;
                this.env = env;
                this.defaultFormat = env.getDateFormatObject(dateBI.this.dateType);
            }

            public Date getAsDate() throws TemplateModelException {
                if (this.cachedValue == null) {
                    this.cachedValue = this.parse(this.defaultFormat);
                }
                return this.cachedValue;
            }

            public int getDateType() {
                return dateBI.this.dateType;
            }

            public TemplateModel get(String pattern) throws TemplateModelException {
                return new SimpleDate(this.parse(this.env.getDateFormatObject(dateBI.this.dateType, pattern)), dateBI.this.dateType);
            }

            public Object exec(List arguments) throws TemplateModelException {
                if (arguments.size() != 1) {
                    throw new TemplateModelException("string?" + dateBI.this.key + "(...) requires exactly 1 argument.");
                }
                return this.get((String)arguments.get(0));
            }

            public boolean isEmpty() {
                return false;
            }

            private Date parse(DateFormat df) throws TemplateModelException {
                try {
                    return df.parse(this.text);
                }
                catch (java.text.ParseException e) {
                    String pattern = null;
                    if (df instanceof SimpleDateFormat) {
                        pattern = ((SimpleDateFormat)df).toPattern();
                    }
                    String mess = "Error: " + dateBI.this.getStartLocation() + "\nThe string doesn't match the expected date/time format. " + "The string to parse was: " + StringUtil.jQuote(this.text) + (pattern != null ? ". The expected format was: " + StringUtil.jQuote(pattern) + "." : "");
                    throw new TemplateModelException(mess, e);
                }
            }
        }
    }

    static class lengthBI
    extends BuiltIn {
        lengthBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            return new SimpleNumber(this.target.getStringValue(env).length());
        }
    }
}

