/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.gui;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import javax.print.PrintException;
import javax.swing.JDialog;
import org.antlr.v4.gui.TreePostScriptGenerator;
import org.antlr.v4.gui.TreeTextProvider;
import org.antlr.v4.gui.TreeViewer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.misc.Utils;
import org.antlr.v4.runtime.tree.Tree;

public class Trees {
    public static Future<JDialog> inspect(Tree t2, List<String> ruleNames) {
        TreeViewer viewer = new TreeViewer(ruleNames, t2);
        return viewer.open();
    }

    public static Future<JDialog> inspect(Tree t2, Parser parser) {
        List<String> ruleNames = parser != null ? Arrays.asList(parser.getRuleNames()) : null;
        return Trees.inspect(t2, ruleNames);
    }

    public static void save(Tree t2, Parser parser, String fileName) throws IOException, PrintException {
        List<String> ruleNames = parser != null ? Arrays.asList(parser.getRuleNames()) : null;
        Trees.save(t2, ruleNames, fileName);
    }

    public static void save(Tree t2, Parser parser, String fileName, String fontName, int fontSize) throws IOException {
        List<String> ruleNames = parser != null ? Arrays.asList(parser.getRuleNames()) : null;
        Trees.save(t2, ruleNames, fileName, fontName, fontSize);
    }

    public static void save(Tree t2, List<String> ruleNames, String fileName) throws IOException, PrintException {
        Trees.writePS(t2, ruleNames, fileName);
    }

    public static void save(Tree t2, List<String> ruleNames, String fileName, String fontName, int fontSize) throws IOException {
        Trees.writePS(t2, ruleNames, fileName, fontName, fontSize);
    }

    public static String getPS(Tree t2, List<String> ruleNames, String fontName, int fontSize) {
        TreePostScriptGenerator psgen = new TreePostScriptGenerator(ruleNames, t2, fontName, fontSize);
        return psgen.getPS();
    }

    public static String getPS(Tree t2, List<String> ruleNames) {
        return Trees.getPS(t2, ruleNames, "Helvetica", 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePS(Tree t2, List<String> ruleNames, String fileName, String fontName, int fontSize) throws IOException {
        String ps = Trees.getPS(t2, ruleNames, fontName, fontSize);
        FileWriter f2 = new FileWriter(fileName);
        BufferedWriter bw = new BufferedWriter(f2);
        try {
            bw.write(ps);
        }
        finally {
            bw.close();
        }
    }

    public static void writePS(Tree t2, List<String> ruleNames, String fileName) throws IOException {
        Trees.writePS(t2, ruleNames, fileName, "Helvetica", 11);
    }

    public static String toStringTree(Tree t2, TreeTextProvider nodeTextProvider) {
        if (t2 == null) {
            return "null";
        }
        String s = Utils.escapeWhitespace(nodeTextProvider.getText(t2), false);
        if (t2.getChildCount() == 0) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        s = Utils.escapeWhitespace(nodeTextProvider.getText(t2), false);
        buf.append(s);
        buf.append(' ');
        for (int i = 0; i < t2.getChildCount(); ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(Trees.toStringTree(t2.getChild(i), nodeTextProvider));
        }
        buf.append(")");
        return buf.toString();
    }

    private Trees() {
    }
}

