/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import java.util.Arrays;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.MathArrays;

public class StepFunction
implements UnivariateFunction {
    private final double[] abscissa;
    private final double[] ordinate;

    public StepFunction(double[] x2, double[] y) throws NullArgumentException, NoDataException, DimensionMismatchException, NonMonotonicSequenceException {
        if (x2 == null || y == null) {
            throw new NullArgumentException();
        }
        if (x2.length == 0 || y.length == 0) {
            throw new NoDataException();
        }
        if (y.length != x2.length) {
            throw new DimensionMismatchException(y.length, x2.length);
        }
        MathArrays.checkOrder(x2);
        this.abscissa = MathArrays.copyOf(x2);
        this.ordinate = MathArrays.copyOf(y);
    }

    public double value(double x2) {
        int index2 = Arrays.binarySearch(this.abscissa, x2);
        double fx = 0.0;
        fx = index2 < -1 ? this.ordinate[-index2 - 2] : (index2 >= 0 ? this.ordinate[index2] : this.ordinate[0]);
        return fx;
    }
}

