/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.math.BigInteger;
import java.util.RandomAccess;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleCRTMath;
import org.apfloat.internal.DoubleModConstants;
import org.apfloat.internal.DoubleModMath;
import org.apfloat.internal.MessagePasser;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class DoubleCarryCRT
extends DoubleCRTMath {
    private static final long serialVersionUID = -3954870352092656433L;
    private static final DoubleModMath MATH_MOD_0 = new DoubleModMath();
    private static final DoubleModMath MATH_MOD_1 = new DoubleModMath();
    private static final DoubleModMath MATH_MOD_2 = new DoubleModMath();
    private static final double T0;
    private static final double T1;
    private static final double T2;
    private static final double[] M01;
    private static final double[] M02;
    private static final double[] M12;
    private static final double[] M012;
    private ParallelRunner parallelRunner;

    public DoubleCarryCRT(int radix) {
        super(radix);
    }

    public DataStorage carryCRT(final DataStorage resultMod0, final DataStorage resultMod1, final DataStorage resultMod2, final long resultSize) throws ApfloatRuntimeException {
        final long size2 = Math.min(resultSize + 2L, resultMod0.getSize());
        ApfloatContext ctx = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = ctx.getBuilderFactory().getDataStorageBuilder();
        final DataStorage dataStorage = dataStorageBuilder.createDataStorage(resultSize * 8L);
        dataStorage.setSize(resultSize);
        final MessagePasser<Long, double[]> messagePasser = new MessagePasser<Long, double[]>();
        if (size2 <= Integer.MAX_VALUE && this.parallelRunner != null && resultMod0 instanceof RandomAccess && resultMod1 instanceof RandomAccess && resultMod2 instanceof RandomAccess && dataStorage instanceof RandomAccess) {
            ParallelRunnable parallelRunnable = new ParallelRunnable(){

                public int getLength() {
                    return (int)size2;
                }

                public Runnable getRunnable(int offset, int length) {
                    return new CarryCRTRunnable(resultMod0, resultMod1, resultMod2, dataStorage, size2, resultSize, offset, length, messagePasser);
                }
            };
            this.parallelRunner.runParallel(parallelRunnable);
        } else {
            new CarryCRTRunnable(resultMod0, resultMod1, resultMod2, dataStorage, size2, resultSize, 0L, size2, messagePasser).run();
        }
        double[] carries = null;
        assert ((carries = messagePasser.getMessage(size2)) != null);
        assert (carries.length == 2);
        assert (carries[0] == 0.0);
        assert (carries[1] == 0.0);
        return dataStorage;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    private static DataStorage.Iterator arrayIterator(final double[] data2) {
        return new DataStorage.Iterator(){
            private int position;
            {
                this.position = data2.length - 1;
            }

            public boolean hasNext() {
                return true;
            }

            public void next() {
                --this.position;
            }

            public double getDouble() {
                assert (this.position >= 0);
                return data2[this.position];
            }

            public void setDouble(double value2) {
                assert (this.position >= 0);
                data2[this.position] = value2;
            }
        };
    }

    private static DataStorage.Iterator compositeIterator(final DataStorage.Iterator iterator1, final long size2, final DataStorage.Iterator iterator2) {
        return new DataStorage.Iterator(){
            private long position;

            public boolean hasNext() {
                return this.position < size2 ? iterator1.hasNext() : iterator2.hasNext();
            }

            public void next() {
                (this.position < size2 ? iterator1 : iterator2).next();
                ++this.position;
            }

            public double getDouble() {
                return (this.position < size2 ? iterator1 : iterator2).getDouble();
            }

            public void setDouble(double value2) {
                (this.position < size2 ? iterator1 : iterator2).setDouble(value2);
            }

            public void close() throws ApfloatRuntimeException {
                (this.position < size2 ? iterator1 : iterator2).close();
            }
        };
    }

    static {
        MATH_MOD_0.setModulus(DoubleModConstants.MODULUS[0]);
        MATH_MOD_1.setModulus(DoubleModConstants.MODULUS[1]);
        MATH_MOD_2.setModulus(DoubleModConstants.MODULUS[2]);
        BigInteger base = BigInteger.valueOf(Math.abs(0x8000000000000L));
        BigInteger m0 = BigInteger.valueOf((long)DoubleModConstants.MODULUS[0]);
        BigInteger m1 = BigInteger.valueOf((long)DoubleModConstants.MODULUS[1]);
        BigInteger m2 = BigInteger.valueOf((long)DoubleModConstants.MODULUS[2]);
        BigInteger m01 = m0.multiply(m1);
        BigInteger m02 = m0.multiply(m2);
        BigInteger m12 = m1.multiply(m2);
        T0 = m12.modInverse(m0).doubleValue();
        T1 = m02.modInverse(m1).doubleValue();
        T2 = m01.modInverse(m2).doubleValue();
        M01 = new double[2];
        M02 = new double[2];
        M12 = new double[2];
        M012 = new double[3];
        BigInteger[] qr = m01.divideAndRemainder(base);
        DoubleCarryCRT.M01[0] = qr[0].doubleValue();
        DoubleCarryCRT.M01[1] = qr[1].doubleValue();
        qr = m02.divideAndRemainder(base);
        DoubleCarryCRT.M02[0] = qr[0].doubleValue();
        DoubleCarryCRT.M02[1] = qr[1].doubleValue();
        qr = m12.divideAndRemainder(base);
        DoubleCarryCRT.M12[0] = qr[0].doubleValue();
        DoubleCarryCRT.M12[1] = qr[1].doubleValue();
        qr = m0.multiply(m12).divideAndRemainder(base);
        DoubleCarryCRT.M012[2] = qr[1].doubleValue();
        qr = qr[0].divideAndRemainder(base);
        DoubleCarryCRT.M012[0] = qr[0].doubleValue();
        DoubleCarryCRT.M012[1] = qr[1].doubleValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CarryCRTRunnable
    implements Runnable {
        private DataStorage resultMod0;
        private DataStorage resultMod1;
        private DataStorage resultMod2;
        private DataStorage dataStorage;
        private long size;
        private long resultSize;
        private long offset;
        private long length;
        private MessagePasser<Long, double[]> messagePasser;

        public CarryCRTRunnable(DataStorage resultMod0, DataStorage resultMod1, DataStorage resultMod2, DataStorage dataStorage, long size2, long resultSize, long offset, long length, MessagePasser<Long, double[]> messagePasser) {
            this.resultMod0 = resultMod0;
            this.resultMod1 = resultMod1;
            this.resultMod2 = resultMod2;
            this.dataStorage = dataStorage;
            this.size = size2;
            this.resultSize = resultSize;
            this.offset = offset;
            this.length = length;
            this.messagePasser = messagePasser;
        }

        @Override
        public void run() {
            long skipSize = this.offset == 0L ? this.size - this.resultSize + 1L : 0L;
            long lastSize = this.offset + this.length == this.size ? 1 : 0;
            long nonLastSize = 1L - lastSize;
            long subResultSize = this.length - skipSize + lastSize;
            long subStart = this.size - this.offset;
            long subEnd = subStart - this.length;
            long subResultStart = this.size - this.offset - this.length + nonLastSize + subResultSize;
            long subResultEnd = subResultStart - subResultSize;
            DataStorage.Iterator src0 = this.resultMod0.iterator(1, subStart, subEnd);
            DataStorage.Iterator src1 = this.resultMod1.iterator(1, subStart, subEnd);
            DataStorage.Iterator src2 = this.resultMod2.iterator(1, subStart, subEnd);
            DataStorage.Iterator dst = this.dataStorage.iterator(2, subResultStart, subResultEnd);
            double[] carryResult = new double[3];
            double[] sum2 = new double[3];
            double[] tmp = new double[3];
            for (long i = 0L; i < this.length; ++i) {
                double y0 = MATH_MOD_0.modMultiply(T0, src0.getDouble());
                double y1 = MATH_MOD_1.modMultiply(T1, src1.getDouble());
                double y2 = MATH_MOD_2.modMultiply(T2, src2.getDouble());
                DoubleCarryCRT.this.multiply(M12, y0, sum2);
                DoubleCarryCRT.this.multiply(M02, y1, tmp);
                if (DoubleCarryCRT.this.add(tmp, sum2) != 0.0 || DoubleCarryCRT.this.compare(sum2, M012) >= 0.0) {
                    DoubleCarryCRT.this.subtract(M012, sum2);
                }
                DoubleCarryCRT.this.multiply(M01, y2, tmp);
                if (DoubleCarryCRT.this.add(tmp, sum2) != 0.0 || DoubleCarryCRT.this.compare(sum2, M012) >= 0.0) {
                    DoubleCarryCRT.this.subtract(M012, sum2);
                }
                DoubleCarryCRT.this.add(sum2, carryResult);
                double result2 = DoubleCarryCRT.this.divide(carryResult);
                if (i >= skipSize) {
                    dst.setDouble(result2);
                    dst.next();
                }
                src0.next();
                src1.next();
                src2.next();
            }
            double result0 = DoubleCarryCRT.this.divide(carryResult);
            double result1 = carryResult[2];
            assert (carryResult[0] == 0.0);
            assert (carryResult[1] == 0.0);
            if (subResultSize == this.length - skipSize + 1L) {
                dst.setDouble(result0);
                dst.close();
                result0 = result1;
                assert (result1 == 0.0);
            }
            double[] results = new double[]{result1, result0};
            if (this.offset > 0L) {
                double[] previousResults = this.messagePasser.receiveMessage(this.offset);
                DataStorage.Iterator src = DoubleCarryCRT.arrayIterator(previousResults);
                dst = DoubleCarryCRT.compositeIterator(this.dataStorage.iterator(3, subResultStart, subResultEnd), subResultSize, DoubleCarryCRT.arrayIterator(results));
                double carry = DoubleCarryCRT.this.baseAdd(dst, src, 0.0, dst, previousResults.length);
                carry = this.baseCarry(dst, carry, subResultSize);
                dst.close();
                assert (carry == 0.0);
            }
            this.messagePasser.sendMessage(this.offset + this.length, results);
        }

        private double baseCarry(DataStorage.Iterator srcDst, double carry, long size2) {
            for (long i = 0L; i < size2 && carry > 0.0; ++i) {
                carry = DoubleCarryCRT.this.baseAdd(srcDst, null, carry, srcDst, 1L);
            }
            return carry;
        }
    }
}

