/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.FloatTableFNTStrategy;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.ArrayAccess;

public abstract class FloatParallelFNTStrategy
extends FloatTableFNTStrategy
implements ParallelNTTStrategy {
    protected ParallelRunner parallelRunner;

    protected FloatParallelFNTStrategy() {
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    protected void multiplyElements(final ArrayAccess arrayAccess, final int startRow, final int rows, final int columns, final float w, final float scaleFactor) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return rows;
            }

            public Runnable getRunnable(int strideStartRow, int strideRows) {
                ArrayAccess subArrayAccess = arrayAccess.subsequence(strideStartRow * columns, strideRows * columns);
                return new MultiplyRunnable(subArrayAccess, startRow + strideStartRow, strideRows, columns, w, scaleFactor);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    protected void transformRows(final int length, final int count2, final boolean isInverse, final ArrayAccess arrayAccess, final float[] wTable, final int[] permutationTable) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return count2;
            }

            public Runnable getRunnable(int startIndex, int strideCount) {
                ArrayAccess subArrayAccess = arrayAccess.subsequence(startIndex * length, strideCount * length);
                return new TableFNTRunnable(length, isInverse, subArrayAccess, wTable, permutationTable);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    private class MultiplyRunnable
    implements Runnable {
        private ArrayAccess arrayAccess;
        private int startRow;
        private int rows;
        private int columns;
        private float w;
        private float scaleFactor;

        public MultiplyRunnable(ArrayAccess arrayAccess, int startRow, int rows, int columns, float w, float scaleFactor) {
            this.arrayAccess = arrayAccess;
            this.startRow = startRow;
            this.rows = rows;
            this.columns = columns;
            this.w = w;
            this.scaleFactor = scaleFactor;
        }

        public void run() {
            float[] data2 = this.arrayAccess.getFloatData();
            int position = this.arrayAccess.getOffset();
            float tmp = FloatParallelFNTStrategy.this.modPow(this.w, this.startRow);
            for (int i = 0; i < this.rows; ++i) {
                float tmp2 = this.scaleFactor;
                int j = 0;
                while (j < this.columns) {
                    data2[position] = FloatParallelFNTStrategy.this.modMultiply(data2[position], tmp2);
                    tmp2 = FloatParallelFNTStrategy.this.modMultiply(tmp2, tmp);
                    ++j;
                    ++position;
                }
                tmp = FloatParallelFNTStrategy.this.modMultiply(tmp, this.w);
            }
        }
    }

    private class TableFNTRunnable
    implements Runnable {
        private int length;
        private boolean isInverse;
        private ArrayAccess arrayAccess;
        private float[] wTable;
        private int[] permutationTable;

        public TableFNTRunnable(int length, boolean isInverse, ArrayAccess arrayAccess, float[] wTable, int[] permutationTable) {
            this.length = length;
            this.isInverse = isInverse;
            this.arrayAccess = arrayAccess;
            this.wTable = wTable;
            this.permutationTable = permutationTable;
        }

        public void run() {
            int maxI = this.arrayAccess.getLength();
            for (int i = 0; i < maxI; i += this.length) {
                ArrayAccess arrayAccess = this.arrayAccess.subsequence(i, this.length);
                if (this.isInverse) {
                    FloatParallelFNTStrategy.this.inverseTableFNT(arrayAccess, this.wTable, this.permutationTable);
                    continue;
                }
                FloatParallelFNTStrategy.this.tableFNT(arrayAccess, this.wTable, this.permutationTable);
            }
        }
    }
}

