/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.math.BigInteger;
import java.util.RandomAccess;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.IntCRTMath;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntModMath;
import org.apfloat.internal.MessagePasser;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class IntCarryCRT
extends IntCRTMath {
    private static final long serialVersionUID = -3954870352092656433L;
    private static final IntModMath MATH_MOD_0 = new IntModMath();
    private static final IntModMath MATH_MOD_1 = new IntModMath();
    private static final IntModMath MATH_MOD_2 = new IntModMath();
    private static final int T0;
    private static final int T1;
    private static final int T2;
    private static final int[] M01;
    private static final int[] M02;
    private static final int[] M12;
    private static final int[] M012;
    private ParallelRunner parallelRunner;

    public IntCarryCRT(int radix) {
        super(radix);
    }

    public DataStorage carryCRT(final DataStorage resultMod0, final DataStorage resultMod1, final DataStorage resultMod2, final long resultSize) throws ApfloatRuntimeException {
        final long size2 = Math.min(resultSize + 2L, resultMod0.getSize());
        ApfloatContext ctx = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = ctx.getBuilderFactory().getDataStorageBuilder();
        final DataStorage dataStorage = dataStorageBuilder.createDataStorage(resultSize * 8L);
        dataStorage.setSize(resultSize);
        final MessagePasser<Long, int[]> messagePasser = new MessagePasser<Long, int[]>();
        if (size2 <= Integer.MAX_VALUE && this.parallelRunner != null && resultMod0 instanceof RandomAccess && resultMod1 instanceof RandomAccess && resultMod2 instanceof RandomAccess && dataStorage instanceof RandomAccess) {
            ParallelRunnable parallelRunnable = new ParallelRunnable(){

                public int getLength() {
                    return (int)size2;
                }

                public Runnable getRunnable(int offset, int length) {
                    return new CarryCRTRunnable(resultMod0, resultMod1, resultMod2, dataStorage, size2, resultSize, offset, length, messagePasser);
                }
            };
            this.parallelRunner.runParallel(parallelRunnable);
        } else {
            new CarryCRTRunnable(resultMod0, resultMod1, resultMod2, dataStorage, size2, resultSize, 0L, size2, messagePasser).run();
        }
        int[] carries = null;
        assert ((carries = messagePasser.getMessage(size2)) != null);
        assert (carries.length == 2);
        assert (carries[0] == 0);
        assert (carries[1] == 0);
        return dataStorage;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    private static DataStorage.Iterator arrayIterator(final int[] data2) {
        return new DataStorage.Iterator(){
            private int position;
            {
                this.position = data2.length - 1;
            }

            public boolean hasNext() {
                return true;
            }

            public void next() {
                --this.position;
            }

            public int getInt() {
                assert (this.position >= 0);
                return data2[this.position];
            }

            public void setInt(int value2) {
                assert (this.position >= 0);
                data2[this.position] = value2;
            }
        };
    }

    private static DataStorage.Iterator compositeIterator(final DataStorage.Iterator iterator1, final long size2, final DataStorage.Iterator iterator2) {
        return new DataStorage.Iterator(){
            private long position;

            public boolean hasNext() {
                return this.position < size2 ? iterator1.hasNext() : iterator2.hasNext();
            }

            public void next() {
                (this.position < size2 ? iterator1 : iterator2).next();
                ++this.position;
            }

            public int getInt() {
                return (this.position < size2 ? iterator1 : iterator2).getInt();
            }

            public void setInt(int value2) {
                (this.position < size2 ? iterator1 : iterator2).setInt(value2);
            }

            public void close() throws ApfloatRuntimeException {
                (this.position < size2 ? iterator1 : iterator2).close();
            }
        };
    }

    static {
        MATH_MOD_0.setModulus(IntModConstants.MODULUS[0]);
        MATH_MOD_1.setModulus(IntModConstants.MODULUS[1]);
        MATH_MOD_2.setModulus(IntModConstants.MODULUS[2]);
        BigInteger base = BigInteger.valueOf(Math.abs(Integer.MIN_VALUE));
        BigInteger m0 = BigInteger.valueOf(IntModConstants.MODULUS[0]);
        BigInteger m1 = BigInteger.valueOf(IntModConstants.MODULUS[1]);
        BigInteger m2 = BigInteger.valueOf(IntModConstants.MODULUS[2]);
        BigInteger m01 = m0.multiply(m1);
        BigInteger m02 = m0.multiply(m2);
        BigInteger m12 = m1.multiply(m2);
        T0 = m12.modInverse(m0).intValue();
        T1 = m02.modInverse(m1).intValue();
        T2 = m01.modInverse(m2).intValue();
        M01 = new int[2];
        M02 = new int[2];
        M12 = new int[2];
        M012 = new int[3];
        BigInteger[] qr = m01.divideAndRemainder(base);
        IntCarryCRT.M01[0] = qr[0].intValue();
        IntCarryCRT.M01[1] = qr[1].intValue();
        qr = m02.divideAndRemainder(base);
        IntCarryCRT.M02[0] = qr[0].intValue();
        IntCarryCRT.M02[1] = qr[1].intValue();
        qr = m12.divideAndRemainder(base);
        IntCarryCRT.M12[0] = qr[0].intValue();
        IntCarryCRT.M12[1] = qr[1].intValue();
        qr = m0.multiply(m12).divideAndRemainder(base);
        IntCarryCRT.M012[2] = qr[1].intValue();
        qr = qr[0].divideAndRemainder(base);
        IntCarryCRT.M012[0] = qr[0].intValue();
        IntCarryCRT.M012[1] = qr[1].intValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CarryCRTRunnable
    implements Runnable {
        private DataStorage resultMod0;
        private DataStorage resultMod1;
        private DataStorage resultMod2;
        private DataStorage dataStorage;
        private long size;
        private long resultSize;
        private long offset;
        private long length;
        private MessagePasser<Long, int[]> messagePasser;

        public CarryCRTRunnable(DataStorage resultMod0, DataStorage resultMod1, DataStorage resultMod2, DataStorage dataStorage, long size2, long resultSize, long offset, long length, MessagePasser<Long, int[]> messagePasser) {
            this.resultMod0 = resultMod0;
            this.resultMod1 = resultMod1;
            this.resultMod2 = resultMod2;
            this.dataStorage = dataStorage;
            this.size = size2;
            this.resultSize = resultSize;
            this.offset = offset;
            this.length = length;
            this.messagePasser = messagePasser;
        }

        @Override
        public void run() {
            long skipSize = this.offset == 0L ? this.size - this.resultSize + 1L : 0L;
            long lastSize = this.offset + this.length == this.size ? 1 : 0;
            long nonLastSize = 1L - lastSize;
            long subResultSize = this.length - skipSize + lastSize;
            long subStart = this.size - this.offset;
            long subEnd = subStart - this.length;
            long subResultStart = this.size - this.offset - this.length + nonLastSize + subResultSize;
            long subResultEnd = subResultStart - subResultSize;
            DataStorage.Iterator src0 = this.resultMod0.iterator(1, subStart, subEnd);
            DataStorage.Iterator src1 = this.resultMod1.iterator(1, subStart, subEnd);
            DataStorage.Iterator src2 = this.resultMod2.iterator(1, subStart, subEnd);
            DataStorage.Iterator dst = this.dataStorage.iterator(2, subResultStart, subResultEnd);
            int[] carryResult = new int[3];
            int[] sum2 = new int[3];
            int[] tmp = new int[3];
            for (long i = 0L; i < this.length; ++i) {
                int y0 = MATH_MOD_0.modMultiply(T0, src0.getInt());
                int y1 = MATH_MOD_1.modMultiply(T1, src1.getInt());
                int y2 = MATH_MOD_2.modMultiply(T2, src2.getInt());
                IntCarryCRT.this.multiply(M12, y0, sum2);
                IntCarryCRT.this.multiply(M02, y1, tmp);
                if (IntCarryCRT.this.add(tmp, sum2) != 0 || IntCarryCRT.this.compare(sum2, M012) >= 0) {
                    IntCarryCRT.this.subtract(M012, sum2);
                }
                IntCarryCRT.this.multiply(M01, y2, tmp);
                if (IntCarryCRT.this.add(tmp, sum2) != 0 || IntCarryCRT.this.compare(sum2, M012) >= 0) {
                    IntCarryCRT.this.subtract(M012, sum2);
                }
                IntCarryCRT.this.add(sum2, carryResult);
                int result2 = IntCarryCRT.this.divide(carryResult);
                if (i >= skipSize) {
                    dst.setInt(result2);
                    dst.next();
                }
                src0.next();
                src1.next();
                src2.next();
            }
            int result0 = IntCarryCRT.this.divide(carryResult);
            int result1 = carryResult[2];
            assert (carryResult[0] == 0);
            assert (carryResult[1] == 0);
            if (subResultSize == this.length - skipSize + 1L) {
                dst.setInt(result0);
                dst.close();
                result0 = result1;
                assert (result1 == 0);
            }
            int[] results = new int[]{result1, result0};
            if (this.offset > 0L) {
                int[] previousResults = this.messagePasser.receiveMessage(this.offset);
                DataStorage.Iterator src = IntCarryCRT.arrayIterator(previousResults);
                dst = IntCarryCRT.compositeIterator(this.dataStorage.iterator(3, subResultStart, subResultEnd), subResultSize, IntCarryCRT.arrayIterator(results));
                int carry = IntCarryCRT.this.baseAdd(dst, src, 0, dst, previousResults.length);
                carry = this.baseCarry(dst, carry, subResultSize);
                dst.close();
                assert (carry == 0);
            }
            this.messagePasser.sendMessage(this.offset + this.length, results);
        }

        private int baseCarry(DataStorage.Iterator srcDst, int carry, long size2) {
            for (long i = 0L; i < size2 && carry > 0; ++i) {
                carry = IntCarryCRT.this.baseAdd(srcDst, null, carry, srcDst, 1L);
            }
            return carry;
        }
    }
}

