/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.Util;

public class IntMatrix {
    private IntMatrix() {
    }

    public static void transpose(ArrayAccess arrayAccess, int n1, int n2) throws ApfloatRuntimeException {
        int[] data2 = arrayAccess.getIntData();
        int offset = arrayAccess.getOffset();
        if (n1 != (n1 & -n1) || n2 != (n2 & -n2) || n1 <= 0 || n2 <= 0) {
            throw new ApfloatInternalException("Matrix size must be a power of two, not " + n1 + " x " + n2);
        }
        if (n1 == n2) {
            IntMatrix.transposeSquare(data2, offset, n1, n1);
        } else if (n2 == 2 * n1) {
            IntMatrix.transposeSquare(data2, offset, n1, n2);
            IntMatrix.transposeSquare(data2, offset + n1, n1, n2);
            IntMatrix.permuteWideToTall(data2, offset, n1, n2);
        } else if (n1 == 2 * n2) {
            IntMatrix.permuteTallToWide(data2, offset, n1, n2);
            IntMatrix.transposeSquare(data2, offset, n2, n1);
            IntMatrix.transposeSquare(data2, offset + n2, n2, n1);
        } else {
            throw new ApfloatInternalException("Must be n1 = n2, n1 = 2*n2 or n2 = 2*n1; matrix is " + n1 + " x " + n2);
        }
    }

    public static void transposeSquare(ArrayAccess arrayAccess, int n1, int n2) throws ApfloatRuntimeException {
        IntMatrix.transposeSquare(arrayAccess.getIntData(), arrayAccess.getOffset(), n1, n2);
    }

    private static void moveBlock(int[] source, int sourceOffset, int sourceWidth, int[] dest, int destOffset, int destWidth, int b) {
        for (int i = 0; i < b; ++i) {
            System.arraycopy(source, sourceOffset, dest, destOffset, b);
            destOffset += destWidth;
            sourceOffset += sourceWidth;
        }
    }

    private static void transpose2blocks(int[] data2, int offset1, int offset2, int width, int b) {
        int i = 0;
        int position1 = offset2;
        while (i < b) {
            int j = 0;
            int position2 = offset1 + i;
            while (j < b) {
                int tmp = data2[position1 + j];
                data2[position1 + j] = data2[position2];
                data2[position2] = tmp;
                ++j;
                position2 += width;
            }
            ++i;
            position1 += width;
        }
    }

    private static void transposeBlock(int[] data2, int offset, int width, int b) {
        int i = 0;
        int position1 = offset;
        while (i < b) {
            int j = i + 1;
            int position2 = offset + j * width + i;
            while (j < b) {
                int tmp = data2[position1 + j];
                data2[position1 + j] = data2[position2];
                data2[position2] = tmp;
                ++j;
                position2 += width;
            }
            ++i;
            position1 += width;
        }
    }

    private static void transposeSquare(int[] data2, int offset, int n1, int n2) {
        ApfloatContext ctx = ApfloatContext.getContext();
        int cacheBurstBlockSize = Util.round2down(ctx.getCacheBurst() / 4);
        int cacheBlockSize = Util.sqrt4down(ctx.getCacheL1Size() / 4);
        int cacheTreshold = Util.round2down(ctx.getCacheL2Size() / 4);
        if (n1 <= cacheBurstBlockSize || n1 <= cacheBlockSize) {
            IntMatrix.transposeBlock(data2, offset, n2, n1);
        } else if (n1 * n2 <= cacheTreshold) {
            int b = cacheBurstBlockSize;
            int i = 0;
            int position1 = offset;
            while (i < n1) {
                IntMatrix.transposeBlock(data2, position1 + i, n2, b);
                int j = i + b;
                int position2 = offset + j * n2 + i;
                while (j < n1) {
                    IntMatrix.transpose2blocks(data2, position1 + j, position2, n2, b);
                    j += b;
                    position2 += b * n2;
                }
                i += b;
                position1 += b * n2;
            }
        } else {
            int b = cacheBlockSize;
            int[] tmp1 = new int[b * b];
            int[] tmp2 = new int[b * b];
            int i = 0;
            int position1 = offset;
            while (i < n1) {
                IntMatrix.moveBlock(data2, position1 + i, n2, tmp1, 0, b, b);
                IntMatrix.transposeBlock(tmp1, 0, b, b);
                IntMatrix.moveBlock(tmp1, 0, b, data2, position1 + i, n2, b);
                int j = i + b;
                int position2 = offset + j * n2 + i;
                while (j < n1) {
                    IntMatrix.moveBlock(data2, position1 + j, n2, tmp1, 0, b, b);
                    IntMatrix.transposeBlock(tmp1, 0, b, b);
                    IntMatrix.moveBlock(data2, position2, n2, tmp2, 0, b, b);
                    IntMatrix.transposeBlock(tmp2, 0, b, b);
                    IntMatrix.moveBlock(tmp2, 0, b, data2, position1 + j, n2, b);
                    IntMatrix.moveBlock(tmp1, 0, b, data2, position2, n2, b);
                    j += b;
                    position2 += b * n2;
                }
                i += b;
                position1 += b * n2;
            }
        }
    }

    private static void permuteWideToTall(int[] data2, int offset, int n1, int n2) {
        assert (n2 == 2 * n1);
        if (n2 < 4) {
            return;
        }
        int[] tmp = new int[n1];
        boolean[] isRowDone = new boolean[n2];
        int j = 1;
        do {
            int o = j;
            int m = j;
            System.arraycopy(data2, offset + n1 * m, tmp, 0, n1);
            isRowDone[m] = true;
            int n = m = m < n1 ? 2 * m : 2 * (m - n1) + 1;
            while (m != j) {
                isRowDone[m] = true;
                System.arraycopy(data2, offset + n1 * m, data2, offset + n1 * o, n1);
                o = m;
                m = m < n1 ? 2 * m : 2 * (m - n1) + 1;
            }
            System.arraycopy(tmp, 0, data2, offset + n1 * o, n1);
            while (isRowDone[j]) {
                ++j;
            }
        } while (j < n2 - 1);
    }

    private static void permuteTallToWide(int[] data2, int offset, int n1, int n2) {
        assert (n1 == 2 * n2);
        if (n1 < 4) {
            return;
        }
        int[] tmp = new int[n2];
        boolean[] isRowDone = new boolean[n1];
        int j = 1;
        do {
            int o = j;
            int m = j;
            System.arraycopy(data2, offset + n2 * m, tmp, 0, n2);
            isRowDone[m] = true;
            int n = m = (m & 1) != 0 ? m / 2 + n2 : m / 2;
            while (m != j) {
                isRowDone[m] = true;
                System.arraycopy(data2, offset + n2 * m, data2, offset + n2 * o, n2);
                o = m;
                m = (m & 1) != 0 ? m / 2 + n2 : m / 2;
            }
            System.arraycopy(tmp, 0, data2, offset + n2 * o, n2);
            while (isRowDone[j]) {
                ++j;
            }
        } while (j < n1 - 1);
    }
}

