/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.ce;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.ce.CECalculator;
import org.biojava.bio.structure.align.ce.CeCPUserArgumentProcessor;
import org.biojava.bio.structure.align.ce.CeMain;
import org.biojava.bio.structure.align.ce.GuiWrapper;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.align.util.AFPAlignmentDisplay;
import org.biojava.bio.structure.jama.Matrix;

public class CeCPMain
extends CeMain {
    private static boolean debug = false;
    public static final String algorithmName = "jCE Circular Permutation";
    public static final int DEFAULT_MIN_CP_LENGTH = 5;
    public static final String version = "1.3";

    public CeCPMain() {
        this.params.setMaxGapSize(0);
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public String getVersion() {
        return version;
    }

    public static void main(String[] args) {
        CeCPMain ce = new CeCPMain();
        if (args.length == 0) {
            System.out.println(ce.printHelp());
            return;
        }
        if (args.length == 1 && (args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--help"))) {
            System.out.println(ce.printHelp());
            return;
        }
        CeCPUserArgumentProcessor processor = new CeCPUserArgumentProcessor();
        processor.process(args);
    }

    @Override
    public AFPChain align(Atom[] ca1, Atom[] ca2, Object param2) throws StructureException {
        long startTime = System.currentTimeMillis();
        Atom[] ca2m = StructureTools.duplicateCA2(ca2);
        if (debug) {
            System.out.format("Duplicating ca2 took %s ms\n", System.currentTimeMillis() - startTime);
            startTime = System.currentTimeMillis();
        }
        AFPChain afpChain = super.align(ca1, ca2m, this.params);
        try {
            afpChain.setName2(ca2[0].getGroup().getChain().getParent().getName());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (debug) {
            System.out.format("Running %dx2*%d alignment took %s ms\n", ca1.length, ca2.length, System.currentTimeMillis() - startTime);
            startTime = System.currentTimeMillis();
        }
        afpChain = CeCPMain.postProcessAlignment(afpChain, ca1, ca2m, this.calculator);
        if (debug) {
            System.out.format("Finding CP point took %s ms\n", System.currentTimeMillis() - startTime);
            startTime = System.currentTimeMillis();
        }
        return afpChain;
    }

    public static AFPChain postProcessAlignment(AFPChain afpChain, Atom[] ca1, Atom[] ca2m, CECalculator calculator) throws StructureException {
        int alignLen;
        Matrix doubledMatrix = afpChain.getDistanceMatrix();
        if (doubledMatrix != null) {
            assert (doubledMatrix.getRowDimension() == ca1.length);
            assert (doubledMatrix.getColumnDimension() == ca2m.length);
            Matrix singleMatrix = doubledMatrix.getMatrix(0, ca1.length - 1, 0, ca2m.length / 2 - 1);
            assert (singleMatrix.getRowDimension() == ca1.length);
            assert (singleMatrix.getColumnDimension() == ca2m.length / 2);
            afpChain.setDistanceMatrix(singleMatrix);
        }
        if ((alignLen = afpChain.getOptLength()) > 0) {
            afpChain = CeCPMain.filterDuplicateAFPs(afpChain, calculator, ca1, ca2m);
        }
        return afpChain;
    }

    public static AFPChain filterDuplicateAFPs(AFPChain afpChain, CECalculator ceCalc, Atom[] ca1, Atom[] ca2duplicated) throws StructureException {
        return CeCPMain.filterDuplicateAFPs(afpChain, ceCalc, ca1, ca2duplicated, 5);
    }

    public static AFPChain filterDuplicateAFPs(AFPChain afpChain, CECalculator ceCalc, Atom[] ca1, Atom[] ca2duplicated, int minCPlength) throws StructureException {
        AFPChain newAFPChain = new AFPChain(afpChain);
        int ca2len = afpChain.getCa2Length() / 2;
        newAFPChain.setCa2Length(ca2len);
        int[][][] optAln = afpChain.getOptAln();
        int[] optLen = afpChain.getOptLen();
        int alignLen = afpChain.getOptLength();
        if (alignLen < 1) {
            return newAFPChain;
        }
        assert (afpChain.getBlockNum() == 1);
        int nStart = optAln[0][1][0];
        int cEnd = optAln[0][1][alignLen - 1];
        int firstRes = nStart;
        int lastRes = nStart + ca2len;
        if (nStart >= ca2len || cEnd < ca2len) {
            firstRes = nStart;
            lastRes = cEnd;
        } else {
            int overlapLength = cEnd + 1 - nStart - ca2len;
            if (overlapLength <= 0) {
                CPRange minCP = CeCPMain.calculateMinCP(optAln[0][1], alignLen, ca2len, minCPlength);
                firstRes = nStart;
                lastRes = cEnd;
                if (firstRes > minCP.n) {
                    firstRes = ca2len;
                    if (debug) {
                        System.out.format("Discarding n-terminal block as too short (%d residues, needs %d)\n", minCP.mid, minCPlength);
                    }
                }
                if (lastRes < minCP.c) {
                    lastRes = ca2len - 1;
                    if (debug) {
                        System.out.format("Discarding c-terminal block as too short (%d residues, needs %d)\n", optLen[0] - minCP.mid, minCPlength);
                    }
                }
            } else {
                CutPoint cp = CeCPMain.calculateCutPoint(optAln[0][1], nStart, cEnd, overlapLength, alignLen, minCPlength, ca2len, firstRes);
                firstRes = cp.firstRes;
                lastRes = cp.lastRes;
            }
        }
        ArrayList<ResiduePair> left = new ArrayList<ResiduePair>();
        ArrayList<ResiduePair> right = new ArrayList<ResiduePair>();
        for (int i = 0; i < optLen[0]; ++i) {
            if (optAln[0][1][i] < firstRes || optAln[0][1][i] > lastRes) continue;
            if (optAln[0][1][i] < ca2len) {
                left.add(new ResiduePair(optAln[0][0][i], optAln[0][1][i]));
                continue;
            }
            right.add(new ResiduePair(optAln[0][0][i], optAln[0][1][i] - ca2len));
        }
        alignLen = 0;
        ArrayList<ArrayList<ResiduePair>> blocks = new ArrayList<ArrayList<ResiduePair>>(2);
        if (!left.isEmpty()) {
            blocks.add(left);
            alignLen += left.size();
        }
        if (!right.isEmpty()) {
            blocks.add(right);
            alignLen += right.size();
        }
        left = null;
        right = null;
        int[][][] newAlign = new int[blocks.size()][][];
        int[] blockLengths = new int[blocks.size()];
        for (int blockNum = 0; blockNum < blocks.size(); ++blockNum) {
            List block = (List)blocks.get(blockNum);
            newAlign[blockNum] = new int[2][block.size()];
            for (int i = 0; i < block.size(); ++i) {
                ResiduePair pair2 = (ResiduePair)block.get(i);
                newAlign[blockNum][0][i] = pair2.a;
                newAlign[blockNum][1][i] = pair2.b;
            }
            blockLengths[blockNum] = block.size();
        }
        newAFPChain.setOptAln(newAlign);
        newAFPChain.setOptLen(blockLengths);
        newAFPChain.setOptLength(alignLen);
        newAFPChain.setBlockNum(blocks.size());
        newAFPChain.setBlockResSize((int[])blockLengths.clone());
        newAFPChain.setSequentialAlignment(blocks.size() == 1);
        Atom[] atoms1 = new Atom[alignLen];
        Atom[] atoms2 = new Atom[alignLen];
        int pos = 0;
        for (List list2 : blocks) {
            for (ResiduePair pair3 : list2) {
                atoms1[pos] = ca1[pair3.a];
                atoms2[pos] = ca2duplicated[pair3.b];
                ++pos;
            }
        }
        assert (pos == alignLen);
        double rmsd = -1.0;
        double[] blockRMSDs = new double[blocks.size()];
        Matrix[] blockRotationMatrices = new Matrix[blocks.size()];
        Atom[] blockShifts = new Atom[blocks.size()];
        if (alignLen > 0) {
            blockRMSDs[0] = rmsd = ceCalc.calc_rmsd(atoms1, atoms2, alignLen, true, false);
            blockRotationMatrices[0] = ceCalc.getRotationMatrix();
            blockShifts[0] = ceCalc.getShift();
            for (int i = 1; i < blocks.size(); ++i) {
                blockRMSDs[i] = rmsd;
                blockRotationMatrices[i] = (Matrix)blockRotationMatrices[0].clone();
                blockShifts[i] = (Atom)blockShifts[0].clone();
            }
        }
        newAFPChain.setOptRmsd(blockRMSDs);
        newAFPChain.setBlockRmsd(blockRMSDs);
        newAFPChain.setBlockRotationMatrix(blockRotationMatrices);
        newAFPChain.setBlockShiftVector(blockShifts);
        newAFPChain.setTotalRmsdOpt(rmsd);
        Atom[] ca2 = new Atom[ca2len];
        for (int i = 0; i < ca2len; ++i) {
            ca2[i] = ca2duplicated[i];
        }
        AFPAlignmentDisplay.getAlign(newAFPChain, ca1, ca2duplicated);
        return newAFPChain;
    }

    private static int[] countCtermResidues(int[] block, int blockLen, int cEnd, int overlapLength) {
        int[] cTermResCount = new int[overlapLength + 1];
        cTermResCount[overlapLength] = 0;
        int alignPos = blockLen - 1;
        for (int i = overlapLength - 1; i >= 0; --i) {
            if (block[alignPos] == cEnd - overlapLength + 1 + i) {
                cTermResCount[i] = cTermResCount[i + 1] + 1;
                --alignPos;
                continue;
            }
            cTermResCount[i] = cTermResCount[i + 1];
        }
        return cTermResCount;
    }

    private static int[] countNtermResidues(int[] block, int nStart, int overlapLength) {
        int[] nTermResCount = new int[overlapLength + 1];
        nTermResCount[0] = 0;
        int alignPos = 0;
        for (int i = 1; i <= overlapLength; ++i) {
            if (block[alignPos] == nStart + i - 1) {
                nTermResCount[i] = nTermResCount[i - 1] + 1;
                ++alignPos;
                continue;
            }
            nTermResCount[i] = nTermResCount[i - 1];
        }
        return nTermResCount;
    }

    protected static CPRange calculateMinCP(int[] block, int blockLen, int ca2len, int minCPlength) {
        CPRange range2 = new CPRange();
        int middle = Arrays.binarySearch(block, ca2len);
        if (middle < 0) {
            middle = -middle - 1;
        }
        range2.mid = middle;
        int minCPntermIndex = middle - minCPlength;
        range2.n = minCPntermIndex >= 0 ? block[minCPntermIndex] : -1;
        int minCPctermIndex = middle + minCPlength - 1;
        range2.c = minCPctermIndex < blockLen ? block[minCPctermIndex] : ca2len * 2;
        return range2;
    }

    private static CutPoint calculateCutPoint(int[] block, int nStart, int cEnd, int overlapLength, int alignLen, int minCPlength, int ca2len, int firstRes) {
        int lastRes;
        CPRange minCP = CeCPMain.calculateMinCP(block, alignLen, ca2len, minCPlength);
        int minCPnterm = minCP.n;
        int minCPcterm = minCP.c;
        int[] nTermResCount = CeCPMain.countNtermResidues(block, nStart, overlapLength);
        int[] cTermResCount = CeCPMain.countCtermResidues(block, alignLen, cEnd, overlapLength);
        int maxResCount = -1;
        for (int i = 0; i <= overlapLength; ++i) {
            int cRemain;
            int nRemain = nStart + i <= minCPnterm ? nTermResCount[overlapLength] - nTermResCount[i] : 0;
            if (nRemain + (cRemain = cEnd - overlapLength + i >= minCPcterm ? cTermResCount[0] - cTermResCount[i] : 0) <= maxResCount) continue;
            maxResCount = nRemain + cRemain;
            firstRes = nStart + i;
        }
        int numResiduesCut = nTermResCount[overlapLength] + cTermResCount[0] - maxResCount;
        if (firstRes > minCPnterm) {
            numResiduesCut += 0;
            firstRes = ca2len;
        }
        if ((lastRes = firstRes + ca2len - 1) < minCPcterm) {
            numResiduesCut += 0;
            lastRes = ca2len - 1;
        }
        CutPoint cp = new CutPoint();
        cp.firstRes = firstRes;
        cp.numResiduesCut = numResiduesCut;
        cp.lastRes = lastRes;
        if (debug) {
            System.out.format("Found a CP at residue %d. Trimming %d aligned residues from %d-%d of block 0 and %d-%d of block 1.\n", firstRes, cp.numResiduesCut, nStart, firstRes - 1, firstRes, cEnd - ca2len);
        }
        return cp;
    }

    private static void displayAlignment(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, StructureException {
        Atom[] ca1clone = StructureTools.cloneCAArray(ca1);
        Atom[] ca2clone = StructureTools.cloneCAArray(ca2);
        if (!GuiWrapper.isGuiModuleInstalled()) {
            System.err.println("The biojava-structure-gui and/or JmolApplet modules are not installed. Please install!");
            System.out.println(afpChain.toCE(ca1clone, ca2clone));
        } else {
            Object jmol = GuiWrapper.display(afpChain, ca1clone, ca2clone);
            GuiWrapper.showAlignmentImage(afpChain, ca1clone, ca2clone, jmol);
        }
    }

    private static class CutPoint {
        public int numResiduesCut;
        public int firstRes;
        public int lastRes;

        private CutPoint() {
        }
    }

    protected static class CPRange {
        public int n;
        public int mid;
        public int c;

        protected CPRange() {
        }
    }

    private static class ResiduePair {
        public int a;
        public int b;

        public ResiduePair(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public String toString() {
            return this.a + ":" + this.b;
        }
    }
}

