/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileDownloadUtils {
    public static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static String getFileExtension(File f2) {
        String fileName = f2.getName();
        String ext = "";
        int mid = fileName.lastIndexOf(".");
        ext = fileName.substring(mid + 1, fileName.length());
        return ext;
    }

    public static String getFilePrefix(File f2) {
        String fileName = f2.getName();
        String fname = "";
        int mid = fileName.indexOf(".");
        fname = fileName.substring(0, mid);
        return fname;
    }

    public static void downloadGzipCompressedFile(URL url, File destination) throws IOException {
        InputStream uStream = url.openStream();
        GZIPInputStream conn = new GZIPInputStream(uStream);
        File tempFile = File.createTempFile(FileDownloadUtils.getFilePrefix(destination), "." + FileDownloadUtils.getFileExtension(destination));
        try {
            String line;
            FileOutputStream outPut = new FileOutputStream(tempFile);
            GZIPOutputStream gzOutPut = new GZIPOutputStream(outPut);
            PrintWriter pw = new PrintWriter(gzOutPut);
            BufferedReader fileBuffer = new BufferedReader(new InputStreamReader(conn));
            while ((line = fileBuffer.readLine()) != null) {
                pw.println(line);
            }
            pw.flush();
            pw.close();
            outPut.flush();
            outPut.close();
            ((InputStream)conn).close();
            uStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (conn != null) {
                ((InputStream)conn).close();
            }
            if (uStream != null) {
                uStream.close();
            }
            throw new IOException(e.getMessage());
        }
        FileDownloadUtils.copy(tempFile, destination);
        tempFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFileIfAvailable(URL url, File destination) throws IOException {
        InputStream uStream = null;
        GZIPInputStream conn = null;
        try {
            uStream = url.openStream();
            conn = new GZIPInputStream(uStream);
        }
        catch (IOException e1) {
            System.err.println("Problem while downloading file " + url);
            try {
                if (uStream != null) {
                    uStream.close();
                }
                if (conn != null) {
                    ((InputStream)conn).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        FileOutputStream outPut = null;
        GZIPOutputStream gzOutPut = null;
        File tempFile = File.createTempFile(FileDownloadUtils.getFilePrefix(destination), "." + FileDownloadUtils.getFileExtension(destination));
        try {
            String line;
            outPut = new FileOutputStream(tempFile);
            gzOutPut = new GZIPOutputStream(outPut);
            PrintWriter pw = new PrintWriter(gzOutPut);
            BufferedReader fileBuffer = new BufferedReader(new InputStreamReader(conn));
            while ((line = fileBuffer.readLine()) != null) {
                pw.println(line);
            }
            pw.flush();
            pw.close();
            outPut.flush();
            outPut.close();
            ((InputStream)conn).close();
            uStream.close();
        }
        catch (Exception e) {
            System.err.println("Problem while downloading " + url);
            e.printStackTrace();
            File file = null;
            return file;
        }
        finally {
            if (conn != null) {
                try {
                    ((InputStream)conn).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (uStream != null) {
                try {
                    uStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (outPut != null) {
                    outPut.close();
                }
                if (gzOutPut != null) {
                    gzOutPut.close();
                }
            }
            catch (IOException e) {}
        }
        System.out.println("Writing to " + destination);
        FileDownloadUtils.copy(tempFile, destination);
        return destination;
    }

    public static String toUnixPath(String path) {
        String uPath = path;
        if (uPath.contains("\\")) {
            uPath = uPath.replaceAll("\\\\", "/");
        }
        if (uPath.endsWith("//")) {
            uPath = uPath.substring(0, uPath.length() - 1);
        }
        if (!uPath.endsWith("/")) {
            uPath = uPath + "/";
        }
        return uPath;
    }
}

