/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.structure;

import java.io.IOException;
import java.util.List;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.quaternary.BiologicalAssemblyBuilder;
import org.biojava.bio.structure.quaternary.ModelTransformationMatrix;
import org.biojava.bio.structure.quaternary.io.BioUnitDataProvider;
import org.biojava.bio.structure.quaternary.io.BioUnitDataProviderFactory;

public class StructureIO {
    private static AtomCache cache;
    private static final String FILE_SEPARATOR;

    public static Structure getStructure(String name) throws IOException, StructureException {
        StructureIO.checkInitAtomCache();
        return cache.getStructure(name);
    }

    private static void checkInitAtomCache() {
        if (cache == null) {
            cache = new AtomCache();
        }
    }

    public static void setAtomCache(AtomCache c) {
        cache = c;
    }

    public static Structure getBiologicalAssembly(String pdbId) throws IOException, StructureException {
        return StructureIO.getBiologicalAssembly(pdbId, 1);
    }

    public static Structure getBiologicalAssembly(String pdbId, int biolAssemblyNr) throws IOException, StructureException {
        pdbId = pdbId.toLowerCase();
        BioUnitDataProvider provider = BioUnitDataProviderFactory.getBioUnitDataProvider();
        if (cache != null) {
            provider.setAtomCache(cache);
        }
        Structure asymUnit = null;
        asymUnit = provider.getAsymUnit(pdbId);
        provider.setAsymUnit(null);
        provider.setAtomCache(null);
        if (biolAssemblyNr == 0) {
            return asymUnit;
        }
        List<ModelTransformationMatrix> transformations = asymUnit.getPDBHeader().getBioUnitTranformationMap().get(biolAssemblyNr);
        if (transformations == null || transformations.size() == 0) {
            throw new StructureException("Could not load transformations to recreate biological assembly nr " + biolAssemblyNr + " of " + pdbId);
        }
        BiologicalAssemblyBuilder builder = new BiologicalAssemblyBuilder();
        return builder.rebuildQuaternaryStructure(asymUnit, transformations);
    }

    public static boolean hasBiologicalAssembly(String pdbId) {
        pdbId = pdbId.toLowerCase();
        BioUnitDataProvider provider = BioUnitDataProviderFactory.getBioUnitDataProvider();
        provider.setAtomCache(cache);
        return provider.hasBiolAssembly(pdbId);
    }

    public static int getNrBiologicalAssemblies(String pdbId) {
        pdbId = pdbId.toLowerCase();
        BioUnitDataProvider provider = BioUnitDataProviderFactory.getBioUnitDataProvider();
        provider.setAtomCache(cache);
        return provider.getNrBiolAssemblies(pdbId);
    }

    public static void setPdbPath(String pathToPDBFiles) {
        if (!pathToPDBFiles.endsWith(FILE_SEPARATOR)) {
            pathToPDBFiles = pathToPDBFiles + FILE_SEPARATOR;
        }
        System.setProperty("PDB_DIR", pathToPDBFiles);
    }

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
    }
}

