/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationDelEtc {
    public static boolean debug;
    public static boolean verbose;

    @Test
    public void test_01_del_repeated_effects() {
        Gpr.debug("Test");
        String[] args = new String[]{"-ud", "0", "testHg3775Chr1", "tests/del_multiple_splice_region.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff snpeff = (SnpEffCmdEff)cmd.cmd();
        snpeff.setSupressOutput(!verbose);
        snpeff.setVerbose(verbose);
        int countEffs = 0;
        boolean repeat2 = false;
        List<VcfEntry> vcfEnties = snpeff.run(true);
        for (VcfEntry ve : vcfEnties) {
            if (verbose) {
                System.out.println(ve);
            }
            List<VcfEffect> veffs = ve.getVcfEffects();
            for (VcfEffect veff : veffs) {
                HashSet<String> effs = new HashSet<String>();
                if (verbose) {
                    System.out.println("\t" + veff.getEffString());
                }
                for (String eff : veff.getEffString().split("\\&")) {
                    if (verbose) {
                        System.out.println("\t\t" + eff);
                    }
                    if (!effs.add(eff)) {
                        repeat2 = true;
                    }
                    ++countEffs;
                }
            }
        }
        Assert.assertTrue("No effect annotated", countEffs > 0);
        Assert.assertFalse("Duplicated effect", repeat2);
    }

    @Test
    public void test_02_del_repeated_effects_gatk() {
        Gpr.debug("Test");
        String[] args = new String[]{"-ud", "0", "-o", "gatk", "testHg3775Chr1", "tests/del_multiple_splice_region.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff snpeff = (SnpEffCmdEff)cmd.cmd();
        snpeff.setSupressOutput(!verbose);
        snpeff.setVerbose(verbose);
        int countEffs = 0;
        List<VcfEntry> vcfEnties = snpeff.run(true);
        for (VcfEntry ve : vcfEnties) {
            if (verbose) {
                System.out.println(ve);
            }
            List<VcfEffect> veffs = ve.getVcfEffects();
            for (VcfEffect veff : veffs) {
                if (verbose) {
                    System.out.println("\t" + veff.getEffString());
                }
                countEffs = 0;
                for (String eff : veff.getEffString().split("\\+")) {
                    if (verbose) {
                        System.out.println("\t\t" + eff);
                    }
                    ++countEffs;
                }
                Assert.assertEquals(1L, countEffs);
            }
        }
    }

    static {
        verbose = debug = false;
    }
}

