/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.HgvsDna;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;

public class TestCasesHgvsDnaDupNegative
extends TestCasesBase {
    @Override
    protected void init() {
        super.init();
        this.onlyMinusStrand = true;
        this.onlyPlusStrand = false;
        this.shiftHgvs = true;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        if (this.verbose) {
            Exon exFirst = (Exon)this.transcript.sorted().get(0);
            String exFirstSeq = exFirst.isStrandPlus() ? exFirst.getSequence() : GprSeq.reverseWc(exFirst.getSequence());
            Gpr.debug(this.transcript + "\n\tSequence: " + exFirstSeq);
        }
        Variant variant = new Variant((Marker)this.chromosome, 1001, "", "C", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.1dupG", hgvsDna);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        if (this.verbose) {
            Exon exFirst = (Exon)this.transcript.sorted().get(0);
            String exFirstSeq = exFirst.isStrandPlus() ? exFirst.getSequence() : GprSeq.reverseWc(exFirst.getSequence());
            Gpr.debug(this.transcript + "\n\tSequence: " + exFirstSeq);
        }
        Variant variant = new Variant((Marker)this.chromosome, 997, "", "G", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.5dupC", hgvsDna);
    }

    @Test
    public void test_03() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        if (this.verbose) {
            Exon exFirst = (Exon)this.transcript.sorted().get(0);
            String exFirstSeq = exFirst.isStrandPlus() ? exFirst.getSequence() : GprSeq.reverseWc(exFirst.getSequence());
            Gpr.debug(this.transcript + "\n\tSequence: " + exFirstSeq);
        }
        Variant variant = new Variant((Marker)this.chromosome, 996, "", "CG", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.5_6dupCG", hgvsDna);
    }

    @Test
    public void test_04() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        if (this.verbose) {
            Exon exFirst = (Exon)this.transcript.sorted().get(0);
            String exFirstSeq = exFirst.isStrandPlus() ? exFirst.getSequence() : GprSeq.reverseWc(exFirst.getSequence());
            Gpr.debug(this.transcript + "\n\tSequence: " + exFirstSeq);
        }
        Variant variant = new Variant((Marker)this.chromosome, 984, "", "CAT", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.16_18dupATG", hgvsDna);
    }
}

