/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantBnd;
import org.snpeff.outputFormatter.VcfOutputFormatter;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;

public class TestCasesVcf
extends TestCasesBase {
    boolean verbose = false;
    boolean debug = false;
    boolean createOutputFile = false;

    @Test
    public void test_00() {
        Gpr.debug("Test");
        String fileName = "./tests/1kg_head.vcf";
        VcfFileIterator vcf = new VcfFileIterator(fileName);
        for (VcfEntry ve : vcf) {
            Assert.assertEquals(1L, ve.size());
        }
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String fileName = "./tests/vcf.vcf";
        VcfFileIterator vcf = new VcfFileIterator(fileName);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            for (Variant variant : vcfEntry.variants()) {
                String variantStr = "chr" + variant.toStringOld();
                if (this.verbose) {
                    System.out.println(variant + "\t'" + variantStr + "'");
                }
                Assert.assertEquals(variant.getId(), variantStr);
            }
        }
    }

    @Test
    public void test_04_del() {
        Gpr.debug("Test");
        String fileName = "./tests/vcf_04_del.vcf";
        VcfFileIterator vcf = new VcfFileIterator(fileName);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            for (Variant variant : vcfEntry.variants()) {
                if (variant.isDel()) continue;
                throw new RuntimeException("All VCF entries in this file should be deletions!\n\t" + variant);
            }
        }
    }

    @Test
    public void test_05_choking_on_dot_slash_dot() {
        Gpr.debug("Test");
        String fileName = "./tests/choking_on_dot_slash_dot.vcf";
        VcfFileIterator vcf = new VcfFileIterator(fileName);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            for (VcfGenotype gen : vcfEntry) {
                boolean var = gen.isVariant();
                if (!this.verbose) continue;
                System.out.println("\t" + var + "\t" + gen);
            }
        }
        if (this.verbose) {
            System.out.println("");
        }
    }

    @Test
    public void test_06_mixed_change() {
        Gpr.debug("Test");
        String file = "./tests/array_out_of_bounds.vcf";
        VcfFileIterator vcf = new VcfFileIterator(file);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            if (this.verbose) {
                System.out.println(vcfEntry);
            }
            List<Variant> variants = vcfEntry.variants();
            Assert.assertEquals("chr1:223921_GACCACTGGAA/ACATCCATACAT", variants.get(0).toString());
            Assert.assertEquals("chr1:223919_TC/AT", variants.get(1).toString());
        }
    }

    @Test
    public void test_07_long_lines() {
        Gpr.debug("Test");
        String file = "./tests/long.vcf";
        Timer t2 = new Timer();
        t2.start();
        VcfFileIterator vcf = new VcfFileIterator(file);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            if (this.verbose) {
                System.out.println(vcfEntry.getChromosomeName() + ":" + vcfEntry.getStart());
            }
            for (VcfGenotype vg : vcfEntry) {
                if (!this.verbose) continue;
                System.out.println("\t" + vg);
            }
        }
        if (t2.elapsed() > 1000L) {
            throw new RuntimeException("It should not take this long to process a few lines!!!");
        }
    }

    @Test
    public void test_08_alt_del() {
        Gpr.debug("Test");
        String file = "./tests/alt_del.vcf";
        VcfFileIterator vcf = new VcfFileIterator(file);
        vcf.setCreateChromos(true);
        for (VcfEntry vcfEntry : vcf) {
            if (this.verbose) {
                System.out.println(vcfEntry);
            }
            boolean hasDel = false;
            for (Variant sc : vcfEntry.variants()) {
                hasDel |= sc.isDel();
                if (!this.verbose) continue;
                System.out.println("\t" + sc + "\t" + sc.isDel());
            }
            Assert.assertEquals(true, hasDel);
        }
    }

    @Test
    public void test_09_empty_ALT() {
        Gpr.debug("Test");
        String file = "./tests/empty.vcf";
        VcfFileIterator vcf = new VcfFileIterator(file);
        for (VcfEntry vcfEntry : vcf) {
            if (this.verbose) {
                System.out.println(vcfEntry);
            }
            Assert.assertEquals(false, vcfEntry.isVariant());
        }
    }

    @Test
    public void test_10_empty_QUAL() {
        Gpr.debug("Test");
        String file = "./tests/empty.vcf";
        VcfFileIterator vcf = new VcfFileIterator(file);
        for (VcfEntry vcfEntry : vcf) {
            if (this.verbose) {
                System.out.println(vcfEntry);
            }
            Assert.assertEquals(0.0, vcfEntry.getQuality(), -16.0);
        }
    }

    @Test
    public void test_11_empty() {
        Gpr.debug("Test");
        String file = "./tests/empty.vcf";
        VcfFileIterator vcf = new VcfFileIterator(file);
        for (VcfEntry vcfEntry : vcf) {
            if (this.verbose) {
                System.out.println(vcfEntry);
            }
            Assert.assertEquals("1\t11169327\t.\tT\t.\t.\tPASS\tAC=0;AF=0.00;AN=176;DP=7756;MQ0=0;set=ReferenceInAll\tGT:DP\t0/0:115", vcfEntry.toString());
        }
    }

    @Test
    public void test_12_readHeader() {
        Gpr.debug("Test");
        String file = "./tests/test.chr1.1line.vcf";
        VcfFileIterator vcfFile = new VcfFileIterator(file);
        vcfFile.readHeader();
        int numLines = 0;
        for (VcfEntry vcfEntry : vcfFile) {
            if (this.verbose) {
                System.out.println(vcfEntry);
            }
            ++numLines;
        }
        Assert.assertEquals(1L, numLines);
    }

    @Test
    public void test_12_readHeader_NL() {
        Gpr.debug("Test");
        String file = "./tests/test.chr1.1line.vcf";
        VcfFileIterator vcfFile = new VcfFileIterator(file);
        String header = vcfFile.readHeader().toString();
        Assert.assertEquals(false, header.charAt(header.length() - 1) == '\n');
    }

    @Test
    public void test_13_chrOri() {
        Gpr.debug("Test");
        String file = "./tests/test.chr1.1line.vcf";
        VcfFileIterator vcfFile = new VcfFileIterator(file);
        vcfFile.readHeader();
        String chr = null;
        for (VcfEntry vcfEntry : vcfFile) {
            chr = vcfEntry.getChromosomeNameOri();
        }
        Assert.assertEquals("chr1", chr);
    }

    @Test
    public void test_14_VcfInfoKey() {
        Gpr.debug("Test");
        new VcfOutputFormatter(null);
        String[] testIn = new String[]{"Hi ", "Hi how;", "Hi how;are|", "Hi how;are|you,", "Hi how;are|you,doing=", "Hi how;are|you,doing=today(.)", ".ann"};
        String[] testOut = new String[]{"Hi_", "Hi_how_", "Hi_how_are_", "Hi_how_are_you_", "Hi_how_are_you_doing_", "Hi_how_are_you_doing_today_._", "_.ann"};
        for (int i = 0; i < testIn.length; ++i) {
            String safe = VcfEntry.vcfInfoKeySafe(testIn[i]);
            if (this.verbose) {
                System.out.println("'" + testIn[i] + "'\t'" + safe + "'\t'" + testOut[i] + "'");
            }
            Assert.assertEquals(testOut[i], safe);
        }
    }

    @Test
    public void test_14_VcfInfoValue() {
        Gpr.debug("Test");
        new VcfOutputFormatter(null);
        String[] testIn = new String[]{"Hi ", "Hi how;", "Hi how;are|", "Hi how;are|you,", "Hi how;are|you,doing=", "Hi how;are|you,doing=today(.)"};
        String[] testOut = new String[]{"Hi_", "Hi_how_", "Hi_how_are_", "Hi_how_are_you_", "Hi_how_are_you_doing_", "Hi_how_are_you_doing_today_._"};
        for (int i = 0; i < testIn.length; ++i) {
            String safe = VcfEntry.vcfInfoValueSafe(testIn[i]);
            if (this.verbose) {
                System.out.println("'" + testIn[i] + "'\t'" + safe + "'\t'" + testOut[i] + "'");
            }
            Assert.assertEquals(testOut[i], safe);
        }
    }

    @Test
    public void test_15_Eff_format_version_guess() {
        Gpr.debug("Test");
        String vcfFileName = "./tests/test.EFF_V2.vcf";
        EffFormatVersion formatVersion = this.formatVersion(vcfFileName);
        Assert.assertEquals((Object)EffFormatVersion.FORMAT_EFF_2, (Object)formatVersion);
        vcfFileName = "./tests/test.EFF_V3.vcf";
        formatVersion = this.formatVersion(vcfFileName);
        Assert.assertEquals((Object)EffFormatVersion.FORMAT_EFF_3, (Object)formatVersion);
    }

    @Test
    public void test_16_indels() {
        Gpr.debug("Test");
        String vcfFile = "tests/1kg.indels.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            StringBuilder variantResult = new StringBuilder();
            for (Variant v : ve.variants()) {
                if (variantResult.length() > 0) {
                    variantResult.append(",");
                }
                String vs = v.toStringOld();
                vs = vs.substring(vs.indexOf(95) + 1);
                if (this.verbose) {
                    System.out.println("\t" + v + "\t" + v.toStringOld() + "\t" + vs);
                }
                variantResult.append(vs);
            }
            String variantExpected = ve.getInfo("SEQCHANGE");
            Assert.assertEquals(variantExpected, variantResult.toString());
        }
    }

    @Test
    public void test_18_vcf_tabix() {
        Gpr.debug("Test");
        VcfFileIterator vcf = new VcfFileIterator("./tests/test_tabix.vcf.gz");
        String chrpos = "";
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            chrpos = chrpos + ve.getChromosomeName() + ":" + ve.getStart() + " ";
        }
        Assert.assertEquals("1:249211906 2:41612", chrpos.trim());
    }

    @Test
    public void test_22_huge_headers() {
        Gpr.debug("Test");
        String vcfFile = "tests/huge_header_slow.vcf.gz";
        Timer timer = new Timer();
        timer.start();
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        for (VcfEntry ve : vcf) {
            if (!this.verbose) continue;
            System.out.println(ve);
        }
        Assert.assertTrue(timer.elapsed() < 1000L);
    }

    @Test
    public void test_23_VcfUnsorted() {
        boolean errorFound;
        block4: {
            Gpr.debug("Test");
            String vcfFile = "tests/out_of_order.vcf";
            VcfFileIterator vcf = new VcfFileIterator(vcfFile);
            vcf.setErrorIfUnsorted(true);
            errorFound = false;
            String expectedErrorMessage = "VCF file 'tests/out_of_order.vcf' is not sorted, genomic position 20:2622038 is before 20:2621729";
            try {
                for (VcfEntry ve : vcf) {
                    if (!this.verbose) continue;
                    System.out.println(ve);
                }
            }
            catch (Throwable e) {
                errorFound = e.getMessage().startsWith(expectedErrorMessage);
                if (this.verbose) {
                    e.printStackTrace();
                }
                if (errorFound) break block4;
                Gpr.debug("Error messages differ:\n\tExpected : '" + expectedErrorMessage + "'\n\tActual   : '" + e.getMessage() + "'");
            }
        }
        Assert.assertTrue(errorFound);
    }

    @Test
    public void test_24_VcfEffect_parse_SO() {
        String vcfFileName = "tests/test_rasmus.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (!this.verbose) continue;
                System.out.println("\t\t" + veff);
            }
        }
    }

    @Test
    public void test_25_Genomic_VCF() {
        String vcfFileName = "tests/genomic_vcf.gvcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        int start = -1;
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            if (start < 0) {
                start = ve.getStart();
            }
            if (start != ve.getStart()) {
                throw new RuntimeException("Start position should be " + start + " instead of " + ve.getStart() + "\n" + ve);
            }
            boolean ok = false;
            for (Variant var : ve.variants()) {
                ok |= var.getVariantType().toString().equals(ve.getInfo("Type"));
                if (!this.verbose) continue;
                System.out.println(ve + "\n\t\tSize   : " + ve.size() + "\n\t\tVariant: " + ve.isVariant() + "\n\t\tType   : " + (Object)((Object)var.getVariantType()) + "\n");
            }
            if (!ok) {
                throw new RuntimeException("Variant type should be '" + ve.getInfo("Type") + "'\n" + ve);
            }
            start += ve.size();
        }
    }

    @Test
    public void test_26_vcfInfoHeaderAdd() {
        Gpr.debug("Test");
        String vcfFileName = "tests/example_42.vcf";
        String infoFieldName = "NEW_INFO";
        VcfHeaderInfo vhInfo = new VcfHeaderInfo(infoFieldName, VcfInfoType.Integer, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "An arbitrary set of random numbers");
        String expectedHeader = "##INFO=<ID=" + infoFieldName + ",Number=.,Type=Integer,Description=\"An arbitrary set of random numbers\">";
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        for (VcfEntry ve : vcf) {
            if (vcf.isHeadeSection()) {
                vcf.getVcfHeader().addInfo(vhInfo);
                if (this.verbose) {
                    System.out.println(vcf.getVcfHeader());
                }
                Assert.assertTrue(vcf.getVcfHeader().toString().contains(expectedHeader));
            }
            String value2 = "" + (int)(1000.0 * Math.random());
            ve.addInfo(infoFieldName, value2);
            if (this.verbose) {
                System.out.println(ve);
            }
            Assert.assertTrue(ve.toString().contains(infoFieldName + "=" + value2));
        }
    }

    @Test
    public void test_27_vcfInfoHeaderReplace() {
        Gpr.debug("Test");
        String infoFieldName = "NEW_INFO";
        String vcfFileName = "tests/example_42.vcf";
        VcfHeaderInfo vhInfo = new VcfHeaderInfo(infoFieldName, VcfInfoType.Integer, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "An arbitrary set of integer random numbers");
        String expectedHeader = "##INFO=<ID=" + infoFieldName + ",Number=.,Type=Integer,Description=\"An arbitrary set of integer random numbers\">";
        VcfHeaderInfo vhInfo2 = new VcfHeaderInfo(infoFieldName, VcfInfoType.Float, "1", "One float random number");
        String expectedHeader2 = "##INFO=<ID=" + infoFieldName + ",Number=1,Type=Float,Description=\"One float random number\">";
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        for (VcfEntry ve : vcf) {
            if (vcf.isHeadeSection()) {
                vcf.getVcfHeader().addInfo(vhInfo);
                if (this.verbose) {
                    System.out.println(vcf.getVcfHeader());
                }
                Assert.assertTrue(vcf.getVcfHeader().toString().contains(expectedHeader));
                vcf.getVcfHeader().addInfo(vhInfo2);
                if (this.verbose) {
                    System.out.println(vcf.getVcfHeader());
                }
                Assert.assertTrue(vcf.getVcfHeader().toString().contains(expectedHeader2));
                Assert.assertTrue(!vcf.getVcfHeader().toString().contains(expectedHeader));
            }
            String value2 = "" + (int)(1000.0 * Math.random());
            ve.addInfo(infoFieldName, value2);
            if (this.verbose) {
                System.out.println(ve);
            }
            Assert.assertTrue(ve.toString().contains(infoFieldName + "=" + value2));
        }
    }

    @Test
    public void test_28_vcfInfoReplace() {
        Gpr.debug("Test");
        String vcfFileName = "tests/example_42.vcf";
        String infoKey = "DP";
        String infoValue = "42";
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        for (VcfEntry ve : vcf) {
            String infoValuePrev = ve.getInfo(infoKey);
            String keyValPrev = infoKey + "=" + infoValuePrev;
            Assert.assertTrue("Old key=valu is not present", ve.getInfoStr().contains(keyValPrev));
            ve.addInfo(infoKey, infoValue);
            if (this.verbose) {
                System.out.println(ve);
            }
            String keyVal = infoKey + "=" + infoValue;
            Assert.assertTrue("New key=value is present", ve.toString().contains(keyVal));
            Assert.assertTrue("Old key=value is still in INOF field", !ve.getInfoStr().contains(keyValPrev));
        }
    }

    @Test
    public void test_29() {
        Gpr.debug("Test");
        String fileName = "./tests/test_vcf_ann_plus_sign.vcf";
        VcfFileIterator vcf = new VcfFileIterator(fileName);
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\t" + veff);
                }
                Assert.assertEquals(EffectType.UTR_5_DELETED.toString(), veff.getEffectTypes().get(0).toString());
                Assert.assertEquals(EffectType.EXON_DELETED.toString(), veff.getEffectTypes().get(1).toString());
            }
        }
    }

    @Test
    public void test_30_gVCF_NON_REF() {
        Gpr.debug("Test");
        String vcfFileName = "tests/test_gVCF_NON_REF.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            int countNonVariants = 0;
            for (Variant var : ve.variants()) {
                if (this.verbose) {
                    System.out.println("\t" + var);
                }
                if (var.isVariant()) continue;
                ++countNonVariants;
            }
            Assert.assertEquals(1L, countNonVariants);
            for (VcfGenotype vgt : ve.getVcfGenotypes()) {
                if (!this.verbose) continue;
                System.out.println("\t\tVCF_GT: " + vgt);
            }
            for (Object gt : (Object)ve.getGenotypesScores()) {
                if (this.verbose) {
                    System.out.println("\t\tGT    : " + (int)gt);
                }
                Assert.assertEquals(1L, (long)gt);
            }
        }
    }

    @Test
    public void test_31_MISSING_REF() {
        String vcfFile = "tests/test_missing_ref.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        int countVariants = 0;
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (Variant v : ve.variants()) {
                if (this.verbose) {
                    System.out.println("\t" + v + "\tis Variant: " + v.isVariant());
                }
                if (!v.isVariant()) continue;
                ++countVariants;
            }
        }
        Assert.assertEquals(1L, countVariants);
    }

    @Test
    public void test_32_VcfInfoKeyNames() {
        String[] keysPass = new String[]{"ANN", "ann9", "a9nn", "ann_", "a_nn", "_ann", "ann.gene"};
        String[] keysFail = new String[]{"ann+", "9ann", ".gene"};
        for (String key : keysPass) {
            Assert.assertTrue("String '" + key + "' should be a valid INFO key", VcfEntry.isValidInfoKey(key));
        }
        for (String key : keysFail) {
            Assert.assertFalse("String '" + key + "' should be an invalid INFO key", VcfEntry.isValidInfoKey(key));
        }
    }

    @Test
    public void test_33_translocations() {
        Gpr.debug("Test");
        String vcfFile = "tests/vcf_translocation.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            boolean ok = false;
            for (Variant var : ve.variants()) {
                if (this.verbose) {
                    System.out.println("\t" + (Object)((Object)var.getVariantType()) + "\t" + var);
                }
                Assert.assertEquals("Variant type is not 'BND'", (Object)Variant.VariantType.BND, (Object)var.getVariantType());
                ok = true;
            }
            Assert.assertTrue("No variants found!", ok);
        }
    }

    @Test
    public void test_34_vcfInfoEncoding() {
        String str = "hi;hello;bye;\nadios=chau\tbye\nhi=hello\thola";
        String enc = VcfEntry.vcfInfoEncode(str);
        String dec = VcfEntry.vcfInfoDecode(enc);
        Assert.assertEquals("Encoding-Decoding cycle failed", str, dec);
    }

    @Test
    public void test_35_translocations_parsing() {
        Gpr.debug("Test");
        String vcfFile = "tests/vcf_translocation_parsing.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            boolean ok = false;
            for (Variant var : ve.variants()) {
                if (this.verbose) {
                    System.out.println("\t" + (Object)((Object)var.getVariantType()) + "\t" + var);
                }
                Assert.assertEquals("Variant type is not 'BND'", (Object)Variant.VariantType.BND, (Object)var.getVariantType());
                VariantBnd vbnd = (VariantBnd)var;
                Assert.assertEquals("Variant BND 'left' does not match", ve.getInfoFlag("LEFT"), vbnd.isLeft());
                Assert.assertEquals("Variant BND 'before' does not match", ve.getInfoFlag("BEFORE"), vbnd.isBefore());
                ok = true;
            }
            Assert.assertTrue("No variants found!", ok);
        }
    }
}

