/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.fileIterator;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.samtools.tabix.TabixIterator;
import net.sf.samtools.tabix.TabixReader;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfInfoType;
import org.snpsift.annotate.DbMarker;
import org.snpsift.fileIterator.DbNsfpEntry;

public class DbNsfp
implements DbMarker<Variant, DbNsfpEntry> {
    public static final String DATA_TYPES_CACHE_EXT = ".data_types";
    public static final int DATA_TYPES_MIN_LINES = 10000;
    public static final int DATA_TYPES_MAX_LINES = 100000;
    public static final String HEADER_PREFIX = "#";
    public static final String COLUMN_SEPARATOR = "\t";
    public static final char SUBFIELD_SEPARATOR_CHAR = ';';
    public static final String SUBFIELD_SEPARATOR = ";";
    public static final char SUBFIELD_SEPARATOR_CHAR_2 = ',';
    public static final String SUBFIELD_SEPARATOR_2 = ",";
    public static final String COLUMN_CHR_NAME = "chr";
    public static final String COLUMN_POS_NAME_v2 = "pos(1-coor)";
    public static final String COLUMN_POS_NAME_v3 = "pos(1-based)";
    public static final String ALT_NAME = "alt";
    public static final String REF_NAME = "ref";
    protected String fileName;
    protected boolean debug;
    protected boolean[] multipleValues = null;
    protected boolean verbose;
    protected int chromosomeIdx;
    protected int startIdx;
    protected int altIdx;
    protected int refIdx;
    protected String[] fieldNames = null;
    protected VcfInfoType[] types = null;
    protected Genome genome;
    protected HashMap<String, Integer> names2index;
    protected TabixReader tabixReader;
    protected String latestTabixIteratorBlocks = "";
    protected List<DbNsfpEntry> latestResults;

    public DbNsfp(String fileName) {
        this.fileName = fileName;
        this.genome = new Genome();
    }

    @Override
    public void close() {
        if (this.tabixReader != null) {
            this.tabixReader.close();
        }
        this.tabixReader = null;
    }

    protected boolean dataTypes() {
        boolean ok = false;
        String cacheFileName = this.fileName + DATA_TYPES_CACHE_EXT;
        if (!this.loadCachedDataTypes(cacheFileName)) {
            ok = this.guessDataTypes();
            this.saveDataTypesCache(cacheFileName);
        }
        this.forceMissingTypesAsString();
        return ok;
    }

    public void forceMissingTypesAsString() {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != null) continue;
            this.types[i] = VcfInfoType.String;
        }
    }

    public int getAltIdx() {
        return this.altIdx;
    }

    public Chromosome getChromosome(String chromoName) {
        return this.genome.getOrCreateChromosome(chromoName);
    }

    public int getChromosomeIdx() {
        return this.chromosomeIdx;
    }

    public int getFieldCount() {
        return this.fieldNames.length;
    }

    public String getFieldName(int idx) {
        return this.fieldNames[idx];
    }

    public Set<String> getFieldNames() {
        return this.names2index.keySet();
    }

    public String[] getFieldNamesSorted() {
        return this.fieldNames;
    }

    public int getIndex(String name) {
        return this.names2index.get(name);
    }

    public HashMap<String, Integer> getNames2index() {
        return this.names2index;
    }

    public int getRefIdx() {
        return this.refIdx;
    }

    public int getStartIdx() {
        return this.startIdx;
    }

    public VcfInfoType[] getTypes() {
        return this.types;
    }

    protected VcfInfoType guessDataType(String value2) {
        if (value2 == null || value2.isEmpty() || value2.equals(".")) {
            return null;
        }
        if (this.isMultipleValues(value2)) {
            String[] values2 = DbNsfpEntry.splitValuesField(value2);
            VcfInfoType type = null;
            for (String val : values2) {
                VcfInfoType valType = this.guessDataType(val);
                if (type == null) {
                    type = valType;
                    continue;
                }
                if (valType == null || type == valType) continue;
                return null;
            }
            return type;
        }
        try {
            Long.parseLong(value2);
            return VcfInfoType.Integer;
        }
        catch (Exception exception) {
            try {
                Double.parseDouble(value2);
                return VcfInfoType.Float;
            }
            catch (Exception exception2) {
                if (value2.length() == 1) {
                    return VcfInfoType.Character;
                }
                if (value2.equalsIgnoreCase("true") || value2.equalsIgnoreCase("false") || value2.equalsIgnoreCase("yes") || value2.equalsIgnoreCase("no")) {
                    return VcfInfoType.Flag;
                }
                return VcfInfoType.String;
            }
        }
    }

    protected boolean guessDataTypes() {
        if (this.verbose) {
            Timer.showStdErr("Guessing data types for file '" + this.fileName + "'");
        }
        boolean header = true;
        this.fieldNames = null;
        this.types = null;
        this.multipleValues = null;
        this.names2index = null;
        LineFileIterator lfi = new LineFileIterator(this.fileName);
        int entryNum = 0;
        for (String line : lfi) {
            if (line == null) {
                lfi.close();
                return false;
            }
            if (header) {
                header = false;
                this.parseHeader(line);
                continue;
            }
            if (this.multipleValues == null) {
                throw new RuntimeException("Cannot parse file '" + this.fileName + "'. Missing header?");
            }
            boolean done = true;
            String[] values2 = line.split(COLUMN_SEPARATOR, -1);
            for (int i = 0; i < this.fieldNames.length; ++i) {
                VcfInfoType type = this.guessDataType(values2[i]);
                if (this.types[i] == null) {
                    this.types[i] = type;
                } else if (this.types[i] == VcfInfoType.Integer && type == VcfInfoType.Float) {
                    this.types[i] = type;
                } else if (type == VcfInfoType.String) {
                    this.types[i] = type;
                }
                int n = i;
                this.multipleValues[n] = this.multipleValues[n] | this.isMultipleValues(values2[i]);
                done &= this.types[i] != null;
            }
            if (this.verbose) {
                Gpr.showMark(entryNum, 1000);
            }
            if (done && entryNum > 10000) {
                lfi.close();
                return true;
            }
            if (entryNum > 100000) {
                lfi.close();
                return false;
            }
            ++entryNum;
        }
        return true;
    }

    public boolean hasField(String filedName) {
        return this.names2index.containsKey(filedName);
    }

    protected boolean initTabix(String fileName) {
        try {
            String indexFile = fileName + ".tbi";
            if (!Gpr.exists(indexFile)) {
                throw new RuntimeException("Cannot find tabix index file '" + indexFile + "'");
            }
            if (this.verbose) {
                Timer.showStdErr("Opening database file and loading index");
            }
            this.tabixReader = new TabixReader(fileName, this.debug);
            this.tabixReader.setShowHeader(false);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening tabix file '" + fileName + "'", e);
        }
        return true;
    }

    boolean isMultipleValues(String value2) {
        return value2.indexOf(SUBFIELD_SEPARATOR) >= 0 || value2.indexOf(SUBFIELD_SEPARATOR_2) >= 0;
    }

    boolean loadCachedDataTypes(String cacheFileName) {
        int i;
        if (this.verbose) {
            Timer.showStdErr("Loading data types from file '" + cacheFileName + "'");
        }
        if (!Gpr.canRead(cacheFileName)) {
            if (this.verbose) {
                Timer.showStdErr("Data types cache file '" + cacheFileName + "' not found");
            }
            return false;
        }
        File db = new File(this.fileName);
        File cache = new File(cacheFileName);
        if (db.lastModified() > cache.lastModified()) {
            if (this.verbose) {
                Timer.showStdErr("Data types cache file '" + cacheFileName + "' needs to be updated");
            }
            return false;
        }
        String[] lines2 = Gpr.readFile(cacheFileName).split("\n");
        this.fieldNames = new String[lines2.length];
        this.types = new VcfInfoType[lines2.length];
        this.multipleValues = new boolean[lines2.length];
        for (i = 0; i < lines2.length; ++i) {
            String[] fields = lines2[i].split(COLUMN_SEPARATOR);
            if (fields.length != 3) {
                throw new RuntimeException("Error parsing line " + (i + 1) + " from file '" + this.fileName + "':\n" + lines2[i]);
            }
            this.fieldNames[i] = fields[0];
            this.types[i] = fields[1].equals("null") ? null : VcfInfoType.valueOf(fields[1]);
            this.multipleValues[i] = Gpr.parseBoolSafe(fields[2]);
        }
        this.names2index = new HashMap();
        for (i = 0; i < this.fieldNames.length; ++i) {
            String fieldName;
            this.fieldNames[i] = fieldName = this.fieldNames[i].trim();
            this.names2index.put(fieldName, i);
            this.updateIndexes(fieldName, i);
        }
        return true;
    }

    protected boolean match(Variant var, DbNsfpEntry dbEntry) {
        return var.getChromosomeName().equals(dbEntry.getChromosomeName()) && var.getStart() == dbEntry.getStart() && var.getEnd() == dbEntry.getEnd() && var.getReference().equalsIgnoreCase(dbEntry.getReference()) && var.getAlt().equalsIgnoreCase(dbEntry.getAlt());
    }

    @Override
    public void open() {
        this.dataTypes();
        this.initTabix(this.fileName);
    }

    void parseHeader(String line) {
        if (!line.startsWith(HEADER_PREFIX)) {
            throw new RuntimeException("Error: Invalid header line!\n\tLine:\t" + line);
        }
        line = line.substring(HEADER_PREFIX.length());
        this.altIdx = -1;
        this.startIdx = -1;
        this.chromosomeIdx = -1;
        this.fieldNames = line.split(COLUMN_SEPARATOR, -1);
        this.types = new VcfInfoType[this.fieldNames.length];
        this.multipleValues = new boolean[this.fieldNames.length];
        this.names2index = new HashMap();
        for (int idx = 0; idx < this.fieldNames.length; ++idx) {
            String fieldName;
            this.fieldNames[idx] = fieldName = this.fieldNames[idx].trim();
            this.names2index.put(fieldName, idx);
            this.updateIndexes(fieldName, idx);
        }
        if (this.chromosomeIdx == -1) {
            throw new RuntimeException("Missing 'chr' columns in dbNSFP file");
        }
        if (this.startIdx == -1) {
            throw new RuntimeException("Missing 'pos(1-coor)' columns in dbNSFP file");
        }
        if (this.altIdx == -1) {
            throw new RuntimeException("Missing 'alt' columns in dbNSFP file");
        }
    }

    @Override
    public Collection<DbNsfpEntry> query(Variant variant) {
        TabixIterator tabixIterator = this.tabixReader.query(variant);
        if (tabixIterator == null) {
            return null;
        }
        String tiblocks = tabixIterator.toStringBlocks();
        if (tiblocks.equals(this.latestTabixIteratorBlocks)) {
            LinkedList<DbNsfpEntry> results = new LinkedList<DbNsfpEntry>();
            for (DbNsfpEntry de : this.latestResults) {
                if (this.match(variant, de)) {
                    results.add(de);
                    continue;
                }
                if (variant.getEnd() >= de.getStart()) continue;
                break;
            }
            return results;
        }
        tabixIterator.setReadBlock(true);
        this.latestResults = new LinkedList<DbNsfpEntry>();
        LinkedList<DbNsfpEntry> results = new LinkedList<DbNsfpEntry>();
        this.latestTabixIteratorBlocks = tiblocks;
        int numLines = 0;
        for (String line : tabixIterator) {
            DbNsfpEntry de;
            line = Gpr.removeBackslashR(line);
            if (this.debug) {
                Gpr.debug("Query: Parse line " + line);
            }
            if (this.match(variant, de = new DbNsfpEntry(this, line))) {
                results.add(de);
            }
            this.latestResults.add(de);
            ++numLines;
        }
        if (this.debug) {
            Gpr.debug("Query: " + variant.toStr() + "\tParsed lines: " + numLines);
        }
        return results;
    }

    protected void saveDataTypesCache(String cacheFileName) {
        if (this.verbose) {
            Timer.showStdErr("Saving data types to file '" + cacheFileName + "'");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            sb.append(this.fieldNames[i] + COLUMN_SEPARATOR + (Object)((Object)this.types[i]) + COLUMN_SEPARATOR + this.multipleValues[i] + "\n");
        }
        Gpr.toFile(cacheFileName, sb);
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    void updateIndexes(String fieldName, int idx) {
        switch (fieldName.toLowerCase()) {
            case "chr": {
                this.chromosomeIdx = idx;
                break;
            }
            case "pos(1-coor)": 
            case "pos(1-based)": {
                this.startIdx = idx;
                break;
            }
            case "alt": {
                this.altIdx = idx;
                break;
            }
            case "ref": {
                this.refIdx = idx;
                break;
            }
        }
    }
}

