/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jython;

import freemarker.ext.jython.JythonModelCache;
import freemarker.ext.util.ModelCache;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelAdapter;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.OptimizerUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;

public class JythonWrapper
implements ObjectWrapper {
    private static final Class PYOBJECT_CLASS = class$org$python$core$PyObject == null ? (class$org$python$core$PyObject = JythonWrapper.class$("org.python.core.PyObject")) : class$org$python$core$PyObject;
    public static final JythonWrapper INSTANCE = new JythonWrapper();
    private final ModelCache modelCache = new JythonModelCache(this);
    private boolean attributesShadowItems = true;
    static /* synthetic */ Class class$org$python$core$PyObject;

    public void setUseCache(boolean useCache) {
        this.modelCache.setUseCache(useCache);
    }

    public synchronized void setAttributesShadowItems(boolean attributesShadowItems) {
        this.attributesShadowItems = attributesShadowItems;
    }

    boolean isAttributesShadowItems() {
        return this.attributesShadowItems;
    }

    public TemplateModel wrap(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.modelCache.getInstance(obj);
    }

    public PyObject unwrap(TemplateModel model) throws TemplateModelException {
        if (model instanceof AdapterTemplateModel) {
            return Py.java2py((Object)((AdapterTemplateModel)model).getAdaptedObject(PYOBJECT_CLASS));
        }
        if (model instanceof WrapperTemplateModel) {
            return Py.java2py((Object)((WrapperTemplateModel)model).getWrappedObject());
        }
        if (model instanceof TemplateScalarModel) {
            return new PyString(((TemplateScalarModel)model).getAsString());
        }
        if (model instanceof TemplateNumberModel) {
            Number number2 = ((TemplateNumberModel)model).getAsNumber();
            if (number2 instanceof BigDecimal) {
                number2 = OptimizerUtil.optimizeNumberRepresentation(number2);
            }
            if (number2 instanceof BigInteger) {
                return new PyLong((BigInteger)number2);
            }
            return Py.java2py((Object)number2);
        }
        return new TemplateModelToJythonAdapter(model);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TemplateModelToJythonAdapter
    extends PyObject
    implements TemplateModelAdapter {
        private final TemplateModel model;

        TemplateModelToJythonAdapter(TemplateModel model) {
            this.model = model;
        }

        public TemplateModel getTemplateModel() {
            return this.model;
        }

        public PyObject __finditem__(PyObject key) {
            if (key instanceof PyInteger) {
                return this.__finditem__(((PyInteger)key).getValue());
            }
            return this.__finditem__(key.toString());
        }

        public PyObject __finditem__(String key) {
            if (this.model instanceof TemplateHashModel) {
                try {
                    return JythonWrapper.this.unwrap(((TemplateHashModel)this.model).get(key));
                }
                catch (TemplateModelException e) {
                    throw Py.JavaError((Throwable)e);
                }
            }
            throw Py.TypeError((String)("item lookup on non-hash model (" + this.getModelClass() + ")"));
        }

        public PyObject __finditem__(int index2) {
            if (this.model instanceof TemplateSequenceModel) {
                try {
                    return JythonWrapper.this.unwrap(((TemplateSequenceModel)this.model).get(index2));
                }
                catch (TemplateModelException e) {
                    throw Py.JavaError((Throwable)e);
                }
            }
            throw Py.TypeError((String)("item lookup on non-sequence model (" + this.getModelClass() + ")"));
        }

        public PyObject __call__(PyObject[] args, String[] keywords) {
            if (this.model instanceof TemplateMethodModel) {
                boolean isEx = this.model instanceof TemplateMethodModelEx;
                ArrayList<Object> list2 = new ArrayList<Object>(args.length);
                try {
                    for (int i = 0; i < args.length; ++i) {
                        list2.add(isEx ? JythonWrapper.this.wrap(args[i]) : (args[i] == null ? null : args[i].toString()));
                    }
                    return JythonWrapper.this.unwrap((TemplateModel)((TemplateMethodModelEx)this.model).exec(list2));
                }
                catch (TemplateModelException e) {
                    throw Py.JavaError((Throwable)e);
                }
            }
            throw Py.TypeError((String)("call of non-method model (" + this.getModelClass() + ")"));
        }

        public int __len__() {
            try {
                if (this.model instanceof TemplateSequenceModel) {
                    return ((TemplateSequenceModel)this.model).size();
                }
                if (this.model instanceof TemplateHashModelEx) {
                    return ((TemplateHashModelEx)this.model).size();
                }
            }
            catch (TemplateModelException e) {
                throw Py.JavaError((Throwable)e);
            }
            return 0;
        }

        public boolean __nonzero__() {
            try {
                if (this.model instanceof TemplateBooleanModel) {
                    return ((TemplateBooleanModel)this.model).getAsBoolean();
                }
                if (this.model instanceof TemplateSequenceModel) {
                    return ((TemplateSequenceModel)this.model).size() > 0;
                }
                if (this.model instanceof TemplateHashModel) {
                    return !((TemplateHashModelEx)this.model).isEmpty();
                }
            }
            catch (TemplateModelException e) {
                throw Py.JavaError((Throwable)e);
            }
            return false;
        }

        private String getModelClass() {
            return this.model == null ? "null" : this.model.getClass().getName();
        }
    }
}

