/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.fatcat.calc;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.SVDSuperimposer;
import org.biojava.bio.structure.align.fatcat.calc.FatCatParameters;
import org.biojava.bio.structure.align.model.AFP;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.jama.Matrix;

public class AFPCalculator {
    public static final boolean debug = false;

    public static final void extractAFPChains(FatCatParameters params, AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        ArrayList<AFP> afpSet = new ArrayList<AFP>();
        afpChain.setAfpSet(afpSet);
        double rmsd = 0.0;
        Matrix r = new Matrix(3, 3);
        AtomImpl t2 = new AtomImpl();
        int sparse = params.getSparse();
        int maxTra = params.getMaxTra();
        int fragLen = params.getFragLen();
        double disFilter = params.getDisFilter();
        double rmsdCut = params.getRmsdCut();
        double badRmsd = params.getBadRmsd();
        double fragScore = params.getFragScore();
        int add2 = sparse + 1;
        int n2 = 0;
        int n1 = 0;
        int n = 0;
        int n0 = 0;
        int minLen = 0;
        int prot1Length = ca1.length;
        int prot2Length = ca2.length;
        minLen = prot1Length < prot2Length ? prot1Length : prot2Length;
        afpChain.setMinLen(minLen);
        afpChain.setBlockResList(new int[maxTra + 1][2][minLen]);
        afpChain.setFocusRes1(new int[minLen]);
        afpChain.setFocusRes2(new int[minLen]);
        for (int p1 = 0; p1 < prot1Length - fragLen; p1 += add2) {
            for (int p2 = 0; p2 < prot2Length - fragLen; p2 += add2) {
                ++n0;
                double filter1 = AFPCalculator.getEnd2EndDistance(ca1, ca2, p1, p1 + fragLen - 1, p2, p2 + fragLen - 1);
                if (filter1 > disFilter) {
                    ++n1;
                    continue;
                }
                boolean filter2 = AFPCalculator.filterTerminal(ca1, ca2, p1, p1 + fragLen - 1, p2, p2 + fragLen - 1, fragLen, minLen);
                if (filter2) {
                    ++n2;
                    continue;
                }
                rmsd = AFPCalculator.getRmsd(ca1, ca2, fragLen, p1, p2, r, t2);
                if (!(rmsd < rmsdCut)) continue;
                AFP afptmp = new AFP();
                afptmp.setP1(p1);
                afptmp.setP2(p2);
                afptmp.setFragLen(fragLen);
                afptmp.setRmsd(rmsd);
                afptmp.setM(r);
                afptmp.setT(t2.getCoords());
                afptmp.setScore(AFPCalculator.scoreAfp(afptmp, badRmsd, fragScore));
                afpSet.add(afptmp);
                ++n;
            }
        }
        int afpNum = afpSet.size();
    }

    private static final double getEnd2EndDistance(Atom[] ca1, Atom[] ca2, int p1b, int p1e, int p2b, int p2e) {
        double min2 = 99.0;
        try {
            double dist1 = Calc.getDistance(ca1[p1b], ca1[p1e]);
            double dist2 = Calc.getDistance(ca2[p2b], ca2[p2e]);
            min2 = dist1 - dist2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Math.abs(min2);
    }

    private static final boolean filterTerminal(Atom[] ca1, Atom[] ca2, int p1b, int p1e, int p2b, int p2e, int fragLen, int minLen) {
        int d4;
        int d2;
        int d1 = p1b < p2b ? p1b : p2b;
        int d3 = d1 + (d2 = ca1.length - p1e < ca2.length - p2e ? ca1.length - p1e : ca2.length - p2e) + fragLen;
        return d3 < (d4 = (int)(0.3 * (double)minLen));
    }

    private static final double getRmsd(Atom[] ca1, Atom[] ca2, int fragLen, int p1, int p2, Matrix m, Atom t2) {
        double rmsd = 99.9;
        try {
            Atom[] catmp1 = AFPCalculator.getFragment(ca1, p1, fragLen, false);
            Atom[] catmp2 = AFPCalculator.getFragment(ca2, p2, fragLen, true);
            if (catmp1 == null) {
                System.err.println("could not get fragment for ca1 " + p1 + " " + fragLen);
                return rmsd;
            }
            if (catmp2 == null) {
                System.err.println("could not get fragment for ca2 " + p2 + " " + fragLen);
                return rmsd;
            }
            SVDSuperimposer svd = new SVDSuperimposer(catmp1, catmp2);
            m = svd.getRotation();
            t2 = svd.getTranslation();
            for (Atom a : catmp2) {
                Calc.rotate(a, m);
                Calc.shift(a, t2);
            }
            rmsd = SVDSuperimposer.getRMS(catmp1, catmp2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rmsd;
    }

    private static final Atom[] getFragment(Atom[] caall, int pos, int fragmentLength, boolean clone2) {
        if (pos + fragmentLength > caall.length) {
            return null;
        }
        Atom[] tmp = new Atom[fragmentLength];
        for (int i = 0; i < fragmentLength; ++i) {
            tmp[i] = clone2 ? (Atom)caall[i + pos].clone() : caall[i + pos];
        }
        return tmp;
    }

    private static final double scoreAfp(AFP afp, double badRmsd, double fragScore) {
        double w = afp.getRmsd() / badRmsd;
        w *= w;
        double s = fragScore * (1.0 - w);
        return s;
    }

    public static final void sortAfps(AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        List<AFP> afpSet = afpChain.getAfpSet();
        int pro1Len = ca1.length;
        int pro2Len = ca2.length;
        afpChain.setAfpIndex(new int[pro1Len][pro2Len]);
        afpChain.setAfpAftIndex(new int[pro1Len][pro2Len]);
        afpChain.setAfpBefIndex(new int[pro1Len][pro2Len]);
        int[][] afpIndex = afpChain.getAfpIndex();
        int[][] afpAftIndex = afpChain.getAfpAftIndex();
        int[][] afpBefIndex = afpChain.getAfpBefIndex();
        for (int i = 0; i < pro1Len; ++i) {
            for (int j = 0; j < pro2Len; ++j) {
                afpBefIndex[i][j] = -1;
                afpAftIndex[i][j] = -1;
                afpIndex[i][j] = -1;
            }
        }
        int afpNum = afpSet.size();
        int b0 = 0;
        for (int a = 0; a < afpNum; ++a) {
            int k;
            if (a != afpNum - 1 && afpSet.get(a).getP1() == afpSet.get(a + 1).getP1()) continue;
            int i = afpSet.get(a).getP1();
            for (int b = b0; b <= a; ++b) {
                int j = afpSet.get(b).getP2();
                afpIndex[i][j] = b;
                afpBefIndex[i][j] = b;
                afpAftIndex[i][j] = b;
                if (afpSet.get(b).getP1() == i) continue;
                System.err.println(String.format("Warning: wrong afp index %d %d\n", i, afpSet.get(b).getP1()));
                return;
            }
            for (k = 1; k < pro2Len; ++k) {
                if (afpBefIndex[i][k] != -1) continue;
                afpBefIndex[i][k] = afpBefIndex[i][k - 1];
            }
            for (k = pro2Len - 2; k >= 0; --k) {
                if (afpAftIndex[i][k] != -1) continue;
                afpAftIndex[i][k] = afpAftIndex[i][k + 1];
            }
            b0 = a + 1;
        }
    }
}

