/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.util;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomPositionMap;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.ResidueRange;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.client.StructureName;
import org.biojava.bio.structure.align.util.UserConfiguration;
import org.biojava.bio.structure.cath.CathDomain;
import org.biojava.bio.structure.cath.CathInstallation;
import org.biojava.bio.structure.cath.CathSegment;
import org.biojava.bio.structure.domain.PDPProvider;
import org.biojava.bio.structure.domain.RemotePDPProvider;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.MMCIFFileReader;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava.bio.structure.scop.CachedRemoteScopInstallation;
import org.biojava.bio.structure.scop.ScopDatabase;
import org.biojava.bio.structure.scop.ScopDescription;
import org.biojava.bio.structure.scop.ScopDomain;
import org.biojava.bio.structure.scop.ScopFactory;
import org.biojava3.structure.StructureIO;

public class AtomCache {
    public static final String BIOL_ASSEMBLY_IDENTIFIER = "BIO:";
    public static final String CHAIN_NR_SYMBOL = ":";
    public static final String CHAIN_SPLIT_SYMBOL = ".";
    public static final String PDP_DOMAIN_IDENTIFIER = "PDP:";
    public static final Pattern scopIDregex = Pattern.compile("d(....)(.)(.)");
    public static final String UNDERSCORE = "_";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private boolean fetchCurrent;
    private boolean fetchFileEvenIfObsolete;
    private ScopDatabase scopInstallation;
    protected FileParsingParameters params;
    protected PDPProvider pdpprovider;
    boolean autoFetch;
    String cachePath;
    Collection<String> currentlyLoading = Collections.synchronizedCollection(new TreeSet());
    boolean isSplit;
    String path;
    boolean strictSCOP;
    boolean useMmCif;

    public AtomCache() {
        this(new UserConfiguration());
    }

    public AtomCache(String pdbFilePath, boolean isSplit) {
        if (!pdbFilePath.endsWith(FILE_SEPARATOR)) {
            pdbFilePath = pdbFilePath + FILE_SEPARATOR;
        }
        System.setProperty("biojava.cache.files", "true");
        this.path = pdbFilePath;
        System.setProperty("PDB_DIR", this.path);
        String tmpCache = System.getProperty("PDB_CACHE_DIR");
        if (tmpCache == null || tmpCache.equals("")) {
            tmpCache = pdbFilePath;
        }
        this.cachePath = tmpCache;
        System.setProperty("PDB_CACHE_DIR", this.cachePath);
        this.isSplit = isSplit;
        this.autoFetch = true;
        this.fetchFileEvenIfObsolete = false;
        this.fetchCurrent = false;
        this.currentlyLoading.clear();
        this.params = new FileParsingParameters();
        this.params.setAlignSeqRes(false);
        this.params.setParseSecStruc(false);
        this.strictSCOP = true;
        this.scopInstallation = null;
        this.useMmCif = false;
    }

    public AtomCache(UserConfiguration config) {
        this(config.getPdbFilePath(), config.isSplit());
        this.autoFetch = config.getAutoFetch();
    }

    public Atom[] getAtoms(String name) throws IOException, StructureException {
        Atom[] atoms = null;
        Structure s = null;
        try {
            s = this.getStructure(name);
        }
        catch (StructureException ex) {
            System.err.println("error getting Structure for " + name);
            throw new StructureException(ex.getMessage(), ex);
        }
        atoms = StructureTools.getAtomCAArray(s);
        return atoms;
    }

    @Deprecated
    public Atom[] getAtoms(String name, boolean clone2) throws IOException, StructureException {
        Atom[] atoms = this.getAtoms(name);
        if (clone2) {
            return StructureTools.cloneCAArray(atoms);
        }
        return atoms;
    }

    public Structure getBiologicalAssembly(String pdbId, int bioAssemblyId, boolean bioAssemblyFallback) throws StructureException, IOException {
        if (bioAssemblyId < 1) {
            throw new StructureException("bioAssemblyID must be greater than zero: " + pdbId + " bioAssemblyId " + bioAssemblyId);
        }
        PDBFileReader reader = new PDBFileReader();
        reader.setPath(this.path);
        reader.setPdbDirectorySplit(this.isSplit);
        reader.setAutoFetch(this.autoFetch);
        reader.setFetchFileEvenIfObsolete(this.fetchFileEvenIfObsolete);
        reader.setFetchCurrent(this.fetchCurrent);
        reader.setFileParsingParameters(this.params);
        reader.setBioAssemblyId(bioAssemblyId);
        reader.setBioAssemblyFallback(bioAssemblyFallback);
        Structure s = reader.getStructureById(pdbId.toLowerCase());
        s.setPDBCode(pdbId);
        return s;
    }

    public Structure getBiologicalUnit(String pdbId) throws StructureException, IOException {
        int bioAssemblyId = 1;
        boolean bioAssemblyFallback = true;
        return this.getBiologicalAssembly(pdbId, bioAssemblyId, bioAssemblyFallback);
    }

    public String getCachePath() {
        if (this.cachePath == null || this.cachePath.equals("")) {
            return this.getPath();
        }
        return this.cachePath;
    }

    public FileParsingParameters getFileParsingParams() {
        return this.params;
    }

    public String getPath() {
        return this.path;
    }

    public PDPProvider getPdpprovider() {
        return this.pdpprovider;
    }

    public ScopDatabase getScopInstallation() {
        if (this.scopInstallation == null) {
            this.scopInstallation = ScopFactory.getSCOP();
        }
        return this.scopInstallation;
    }

    public Structure getStructure(String name) throws IOException, StructureException {
        if (name.length() < 4) {
            throw new IllegalArgumentException("Can't interpret IDs that are shorter than 4 residues!");
        }
        Structure n = null;
        boolean useChainNr = false;
        boolean useDomainInfo = false;
        String range2 = null;
        int chainNr = -1;
        try {
            StructureName structureName = new StructureName(name);
            String pdbId = null;
            String chainId = null;
            if (name.length() == 4) {
                pdbId = name;
                Structure s = this.useMmCif ? this.loadStructureFromCifByPdbId(pdbId) : this.loadStructureFromPdbByPdbId(pdbId);
                return s;
            }
            if (structureName.isScopName()) {
                return this.getStructureFromSCOPDomain(name);
            }
            if (structureName.isCathID()) {
                return this.getStructureFromCATHDomain(structureName);
            }
            if (name.length() == 6) {
                pdbId = name.substring(0, 4);
                if (name.substring(4, 5).equals(CHAIN_SPLIT_SYMBOL)) {
                    chainId = name.substring(5, 6);
                } else if (name.substring(4, 5).equals(CHAIN_NR_SYMBOL)) {
                    useChainNr = true;
                    chainNr = Integer.parseInt(name.substring(5, 6));
                }
            } else {
                if (name.startsWith("file:/") || name.startsWith("http:/")) {
                    try {
                        URL url = new URL(name);
                        return this.getStructureFromURL(url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                if (structureName.isPDPDomain()) {
                    try {
                        return this.getPDPStructure(name);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                if (name.startsWith(BIOL_ASSEMBLY_IDENTIFIER)) {
                    try {
                        return this.getBioAssembly(name);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                if (!(name.length() <= 6 || name.startsWith(PDP_DOMAIN_IDENTIFIER) || !name.contains(CHAIN_NR_SYMBOL) && !name.contains(UNDERSCORE) || name.startsWith("file:/") || name.startsWith("http:/"))) {
                    pdbId = name.substring(0, 4);
                    useDomainInfo = true;
                    range2 = name.substring(5);
                }
            }
            if (pdbId == null) {
                return null;
            }
            while (this.checkLoading(pdbId)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    System.err.println(e.getMessage());
                }
            }
            Structure s = this.useMmCif ? this.loadStructureFromCifByPdbId(pdbId) : this.loadStructureFromPdbByPdbId(pdbId);
            n = chainId == null && chainNr < 0 && range2 == null ? StructureTools.getReducedStructure(s, -1) : (useChainNr ? StructureTools.getReducedStructure(s, chainNr) : (useDomainInfo ? StructureTools.getSubRanges(s, range2) : StructureTools.getReducedStructure(s, chainId)));
        }
        catch (Exception e) {
            System.err.println("problem loading:" + name);
            e.printStackTrace();
            throw new StructureException(e.getMessage() + " while parsing " + name, e);
        }
        n.setName(name);
        return n;
    }

    public Structure getStructureForDomain(ScopDomain domain) throws IOException, StructureException {
        if (this.scopInstallation == null) {
            this.scopInstallation = ScopFactory.getSCOP();
        }
        return this.getStructureForDomain(domain, this.scopInstallation);
    }

    public Structure getStructureForDomain(ScopDomain domain, ScopDatabase scopDatabase) throws IOException, StructureException {
        return this.getStructureForDomain(domain, scopDatabase, false);
    }

    public Structure getStructureForDomain(ScopDomain domain, ScopDatabase scopDatabase, boolean strictLigandHandling) throws IOException, StructureException {
        int sf;
        ScopDescription description;
        String pdbId = domain.getPdbId();
        Structure fullStructure = this.getStructure(pdbId);
        StringBuilder rangeString = new StringBuilder();
        Iterator<String> iter2 = domain.getRanges().iterator();
        while (iter2.hasNext()) {
            rangeString.append(iter2.next());
            if (!iter2.hasNext()) continue;
            rangeString.append(",");
        }
        Structure structure = StructureTools.getSubRanges(fullStructure, rangeString.toString());
        structure.setName(domain.getScopId());
        structure.setPDBCode(domain.getScopId());
        AtomPositionMap map2 = null;
        List<ResidueRange> rrs = null;
        if (strictLigandHandling) {
            map2 = new AtomPositionMap(StructureTools.getAllAtomArray(fullStructure), AtomPositionMap.ANYTHING_MATCHER);
            rrs = ResidueRange.parseMultiple(domain.getRanges(), map2);
        }
        for (Chain chain2 : fullStructure.getChains()) {
            if (!structure.hasChain(chain2.getChainID())) continue;
            Chain newChain = structure.getChainByPDB(chain2.getChainID());
            List<Group> ligands = StructureTools.filterLigands(chain2.getAtomGroups());
            for (Group group : ligands) {
                boolean shouldContain = true;
                if (strictLigandHandling) {
                    shouldContain = false;
                    for (ResidueRange rr : rrs) {
                        if (!rr.contains(group.getResidueNumber(), map2)) continue;
                        shouldContain = true;
                    }
                }
                boolean alreadyContains = newChain.getAtomGroups().contains(group);
                if (!shouldContain || alreadyContains) continue;
                newChain.addGroup(group);
            }
        }
        StringBuilder header = new StringBuilder();
        header.append(domain.getClassificationId());
        if (scopDatabase != null && (description = scopDatabase.getScopDescriptionBySunid(sf = domain.getSuperfamilyId())) != null) {
            header.append(" | ");
            header.append(description.getDescription());
        }
        structure.getPDBHeader().setDescription(header.toString());
        return structure;
    }

    public Structure getStructureForDomain(String scopId) throws IOException, StructureException {
        if (this.scopInstallation == null) {
            this.scopInstallation = ScopFactory.getSCOP();
        }
        return this.getStructureForDomain(scopId, this.scopInstallation);
    }

    public Structure getStructureForDomain(String scopId, ScopDatabase scopDatabase) throws IOException, StructureException {
        ScopDomain domain = scopDatabase.getDomainByScopID(scopId);
        return this.getStructureForDomain(domain, scopDatabase);
    }

    public boolean isAutoFetch() {
        return this.autoFetch;
    }

    public boolean isFetchCurrent() {
        return this.fetchCurrent;
    }

    public boolean isFetchFileEvenIfObsolete() {
        return this.fetchFileEvenIfObsolete;
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public boolean isStrictSCOP() {
        return this.strictSCOP;
    }

    public void notifyShutdown() {
        if (this.pdpprovider != null && this.pdpprovider instanceof RemotePDPProvider) {
            RemotePDPProvider remotePDP = (RemotePDPProvider)this.pdpprovider;
            remotePDP.flushCache();
        }
        if (this.scopInstallation != null && this.scopInstallation instanceof CachedRemoteScopInstallation) {
            CachedRemoteScopInstallation cacheScop = (CachedRemoteScopInstallation)this.scopInstallation;
            cacheScop.flushCache();
        }
    }

    public void setAutoFetch(boolean autoFetch) {
        this.autoFetch = autoFetch;
    }

    public void setCachePath(String cachePath) {
        this.cachePath = cachePath;
        System.setProperty("PDB_CACHE_DIR", cachePath);
    }

    public void setFetchCurrent(boolean fetchNewestCurrent) {
        this.fetchCurrent = fetchNewestCurrent;
    }

    public void setFetchFileEvenIfObsolete(boolean fetchFileEvenIfObsolete) {
        this.fetchFileEvenIfObsolete = fetchFileEvenIfObsolete;
    }

    public void setFileParsingParams(FileParsingParameters params) {
        this.params = params;
    }

    public void setPath(String path) {
        System.setProperty("PDB_DIR", path);
        this.path = path;
    }

    public void setPdpprovider(PDPProvider pdpprovider) {
        this.pdpprovider = pdpprovider;
    }

    public void setSplit(boolean isSplit) {
        this.isSplit = isSplit;
    }

    public void setStrictSCOP(boolean strictSCOP) {
        this.strictSCOP = strictSCOP;
    }

    public boolean isUseMmCif() {
        return this.useMmCif;
    }

    public void setUseMmCif(boolean useMmCif) {
        this.useMmCif = useMmCif;
    }

    private boolean checkLoading(String name) {
        return this.currentlyLoading.contains(name);
    }

    private Structure getBioAssembly(String name) throws IOException, StructureException {
        String pdbId = name.substring(4, 8);
        int biolNr = 1;
        if (name.length() > 8) {
            biolNr = Integer.parseInt(name.substring(9, name.length()));
        }
        return StructureIO.getBiologicalAssembly(pdbId, biolNr);
    }

    private Structure getPDPStructure(String pdpDomainName) {
        if (this.pdpprovider == null) {
            this.pdpprovider = new RemotePDPProvider(true);
        }
        return this.pdpprovider.getDomain(pdpDomainName, this);
    }

    private ScopDomain getScopDomain(String scopId) {
        if (this.scopInstallation == null) {
            this.scopInstallation = ScopFactory.getSCOP();
        }
        return this.scopInstallation.getDomainByScopID(scopId);
    }

    private Structure getStructureFromCATHDomain(StructureName structureName) throws IOException, StructureException {
        CathInstallation cathInstall = new CathInstallation(this.path);
        CathDomain cathDomain = cathInstall.getDomainByCathId(structureName.getName());
        List<CathSegment> segments = cathDomain.getSegments();
        StringWriter range2 = new StringWriter();
        int rangePos = 0;
        String chainId = structureName.getChainId();
        for (CathSegment segment : segments) {
            ++rangePos;
            range2.append(chainId);
            range2.append(UNDERSCORE);
            range2.append(segment.getStart());
            range2.append("-");
            range2.append(segment.getStop());
            if (segments.size() <= 1 || rangePos >= segments.size()) continue;
            range2.append(",");
        }
        String pdbId = structureName.getPdbId();
        Structure s = null;
        try {
            s = this.getStructure(pdbId);
        }
        catch (StructureException ex) {
            System.err.println("error getting Structure for " + pdbId);
            throw new StructureException(ex);
        }
        String rangeS = range2.toString();
        System.out.println(rangeS);
        Structure n = StructureTools.getSubRanges(s, rangeS);
        Chain newChain = n.getChainByPDB(structureName.getChainId());
        Chain origChain = s.getChainByPDB(structureName.getChainId());
        List<Group> ligands = origChain.getAtomLigands();
        for (Group g : ligands) {
            if (newChain.getAtomGroups().contains(g)) continue;
            newChain.addGroup(g);
        }
        n.setName(structureName.getName());
        n.setPDBCode(structureName.getPdbId());
        n.getPDBHeader().setDescription(cathDomain.getDomainName());
        return n;
    }

    private Structure getStructureFromSCOPDomain(String name) throws IOException, StructureException {
        Matcher scopMatch;
        ScopDomain domain = this.strictSCOP ? this.getScopDomain(name) : this.guessScopDomain(name);
        System.out.println(domain);
        if (domain != null) {
            Structure s = this.getStructureForDomain(domain);
            return s;
        }
        if (!this.strictSCOP && (scopMatch = scopIDregex.matcher(name)).matches()) {
            Structure struct;
            String pdbID = scopMatch.group(1);
            String chainID = scopMatch.group(2);
            if (!chainID.equals(UNDERSCORE)) {
                pdbID = pdbID + CHAIN_SPLIT_SYMBOL + scopMatch.group(2);
            }
            if ((struct = this.getStructure(pdbID)) != null) {
                System.err.println("Trying chain " + pdbID);
            }
            return struct;
        }
        throw new StructureException("Unable to get structure for SCOP domain: " + name);
    }

    private Structure getStructureFromURL(URL url) throws IOException, StructureException {
        System.out.println("fetching structure from URL:" + url);
        String queryS = url.getQuery();
        String chainId = null;
        if (queryS != null && queryS.startsWith("chainId=")) {
            chainId = queryS.substring(8);
            String fullu = url.toString();
            if (fullu.startsWith("file:") && fullu.endsWith("?" + queryS)) {
                String newu = fullu.substring(0, fullu.length() - ("?" + queryS).length());
                url = new URL(newu);
            }
        }
        PDBFileReader reader = new PDBFileReader();
        reader.setPath(this.path);
        reader.setPdbDirectorySplit(this.isSplit);
        reader.setAutoFetch(this.autoFetch);
        reader.setFetchFileEvenIfObsolete(this.fetchFileEvenIfObsolete);
        reader.setFetchCurrent(this.fetchCurrent);
        reader.setFileParsingParameters(this.params);
        Structure s = reader.getStructure(url);
        if (chainId == null) {
            return StructureTools.getReducedStructure(s, -1);
        }
        return StructureTools.getReducedStructure(s, chainId);
    }

    private ScopDomain guessScopDomain(String name) throws IOException, StructureException {
        Iterator match;
        LinkedList<ScopDomain> matches2 = new LinkedList<ScopDomain>();
        ScopDomain domain = this.getScopDomain(name);
        if (domain != null) {
            return domain;
        }
        System.err.println("Warning, could not find SCOP domain: " + name);
        Matcher scopMatch = scopIDregex.matcher(name);
        if (scopMatch.matches()) {
            String pdbID = scopMatch.group(1);
            String chainID = scopMatch.group(2);
            String domainID = scopMatch.group(3);
            if (this.scopInstallation == null) {
                this.scopInstallation = ScopFactory.getSCOP();
            }
            for (ScopDomain potentialSCOP : this.scopInstallation.getDomainsForPDB(pdbID)) {
                Matcher potMatch = scopIDregex.matcher(potentialSCOP.getScopId());
                if (!potMatch.matches() || !chainID.equals(potMatch.group(2)) && !chainID.equals(UNDERSCORE) && !chainID.equals(CHAIN_SPLIT_SYMBOL) && !potMatch.group(2).equals(UNDERSCORE) && !potMatch.group(2).equals(CHAIN_SPLIT_SYMBOL) || !domainID.equals(potMatch.group(3)) && !domainID.equals(UNDERSCORE) && !potMatch.group(3).equals(UNDERSCORE)) continue;
                matches2.add(potentialSCOP);
            }
        }
        if ((match = matches2.iterator()).hasNext()) {
            ScopDomain bestMatch = (ScopDomain)match.next();
            System.err.print("Trying domain " + bestMatch.getScopId() + CHAIN_SPLIT_SYMBOL);
            if (match.hasNext()) {
                System.err.print(" Other possibilities: ");
                while (match.hasNext()) {
                    System.err.print(((ScopDomain)match.next()).getScopId() + " ");
                }
            }
            System.err.println();
            return bestMatch;
        }
        return null;
    }

    protected void flagLoading(String name) {
        if (!this.currentlyLoading.contains(name)) {
            this.currentlyLoading.add(name);
        }
    }

    protected void flagLoadingFinished(String name) {
        this.currentlyLoading.remove(name);
    }

    protected Structure loadStructureFromCifByPdbId(String pdbId) throws StructureException {
        Structure s;
        this.flagLoading(pdbId);
        try {
            MMCIFFileReader reader = new MMCIFFileReader();
            reader.setPath(this.path);
            reader.setPdbDirectorySplit(this.isSplit);
            reader.setAutoFetch(this.autoFetch);
            reader.setFileParsingParameters(this.params);
            s = reader.getStructureById(pdbId.toLowerCase());
        }
        catch (Exception e) {
            this.flagLoadingFinished(pdbId);
            throw new StructureException(e.getMessage() + " while parsing " + pdbId, e);
        }
        this.flagLoadingFinished(pdbId);
        return s;
    }

    protected Structure loadStructureFromPdbByPdbId(String pdbId) throws StructureException {
        Structure s;
        this.flagLoading(pdbId);
        try {
            PDBFileReader reader = new PDBFileReader();
            reader.setPath(this.path);
            reader.setPdbDirectorySplit(this.isSplit);
            reader.setAutoFetch(this.autoFetch);
            reader.setFetchFileEvenIfObsolete(this.fetchFileEvenIfObsolete);
            reader.setFetchCurrent(this.fetchCurrent);
            reader.setFileParsingParameters(this.params);
            s = reader.getStructureById(pdbId.toLowerCase());
        }
        catch (Exception e) {
            this.flagLoadingFinished(pdbId);
            throw new StructureException(e.getMessage() + " while parsing " + pdbId, e);
        }
        this.flagLoadingFinished(pdbId);
        return s;
    }
}

