/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.math;

import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class SymbolTable<Key extends Comparable<Key>, Value>
implements Iterable<Key>,
Serializable {
    private static final long serialVersionUID = -4417561575046471931L;
    private TreeMap<Key, Value> st = new TreeMap();

    public void put(Key key, Value val) {
        if (val == null) {
            this.st.remove(key);
        } else {
            this.st.put(key, val);
        }
    }

    public Value get(Key key) {
        return this.st.get(key);
    }

    public Value delete(Key key) {
        return this.st.remove(key);
    }

    public boolean contains(Key key) {
        return this.st.containsKey(key);
    }

    public int size() {
        return this.st.size();
    }

    @Override
    public Iterator<Key> iterator() {
        return this.st.keySet().iterator();
    }

    public Iterable<Key> keys() {
        return this.st.keySet();
    }

    public Key min() {
        return (Key)((Comparable)this.st.firstKey());
    }

    public Key max() {
        return (Key)((Comparable)this.st.lastKey());
    }

    public Key ceil(Key k) {
        SortedMap<Key, Value> tail2 = this.st.tailMap(k);
        if (tail2.isEmpty()) {
            return null;
        }
        return (Key)((Comparable)tail2.firstKey());
    }

    public Key floor(Key k) {
        if (this.st.containsKey(k)) {
            return k;
        }
        SortedMap<Key, Value> head2 = this.st.headMap(k);
        if (head2.isEmpty()) {
            return null;
        }
        return (Key)((Comparable)head2.lastKey());
    }
}

