/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava3.core.exceptions.CompoundNotFoundError;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.storage.SequenceAsStringHelper;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.ProxySequenceReader;
import org.biojava3.core.sequence.template.SequenceMixin;
import org.biojava3.core.sequence.template.SequenceProxyView;
import org.biojava3.core.sequence.template.SequenceView;

public class StringProxySequenceReader<C extends Compound>
implements ProxySequenceReader<C> {
    private String sequence;
    private CompoundSet<C> compoundSet;
    private List<C> parsedCompounds = new ArrayList<C>();

    public StringProxySequenceReader() {
    }

    public StringProxySequenceReader(String sequence2, CompoundSet<C> compoundSet) {
        this.sequence = sequence2;
        this.setCompoundSet(compoundSet);
        this.setContents(sequence2);
    }

    @Override
    public void setCompoundSet(CompoundSet<C> compoundSet) {
        this.compoundSet = compoundSet;
    }

    @Override
    public void setContents(String sequence2) {
        String compoundStr;
        this.sequence = sequence2;
        this.parsedCompounds.clear();
        for (int i = 0; i < sequence2.length(); i += compoundStr.length()) {
            compoundStr = null;
            Object compound = null;
            for (int compoundStrLength = 1; compound == null && compoundStrLength <= this.compoundSet.getMaxSingleCompoundStringLength(); ++compoundStrLength) {
                compoundStr = sequence2.substring(i, i + compoundStrLength);
                compound = this.compoundSet.getCompoundForString(compoundStr);
            }
            if (compound == null) {
                throw new CompoundNotFoundError((CharSequence)compoundStr);
            }
            this.parsedCompounds.add(compound);
        }
    }

    @Override
    public int getLength() {
        return this.parsedCompounds.size();
    }

    @Override
    public C getCompoundAt(int position) {
        return (C)((Compound)this.parsedCompounds.get(position - 1));
    }

    @Override
    public int getIndexOf(C compound) {
        return this.parsedCompounds.indexOf(compound) + 1;
    }

    @Override
    public int getLastIndexOf(C compound) {
        return this.parsedCompounds.lastIndexOf(compound) + 1;
    }

    public String toString() {
        return this.getSequenceAsString();
    }

    @Override
    public String getSequenceAsString() {
        return this.sequence;
    }

    @Override
    public List<C> getAsList() {
        return this.parsedCompounds;
    }

    public String getSequenceAsString(Integer bioBegin, Integer bioEnd, Strand strand) {
        SequenceAsStringHelper<C> sequenceAsStringHelper = new SequenceAsStringHelper<C>();
        return sequenceAsStringHelper.getSequenceAsString(this.parsedCompounds, this.compoundSet, bioBegin, bioEnd, strand);
    }

    @Override
    public SequenceView<C> getSubSequence(Integer bioBegin, Integer bioEnd) {
        return new SequenceProxyView(this, bioBegin, bioEnd);
    }

    @Override
    public Iterator<C> iterator() {
        return this.parsedCompounds.iterator();
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.compoundSet;
    }

    @Override
    public AccessionID getAccession() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int countCompounds(C ... compounds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }
}

