/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    public static final boolean DEBUG = false;
    public static final int DEFAULT_LIMIT = 1;
    private final Map<K, SoftReference<V>> map = new HashMap<K, SoftReference<V>>();
    private final int max_limit;
    private final LinkedList<V> hardCache = new LinkedList();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public SoftHashMap() {
        this(1000);
    }

    public SoftHashMap(int hardSize) {
        this.max_limit = hardSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object result2;
        block8: {
            result2 = null;
            SoftReference<V> soft_ref = this.map.get(key);
            if (soft_ref != null) {
                try {
                    result2 = soft_ref.get();
                    if (result2 == null) {
                        this.map.remove(key);
                        break block8;
                    }
                    LinkedList<V> linkedList = this.hardCache;
                    synchronized (linkedList) {
                        this.hardCache.addFirst(result2);
                        if (this.hardCache.size() > this.max_limit) {
                            this.hardCache.removeLast();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return (V)result2;
    }

    private void clearGCCollected() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.map.remove(sv.key);
        }
    }

    @Override
    public synchronized V put(K key, V value2) {
        this.clearGCCollected();
        this.map.put(key, new SoftValue(value2, key, this.queue));
        return value2;
    }

    @Override
    public V remove(Object key) {
        this.clearGCCollected();
        return this.map.remove(key).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LinkedList<V> linkedList = this.hardCache;
        synchronized (linkedList) {
            this.hardCache.clear();
        }
        this.clearGCCollected();
        this.map.clear();
    }

    @Override
    public int size() {
        this.clearGCCollected();
        return this.map.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class SoftValue<K, V>
    extends SoftReference<V> {
        private final Object key;

        private SoftValue(V k, K key, ReferenceQueue<? super V> q) {
            super(k, q);
            this.key = key;
        }
    }
}

