/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class RPTreeHeader {
    private static Logger log = Logger.getLogger(RPTreeHeader.class);
    public final int RPTREE_HEADER_SIZE = 48;
    public final int RPTREE_MAGIC_LTH = 610839776;
    public final int RPTREE_MAGIC_HTL = -525572060;
    private long rpTreeOffset;
    private boolean headerOK;
    private int magic;
    private int blockSize;
    private long itemCount;
    private int startChromID;
    private int startBase;
    private int endChromID;
    private int endBase;
    private long endFileOffset;
    private int itemsPerSlot;
    private long reserved;

    public RPTreeHeader(SeekableStream fis, long fileOffset, boolean isLowToHigh) {
        this.rpTreeOffset = fileOffset;
        this.headerOK = this.readHeader(fis, this.rpTreeOffset, isLowToHigh);
    }

    public boolean isHeaderOK() {
        return this.headerOK;
    }

    public int getHeaderSize() {
        return 48;
    }

    public long getTreeOffset() {
        return this.rpTreeOffset;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getItemCount() {
        return this.itemCount;
    }

    public int getStartChromID() {
        return this.startChromID;
    }

    public int getStartBase() {
        return this.startBase;
    }

    public int getEndChromID() {
        return this.endChromID;
    }

    public int getEndBase() {
        return this.endBase;
    }

    public long getMEndFileOffset() {
        return this.endFileOffset;
    }

    public int getItemsPerSlot() {
        return this.itemsPerSlot;
    }

    public long getReserved() {
        return this.reserved;
    }

    public void print() {
        if (!this.headerOK) {
            log.debug("R+ Tree header is unrecognized type, header magic = " + this.magic);
            return;
        }
        log.debug("R+ tree header has 48 bytes.");
        log.debug("R+ tree header magic = " + this.magic);
        log.debug("R+ Tree file offset = " + this.rpTreeOffset);
        log.debug("magic = " + this.magic);
        log.debug("Block size = " + this.blockSize);
        log.debug("ItemCount = " + this.itemCount);
        log.debug("StartChromID = " + this.startChromID);
        log.debug("StartBase = " + this.startBase);
        log.debug("EndChromID = " + this.endChromID);
        log.debug("EndBase = " + this.endBase);
        log.debug("EndFileOffset = " + this.endFileOffset);
        log.debug("ItemsPerSlot = " + this.itemsPerSlot);
        log.debug("Reserved = " + this.reserved);
    }

    private boolean readHeader(SeekableStream fis, long fileOffset, boolean isLowToHigh) {
        byte[] buffer = new byte[48];
        try {
            fis.seek(fileOffset);
            fis.readFully(buffer);
            if (isLowToHigh) {
                LittleEndianInputStream lbdis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
                this.magic = lbdis.readInt();
                if (this.magic != 610839776) {
                    return false;
                }
                this.blockSize = lbdis.readInt();
                this.itemCount = lbdis.readLong();
                this.startChromID = lbdis.readInt();
                this.startBase = lbdis.readInt();
                this.endChromID = lbdis.readInt();
                this.endBase = lbdis.readInt();
                this.endFileOffset = lbdis.readLong();
                this.itemsPerSlot = lbdis.readInt();
                this.reserved = lbdis.readInt();
            } else {
                DataInputStream bdis = new DataInputStream(new ByteArrayInputStream(buffer));
                this.magic = bdis.readInt();
                if (this.magic != -525572060) {
                    return false;
                }
                this.blockSize = bdis.readInt();
                this.itemCount = bdis.readLong();
                this.startChromID = bdis.readInt();
                this.startBase = bdis.readInt();
                this.endChromID = bdis.readInt();
                this.endBase = bdis.readInt();
                this.endFileOffset = bdis.readLong();
                this.itemsPerSlot = bdis.readInt();
                this.reserved = bdis.readInt();
            }
        }
        catch (IOException ex) {
            log.error("Error reading R+ tree header " + ex);
            throw new RuntimeException("Error reading R+ tree header ", ex);
        }
        return true;
    }
}

