/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.io.Serializable;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;

public class Interval
implements Comparable<Interval>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3547434510230920403L;
    protected int start;
    protected int end;
    protected boolean strandMinus;
    protected String id = "";
    protected String chromosomeNameOri;
    protected Interval parent;

    protected Interval() {
        this.start = -1;
        this.end = -1;
        this.id = null;
        this.strandMinus = false;
        this.parent = null;
    }

    public Interval(Interval parent, int start, int end, boolean strandMinus, String id) {
        this.start = start;
        this.end = end;
        this.id = id;
        this.strandMinus = strandMinus;
        this.parent = parent;
    }

    public Interval clone() {
        try {
            return (Interval)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(Interval i2) {
        if (this.start > i2.start) {
            return 1;
        }
        if (this.start < i2.start) {
            return -1;
        }
        if (this.end > i2.end) {
            return 1;
        }
        if (this.end < i2.end) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Interval interval) {
        return this.compareTo(interval) == 0;
    }

    public Interval findParent(Class clazz) {
        if (this.getClass().equals(clazz)) {
            return this;
        }
        if (this.parent != null && this.parent instanceof Marker) {
            return ((Marker)this.parent).findParent(clazz);
        }
        return null;
    }

    public Chromosome getChromosome() {
        return (Chromosome)this.findParent(Chromosome.class);
    }

    public String getChromosomeName() {
        Chromosome chromo = this.getChromosome();
        if (chromo != null) {
            return chromo.getId();
        }
        return "";
    }

    public String getChromosomeNameOri() {
        return this.chromosomeNameOri;
    }

    public double getChromosomeNum() {
        Chromosome chromo = (Chromosome)this.findParent(Chromosome.class);
        if (chromo != null) {
            return chromo.chromosomeNum;
        }
        return -1.0;
    }

    public int getEnd() {
        return this.end;
    }

    public Genome getGenome() {
        return (Genome)this.findParent(Genome.class);
    }

    public String getGenomeName() {
        Genome genome = (Genome)this.findParent(Genome.class);
        if (genome != null) {
            return genome.getId();
        }
        return "";
    }

    public String getId() {
        return this.id;
    }

    public Interval getParent() {
        return this.parent;
    }

    public int getStart() {
        return this.start;
    }

    public String getStrand() {
        return this.strandMinus ? "-" : "+";
    }

    public int hashCode() {
        int hashCode = this.getChromosomeName().hashCode();
        hashCode = hashCode * 31 + this.start;
        hashCode = hashCode * 31 + this.end;
        hashCode = hashCode * 31 + (this.strandMinus ? -1 : 1);
        if (this.id != null) {
            hashCode = hashCode * 31 + this.id.hashCode();
        }
        return hashCode;
    }

    public boolean intersects(int iStart, int iEnd) {
        return iEnd >= this.start && iStart <= this.end;
    }

    public boolean intersects(Interval interval) {
        return interval.getEnd() >= this.start && interval.getStart() <= this.end;
    }

    public boolean intersects(long point) {
        return (long)this.start <= point && point <= (long)this.end;
    }

    public boolean intersects(Marker interval) {
        if (!interval.getChromosomeName().equals(this.getChromosomeName())) {
            return false;
        }
        return interval.getEnd() >= this.start && interval.getStart() <= this.end;
    }

    public int intersectSize(Marker interval) {
        if (!interval.getChromosomeName().equals(this.getChromosomeName())) {
            return 0;
        }
        int start = Math.max(this.start, interval.getStart());
        int end = Math.min(this.end, interval.getEnd());
        if (end < start) {
            return 0;
        }
        return end - start + 1;
    }

    public boolean isCircular() {
        Chromosome chr = this.getChromosome();
        return this.start < 0 || this.start > this.end || this.end > chr.getEnd();
    }

    public boolean isSameChromo(Marker interval) {
        return interval.getChromosomeName().equals(this.getChromosomeName());
    }

    public boolean isStrandMinus() {
        return this.strandMinus;
    }

    public boolean isStrandPlus() {
        return !this.strandMinus;
    }

    public boolean isValid() {
        return this.start <= this.end;
    }

    public void setChromosomeNameOri(String chromosomeNameOri) {
        this.chromosomeNameOri = chromosomeNameOri;
    }

    public void setEnd(int end) {
        if (end < this.start) {
            throw new RuntimeException("Trying to set end before start:\n\tstart: " + this.start + "\n\tend : " + end + "\n\t" + this);
        }
        this.end = end;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParent(Interval parent) {
        this.parent = parent;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setStrandMinus(boolean strand) {
        this.strandMinus = strand;
    }

    public void shiftCoordinates(int shift) {
        this.start += shift;
        this.end += shift;
    }

    public int size() {
        return this.end - this.start + 1;
    }

    public String toStr() {
        return this.getClass().getSimpleName() + "_" + this.getChromosomeName() + ":" + (this.start + 1) + "-" + (this.end + 1);
    }

    public String toString() {
        return this.start + "-" + this.end + (this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "");
    }

    public String toStringAsciiArt(int maxLen) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxLen; ++i) {
            if (i >= this.start && i <= this.end) {
                sb.append('-');
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }
}

