/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import java.util.Collection;
import java.util.HashSet;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Interval;
import org.snpeff.interval.Marker;
import org.snpeff.interval.SpliceSite;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfLof;
import org.snpeff.vcf.VcfNmd;

public class LossOfFunction {
    public static final String VCF_INFO_NMD_NAME = "NMD";
    public static final String VCF_INFO_LOF_NAME = "LOF";
    public static final int MND_BASES_BEFORE_LAST_JUNCTION = 50;
    public static final double DEFAULT_IGNORE_PROTEIN_CODING_AFTER = 0.95;
    public static final double DEFAULT_IGNORE_PROTEIN_CODING_BEFORE = 0.05;
    public static final double DEFAULT_DELETE_PROTEIN_CODING_BASES = 0.5;
    public double ignoreProteinCodingAfter;
    public double ignoreProteinCodingBefore;
    public double deleteProteinCodingBases;
    Config config;
    HashSet<Transcript> transcriptsLof;
    HashSet<Gene> genesLof;
    HashSet<Transcript> transcriptsNmd;
    HashSet<Gene> genesNmd;
    Collection<VariantEffect> variantEffects;
    int lofCount = -1;
    int nmdCount = -1;

    public LossOfFunction(Config config, Collection<VariantEffect> variantEffects) {
        this.variantEffects = variantEffects;
        this.transcriptsLof = new HashSet();
        this.genesLof = new HashSet();
        this.transcriptsNmd = new HashSet();
        this.genesNmd = new HashSet();
        this.config = config;
        this.ignoreProteinCodingBefore = config.getLofIgnoreProteinCodingBefore();
        this.ignoreProteinCodingAfter = config.getLofIgnoreProteinCodingAfter();
        this.deleteProteinCodingBases = config.getLofDeleteProteinCodingBases();
    }

    public boolean isLof() {
        if (this.lofCount < 0) {
            this.nmdCount = 0;
            this.lofCount = 0;
            for (VariantEffect variantEffect : this.variantEffects) {
                if (!this.isLof(variantEffect)) continue;
                ++this.lofCount;
            }
        }
        return this.lofCount > 0;
    }

    protected boolean isLof(VariantEffect variantEffect) {
        if (variantEffect.getVariant() != null && !variantEffect.getVariant().isVariant()) {
            return false;
        }
        Gene gene = variantEffect.getGene();
        Transcript tr = variantEffect.getTranscript();
        if (gene == null || tr == null || !gene.isProteinCoding() && !this.config.isTreatAllAsProteinCoding() || !tr.isProteinCoding() && !this.config.isTreatAllAsProteinCoding()) {
            return false;
        }
        boolean lof = false;
        if (variantEffect.hasEffectType(EffectType.FRAME_SHIFT)) {
            double perc = this.percentCds(variantEffect);
            lof |= this.ignoreProteinCodingBefore <= perc && perc <= this.ignoreProteinCodingAfter;
        }
        if (variantEffect.getVariant().isDel()) {
            lof |= this.isLofDeletion(variantEffect);
        }
        if (variantEffect.hasEffectType(EffectType.SPLICE_SITE_ACCEPTOR) || variantEffect.hasEffectType(EffectType.SPLICE_SITE_DONOR)) {
            SpliceSite spliceSite;
            if (variantEffect.getMarker() != null && variantEffect.getMarker() instanceof SpliceSite && (spliceSite = (SpliceSite)variantEffect.getMarker()).intersectsCoreSpliceSite(variantEffect.getVariant())) {
                lof = true;
            }
        } else if (variantEffect.hasEffectType(EffectType.STOP_GAINED)) {
            lof |= this.isNmd(variantEffect);
        } else if (variantEffect.hasEffectType(EffectType.RARE_AMINO_ACID)) {
            lof = true;
        } else if (variantEffect.hasEffectType(EffectType.START_LOST)) {
            lof = true;
        }
        if (lof) {
            this.transcriptsLof.add(variantEffect.getTranscript());
            this.genesLof.add(variantEffect.getGene());
        }
        return lof;
    }

    protected boolean isLofDeletion(VariantEffect variantEffect) {
        int end;
        Variant variant;
        Transcript tr = variantEffect.getTranscript();
        if (tr == null) {
            throw new RuntimeException("Transcript not found for change:\n\t" + variantEffect);
        }
        if (variantEffect.hasEffectType(EffectType.TRANSCRIPT_DELETED)) {
            return true;
        }
        if (variantEffect.hasEffectType(EffectType.EXON_DELETED)) {
            variant = variantEffect.getVariant();
            if (variant == null) {
                throw new RuntimeException("Cannot retrieve 'variant' from EXON_DELETED effect!");
            }
            if (variant.includes(tr.getFirstCodingExon())) {
                return true;
            }
        }
        if (variantEffect.hasEffectType(EffectType.GENE_FUSION) || variantEffect.hasEffectType(EffectType.GENE_FUSION_HALF) || variantEffect.hasEffectType(EffectType.GENE_FUSION_REVERESE)) {
            return true;
        }
        variant = variantEffect.getVariant();
        int cdsStart = tr.isStrandPlus() ? tr.getCdsStart() : tr.getCdsEnd();
        int cdsEnd = tr.isStrandPlus() ? tr.getCdsEnd() : tr.getCdsStart();
        Marker coding = new Marker(variant.getChromosome(), cdsStart, cdsEnd, false, "");
        int start = Math.max(cdsStart, variant.getStart());
        if (start >= (end = Math.min(cdsEnd, variant.getEnd()))) {
            return false;
        }
        Marker codingDeleted = new Marker(variant.getChromosome(), start, end, false, "");
        int codingBasesDeleted = 0;
        int codingBases = 0;
        for (Exon exon : tr) {
            codingBasesDeleted += codingDeleted.intersectSize(exon);
            codingBases += coding.intersectSize(exon);
        }
        double percDeleted = (double)codingBasesDeleted / (double)codingBases;
        return percDeleted > this.deleteProteinCodingBases;
    }

    public boolean isNmd() {
        if (this.nmdCount < 0) {
            this.isLof();
        }
        return this.nmdCount > 0;
    }

    protected boolean isNmd(VariantEffect variantEffect) {
        boolean nmd;
        Transcript tr = variantEffect.getTranscript();
        if (tr == null) {
            throw new RuntimeException("Transcript not found for change:\n\t" + variantEffect);
        }
        if (tr.numChilds() <= 1) {
            return false;
        }
        int lastNmdPos = this.lastNmdPos(tr);
        if (lastNmdPos < 0) {
            return false;
        }
        Variant variant = variantEffect.getVariant();
        if (tr.isStrandPlus()) {
            nmd = variant.getStart() <= lastNmdPos;
        } else {
            boolean bl = nmd = lastNmdPos <= variant.getEnd();
        }
        if (nmd) {
            this.transcriptsNmd.add(variantEffect.getTranscript());
            this.genesNmd.add(variantEffect.getGene());
            ++this.nmdCount;
        }
        return nmd;
    }

    public int lastNmdPos(Transcript tr) {
        int cdsEnd = tr.getCdsEnd();
        int cdsStart = tr.getCdsStart();
        Marker cds = new Marker(tr.getChromosome(), Math.min(cdsStart, cdsEnd), Math.max(cdsStart, cdsEnd), tr.isStrandMinus(), "");
        Interval lastExon = null;
        int countCodingExons = 0;
        for (Exon exon : tr.sortedStrand()) {
            if (exon.intersects(cdsEnd)) {
                lastExon = exon;
            }
            if (!cds.intersects(exon)) continue;
            ++countCodingExons;
        }
        if (countCodingExons <= 1) {
            return -1;
        }
        if (lastExon == null) {
            throw new RuntimeException("Cannot find last coding exon for transcript '" + tr.getId() + "' (cdsEnd: " + cdsEnd + ")\n\t" + tr);
        }
        int lastExonJunction = tr.isStrandPlus() ? lastExon.getStart() : lastExon.getEnd();
        int[] chrPos = tr.baseNumberCds2Pos();
        int lastNmdPos = -1;
        for (int cdsi = chrPos.length - 1; cdsi >= 0; --cdsi) {
            if (chrPos[cdsi] != lastExonJunction) continue;
            if (cdsi <= 50) {
                return tr.isStrandPlus() ? 0 : Integer.MAX_VALUE;
            }
            lastNmdPos = chrPos[cdsi - 50 - 1];
            return lastNmdPos;
        }
        throw new RuntimeException("Cannot find last exon junction position for transcript '" + tr.getId() + "'\n\t" + tr);
    }

    void parseNmd(VcfEntry vcfEntry) {
    }

    double percentCds(VariantEffect variantEffect) {
        int cdsLen = variantEffect.getAaLength();
        int codonNum = variantEffect.getCodonNum();
        if (cdsLen >= 0 && codonNum >= 0) {
            return (double)codonNum / (double)cdsLen;
        }
        return Double.NaN;
    }

    double percentOfTranscriptsAffected(Gene gene, HashSet<Transcript> transcripts) {
        if (gene == null) {
            return 0.0;
        }
        int countAffected = 0;
        for (Transcript tr : gene) {
            if (!transcripts.contains(tr)) continue;
            ++countAffected;
        }
        return (double)countAffected / (double)gene.numChilds();
    }

    public String toString() {
        return (this.isLof() ? "LOF=" + this.toStringVcfLof() + " " : "") + (this.isNmd() ? "NMD=" + this.toStringVcfNmd() : "");
    }

    public String toStringVcfLof() {
        StringBuilder sb = new StringBuilder();
        for (Gene gene : this.genesLof) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            double perc = this.percentOfTranscriptsAffected(gene, this.transcriptsLof);
            VcfLof lofent = new VcfLof(gene, perc);
            sb.append(lofent.toString());
        }
        return sb.toString();
    }

    public String toStringVcfNmd() {
        StringBuilder sb = new StringBuilder();
        for (Gene gene : this.genesNmd) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            double perc = this.percentOfTranscriptsAffected(gene, this.transcriptsNmd);
            VcfNmd nmdent = new VcfNmd(gene, perc);
            sb.append(nmdent.toString());
        }
        return sb.toString();
    }
}

