/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import org.junit.Test;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.unity.Save;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;

public class TestCasesMnps
extends TestCasesBase {
    public static int N = 1000;
    String chromoNewSequence = "";
    String codonsOld = "";
    String codonsNew = "";
    int MAX_MNP_LEN = 10;

    void addIfDiff(char[] codonOld, char[] codonNew) {
        String cold = new String(codonOld);
        String cnew = new String(codonNew);
        if (!cold.equals(cnew)) {
            this.codonsOld = this.codonsOld + (this.transcript.isStrandPlus() ? cold : GprSeq.wc(cold));
            this.codonsNew = this.codonsNew + (this.transcript.isStrandPlus() ? cnew : GprSeq.wc(cnew));
        }
    }

    void analyze(int i, int pos, String ref, String mnp) {
        String codons = this.codons();
        Variant variant = new Variant((Marker)this.chromosome, pos, ref + "", mnp + "", "");
        VariantEffects effects = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect effect = null;
        if (effects.size() > 1) {
            for (VariantEffect ce : effects) {
                if (ce.getEffectType() == EffectType.SPLICE_SITE_ACCEPTOR || ce.getEffectType() == EffectType.SPLICE_SITE_DONOR || ce.getEffectType() == EffectType.INTRON || ce.getEffectType() == EffectType.INTERGENIC) continue;
                effect = ce;
            }
        } else {
            effect = effects.get();
        }
        if (effect != null) {
            String effStr = effect.effect(true, true, true, false, false);
            if (codons.length() > 1) {
                boolean error;
                String[] codonsExp = codons.split("/");
                boolean bl = error = !codonsExp[0].toUpperCase().equals(effect.getCodonsRef().toUpperCase()) || !codonsExp[1].toUpperCase().equals(effect.getCodonsAlt().toUpperCase());
                if (error || this.debug) {
                    Gpr.debug("Fatal error:\n\tPos           : " + pos + "\n\tVariant       : " + variant + "\n\tCodon (exp)   : " + codons + "\n\tCodon (pred)  : " + effect.getCodonsRef().toUpperCase() + "/" + effect.getCodonsAlt().toUpperCase() + "\n\tEffect (pred) : " + effStr + "\n\tEffect (pred) : " + effect + "\n\tGene          : " + this.gene + "\n\tChromo        : " + this.chromoSequence);
                }
                if (error) {
                    System.err.println("Error. Dumping data");
                    Save save2 = new Save();
                    save2.snpEffectPredictor = this.snpEffectPredictor;
                    save2.chromoSequence = this.chromoSequence;
                    save2.chromoNewSequence = this.chromoNewSequence;
                    save2.ref = ref;
                    save2.pos = pos;
                    save2.mnp = mnp;
                    String outFile = "/tmp/sep_" + i + "_" + pos + ".bin";
                    Gpr.toFileSerialize(outFile, save2);
                    throw new RuntimeException("Codons do not match!\n\tData dumped: '" + outFile + "'");
                }
            }
        }
    }

    String codons() {
        char[] seq2 = this.chromoSequence.toCharArray();
        char[] seqNew = this.chromoNewSequence.toCharArray();
        this.codonsOld = "";
        this.codonsNew = "";
        int codonIdx = 0;
        int i = 0;
        int step2 = this.transcript.isStrandPlus() ? 1 : -1;
        char[] codonOld = new char[3];
        char[] codonNew = new char[3];
        for (Exon ex : this.transcript.sortedStrand()) {
            int start;
            i = start = ex.isStrandPlus() ? ex.getStart() : ex.getEnd();
            while (ex.intersects(i)) {
                codonOld[codonIdx] = seq2[i];
                codonNew[codonIdx] = seqNew[i];
                if (codonIdx == 2) {
                    this.addIfDiff(codonOld, codonNew);
                }
                i += step2;
                codonIdx = (codonIdx + 1) % 3;
            }
        }
        while (codonIdx != 0) {
            codonOld[codonIdx] = 78;
            codonNew[codonIdx] = 78;
            if (codonIdx == 2) {
                this.addIfDiff(codonOld, codonNew);
            }
            i += step2;
            codonIdx = (codonIdx + 1) % 3;
        }
        return this.codonsOld + "/" + this.codonsNew;
    }

    String createMnp(int pos, int mnpLen) {
        char[] chSeq = this.chromoSequence.toCharArray();
        char[] chSeqNew = this.chromoSequence.toCharArray();
        String mnp = "";
        for (int i = pos; i < pos + mnpLen; ++i) {
            chSeqNew[i] = this.snp(chSeq[i]);
            mnp = mnp + chSeqNew[i];
        }
        this.chromoNewSequence = new String(chSeqNew);
        return mnp;
    }

    @Override
    protected void init() {
        super.init();
        this.randSeed = 20111222;
    }

    char snp(char ref) {
        char snp = ref;
        while (snp == ref) {
            snp = Character.toUpperCase(GprSeq.randBase(this.rand));
        }
        return snp;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.out.println("MNP Test iteration: " + i + "\nChromo:\t" + this.chromoSequence + "\n" + this.transcript);
            } else if (this.verbose) {
                System.out.println("MNP Test iteration: " + i + "\t" + (this.transcript.isStrandPlus() ? "+" : "-") + "\t" + this.transcript.cds());
            } else {
                Gpr.showMark(i + 1, 1);
            }
            if (this.debug) {
                for (Exon exon : this.transcript.sortedStrand()) {
                    System.out.println("\tExon: " + exon + "\tSEQ:\t" + (exon.isStrandMinus() ? GprSeq.reverseWc(exon.getSequence()) : exon.getSequence()).toUpperCase());
                }
            }
            for (int pos = 0; pos < this.chromoSequence.length() - 2; ++pos) {
                int mnpLen = this.rand.nextInt(this.MAX_MNP_LEN) + 2;
                int maxMnpLen = this.chromoSequence.length() - pos;
                mnpLen = Math.min(mnpLen, maxMnpLen);
                String ref = this.chromoSequence.substring(pos, pos + mnpLen);
                String mnp = this.createMnp(pos, mnpLen);
                this.analyze(i, pos, ref, mnp);
            }
        }
        System.err.println("");
    }
}

