/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.codons.CodonTable;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;

public class TestCasesSnps
extends TestCasesBase {
    public static int N = 1000;

    String effectStr(VariantEffect effect) {
        String effStr = effect.effect(true, true, true, false, false);
        String aaStr = effect.getAaChangeOld();
        int idx = effStr.indexOf(40);
        return effStr.substring(0, idx) + "(" + aaStr + ")";
    }

    @Override
    protected void init() {
        super.init();
        this.randSeed = 20100629;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        CodonTable codonTable = this.genome.codonTable();
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.out.println("SNP Test iteration: " + i + "\n" + this.transcript);
            } else if (this.verbose) {
                System.out.println("SNP Test iteration: " + i + "\t" + this.transcript.getStrand() + "\t" + this.transcript.cds());
            } else {
                Gpr.showMark(i + 1, 1);
            }
            int cdsBaseNum = 0;
            for (Exon exon : this.transcript.sortedStrand()) {
                int beg;
                int step2 = exon.isStrandPlus() ? 1 : -1;
                int pos = beg = exon.isStrandPlus() ? exon.getStart() : exon.getEnd();
                while (pos >= exon.getStart() && pos <= exon.getEnd()) {
                    char refBase = this.chromoBases[pos];
                    refBase = Character.toUpperCase(refBase);
                    int cdsCodonNum = cdsBaseNum / 3;
                    int cdsCodonPos = cdsBaseNum % 3;
                    int minCodonPos = cdsCodonNum * 3;
                    int maxCodonPos = minCodonPos + 3;
                    if (maxCodonPos < this.transcript.cds().length()) {
                        VariantEffects effects;
                        Variant variant;
                        String codon = this.transcript.cds().substring(minCodonPos, maxCodonPos);
                        codon = codon.toUpperCase();
                        String aa = codonTable.aa(codon);
                        char snp = refBase;
                        while (snp == refBase) {
                            snp = Character.toUpperCase(GprSeq.randBase(this.rand));
                        }
                        String newCodon = codon.substring(0, cdsCodonPos) + snp + codon.substring(cdsCodonPos + 1);
                        String newAa = codonTable.aa(newCodon);
                        String effectExpected = "";
                        effectExpected = newAa.equals(aa) ? (cdsCodonNum == 0 && codonTable.isStart(codon) ? (codonTable.isStart(newCodon) ? "SYNONYMOUS_START(" + aa + ")" : "START_LOST(" + aa + ")") : (aa.equals("*") ? "SYNONYMOUS_STOP(" + aa + ")" : "SYNONYMOUS_CODING(" + aa + ")")) : (cdsCodonNum == 0 && codonTable.isStart(codon) ? (codonTable.isStart(newCodon) ? "NON_SYNONYMOUS_START(" + aa + "/" + newAa + ")" : "START_LOST(" + aa + "/" + newAa + ")") : (codonTable.isStop(codon) ? "STOP_LOST(" + aa + "/" + newAa + ")" : (codonTable.isStop(newCodon) ? "STOP_GAINED(" + aa + "/" + newAa + ")" : "NON_SYNONYMOUS_CODING(" + aa + "/" + newAa + ")")));
                        if (exon.isStrandMinus()) {
                            snp = GprSeq.wc(snp);
                            refBase = GprSeq.wc(refBase);
                        }
                        if (!(variant = new Variant((Marker)this.chromosome, pos, refBase + "", snp + "", "")).isVariant()) {
                            effectExpected = "EXON";
                        }
                        Assert.assertEquals(true, (effects = this.snpEffectPredictor.variantEffect(variant)).size() == 1);
                        if (this.debug) {
                            System.out.println(effects);
                        }
                        VariantEffect effect = effects.get();
                        String effStr = this.effectStr(effect);
                        if (this.debug) {
                            System.out.println("\tPos: " + pos + "\tCDS base num: " + cdsBaseNum + " [" + cdsCodonNum + ":" + cdsCodonPos + "]\t" + variant + "\tCodon: " + codon + " -> " + newCodon + "\tAA: " + aa + " -> " + newAa + "\tEffect: " + effStr);
                        }
                        Assert.assertEquals(effectExpected, effStr);
                    }
                    pos += step2;
                    ++cdsBaseNum;
                }
            }
        }
        System.err.println("");
    }
}

