/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import com.typesafe.config.ConfigOrigin;

public abstract class ConfigException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final ConfigOrigin origin;

    protected ConfigException(ConfigOrigin configOrigin, String string2, Throwable throwable) {
        super(configOrigin.description() + ": " + string2, throwable);
        this.origin = configOrigin;
    }

    protected ConfigException(ConfigOrigin configOrigin, String string2) {
        this(configOrigin.description() + ": " + string2, null);
    }

    protected ConfigException(String string2, Throwable throwable) {
        super(string2, throwable);
        this.origin = null;
    }

    protected ConfigException(String string2) {
        this(string2, null);
    }

    public ConfigOrigin origin() {
        return this.origin;
    }

    public static class Generic
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public Generic(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        public Generic(String string2) {
            this(string2, null);
        }
    }

    public static class ValidationFailed
    extends ConfigException {
        private static final long serialVersionUID = 1L;
        private final Iterable<ValidationProblem> problems;

        public ValidationFailed(Iterable<ValidationProblem> iterable) {
            super(ValidationFailed.makeMessage(iterable), null);
            this.problems = iterable;
        }

        public Iterable<ValidationProblem> problems() {
            return this.problems;
        }

        private static String makeMessage(Iterable<ValidationProblem> iterable) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ValidationProblem validationProblem : iterable) {
                stringBuilder.append(validationProblem.origin().description());
                stringBuilder.append(": ");
                stringBuilder.append(validationProblem.path());
                stringBuilder.append(": ");
                stringBuilder.append(validationProblem.problem());
                stringBuilder.append(", ");
            }
            if (stringBuilder.length() == 0) {
                throw new BugOrBroken("ValidationFailed must have a non-empty list of problems");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            return stringBuilder.toString();
        }
    }

    public static class ValidationProblem {
        private final String path;
        private final ConfigOrigin origin;
        private final String problem;

        public ValidationProblem(String string2, ConfigOrigin configOrigin, String string3) {
            this.path = string2;
            this.origin = configOrigin;
            this.problem = string3;
        }

        public String path() {
            return this.path;
        }

        public ConfigOrigin origin() {
            return this.origin;
        }

        public String problem() {
            return this.problem;
        }
    }

    public static class NotResolved
    extends BugOrBroken {
        private static final long serialVersionUID = 1L;

        public NotResolved(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        public NotResolved(String string2) {
            this(string2, null);
        }
    }

    public static class UnresolvedSubstitution
    extends Parse {
        private static final long serialVersionUID = 1L;

        public UnresolvedSubstitution(ConfigOrigin configOrigin, String string2, Throwable throwable) {
            super(configOrigin, "Could not resolve substitution to a value: " + string2, throwable);
        }

        public UnresolvedSubstitution(ConfigOrigin configOrigin, String string2) {
            this(configOrigin, string2, null);
        }
    }

    public static class Parse
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public Parse(ConfigOrigin configOrigin, String string2, Throwable throwable) {
            super(configOrigin, string2, throwable);
        }

        public Parse(ConfigOrigin configOrigin, String string2) {
            this(configOrigin, string2, null);
        }
    }

    public static class IO
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public IO(ConfigOrigin configOrigin, String string2, Throwable throwable) {
            super(configOrigin, string2, throwable);
        }

        public IO(ConfigOrigin configOrigin, String string2) {
            this(configOrigin, string2, null);
        }
    }

    public static class BugOrBroken
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public BugOrBroken(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        public BugOrBroken(String string2) {
            this(string2, null);
        }
    }

    public static class BadPath
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public BadPath(ConfigOrigin configOrigin, String string2, String string3, Throwable throwable) {
            super(configOrigin, string2 != null ? "Invalid path '" + string2 + "': " + string3 : string3, throwable);
        }

        public BadPath(ConfigOrigin configOrigin, String string2, String string3) {
            this(configOrigin, string2, string3, null);
        }

        public BadPath(String string2, String string3, Throwable throwable) {
            super(string2 != null ? "Invalid path '" + string2 + "': " + string3 : string3, throwable);
        }

        public BadPath(String string2, String string3) {
            this(string2, string3, null);
        }

        public BadPath(ConfigOrigin configOrigin, String string2) {
            this(configOrigin, null, string2);
        }
    }

    public static class BadValue
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public BadValue(ConfigOrigin configOrigin, String string2, String string3, Throwable throwable) {
            super(configOrigin, "Invalid value at '" + string2 + "': " + string3, throwable);
        }

        public BadValue(ConfigOrigin configOrigin, String string2, String string3) {
            this(configOrigin, string2, string3, null);
        }

        public BadValue(String string2, String string3, Throwable throwable) {
            super("Invalid value at '" + string2 + "': " + string3, throwable);
        }

        public BadValue(String string2, String string3) {
            this(string2, string3, null);
        }
    }

    public static class Null
    extends Missing {
        private static final long serialVersionUID = 1L;

        private static String makeMessage(String string2, String string3) {
            if (string3 != null) {
                return "Configuration key '" + string2 + "' is set to null but expected " + string3;
            }
            return "Configuration key '" + string2 + "' is null";
        }

        public Null(ConfigOrigin configOrigin, String string2, String string3, Throwable throwable) {
            super(configOrigin, Null.makeMessage(string2, string3), throwable);
        }

        public Null(ConfigOrigin configOrigin, String string2, String string3) {
            this(configOrigin, string2, string3, null);
        }
    }

    public static class Missing
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public Missing(String string2, Throwable throwable) {
            super("No configuration setting found for key '" + string2 + "'", throwable);
        }

        public Missing(String string2) {
            this(string2, null);
        }

        protected Missing(ConfigOrigin configOrigin, String string2, Throwable throwable) {
            super(configOrigin, string2, throwable);
        }

        protected Missing(ConfigOrigin configOrigin, String string2) {
            this(configOrigin, string2, null);
        }
    }

    public static class WrongType
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public WrongType(ConfigOrigin configOrigin, String string2, String string3, String string4, Throwable throwable) {
            super(configOrigin, string2 + " has type " + string4 + " rather than " + string3, throwable);
        }

        public WrongType(ConfigOrigin configOrigin, String string2, String string3, String string4) {
            this(configOrigin, string2, string3, string4, null);
        }

        WrongType(ConfigOrigin configOrigin, String string2, Throwable throwable) {
            super(configOrigin, string2, throwable);
        }

        WrongType(ConfigOrigin configOrigin, String string2) {
            this(configOrigin, string2, null);
        }
    }
}

