/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import java.util.Arrays;
import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;

public class Sigmoid
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction {
    private final double lo;
    private final double hi;

    public Sigmoid() {
        this(0.0, 1.0);
    }

    public Sigmoid(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    public double value(double x2) {
        return Sigmoid.value(x2, this.lo, this.hi);
    }

    private static double value(double x2, double lo, double hi) {
        return lo + (hi - lo) / (1.0 + FastMath.exp(-x2));
    }

    public DerivativeStructure value(DerivativeStructure t) throws DimensionMismatchException {
        double[] f2 = new double[t.getOrder() + 1];
        double exp = FastMath.exp(-t.getValue());
        if (Double.isInfinite(exp)) {
            f2[0] = this.lo;
            Arrays.fill(f2, 1, f2.length, 0.0);
        } else {
            double[] p = new double[f2.length];
            double inv = 1.0 / (1.0 + exp);
            double coeff = this.hi - this.lo;
            for (int n = 0; n < f2.length; ++n) {
                double v = 0.0;
                p[n] = 1.0;
                for (int k = n; k >= 0; --k) {
                    v = v * exp + p[k];
                    if (k > 1) {
                        p[k - 1] = (double)(n - k + 2) * p[k - 2] - (double)(k - 1) * p[k - 1];
                        continue;
                    }
                    p[0] = 0.0;
                }
                f2[n] = (coeff *= inv) * v;
            }
            f2[0] = f2[0] + this.lo;
        }
        return t.compose(f2);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double x2, double ... param2) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param2);
            return Sigmoid.value(x2, param2[0], param2[1]);
        }

        public double[] gradient(double x2, double ... param2) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param2);
            double invExp1 = 1.0 / (1.0 + FastMath.exp(-x2));
            return new double[]{1.0 - invExp1, invExp1};
        }

        private void validateParameters(double[] param2) throws NullArgumentException, DimensionMismatchException {
            if (param2 == null) {
                throw new NullArgumentException();
            }
            if (param2.length != 2) {
                throw new DimensionMismatchException(param2.length, 2);
            }
        }
    }
}

