/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.annotation.Annotation;
import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.JUnit4TestAdapter;
import junit.framework.JUnit4TestCaseFacade;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit38ClassRunner
extends Runner
implements Filterable,
Sortable {
    private Test fTest;

    public JUnit38ClassRunner(Class<?> klass) {
        this(new TestSuite((Class<? extends TestCase>)klass.asSubclass(TestCase.class)));
    }

    public JUnit38ClassRunner(Test test2) {
        this.fTest = test2;
    }

    @Override
    public void run(RunNotifier notifier) {
        TestResult result2 = new TestResult();
        result2.addListener(JUnit38ClassRunner.createAdaptingListener(notifier));
        this.fTest.run(result2);
    }

    public static TestListener createAdaptingListener(RunNotifier notifier) {
        return new OldTestClassAdaptingListener(notifier);
    }

    @Override
    public Description getDescription() {
        return this.makeDescription(this.fTest);
    }

    private Description makeDescription(Test test2) {
        if (test2 instanceof TestCase) {
            TestCase tc = (TestCase)test2;
            return Description.createTestDescription(tc.getClass(), tc.getName());
        }
        if (test2 instanceof TestSuite) {
            TestSuite ts = (TestSuite)test2;
            String name = ts.getName() == null ? "" : ts.getName();
            Description description = Description.createSuiteDescription(name, new Annotation[0]);
            int n = ts.testCount();
            for (int i = 0; i < n; ++i) {
                description.addChild(this.makeDescription(ts.testAt(i)));
            }
            return description;
        }
        if (test2 instanceof JUnit4TestAdapter) {
            JUnit4TestAdapter adapter = (JUnit4TestAdapter)test2;
            return adapter.getDescription();
        }
        if (test2 instanceof TestDecorator) {
            TestDecorator decorator = (TestDecorator)test2;
            return this.makeDescription(decorator.getTest());
        }
        return Description.createSuiteDescription(test2.getClass());
    }

    @Override
    public void filter(Filter filter2) throws NoTestsRemainException {
        if (this.fTest instanceof JUnit4TestAdapter) {
            JUnit4TestAdapter adapter = (JUnit4TestAdapter)this.fTest;
            adapter.filter(filter2);
        }
    }

    @Override
    public void sort(Sorter sorter) {
        if (this.fTest instanceof JUnit4TestAdapter) {
            JUnit4TestAdapter adapter = (JUnit4TestAdapter)this.fTest;
            adapter.sort(sorter);
        }
    }

    private static final class OldTestClassAdaptingListener
    implements TestListener {
        private final RunNotifier fNotifier;

        private OldTestClassAdaptingListener(RunNotifier notifier) {
            this.fNotifier = notifier;
        }

        public void endTest(Test test2) {
            this.fNotifier.fireTestFinished(this.asDescription(test2));
        }

        public void startTest(Test test2) {
            this.fNotifier.fireTestStarted(this.asDescription(test2));
        }

        public void addError(Test test2, Throwable t) {
            Failure failure2 = new Failure(this.asDescription(test2), t);
            this.fNotifier.fireTestFailure(failure2);
        }

        private Description asDescription(Test test2) {
            if (test2 instanceof JUnit4TestCaseFacade) {
                JUnit4TestCaseFacade facade = (JUnit4TestCaseFacade)test2;
                return facade.getDescription();
            }
            return Description.createTestDescription(test2.getClass(), this.getName(test2));
        }

        private String getName(Test test2) {
            if (test2 instanceof TestCase) {
                return ((TestCase)test2).getName();
            }
            return test2.toString();
        }

        public void addFailure(Test test2, AssertionFailedError t) {
            this.addError(test2, (Throwable)((Object)t));
        }
    }
}

