/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;

public class TestCasesIntegrationEmbl
extends TestCasesIntegrationBase {
    public static boolean debug = false;
    int exonToStringVersionOri;

    @After
    public void after() {
        Exon.ToStringVersion = this.exonToStringVersionOri;
    }

    @Before
    public void before() {
        this.exonToStringVersionOri = Exon.ToStringVersion;
        Exon.ToStringVersion = 1;
    }

    @Test
    public void testCase_Exon_Simple() {
        Gpr.debug("Test");
        String genome = "testEmblPberghei";
        String resultFile = "tests/testEmblPberghei.genes.embl";
        SnpEffectPredictor sep = this.buildEmbl(genome, resultFile);
        int pos = 4055;
        for (Gene g : sep.getGenome().getGenes()) {
            if (debug) {
                System.out.println("Gene: '" + g.getGeneName() + "', '" + g.getId() + "'");
            }
            for (Transcript tr : g) {
                if (debug) {
                    System.out.println("\tTranscript: '" + tr.getId() + "'");
                }
                for (Exon e : tr) {
                    if (debug) {
                        System.out.println("\t\tExon (" + e.getStrand() + "): '" + e.getId() + "'\t" + e.toStr());
                    }
                    if (!e.intersects(pos)) continue;
                    String seq2 = e.getSequence();
                    String base = e.basesAtPos(pos, 1);
                    if (debug) {
                        System.out.println("Seq : " + seq2 + "\nBase: " + base);
                    }
                    Assert.assertEquals("g", base);
                }
            }
        }
    }
}

