/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.snpEffect.testCases.integration.CompareToVep;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationMixedVariants {
    boolean debug;
    boolean verbose;

    public TestCasesIntegrationMixedVariants() {
        this.verbose = this.debug = false;
    }

    public void compareVep(String genome, String vcf) {
        CompareToVep comp = new CompareToVep(genome, this.verbose);
        comp.compareVep(vcf);
        if (this.verbose) {
            System.out.println(comp);
        }
        Assert.assertTrue("No comparissons were made!", comp.checkComapred());
    }

    @Test
    public void test_01_MixedVep() {
        Gpr.debug("Test");
        String vcfFile = "tests/mixed_01.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (Variant var : ve.variants()) {
                if (!this.verbose) continue;
                System.out.println("\t" + var);
            }
        }
    }

    @Test
    public void test_02_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr22", "tests/mixed_chr22.vcf");
    }

    @Test
    public void test_03_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr14", "tests/mixed_chr14.vcf");
    }

    @Test
    public void test_04_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr12", "tests/mixed_chr12.vcf");
    }

    @Test
    public void test_05_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr22", "tests/mixed_chr22.vcf");
    }

    @Test
    public void test_06_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr7", "tests/mixed_chr7.vcf");
    }

    @Test
    public void test_07_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr6", "tests/mixed_chr6.vcf");
    }

    @Test
    public void test_08_MixedVep() {
        Gpr.debug("Test");
        this.compareVep("testHg3775Chr1", "tests/mixed_chr1.vcf");
    }

    @Test
    public void test_09_MixedVep() {
        Gpr.debug("Test");
        String vcfFileName = "tests/mixed_09.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (Variant v : ve.variants()) {
                if (this.verbose) {
                    System.out.println("\t\t" + v);
                }
                Assert.assertTrue("Variant is not MIXED", v.getVariantType() == Variant.VariantType.MIXED);
            }
        }
    }

    @Test
    public void test_11_ExonRank() {
        Gpr.debug("Test");
        String vcfFileName = "tests/mixed_11.vcf";
        String[] args = new String[]{"testHg19Chr20", vcfFileName};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff snpeff = (SnpEffCmdEff)cmd.cmd();
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setVerbose(this.verbose);
        List<VcfEntry> vcfEnties = snpeff.run(true);
        VcfEntry ve = vcfEnties.get(0);
        List<VcfEffect> veffs = ve.getVcfEffects();
        VcfEffect veff = veffs.get(0);
        Assert.assertEquals("Exon rank does not match", 12L, veff.getRank());
    }
}

