/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.snpeff.binseq.GenomicSequences;
import org.snpeff.codons.CodonTable;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryRand;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesBase {
    protected boolean debug;
    protected boolean verbose;
    protected int randSeed;
    protected String genomeName;
    protected boolean addUtrs;
    protected boolean onlyPlusStrand;
    protected boolean onlyMinusStrand;
    protected boolean shiftHgvs;
    protected int numGenes;
    protected int maxGeneLen;
    protected int maxTranscripts;
    protected int maxExons;
    protected int minExons;
    protected int spliceRegionExonSize;
    protected int spliceRegionIntronMin;
    protected int spliceRegionIntronMax;
    protected Random rand;
    protected Config config;
    protected Genome genome;
    protected Chromosome chromosome;
    protected Gene gene;
    protected Transcript transcript;
    protected SnpEffectPredictor snpEffectPredictor;
    protected String chromoSequence;
    protected char[] chromoBases;
    protected CodonTable codonTable;

    public TestCasesBase() {
        this.verbose = this.debug = false;
        this.numGenes = 1;
        this.spliceRegionExonSize = 0;
        this.spliceRegionIntronMin = 0;
        this.spliceRegionIntronMax = 0;
        this.chromoSequence = "";
    }

    @After
    public void after() {
        this.config = null;
        this.codonTable = null;
        this.genome = null;
        this.chromosome = null;
        this.gene = null;
        this.transcript = null;
        this.snpEffectPredictor = null;
        this.chromoBases = null;
        this.chromoSequence = null;
    }

    @Before
    public void before() {
        this.init();
        this.initSnpEffPredictor();
    }

    public void checkApply(Variant variant, Variant.VariantType varType, String expectedCds, String expectedProtein, int exonRank, int expectedExon1Start, int expectedExon1End) {
        Transcript newTr = this.transcript.apply(variant);
        if (this.debug) {
            Gpr.debug("Variant " + (Object)((Object)variant.getVariantType()) + " [ " + variant.getStart() + " , " + variant.getEnd() + "], REF len: " + variant.getReference().length() + ", ALT len: " + variant.getAlt().length() + ":" + variant + "\nBefore:\n" + this.transcript.toStringAsciiArt(true) + "\nAfter:\n" + newTr.toStringAsciiArt(true));
        } else if (this.verbose) {
            Gpr.debug("Variant " + (Object)((Object)variant.getVariantType()) + " [ " + variant.getStart() + " , " + variant.getEnd() + "], REF len: " + variant.getReference().length() + ", ALT len: " + variant.getAlt().length() + ":" + variant + "\nBefore:\n" + Gpr.prependEachLine("\t", this.transcript) + "\nAfter:\n" + Gpr.prependEachLine("\t", newTr));
        }
        if (!variant.getReference().isEmpty()) {
            String chrSeq = this.chromoSequence.substring(variant.getStart(), variant.getEnd() + 1);
            Assert.assertEquals("Reference sequence does not match: " + chrSeq + " vs " + variant.getReference(), chrSeq, variant.getReference());
        }
        Assert.assertEquals("Variant type does not match: " + (Object)((Object)varType) + " vs " + (Object)((Object)variant.getVariantType()), (Object)varType, (Object)variant.getVariantType());
        Assert.assertEquals("CDS sequence should not change", expectedCds, newTr.cds());
        if (expectedProtein != null) {
            Assert.assertEquals("Protein sequence should not change", expectedProtein, newTr.protein());
        }
        Exon newEx1 = (Exon)newTr.sorted().get(1);
        Assert.assertEquals("Exon start coordinate", expectedExon1Start, newEx1.getStart());
        Assert.assertEquals("Exon end coordinate", expectedExon1End, newEx1.getEnd());
    }

    public void checkApplyDel(Variant variant, String expectedCds, String expectedProtein, int exonRank, int expectedExon1Start, int expectedExon1End) {
        this.checkApply(variant, Variant.VariantType.DEL, expectedCds, expectedProtein, exonRank, expectedExon1Start, expectedExon1End);
    }

    public void checkApplyIns(Variant variant, String expectedCds, String expectedProtein, int exonRank, int expectedExon1Start, int expectedExon1End) {
        this.checkApply(variant, Variant.VariantType.INS, expectedCds, expectedProtein, exonRank, expectedExon1Start, expectedExon1End);
    }

    public void checkApplyMixed(Variant variant, String expectedCds, String expectedProtein, int exonRank, int expectedExon1Start, int expectedExon1End) {
        this.checkApply(variant, Variant.VariantType.MIXED, expectedCds, expectedProtein, exonRank, expectedExon1Start, expectedExon1End);
    }

    public void checkApplyMnp(Variant variant, String expectedCds, String expectedProtein, int exonRank, int expectedExon1Start, int expectedExon1End) {
        this.checkApply(variant, Variant.VariantType.MNP, expectedCds, expectedProtein, exonRank, expectedExon1Start, expectedExon1End);
    }

    public void checkApplySnp(Variant variant, String expectedCds, String expectedProtein, int exonRank, int expectedExon1Start, int expectedExon1End) {
        this.checkApply(variant, Variant.VariantType.SNP, expectedCds, expectedProtein, exonRank, expectedExon1Start, expectedExon1End);
    }

    protected void checkEffect(Variant variant, EffectType effectExpected) {
        this.checkEffect(variant, effectExpected, null, null);
    }

    protected void checkEffect(Variant variant, EffectType effectExpected, EffectType effectNotExpected, VariantEffect.EffectImpact impact) {
        VariantEffects effects = this.snpEffectPredictor.variantEffect(variant);
        boolean found = false;
        for (VariantEffect effect : effects) {
            String effStr = effect.getEffectTypeString(false);
            if (this.verbose) {
                System.out.println(effect.toStringSimple(true) + "\n\tEffect type: '" + effStr + "'\tExpected: '" + (Object)((Object)effectExpected) + "'");
            }
            found |= effect.hasEffectType(effectExpected);
            if (effectNotExpected != null && effect.hasEffectType(effectNotExpected)) {
                throw new RuntimeException("Effect '" + (Object)((Object)effectNotExpected) + "' should not be here");
            }
            if (impact == null || effect.getEffectImpact() == impact) continue;
            throw new RuntimeException("Effect '" + (Object)((Object)effectExpected) + "' should have impact '" + (Object)((Object)impact) + "', but impct was '" + (Object)((Object)effect.getEffectImpact()) + "'.");
        }
        Assert.assertTrue("Effect not found: '" + (Object)((Object)effectExpected) + "' in variant " + variant, found);
    }

    protected EffFormatVersion formatVersion(String vcfFileName) {
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        VcfEntry ve = (VcfEntry)vcf.next();
        List<VcfEffect> effs = ve.getVcfEffects();
        if (effs.isEmpty()) {
            throw new RuntimeException("Empty list of effects. Tis should never happen!");
        }
        VcfEffect eff = effs.get(0);
        return eff.formatVersion();
    }

    protected boolean hasEffect(String effectExpected, String effStr) {
        for (String eff : effStr.split("&")) {
            if (!eff.equals(effectExpected)) continue;
            return true;
        }
        return false;
    }

    protected void init() {
        this.randSeed = 20141128;
        this.genomeName = "testCase";
        this.addUtrs = false;
        this.onlyPlusStrand = true;
        this.onlyMinusStrand = false;
        this.numGenes = 1;
        this.maxGeneLen = 1000;
        this.maxTranscripts = 1;
        this.maxExons = 5;
        this.minExons = 1;
        this.shiftHgvs = false;
        this.initRand();
    }

    protected void initRand() {
        this.rand = new Random(this.randSeed);
    }

    protected void initSnpEffPredictor() {
        this.initSnpEffPredictor(null);
    }

    protected void initSnpEffPredictor(Gene[] genesToAdd) {
        if (this.config == null || this.config.getGenome() == null || !this.config.getGenome().getGenomeName().equals(this.genomeName)) {
            this.config = new Config(this.genomeName, "snpEff.config");
        }
        SnpEffPredictorFactoryRand sepf = new SnpEffPredictorFactoryRand(this.config, this.rand, this.maxGeneLen, this.maxTranscripts, this.maxExons);
        sepf.setNumGenes(this.numGenes);
        sepf.setForcePositiveStrand(this.onlyPlusStrand);
        sepf.setForceNegativeStrand(this.onlyMinusStrand);
        sepf.setAddUtrs(this.addUtrs);
        sepf.setMinExons(this.minExons);
        if (genesToAdd != null) {
            for (Gene g : genesToAdd) {
                this.snpEffectPredictor.add(g);
            }
        }
        this.snpEffectPredictor = sepf.create();
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.config.setHgvsShift(this.shiftHgvs);
        this.snpEffectPredictor.setSpliceRegionExonSize(this.spliceRegionExonSize);
        this.snpEffectPredictor.setSpliceRegionIntronMin(this.spliceRegionIntronMin);
        this.snpEffectPredictor.setSpliceRegionIntronMax(this.spliceRegionIntronMax);
        this.snpEffectPredictor.setUpDownStreamLength(0);
        this.chromoSequence = sepf.getChromoSequence();
        this.chromoBases = this.chromoSequence.toCharArray();
        this.snpEffectPredictor.buildForest();
        this.chromosome = sepf.getChromo();
        this.genome = this.config.getGenome();
        this.codonTable = this.genome.codonTable();
        this.gene = this.genome.getGenes().iterator().next();
        this.transcript = (Transcript)this.gene.iterator().next();
        this.genome.getGenomicSequences().clear();
        this.genome.getGenomicSequences().addGeneSequences(this.chromosome.getId(), this.chromoSequence);
    }

    protected void prependSequenceToFirstExon(String prepend) {
        Exon ex = (Exon)this.transcript.sortedStrand().get(0);
        String seq2 = ex.getSequence();
        ex.setSequence(prepend + seq2);
        this.transcript.resetCache();
        this.chromoSequence = this.chromoSequence.substring(0, ex.getStart()) + ex.getSequence() + this.chromoSequence.substring(ex.getEnd() + 1);
        GenomicSequences gs = this.genome.getGenomicSequences();
        gs.reset();
        gs.addGeneSequences(this.chromosome.getId(), this.chromoSequence);
        gs.build();
    }

    public String showTranscripts(Genome genome) {
        StringBuilder sb = new StringBuilder();
        sb.append(genome.getVersion() + "\n");
        for (Chromosome chr : genome) {
            sb.append(chr + "\n");
        }
        for (Gene gene : genome.getGenes().sorted()) {
            sb.append(gene);
        }
        return sb.toString();
    }
}

