/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.util.HashSet;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.binseq.DnaAndQualitySequence;
import org.snpeff.binseq.DnaSequence;
import org.snpeff.binseq.DnaSequencePe;
import org.snpeff.binseq.coder.DnaCoder;
import org.snpeff.fastq.Fastq;
import org.snpeff.fastq.FastqVariant;
import org.snpeff.fileIterator.FastqFileIterator;
import org.snpeff.util.Gpr;

public class TestCasesDnaSequence {
    public static boolean verbose = false;

    String change(String sequence2, int numChanges, Random rand) {
        HashSet<Integer> changedPos = new HashSet<Integer>();
        char[] chars = sequence2.toCharArray();
        int i = 0;
        while (i < numChanges) {
            int pos = rand.nextInt(chars.length);
            if (changedPos.contains(pos)) continue;
            int newCode = rand.nextInt() & 3;
            char newBase = DnaCoder.get().toBase(newCode);
            if (chars[pos] == newBase) continue;
            chars[pos] = newBase;
            changedPos.add(pos);
            ++i;
        }
        return new String(chars);
    }

    public void randDnaSeqGetBasesTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            DnaSequence bseq = new DnaSequence(seq2);
            for (int i = 0; i < numTestsPerSeq; ++i) {
                int randPos = rand.nextInt(len);
                int randLen = rand.nextInt(len - randPos);
                String basesOri = seq2.substring(randPos, randPos + randLen);
                String basesBin = bseq.getBases(randPos, randLen);
                Assert.assertEquals(basesOri, basesBin);
                if (!verbose) continue;
                System.out.println("randDnaSeqGetBasesTest:\tPos: " + randPos + "\tLen: " + randLen + "\t'" + basesOri + "'\t=\t'" + basesBin + "'");
            }
        }
    }

    public void randDnaSeqGetBaseTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            if (verbose) {
                System.out.println("DnaSequence test:" + t + "\tlen:" + len + "\t" + seq2);
            }
            DnaSequence bseq = new DnaSequence(seq2);
            for (int i = 0; i < numTestsPerSeq; ++i) {
                int randPos = rand.nextInt(len);
                char baseOri = seq2.charAt(randPos);
                char baseBin = bseq.getBase(randPos);
                Assert.assertEquals(baseOri, baseBin);
            }
        }
    }

    public void randDnaSeqTest(int numTests, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            if (verbose) {
                System.out.println("DnaSequence test:" + t + "\tlen:" + len + "\t" + seq2);
            }
            DnaSequence bseq = new DnaSequence(seq2);
            Assert.assertEquals(seq2, bseq.toString());
        }
    }

    String randQual(int len, Random rand) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int r = rand.nextInt() & 0x28;
            char qchar = (char)(33 + r);
            sb.append(qchar);
        }
        return sb.toString();
    }

    public void randReplaceBaseTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            DnaSequence bseq = new DnaSequence(seq2);
            if (verbose) {
                System.out.println("randReplaceBaseTest\nOri    :\t" + seq2);
            }
            for (int i = 0; i < numTestsPerSeq; ++i) {
                char baseOri;
                int randPos = rand.nextInt(len);
                char randBase = baseOri = seq2.charAt(randPos);
                while (randBase == baseOri) {
                    int r = rand.nextInt() & 3;
                    randBase = DnaCoder.get().toBase(r);
                }
                char[] seqChars = seq2.toCharArray();
                seqChars[randPos] = randBase;
                seq2 = new String(seqChars);
                bseq.setBase(randPos, randBase);
                if (verbose) {
                    System.out.println("Changed:\t" + seq2 + "\tpos: " + randPos + "\trandbase: " + randBase + "\n\t\t" + bseq);
                }
                Assert.assertEquals(seq2, bseq.toString());
            }
        }
    }

    String randSeq(int len, Random rand) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int r = rand.nextInt() & 3;
            sb.append(DnaCoder.get().toBase(r));
        }
        return sb.toString();
    }

    public void randTestQual(int numTests, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            DnaAndQualitySequence bseq;
            String seq2 = "";
            String qual = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            qual = this.randQual(len, rand);
            String fullSeq = seq2 + "\t" + qual;
            if (verbose) {
                System.out.println("DnaAndQualitySequence test:" + t + "\tlen:" + len + "\t" + seq2);
            }
            if (fullSeq.equals((bseq = new DnaAndQualitySequence(seq2, qual, FastqVariant.FASTQ_SANGER)).toString())) continue;
            throw new RuntimeException("Sequences do not match:\n\tOriginal:\t" + fullSeq + "\n\tDnaAndQSeq:\t" + bseq);
        }
    }

    @Test
    public void test_01_short() {
        Gpr.debug("Test");
        long seed = 20100615L;
        int lenMask = 255;
        int numTests = 1000;
        this.randDnaSeqTest(numTests, lenMask, seed);
    }

    @Test
    public void test_01_short_getBase() {
        Gpr.debug("Test");
        long seed = 20110217L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randDnaSeqGetBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_01_short_getBases() {
        Gpr.debug("Test");
        long seed = 20110218L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randDnaSeqGetBasesTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_01_short_replaceBase() {
        Gpr.debug("Test");
        long seed = 20110218L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randReplaceBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_02_long() {
        Gpr.debug("Test");
        long seed = 20100614L;
        int lenMask = 65535;
        int numTests = 10;
        this.randDnaSeqTest(numTests, lenMask, seed);
    }

    @Test
    public void test_02_long_getBase() {
        Gpr.debug("Test");
        long seed = 20110217L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randDnaSeqGetBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_02_long_getBases() {
        Gpr.debug("Test");
        long seed = 20110218L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randDnaSeqGetBasesTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_02_long_replaceBase() {
        Gpr.debug("Test");
        long seed = 20110217L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randReplaceBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_04_Pe() {
        Gpr.debug("Test");
        int numTests = 1000;
        Random rand = new Random(20100617L);
        for (int t = 0; t < numTests; ++t) {
            String gapStr = "";
            int gap = rand.nextInt(50) + 1;
            for (int i = 0; i < gap; ++i) {
                gapStr = gapStr + "N";
            }
            int len1 = rand.nextInt(100) + 1;
            String seq1 = this.randSeq(len1, rand);
            int len2 = rand.nextInt(100) + 1;
            String seq2 = this.randSeq(len2, rand);
            String seq3 = seq1 + gapStr + seq2;
            DnaSequencePe bseqpe = new DnaSequencePe(seq1, seq2, gap);
            if (verbose) {
                System.out.println("PE test: " + t + "\t" + bseqpe);
            }
            if (bseqpe.toString().equals(seq3)) continue;
            throw new RuntimeException("Sequences do not match:\n\t" + seq3 + "\n\t" + bseqpe);
        }
    }

    @Test
    public void test_05_fastqReader() {
        String txt;
        Gpr.debug("Test");
        String fastqFileName = "tests/fastq_test.fastq";
        String txtFileName = "tests/fastq_test.txt";
        StringBuilder sb = new StringBuilder();
        for (Fastq fq : new FastqFileIterator(fastqFileName, FastqVariant.FASTQ_ILLUMINA)) {
            sb.append(fq.getSequence() + "\t" + fq.getQuality() + "\n");
        }
        if (verbose) {
            System.out.println("Fastq test:\n" + sb);
        }
        if ((txt = Gpr.readFile(txtFileName)).equals(sb.toString())) {
            throw new RuntimeException("Sequences from fastq file does not match expected results:\n----- Fastq file -----" + sb + "\n----- Txt file -----" + txt + "-----");
        }
    }

    @Test
    public void test_05_quality_short() {
        Gpr.debug("Test");
        long seed = 20100804L;
        int lenMask = 255;
        int numTests = 1000;
        this.randTestQual(numTests, lenMask, seed);
    }

    @Test
    public void test_06_quality_long() {
        Gpr.debug("Test");
        long seed = 20100804L;
        int lenMask = 65535;
        int numTests = 10;
        this.randTestQual(numTests, lenMask, seed);
    }
}

