/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.svg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.NextProt;
import org.snpeff.interval.Transcript;
import org.snpeff.svg.Svg;
import org.snpeff.util.Gpr;

public class SvgNextProt
extends Svg {
    Transcript tr;
    List<NextProt> nextprotMarkers;
    Map<String, List<NextProt>> nextprotMarkersByCategory;

    public SvgNextProt(Transcript tr, Svg svg, Markers nextprotMarkers) {
        super(tr, svg);
        this.tr = tr;
        this.rectColorStroke = "#ffffff";
        this.add(nextprotMarkers);
        if (svg != null) {
            this.baseY = svg.nextBaseY;
        }
        int numCat = this.nextprotMarkersByCategory.keySet().size();
        this.nextBaseY = this.baseY + 2 * (numCat + 1) * 20;
    }

    void add(Markers nextprotMarkers) {
        this.nextprotMarkers = new ArrayList<NextProt>();
        this.nextprotMarkersByCategory = new HashMap<String, List<NextProt>>();
        for (Marker m : nextprotMarkers) {
            List<NextProt> byCat;
            NextProt np = (NextProt)m;
            this.nextprotMarkers.add(np);
            String category = np.getId();
            if (category.indexOf(58) > 0) {
                category = category.split(":")[0];
            }
            if ((byCat = this.nextprotMarkersByCategory.get(category)) == null) {
                byCat = new ArrayList<NextProt>();
                this.nextprotMarkersByCategory.put(category, byCat);
            }
            byCat.add(np);
        }
        if (debug) {
            Gpr.debug("Added " + nextprotMarkers.size() + " markers");
        }
    }

    String plotCategory(String category, int order) {
        int baseYori = this.baseY;
        int nextBaseYori = this.nextBaseY;
        this.baseY += 2 * order * 20;
        this.nextBaseY = this.baseY;
        if (debug) {
            Gpr.debug("Plotting NextProt category:" + category);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.hline(this.rectHeight / 2));
        for (NextProt np : this.nextprotMarkersByCategory.get(category)) {
            Svg svg = SvgNextProt.factory(np, this);
            sb.append("\t" + svg);
        }
        sb.append(this.text(0.0, this.baseY + 10, category));
        this.baseY = baseYori;
        this.nextBaseY = nextBaseYori;
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> categories = new ArrayList<String>();
        categories.addAll(this.nextprotMarkersByCategory.keySet());
        Collections.sort(categories);
        int i = 0;
        for (String category : categories) {
            sb.append(this.plotCategory(category, i++));
        }
        return sb.toString();
    }
}

