/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.svg;

import java.text.NumberFormat;
import java.util.Locale;
import org.snpeff.interval.Marker;
import org.snpeff.svg.Svg;

public class SvgScale
extends Svg {
    public static final int SCALE_TICK_HEIGHT = 20;
    public static final int SCALE_HEIGHT = 30;

    public SvgScale(Marker m, Svg svg) {
        super(m, svg);
        this.nextBaseY = this.baseY + 60;
    }

    String scale() {
        int st;
        StringBuilder sb = new StringBuilder();
        sb.append(this.line(0.0, this.baseY + 10, this.sizeY, this.baseY + 10));
        int step2 = this.selectStep();
        for (int pos = st = this.m.getStart() / step2 * step2; pos < this.m.getEnd(); pos += step2) {
            double x2 = this.pos2coord(pos);
            sb.append(this.line(x2, this.baseY + 0, x2, this.baseY + 20));
            String posStr = NumberFormat.getNumberInstance(Locale.US).format(pos);
            sb.append(this.text(x2, this.baseY + 20 + 10, posStr));
        }
        sb.append(this.text(0.0, this.baseY + 10, "chr" + this.m.getChromosomeName()));
        return sb.toString();
    }

    int selectStep() {
        for (int i = 1; i < 100000000; i *= 10) {
            if (this.m.size() / i >= 20) continue;
            return i;
        }
        return 1000000;
    }

    @Override
    public String toString() {
        return this.scale();
    }
}

