/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.testCases;

import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.SnpSift;
import org.snpsift.SnpSiftCmdGwasCatalog;
import org.snpsift.gwasCatalog.GwasCatalog;
import org.snpsift.gwasCatalog.GwasCatalogEntry;

public class TestCasesGwasCatalog
extends TestCase {
    public static boolean verbose = false;

    List<VcfEntry> snpSiftCmdGwasCatalog(String[] args) {
        SnpSift snpSift = new SnpSift(args);
        SnpSiftCmdGwasCatalog snpSiftGwasCat = (SnpSiftCmdGwasCatalog)snpSift.cmd();
        snpSiftGwasCat.setVerbose(verbose);
        snpSiftGwasCat.setSuppressOutput(!verbose);
        return snpSiftGwasCat.run(true);
    }

    public void test_01() {
        Gpr.debug("Test");
        GwasCatalog gwasCatalog = new GwasCatalog("./gwasCatalog/gwascatalog.txt.gz");
        List<GwasCatalogEntry> list2 = gwasCatalog.get("20", 1759589);
        Assert.assertEquals(list2.get((int)0).snps, "rs6080550");
        list2 = gwasCatalog.getByRs("rs6080550");
        Assert.assertEquals(list2.get((int)0).snps, "rs6080550");
    }

    public void test_02() {
        Gpr.debug("Test");
        String[] args = new String[]{"gwasCat", "-db", "db/GRCh37/gwasCatalog/gwascatalog.tsv", "test/test_gwascat_02.vcf"};
        List<VcfEntry> vcfEntries = this.snpSiftCmdGwasCatalog(args);
        int countOk = 0;
        for (VcfEntry ve : vcfEntries) {
            if (verbose) {
                Gpr.debug(ve);
            }
            if (!ve.getInfo("GWC").equals("Y") || ve.getInfo("GWASCAT_TRAIT") == null) continue;
            ++countOk;
        }
        Assert.assertEquals("Two VCF entries should have been annotated", 2L, countOk);
    }
}

